/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.vcs;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import oracle.dbtools.crest.fcp.BrowserDockable;
import oracle.dbtools.crest.fcp.DMDiagramEditor;
import oracle.dbtools.crest.fcp.DisplayableLocatableNode;
import oracle.dbtools.crest.fcp.Messages;
import oracle.dbtools.crest.fcp.vcs.DataModelerChangeList;
import oracle.dbtools.crest.fcp.vcs.DataModelerChangeListWindow;
import oracle.dbtools.crest.fcp.vcs.MergeConflict;
import oracle.dbtools.crest.fcp.vcs.RevisionRange;
import oracle.dbtools.crest.fcp.vcs.StorableObjectStatus;
import oracle.dbtools.crest.fcp.vcs.VersioningTreeNode;
import oracle.dbtools.crest.fcp.vcs.svn.SVNHistoryWindow;
import oracle.dbtools.crest.fcp.vcs.svn.SVNViewPropertiesWindow;
import oracle.dbtools.crest.fcp.vcs.svn.commands.SVNMergeWindow;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.StorableObject;
import oracle.dbtools.crest.model.design.ConnectionInterface;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.process.DataFlowDesign;
import oracle.dbtools.crest.model.design.process.TransformationTask;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.metadata.XMLFromMapTransformer;
import oracle.dbtools.crest.model.metadata.XMLTransformationManager;
import oracle.dbtools.crest.model.placeholder.DesignPartViewPlaceHolder;
import oracle.dbtools.crest.model.xtdmapping.RMExtendedMap;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.browser.BrowserPanel;
import oracle.dbtools.crest.swingui.browser.NavigationTreeRenderer;
import oracle.dbtools.crest.util.TimeLog;
import oracle.dbtools.crest.util.io.LocalFileFilter;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.string.StringUtilities;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.model.Locatable;
import oracle.ide.view.View;
import oracle.jdeveloper.vcs.generic.CommandState;
import oracle.jdeveloper.vcs.vop.VersionOperationPanel;

public abstract class VCSClientHelper<L, R, S, U, I, D, P> {
    private static final Logger LOGGER = new Logger(VCSClientHelper.class);
    public static final String DM_PROPERTIES = "dm:properties";
    public static final String DM_PROPERTIES_SEPARATOR = ":::";
    public static final String SUBVERSION_EXTRA_FOLDER_NAME = ".svn";
    public static final int PROPERTY_ID = 0;
    public static final int PROPERTY_CLASS_NAME = 1;
    public static final int PROPERTY_PARENT_ID = 2;
    public static final int PROPERTY_SOURCE_ID = 3;
    public static final int PROPERTY_TARGET_ID = 4;
    public static final int PROPERTY_NAME = 5;
    public static final int PROPERTIES_COUNT = 6;
    public static final int PROPERTIES_COUNT_OLD = 4;

    public abstract I doInfo(File var1);

    protected abstract void doAdd(File var1, boolean var2);

    public void doAdd(File file) {
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            this.doAdd(file, false);
            this.doIgnore(file, "*.localz");
            this.doIgnore(file, "*.local");
            for (File file2 : fileArray) {
                if (file2.isDirectory()) {
                    this.doAdd(file2);
                    continue;
                }
                if (!VCSClientHelper.accept(file2)) continue;
                this.doAdd(file2, false);
            }
        } else if (VCSClientHelper.accept(file)) {
            this.doAdd(file, false);
        }
    }

    public void doRemove(List<String> list) {
        if (!list.isEmpty()) {
            ArrayList<File> arrayList = new ArrayList<File>();
            for (String string : list) {
                File file = new File(string);
                if (!file.exists()) continue;
                arrayList.add(file);
            }
            this.doRemove(arrayList.toArray(new File[0]));
        }
    }

    public abstract void doRemove(File[] var1);

    public abstract boolean isDeleted(File var1);

    public abstract List<S> doStatus(File var1, boolean var2);

    public abstract void doUpdate(File[] var1, boolean var2);

    public abstract void doCommit(File[] var1, String var2, boolean var3, boolean var4);

    public abstract void doRevert(File[] var1, boolean var2);

    public abstract void doCleanup(File var1);

    public abstract InputStream doGetRevision(U var1, R var2);

    public abstract InputStream doGetRevision(File var1, R var2);

    public abstract void doResolved(File var1);

    public abstract void doIgnore(File var1, String var2);

    public abstract List<D> doDiffSummarize(U var1, U var2);

    public abstract List<MergeConflict> doMerge(U var1, File var2, List<RevisionRange> var3, boolean var4, boolean var5);

    public abstract boolean doMergeReintegrate(U var1, File var2, List<MergeConflict> var3);

    public abstract void doCopy(String var1, File var2, Long var3);

    public abstract List<StorableObjectStatus> getStatuses(Design var1, boolean var2, boolean var3, boolean var4);

    public abstract VersionOperationPanel createVersionOperationTablePanel(List<DisplayableLocatableNode> var1);

    public boolean hasProperty(File file, String string) {
        return this.doGetProperty(file, string) != null;
    }

    public abstract String doGetProperty(U var1, String var2, Long var3);

    public abstract String doGetProperty(File var1, String var2);

    public String doGetProperty(U u, int n, Long l) {
        return this.getProperty(this.doGetProperty(u, DM_PROPERTIES, l), n);
    }

    public String doGetProperty(File file, int n) {
        return this.getProperty(this.doGetProperty(file, DM_PROPERTIES), n);
    }

    public abstract P[] doGetProperties(String var1, Long var2);

    public abstract void doSetProperty(File var1, String var2, String var3);

    public abstract boolean isVersioned(File var1);

    public abstract boolean exists(String var1);

    public abstract long getRevision(File var1);

    public abstract long getLastChangedRevision(File var1);

    public abstract Long getLastMergedRevision(File var1, Long var2, String var3);

    public abstract List<L> doGetLogMessages(U var1, Long var2, Long var3, boolean var4, boolean var5, int var6);

    public abstract List<L> doGetLogMessages(File var1, Long var2, Long var3, boolean var4, boolean var5, int var6);

    public abstract void doLock(File[] var1, boolean var2, String var3);

    public abstract void doUnlock(File[] var1, boolean var2);

    public boolean isVersioned(String string) {
        return StringUtilities.isNotEmpty(string) && this.isVersioned(new File(string));
    }

    public void checkVersioned(Design design) {
        if (this.isVersioned(design.getStoragePath())) {
            design.setVersioned(true);
            this.checkProperties(design, true);
        } else {
            design.setVersioned(false);
        }
    }

    public void checkProperties(Design design, boolean bl) {
        this.checkProperties(design, bl, true);
    }

    public void checkProperties(Design design, boolean bl, boolean bl2) {
        String string = design.getStoragePath();
        if (this.isVersioned(string) && !this.hasProperties(design)) {
            File[] fileArray = new File[]{new File(design.getStorageName()), new File(string)};
            if (bl) {
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), Messages.getString("VCSClientHelper.SetProperties"), Messages.getString("VCSClientHelper.SetPropertiesTitle"), 2);
            }
            ApplicationView.log("save properties - start");
            TimeLog.log("save properties - start");
            this.deleteLocalFilesAndSetIgnoreList(string);
            this.saveProperties(design);
            ApplicationView.log("save properties - end");
            TimeLog.log("save properties - end");
            if (bl2) {
                this.doCommit(fileArray, null, true, false);
                ApplicationView.log("save properties - end commit");
                TimeLog.log("save properties - end commit");
            }
        }
    }

    public boolean hasProperties(Design design) {
        String string = design.getStorageName();
        if (design.isCompressedDesign()) {
            string = string + "z";
        }
        return this.hasProperty(new File(string), DM_PROPERTIES);
    }

    public void saveProperties(Design design) {
        if (design.isVersioned()) {
            DesignPart designPart2;
            String string = design.getStorageName();
            if (design.isCompressedDesign()) {
                string = string + "z";
            }
            this.setProperties(new File(string), new String[]{design.getObjectID(), design.getClass().getName(), "", null, null, design.getName()});
            this.saveDesignPartProperties(design.getBusinessInfoDesign());
            this.saveDesignPartProperties(design.getDataTypesDesign());
            this.saveDPVs(design.getDataTypesDesign(), true);
            this.saveDesignPartProperties(design.getLogicalDesign());
            this.saveDPVs(design.getLogicalDesign(), true);
            Iterator iterator = design.getRelationalDesigns().iterator();
            while (iterator.hasNext()) {
                designPart2 = (RelationalDesign)iterator.next();
                this.saveDesignPartProperties(designPart2);
                this.saveDPVs(designPart2, true);
                Iterator iterator2 = ((RelationalDesign)designPart2).getStorageDesignFactory().getSorageDesigns().iterator();
                while (iterator2.hasNext()) {
                    StorageDesign storageDesign = (StorageDesign)iterator2.next();
                    this.saveProperties(storageDesign);
                    Iterator iterator3 = storageDesign.getStorableObjects().iterator();
                    while (iterator3.hasNext()) {
                        this.saveProperties((ModelIDObject)iterator3.next());
                    }
                }
            }
            iterator = design.getMultidimensionalDesigns().iterator();
            while (iterator.hasNext()) {
                designPart2 = (DesignPart)iterator.next();
                this.saveDesignPartProperties(designPart2);
                this.saveDPVs(designPart2, false);
            }
            this.saveDesignPartProperties(design.getProcessModel());
            iterator = design.getProcessModel().getDataFlowDesigns().iterator();
            while (iterator.hasNext()) {
                designPart2 = (DesignPart)iterator.next();
                this.saveDesignPartProperties(designPart2);
                this.saveDPVs(designPart2, false);
            }
            for (DesignPart designPart2 : design.getProcessModel().getAllTransformationTasks()) {
                this.saveDesignPartProperties(designPart2);
                this.saveDPVs(designPart2, false);
            }
        }
    }

    private void saveDesignPartProperties(DesignPart designPart) {
        this.saveProperties(designPart);
        Iterator iterator = designPart.getStorableDesignObjects().iterator();
        while (iterator.hasNext()) {
            this.saveProperties((ModelIDObject)iterator.next());
        }
    }

    private void saveDPVs(DesignPart designPart, boolean bl) {
        this.saveProperties(designPart.getMainView().getPlaceHolder());
        if (bl) {
            Iterator iterator = designPart.getDesignSubviews().iterator();
            while (iterator.hasNext()) {
                this.saveProperties((DesignPartViewPlaceHolder)iterator.next());
            }
        }
    }

    public void saveProperties(StorableObject storableObject) {
        String string;
        if (storableObject instanceof ModelIDObject) {
            this.saveProperties((ModelIDObject)storableObject);
        } else if (storableObject instanceof DesignPartView) {
            this.saveProperties(((DesignPartView)storableObject).getPlaceHolder());
        } else if (storableObject instanceof RMExtendedMap && (string = storableObject.getStorageName()) != null) {
            File file;
            if (storableObject.getDesign().isCompressedDesign() && string.endsWith(".xml")) {
                string = string + "z";
            }
            if (!this.isVersioned(file = new File(string))) {
                this.doAdd(this.findFirstNotAddedParent(file));
            }
        }
    }

    protected void saveProperties(ModelIDObject modelIDObject) {
        if (modelIDObject instanceof StorageObject && ((StorageObject)modelIDObject).isNullInstance() && !((StorageObject)modelIDObject).isStorableNullInstance()) {
            return;
        }
        String string = modelIDObject instanceof DesignPartViewPlaceHolder ? modelIDObject.getStorageName() : modelIDObject.getSegmentedStorageName();
        this.saveProperties(modelIDObject, string);
    }

    public void saveProperties(ModelIDObject modelIDObject, String string) {
        if (string != null) {
            File file;
            if (modelIDObject.getDesign().isCompressedDesign() && string.endsWith(".xml")) {
                string = string + "z";
            }
            if (!this.isVersioned(file = new File(string))) {
                this.doAdd(this.findFirstNotAddedParent(file));
            }
            if (modelIDObject instanceof TransformationTask) {
                String string2 = ((TransformationTask)modelIDObject).getTransformationPackage().getObjectID();
                this.setProperties(file, new String[]{modelIDObject.getObjectID(), modelIDObject.getClass().getName(), string2, null, null, modelIDObject.getName()});
            } else if (modelIDObject instanceof DataFlowDesign) {
                String string3 = ((DataFlowDesign)modelIDObject).getProcess() != null ? ((DataFlowDesign)modelIDObject).getProcess().getObjectID() : ((DataFlowDesign)modelIDObject).getProcessModel().getObjectID();
                this.setProperties(file, new String[]{modelIDObject.getObjectID(), modelIDObject.getClass().getName(), string3, null, null, modelIDObject.getName()});
            } else if (modelIDObject instanceof DesignPartViewPlaceHolder) {
                DesignPartViewPlaceHolder designPartViewPlaceHolder = (DesignPartViewPlaceHolder)modelIDObject;
                DesignPart designPart = designPartViewPlaceHolder.getDesignPart();
                if (designPart instanceof DataFlowDesign) {
                    String string4 = ((DataFlowDesign)designPart).getObjectID();
                    this.setProperties(file, new String[]{modelIDObject.getObjectID(), designPart.getClass().getName(), string4, null, null, modelIDObject.getName()});
                } else {
                    this.setProperties(file, new String[]{modelIDObject.getObjectID(), designPart.getClass().getName(), designPart.getObjectID(), null, null, modelIDObject.getName()});
                }
            } else if (modelIDObject instanceof DesignPart) {
                this.setProperties(file, new String[]{modelIDObject.getObjectID(), modelIDObject.getClass().getName(), "", null, null, modelIDObject.getName()});
            } else if (modelIDObject instanceof DesignObject) {
                String string5 = ((DesignObject)modelIDObject).getDesignPartId();
                String string6 = null;
                String string7 = null;
                if (modelIDObject instanceof ConnectionInterface) {
                    ConnectionInterface connectionInterface = (ConnectionInterface)((Object)modelIDObject);
                    DesignObject designObject = connectionInterface.getSourceObject();
                    DesignObject designObject2 = connectionInterface.getTargetObject();
                    if (designObject != null) {
                        string6 = designObject.getObjectID();
                    }
                    if (designObject2 != null) {
                        string7 = designObject2.getObjectID();
                    }
                }
                this.setProperties(file, new String[]{modelIDObject.getObjectID(), modelIDObject.getClass().getName(), string5, string6, string7, modelIDObject.getName()});
            } else if (modelIDObject instanceof StorageObject) {
                String string8 = ((StorageObject)modelIDObject).getStorageDesign().getRDBMSSite().getShortObjectID();
                this.setProperties(file, new String[]{modelIDObject.getObjectID(), modelIDObject.getClass().getName(), string8, null, null, modelIDObject.getName()});
            } else if (modelIDObject instanceof StorageDesign) {
                String string9 = ((StorageDesign)modelIDObject).getPhysicalDesign().getShortObjectID();
                this.setProperties(file, new String[]{((StorageDesign)modelIDObject).getRDBMSSite().getShortObjectID(), modelIDObject.getClass().getName(), string9, null, null, modelIDObject.getName()});
            } else {
                this.setProperties(file, new String[]{modelIDObject.getObjectID(), modelIDObject.getClass().getName(), "", null, null, modelIDObject.getName()});
            }
        } else {
            LOGGER.info("Not recognized: " + modelIDObject.getName());
        }
    }

    public boolean actionsEnabled(DataModelerChangeList dataModelerChangeList, Context context, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8) {
        Object object;
        Object object2;
        if (dataModelerChangeList != null && ((object2 = dataModelerChangeList.getPanel().getStatuses()) == null || object2.size() == 0)) {
            return false;
        }
        if (bl) {
            if (context != null) {
                object2 = context.getView();
                object = VCSClientHelper.getSelection((View)object2);
                if (!(object != null && ((DisplayableLocatableNode[])object).length != 0 || object2 instanceof SVNViewPropertiesWindow)) {
                    return false;
                }
                if (DataModelerChangeListWindow.class.isAssignableFrom(object2.getClass())) {
                    dataModelerChangeList = (DataModelerChangeList)((DataModelerChangeListWindow)context.getView()).getContextChangeList();
                } else {
                    if (object2 instanceof BrowserDockable) {
                        return object[0].getFilePath().exists();
                    }
                    if (object2 instanceof DMDiagramEditor) {
                        DesignPartView designPartView = ((DMDiagramEditor)((Object)object2)).getDesignPartView();
                        return object[0].getFilePath().exists() && designPartView.getDesign().isVersioned();
                    }
                    if (object2 instanceof SVNHistoryWindow) {
                        StorableObjectStatus storableObjectStatus = ((SVNHistoryWindow)((Object)object2)).getSelectedStorableObjectStatus();
                        File file = object[0].getFilePath();
                        URL uRL = object[0].getURL();
                        return (file != null || uRL != null) && !storableObjectStatus.isDeleted();
                    }
                    if (object2 instanceof SVNViewPropertiesWindow && ((SVNViewPropertiesWindow)((Object)object2)).isReadOnly()) {
                        return false;
                    }
                }
            } else {
                return false;
            }
        }
        if ((object2 = DataModelerChangeList.getSelectedDesign()) != null && ((Design)object2).isVersioned()) {
            object = new ArrayList();
            if (bl8 && dataModelerChangeList != null && this.containsRootPath(dataModelerChangeList.getPanel().getSelectedFilePaths((List<VersioningTreeNode>)object, true, true))) {
                return false;
            }
            if (bl2 && dataModelerChangeList != null && !dataModelerChangeList.getPanel().hasSelection()) {
                return false;
            }
            if (bl3 && dataModelerChangeList != null && !dataModelerChangeList.getPanel().hasSingleSelection()) {
                return false;
            }
            if (bl4 && this.containsConflicted((List<VersioningTreeNode>)object)) {
                return false;
            }
            if (bl5 && !this.containsAllDependances((List<VersioningTreeNode>)object, bl6)) {
                return false;
            }
            return !bl7 || !this.containsNotExisting((List<VersioningTreeNode>)object);
        }
        return false;
    }

    public boolean containsAllDependances(List<VersioningTreeNode> list, boolean bl) {
        for (VersioningTreeNode versioningTreeNode : list) {
            Object object;
            if (!bl && (object = versioningTreeNode.getStorableObjectStatus()) != null && ((StorableObjectStatus)object).isDeleted() || (object = versioningTreeNode.getDependingOn()) == null || list.contains(object)) continue;
            return false;
        }
        return true;
    }

    public boolean containsConflicted(List<VersioningTreeNode> list) {
        for (VersioningTreeNode versioningTreeNode : list) {
            if (!versioningTreeNode.isConflicted()) continue;
            return true;
        }
        return false;
    }

    public boolean containsNotExisting(List<VersioningTreeNode> list) {
        for (VersioningTreeNode versioningTreeNode : list) {
            StorableObjectStatus storableObjectStatus = versioningTreeNode.getStorableObjectStatus();
            if (storableObjectStatus != null && !storableObjectStatus.isAdded() && !storableObjectStatus.isDeleted()) continue;
            return true;
        }
        return false;
    }

    public boolean containsRootPath(List<File> list) {
        String string = DataModelerChangeList.getSelectedDesign().getDesignPath();
        for (File file : list) {
            if (!file.getPath().equals(string)) continue;
            return true;
        }
        return false;
    }

    public boolean containsRootNode(List<VersioningTreeNode> list) {
        for (VersioningTreeNode versioningTreeNode : list) {
            if (!versioningTreeNode.isRoot()) continue;
            return true;
        }
        return false;
    }

    public File findFirstNotAddedParent(File file) {
        File file2 = file.getParentFile();
        if (!this.isVersioned(file2)) {
            return this.findFirstNotAddedParent(file2);
        }
        return file;
    }

    public List<File> findNotAddedParents(File file, List<File> list) {
        File file2 = file.getParentFile();
        if (file2 != null && !this.isVersioned(file2)) {
            list.add(file2);
            return this.findNotAddedParents(file2, list);
        }
        return list;
    }

    public static boolean accept(File file) {
        String string = file.getName();
        return string.endsWith(".xml") || string.endsWith(".xmlz") || string.endsWith(".dmd") || string.endsWith(".dmdz");
    }

    public void merge(StorableObjectStatus storableObjectStatus, File file, Map map) {
        Class<Design.DLSettings> clazz;
        DesignPart designPart;
        boolean bl;
        StorableObject storableObject = storableObjectStatus.getStorableObject();
        if (storableObjectStatus.getTextStatus() == null) {
            bl = storableObject.getDesign().isCompressedDesign();
            designPart = ((DesignObject)storableObject).getDesignPart();
            clazz = storableObject.getClass();
        } else {
            bl = storableObjectStatus.getDesign().isCompressedDesign();
            designPart = storableObjectStatus.getDesignPart();
            clazz = storableObjectStatus.getObjectClass();
        }
        if (clazz != null && clazz.isAssignableFrom(Design.DLSettings.class)) {
            storableObjectStatus.getDesign().loadDLSettingsFile(storableObjectStatus.getDesign().getStoragePath());
        } else {
            XMLFromMapTransformer.transformMapToXMLFile(map, file.getPath(), bl);
            if (storableObject != null) {
                this.reloadStorableObject(storableObject, file, designPart);
            }
        }
    }

    public void reloadStorableObject(StorableObject storableObject, File file, DesignPart designPart) {
        DesignPartView designPartView;
        XMLTransformationManager xMLTransformationManager = ApplicationView.getInstance().getXMLTransformationManager();
        Design design = storableObject.getDesign();
        xMLTransformationManager.transformFromXMLToObject(storableObject, file, design.isCompressedDesign());
        if (designPart != null) {
            designPart.executeTasks();
        }
        if (storableObject instanceof DesignPartView && (designPartView = (DesignPartView)storableObject).isVisible()) {
            designPartView.setVisible(true);
            for (DesignPartView designPartView2 : designPartView.getSubordinateViews()) {
                designPartView2.setVisible(true);
            }
        }
    }

    public StorageDesign findStorageDesign(Design design, String string) {
        for (StorageDesign storageDesign : design.getStorageDesignFactory().getOpenStorageDesigns()) {
            if (storageDesign.getStorageObject(string) == null) continue;
            return storageDesign;
        }
        return null;
    }

    protected String getProperty(String string, int n) {
        if (string != null) {
            String[] stringArray = string.split(DM_PROPERTIES_SEPARATOR, string.length());
            if (stringArray.length == 4 && n == 5) {
                n = 3;
            }
            if (stringArray.length > n) {
                return stringArray[n];
            }
        }
        return null;
    }

    protected String generateProperty(String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = stringArray[0];
        String string2 = stringArray[1];
        String string3 = stringArray[2];
        String string4 = stringArray[3];
        String string5 = stringArray[4];
        String string6 = stringArray[5];
        if (StringUtilities.isNotEmpty(string)) {
            stringBuilder.append(string);
        }
        stringBuilder.append(DM_PROPERTIES_SEPARATOR);
        if (StringUtilities.isNotEmpty(string2)) {
            stringBuilder.append(string2);
        }
        stringBuilder.append(DM_PROPERTIES_SEPARATOR);
        if (StringUtilities.isNotEmpty(string3)) {
            stringBuilder.append(string3);
        }
        stringBuilder.append(DM_PROPERTIES_SEPARATOR);
        if (StringUtilities.isNotEmpty(string4)) {
            stringBuilder.append(string4);
        }
        stringBuilder.append(DM_PROPERTIES_SEPARATOR);
        if (StringUtilities.isNotEmpty(string5)) {
            stringBuilder.append(string5);
        }
        stringBuilder.append(DM_PROPERTIES_SEPARATOR);
        if (StringUtilities.isNotEmpty(string6)) {
            stringBuilder.append(string6);
        }
        return stringBuilder.toString();
    }

    private void setProperties(File file, String[] stringArray) {
        this.doSetProperty(file, DM_PROPERTIES, this.generateProperty(stringArray));
    }

    public static Icon getIcon(Class clazz) {
        if (clazz != null && File.class.isAssignableFrom(clazz)) {
            return NavigationTreeRenderer.getDefaultIcon();
        }
        Icon icon = NavigationTreeRenderer.getIcon(clazz);
        if (icon == null && clazz != null && (StorageObject.class.isAssignableFrom(clazz) || RelationalObjectProxy.class.isAssignableFrom(clazz))) {
            icon = NavigationTreeRenderer.getIcon(StorageObject.class);
        }
        return icon;
    }

    public static boolean replace(File file, String string) {
        File file2 = new File(file.getPath() + string);
        if (!file2.exists()) {
            return false;
        }
        if (file.canWrite()) {
            file.delete();
        } else {
            LOGGER.info("File " + file.getPath() + " can not be deleted!");
        }
        return file2.renameTo(file);
    }

    public static CommandState createCommandState(View view) {
        return VCSClientHelper.createCommandState(view, false);
    }

    public static CommandState createCommandState(View view, boolean bl) {
        CommandState commandState = new CommandState();
        Locatable[] locatableArray = VCSClientHelper.getSelection(view);
        if (bl) {
            ArrayList<DisplayableLocatableNode> arrayList = new ArrayList<DisplayableLocatableNode>();
            for (Locatable locatable : locatableArray) {
                StorableObject storableObject = locatable.getStorableObject();
                arrayList.add((DisplayableLocatableNode)locatable);
                if (storableObject == null) continue;
                if (storableObject instanceof DesignPart) {
                    DesignPart designPart = (DesignPart)storableObject;
                    for (DesignObject designObject : designPart.getStorableDesignObjects()) {
                        arrayList.add(new DisplayableLocatableNode(designObject));
                    }
                    for (DesignPartView designPartView : designPart.getAllDiagrams()) {
                        arrayList.add(new DisplayableLocatableNode(designPartView));
                    }
                }
                if (storableObject instanceof DesignPartView) {
                    VCSClientHelper.addDesignPartView((DesignPartView)storableObject, arrayList);
                    continue;
                }
                if (!(storableObject instanceof DesignPartViewPlaceHolder)) continue;
                VCSClientHelper.addDesignPartView(((DesignPartViewPlaceHolder)storableObject).getDesignPartView(), arrayList);
            }
            locatableArray = arrayList.toArray(new DisplayableLocatableNode[0]);
        }
        commandState.setLocatables(locatableArray);
        return commandState;
    }

    private static void addDesignPartView(DesignPartView designPartView, List<DisplayableLocatableNode> list) {
        List list2 = designPartView.getTVArcs();
        List list3 = designPartView.getTVShapes();
        List list4 = designPartView.getTVConnectors();
        for (TopView topView : list2) {
            list.add(new DisplayableLocatableNode(topView.getModel()));
        }
        for (TopView topView : list3) {
            list.add(new DisplayableLocatableNode(topView.getModel()));
        }
        for (TopView topView : list4) {
            list.add(new DisplayableLocatableNode(topView.getModel()));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DisplayableLocatableNode[] getSelection(View view) {
        StorableObjectStatus storableObjectStatus;
        if (view instanceof DataModelerChangeListWindow) {
            DataModelerChangeList dataModelerChangeList = (DataModelerChangeList)((DataModelerChangeListWindow)view).getContextChangeList();
            List<File> list = dataModelerChangeList.getPanel().getSelectedFilePaths(new ArrayList<VersioningTreeNode>(), false, false);
            File[] fileArray = list.toArray(new File[list.size()]);
            return DisplayableLocatableNode.convert(fileArray);
        }
        if (view instanceof BrowserDockable) {
            Object object = ((BrowserPanel)((BrowserDockable)view).getBrowser()).getJTree().getLastSelectedPathComponent();
            if (!(object instanceof ModelIDObject) || !((ModelIDObject)object).getDesign().isVersioned() || !(object instanceof StorableObject) || ((StorableObject)object).getStorageName() == null) return null;
            return new DisplayableLocatableNode[]{new DisplayableLocatableNode((StorableObject)object)};
        }
        if (view instanceof DMDiagramEditor) {
            Object[] objectArray = ((DMDiagramEditor)view).getDesignPartView().getSelectedObjects();
            if (objectArray != null && objectArray.length > 0) {
                if (objectArray.length != 1) return null;
                return new DisplayableLocatableNode[]{new DisplayableLocatableNode((StorableObject)objectArray[0])};
            }
            DesignPartView designPartView = ((DMDiagramEditor)view).getDesignPartView();
            if (designPartView.isMasterDPV()) return new DisplayableLocatableNode[]{new DisplayableLocatableNode(designPartView)};
            designPartView = designPartView.getMasterDPV();
            return new DisplayableLocatableNode[]{new DisplayableLocatableNode(designPartView)};
        }
        if (view instanceof SVNViewPropertiesWindow) {
            File[] fileArray = ((SVNViewPropertiesWindow)view).getContextResources();
            return DisplayableLocatableNode.convert(fileArray);
        }
        if (!(view instanceof SVNHistoryWindow) || (storableObjectStatus = ((SVNHistoryWindow)view).getSelectedStorableObjectStatus()) == null) return null;
        if (view instanceof SVNMergeWindow) {
            return new DisplayableLocatableNode[]{new DisplayableLocatableNode(storableObjectStatus.getURL())};
        }
        StorableObject storableObject = storableObjectStatus.getStorableObject();
        if (storableObject == null) return new DisplayableLocatableNode[]{new DisplayableLocatableNode(storableObjectStatus.getFilePath())};
        return new DisplayableLocatableNode[]{new DisplayableLocatableNode(storableObject)};
    }

    public static Design getSelectionDesign(View view) {
        if (view instanceof DataModelerChangeListWindow) {
            return DataModelerChangeList.getSelectedDesign();
        }
        if (view instanceof BrowserDockable) {
            StorableObject storableObject = (StorableObject)((BrowserPanel)((BrowserDockable)view).getBrowser()).getJTree().getLastSelectedPathComponent();
            return storableObject.getDesign();
        }
        if (view instanceof DMDiagramEditor) {
            return ((DMDiagramEditor)view).getDesignPartView().getDesign();
        }
        if (view instanceof SVNViewPropertiesWindow) {
            return ((SVNViewPropertiesWindow)view).getDesign();
        }
        return null;
    }

    public void deleteLocalFilesAndSetIgnoreList(String string) {
        File file = new File(string);
        LocalFileFilter localFileFilter = new LocalFileFilter(".localz");
        LocalFileFilter localFileFilter2 = new LocalFileFilter(".local");
        this.doIgnore(file, "*.localz");
        this.doIgnore(file, "*.local");
        File[] fileArray = file.listFiles();
        if (fileArray.length != 0) {
            for (int i = 0; i < fileArray.length; ++i) {
                if (fileArray[i].isDirectory()) {
                    if (fileArray[i].getName().equals(SUBVERSION_EXTRA_FOLDER_NAME)) continue;
                    try {
                        this.deleteLocalFilesAndSetIgnoreList(fileArray[i].getCanonicalFile().toString());
                    }
                    catch (IOException iOException) {
                        ApplicationView.log("Unable to delete local file in " + fileArray[i].getName() + " folder");
                        LOGGER.error(iOException.getStackTrace()[0].toString());
                    }
                    continue;
                }
                if (!localFileFilter.accept(fileArray[i]) && !localFileFilter2.accept(fileArray[i])) continue;
                if (this.isVersioned(fileArray[i])) {
                    this.doRemove(new File[]{fileArray[i]});
                }
                if (fileArray[i].delete()) continue;
                ApplicationView.log("Unable to delete the file " + fileArray[i].getName());
            }
        }
    }
}

