/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.vcs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import javax.swing.JPanel;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.ide.Context;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.URLFactory;
import oracle.ide.view.View;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.compare.CompareContributor;
import oracle.javatools.compare.CompareFailedException;
import oracle.javatools.compare.CompareModel;
import oracle.javatools.compare.CompareView;
import oracle.javatools.compare.CompareViewFactory;
import oracle.javatools.compare.view.text.TextCompareView;
import oracle.javatools.editor.BasicEditorPane;
import oracle.jdeveloper.compare.StreamType;
import oracle.jdeveloper.merge.TextMergeNode;
import oracle.jdeveloper.merge.TextMergeNodeContributor;
import oracle.jdevimpl.compare.BaseCompareEditor;
import oracle.jdevimpl.compare.CompareAddin;
import oracle.jdevimpl.compare.CompareController;
import oracle.jdevimpl.compare.CompareInvocation;
import oracle.jdevimpl.compare.CompareUtil;

public class TextCompareEditor
extends BaseCompareEditor {
    private JPanel gui;
    private CompareView compareView;
    private CompareController compareController;
    private static final Logger LOGGER = new Logger(TextCompareEditor.class);
    private XMLContributor leftContributor;
    private XMLContributor rightContributor;

    public TextCompareEditor(InputStream inputStream, InputStream inputStream2, String string, String string2, boolean bl, boolean bl2) {
        this(new InputStreamReader(inputStream), new InputStreamReader(inputStream2), string, string2, bl, bl2);
    }

    public TextCompareEditor(Reader reader, Reader reader2, String string, String string2, boolean bl, boolean bl2) {
        try {
            BasicEditorPane[] basicEditorPaneArray;
            this.compareView = this.createCompareView(reader, reader2, string, string2, bl, bl2);
            for (BasicEditorPane basicEditorPane : basicEditorPaneArray = ((TextCompareView)this.compareView).getEditorPanes()) {
                basicEditorPane.putBooleanProperty("show-line-numbers", true);
            }
            this.compareController = this.createCompareController();
            this.gui = new JPanel(new BorderLayout());
            this.gui.add((Component)this.createToolbar(), "North");
            this.gui.add(this.compareView.getGUI(), "Center");
        }
        catch (IOException iOException) {
            LOGGER.error(iOException);
        }
        catch (CompareFailedException compareFailedException) {
            LOGGER.error((Object)compareFailedException);
        }
    }

    public String getLeftText() {
        TextBuffer textBuffer = this.leftContributor.getTextBuffer();
        return textBuffer.getString(0, textBuffer.getLength());
    }

    public String getRightText() {
        TextBuffer textBuffer = this.rightContributor.getTextBuffer();
        return textBuffer.getString(0, textBuffer.getLength());
    }

    private CompareController createCompareController() {
        final Context context = Context.newIdeContext((View)this);
        return new CompareController(){

            protected CompareView getCompareView(Context context2) {
                return super.getCompareView(context);
            }

            public boolean update(IdeAction ideAction, Context context2) {
                return super.update(ideAction, context);
            }

            public boolean handleEvent(IdeAction ideAction, Context context2) {
                return super.handleEvent(ideAction, context);
            }
        };
    }

    public Controller getController() {
        return this.compareController;
    }

    public CompareView getCompareView() {
        return this.compareView;
    }

    public void open() {
    }

    public Component getGUI() {
        return this.gui;
    }

    private Toolbar createToolbar() {
        Toolbar toolbar = new Toolbar();
        toolbar.add((ToggleAction)this.createLocalAction(CompareAddin.GO_FIRST_CMD_ID));
        toolbar.add((ToggleAction)this.createLocalAction(CompareAddin.GO_PREVIOUS_CMD_ID));
        toolbar.add((ToggleAction)this.createLocalAction(CompareAddin.GO_NEXT_CMD_ID));
        toolbar.add((ToggleAction)this.createLocalAction(CompareAddin.GO_LAST_CMD_ID));
        return toolbar;
    }

    protected IdeAction createLocalAction(int n) {
        IdeAction ideAction = IdeAction.find((int)n);
        if (ideAction != null) {
            IdeAction ideAction2 = ideAction.newLocalAction((View)this);
            ideAction2.addController((Controller)this.compareController);
            ideAction2.setEnabled(true);
            return ideAction2;
        }
        return null;
    }

    private CompareView createCompareView(Reader reader, Reader reader2, String string, String string2, boolean bl, boolean bl2) throws IOException, CompareFailedException {
        this.leftContributor = new XMLContributor(reader, bl, string);
        this.rightContributor = new XMLContributor(reader2, bl2, string2);
        CompareInvocation compareInvocation = CompareUtil.createInvocationContext((CompareContributor)this.leftContributor, (CompareContributor)this.rightContributor, (StreamType)StreamType.XML);
        CompareModel compareModel = CompareUtil.createCompareModel((CompareContributor)this.leftContributor, (CompareContributor)this.rightContributor, (CompareInvocation)compareInvocation);
        return CompareViewFactory.createCompareView((CompareModel)compareModel);
    }

    public void update(Object object, UpdateMessage updateMessage) {
    }

    private static final class XMLContributor
    extends TextMergeNodeContributor {
        private boolean readOnly;

        private XMLContributor(Reader reader, boolean bl, String string) throws IOException {
            super(new TextMergeNode(URLFactory.newFileURL((String)string)), string);
            this.readOnly = bl;
            this.getTextBuffer().read(reader);
        }

        public boolean isEditable() {
            return !this.readOnly;
        }

        public String getType() {
            return "xml";
        }
    }
}

