/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.vcs;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import oracle.dbtools.crest.fcp.Messages;
import oracle.dbtools.crest.fcp.vcs.ChooseActionDialog;
import oracle.dbtools.crest.fcp.vcs.MergeConflict;
import oracle.dbtools.crest.fcp.vcs.StorableObjectStatus;
import oracle.dbtools.crest.fcp.vcs.VCSClientHelper;
import oracle.dbtools.crest.fcp.vcs.VCSTextCompareDialog;
import oracle.dbtools.crest.fcp.vcs.VersioningTreeNode;
import oracle.dbtools.crest.fcp.vcs.svn.SVNClientHelper;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.metadata.XMLFromMapTransformer;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.compare.xmlmeta.XMLMetadataComparator;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.ide.Ide;

public class MergeConflictsDialog
extends ChooseActionDialog {
    private static final String ACTION_EDIT_CONFLICT = Messages.getString("MergeConflictsDialog.ActionEditConflict");
    private static final String ACTION_EDIT_CONFLICT_AS_TEXT = Messages.getString("MergeConflictsDialog.ActionEditConflictAsText");
    private static final String ACTION_RESOLVE_LATER = Messages.getString("MergeConflictsDialog.ActionResolveLater");
    private static final String ACTION_USE_LOCAL_VERSION = Messages.getString("MergeConflictsDialog.ActionUseLocalVersion");
    private static final String ACTION_USE_REMOTE_VERSION = Messages.getString("MergeConflictsDialog.ActionUseRemoteVersion");
    private static final String[] ACTIONS = new String[]{ACTION_EDIT_CONFLICT, ACTION_EDIT_CONFLICT_AS_TEXT, ACTION_RESOLVE_LATER, ACTION_USE_LOCAL_VERSION, ACTION_USE_REMOTE_VERSION};
    protected static final SVNClientHelper SVN_CLIENT_HELPER = SVNClientHelper.getInstance();
    private static final MergeConflictsDialog INSTANCE = new MergeConflictsDialog();
    private static final Logger LOGGER = new Logger(MergeConflictsDialog.class);
    private Map<MergeConflict, String> conflictActions = new HashMap<MergeConflict, String>();
    private List<MergeConflict> mergeConflicts;
    List<VersioningTreeNode> nodesForRefreshing = new ArrayList<VersioningTreeNode>();

    public static MergeConflictsDialog getInstance() {
        return INSTANCE;
    }

    @Override
    protected String getTitle() {
        return Messages.getString("MergeConflictsDialog.MergeConflicts");
    }

    public void checkForConflicts(Design design) {
        int n;
        if (!design.getDLSettings().getMergeConflicts().isEmpty() && (n = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), Messages.getString("MergeConflictsDialog.ConflictFoundMessage"), Messages.getString("MergeConflictsDialog.ConflictFoundTitle"), 0, 2)) == 0) {
            this.processConflicts(design, null, null, false);
        }
    }

    @Override
    protected String[] getActions() {
        return ACTIONS;
    }

    @Override
    protected ActionListener getActionsActionListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Object object = MergeConflictsDialog.this.actionsComboBox.getSelectedItem();
                    if (ACTION_EDIT_CONFLICT.equals(object) || ACTION_EDIT_CONFLICT_AS_TEXT.equals(object)) {
                        final MergeConflict mergeConflict = (MergeConflict)MergeConflictsDialog.this.mergeConflicts.get(MergeConflictsDialog.this.tbActions.getSelectedRow());
                        File file = mergeConflict.getLocalFile();
                        Design design = ApplicationView.getInstance().getCurrentDesign();
                        String string = mergeConflict.getRepositoryLabel();
                        FileInputStream fileInputStream = new FileInputStream(new File(file + string));
                        String string2 = Messages.getString("VCSHistoryWindow.LocalSaved");
                        FileInputStream fileInputStream2 = new FileInputStream(file);
                        File file2 = new File(file + mergeConflict.getLocalLabel());
                        if (file2.exists()) {
                            fileInputStream2 = new FileInputStream(file2);
                        }
                        if (ACTION_EDIT_CONFLICT.equals(object)) {
                            XMLMetadataComparator xMLMetadataComparator = new XMLMetadataComparator(design, null, fileInputStream, string, fileInputStream2, string2, true);
                            Map map = xMLMetadataComparator.showModal();
                            if (map != null) {
                                XMLFromMapTransformer.transformMapToXMLFile(map, file.getPath(), design.isCompressedDesign());
                                MergeConflictsDialog.this.resolveConflict(mergeConflict);
                            }
                        } else {
                            VCSTextCompareDialog vCSTextCompareDialog = new VCSTextCompareDialog((Window)Ide.getMainWindow(), file, fileInputStream, string, fileInputStream2, string2, true, false){

                                @Override
                                public void afterSave() {
                                    super.afterSave();
                                    MergeConflictsDialog.this.resolveConflict(mergeConflict);
                                }
                            };
                            vCSTextCompareDialog.setVisible(true);
                        }
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                    LOGGER.error(fileNotFoundException);
                }
            }
        };
    }

    public List<MergeConflict> processConflicts() {
        return this.processConflicts(ApplicationView.getInstance().getCurrentDesign(), null, null, true);
    }

    public List<MergeConflict> processConflicts(Design design, List<MergeConflict> list, List<VersioningTreeNode> list2, boolean bl) {
        Object object;
        List<MergeConflict> list3 = design.getDLSettings().getMergeConflicts();
        ArrayList<VersioningTreeNode> arrayList = new ArrayList<VersioningTreeNode>();
        arrayList.addAll(SVN_CLIENT_HELPER.getLastMergedObjects());
        if (list != null) {
            block0: for (MergeConflict object2 : list) {
                object = object2.getLocalFile();
                if (list3.contains(object2)) continue;
                list3.add(object2);
                for (VersioningTreeNode versioningTreeNode : list2) {
                    if (!versioningTreeNode.getFilePath().equals(object)) continue;
                    object2.setNodeForRefreshing(versioningTreeNode);
                    continue block0;
                }
            }
        }
        if (!list3.isEmpty() || bl) {
            this.mergeConflicts = list3;
            this.conflictActions.clear();
            this.tbActions.updateUI();
            this.conflictActionsUpdate();
            if (this.showDialog()) {
                for (MergeConflict mergeConflict : this.conflictActions.keySet()) {
                    object = this.conflictActions.get(mergeConflict);
                    if (ACTION_USE_LOCAL_VERSION.equals(object)) {
                        this.resolveConflict(mergeConflict);
                        continue;
                    }
                    if (ACTION_USE_REMOTE_VERSION.equals(object)) {
                        VCSClientHelper.replace(mergeConflict.getLocalFile(), mergeConflict.getRepositoryLabel());
                        this.resolveConflict(mergeConflict);
                        continue;
                    }
                    if (!ACTION_RESOLVE_LATER.equals(object)) continue;
                    VCSClientHelper.replace(mergeConflict.getLocalFile(), mergeConflict.getLocalLabel());
                }
                if (list2 != null && list2.size() > 0) {
                    for (VersioningTreeNode versioningTreeNode : list2) {
                        arrayList.add(versioningTreeNode);
                    }
                }
                VersioningTreeNode.refresh(arrayList, false, true);
            }
            design.saveDesignLevelSettings();
        } else {
            VersioningTreeNode.refresh(arrayList, false, true);
        }
        return list3;
    }

    private void resolveConflict(MergeConflict mergeConflict) {
        File file = mergeConflict.getLocalFile();
        VCS_CLIENT_HELPER.doResolved(file);
        this.mergeConflicts.remove(mergeConflict);
        this.tbActions.updateUI();
        VersioningTreeNode versioningTreeNode = mergeConflict.getNodeForRefreshing();
        if (versioningTreeNode != null) {
            this.nodesForRefreshing.add(versioningTreeNode);
        }
    }

    @Override
    protected ChooseActionDialog.ActionsTableModel getActionsTableModel() {
        return new ChooseActionDialog.ActionsTableModel(){

            @Override
            public int getRowCount() {
                return MergeConflictsDialog.this.mergeConflicts == null ? 0 : MergeConflictsDialog.this.mergeConflicts.size();
            }

            @Override
            public Object getValueAt(int n, int n2) {
                if (n2 == 0) {
                    return ((MergeConflict)MergeConflictsDialog.this.mergeConflicts.get(n)).getStorableObjectStatus();
                }
                if (n2 == 1) {
                    String string = (String)MergeConflictsDialog.this.conflictActions.get(MergeConflictsDialog.this.mergeConflicts.get(n));
                    return string == null ? ACTION_RESOLVE_LATER : string;
                }
                return super.getValueAt(n, n2);
            }

            @Override
            public void setValueAt(Object object, int n, int n2) {
                if (n2 == 1 && !ACTION_EDIT_CONFLICT.equals(object)) {
                    MergeConflict mergeConflict = (MergeConflict)MergeConflictsDialog.this.mergeConflicts.get(n);
                    MergeConflictsDialog.this.conflictActions.put(mergeConflict, (String)object);
                }
            }
        };
    }

    @Override
    protected String getActionsTableModelFirstColumnName() {
        return Messages.getString("MergeConflictsDialog.ChangedObject");
    }

    @Override
    protected DefaultTableCellRenderer getActionsCellRenderer() {
        return new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                StorableObjectStatus storableObjectStatus = (StorableObjectStatus)object;
                this.setText(storableObjectStatus.getStorableObjectName());
                this.setIcon(VCSClientHelper.getIcon(storableObjectStatus.getObjectClass()));
                return this;
            }
        };
    }

    protected void conflictActionsUpdate() {
        for (int i = 0; i < this.tbActions.getRowCount(); ++i) {
            MergeConflict mergeConflict = this.mergeConflicts.get(i);
            this.conflictActions.put(mergeConflict, (String)this.tbActions.getModel().getValueAt(i, 1));
        }
    }
}

