/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.vcs;

import java.io.File;
import java.util.List;
import java.util.TimerTask;
import oracle.dbtools.crest.fcp.vcs.DataModelerChangeList;
import oracle.dbtools.crest.fcp.vcs.IChangeListPanel;
import oracle.dbtools.crest.fcp.vcs.StorableObjectStatus;
import oracle.dbtools.crest.fcp.vcs.VCSClientHelper;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.util.string.StringUtilities;

public abstract class DataModelerChangesTimerTask
extends TimerTask {
    protected DataModelerChangeList changeList;

    public DataModelerChangesTimerTask(DataModelerChangeList dataModelerChangeList) {
        this.changeList = dataModelerChangeList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.changeList.getWindow().isVisible() || this.changeList.isRefreshWhenNotVisible()) {
            if (!this.changeList.isBusy()) {
                List<StorableObjectStatus> list = null;
                this.changeList.setBusy(true);
                try {
                    list = this.findChanges(this.changeList.isVersionedOnly());
                }
                finally {
                    this.changeList.setBusy(false);
                }
                this.updateUI(list);
            }
            if (this.changeList.isAutoRefreshDependantChangeList() && this.changeList.getDependantChangeList() != null) {
                this.changeList.getDependantChangeList().refresh();
            }
            if (this.changeList.isAutoRefreshSecondDependantChangeList() && this.changeList.getSecondDependantChangeList() != null) {
                this.changeList.getSecondDependantChangeList().refresh();
            }
        }
    }

    public void updateUI(List<StorableObjectStatus> list) {
        IChangeListPanel iChangeListPanel;
        DataModelerChangeList dataModelerChangeList = this.changeList.getDependantChangeList();
        if (dataModelerChangeList != null && this.markConflictedStatuses(list, (iChangeListPanel = dataModelerChangeList.getPanel()).getStatuses())) {
            iChangeListPanel.update();
        }
        this.changeList.updateUI(list);
    }

    protected boolean markConflictedStatuses(List<StorableObjectStatus> list, List<StorableObjectStatus> list2) {
        boolean bl = false;
        if (list != null && list2 != null && !list.isEmpty() && !list2.isEmpty()) {
            for (StorableObjectStatus storableObjectStatus : list) {
                StorableObjectStatus storableObjectStatus2 = this.findStatusForFile(storableObjectStatus.getFilePath(), list2);
                if (storableObjectStatus2 == null) continue;
                storableObjectStatus.setTextStatus("C");
                storableObjectStatus2.setTextStatus("C");
                bl = true;
            }
        }
        return bl;
    }

    protected StorableObjectStatus findStatusForFile(File file, List<StorableObjectStatus> list) {
        for (StorableObjectStatus storableObjectStatus : list) {
            if (!storableObjectStatus.getFilePath().equals(file)) continue;
            return storableObjectStatus;
        }
        return null;
    }

    protected List<StorableObjectStatus> findChanges(boolean bl) {
        String string;
        Design design = DataModelerChangeList.getSelectedDesign();
        if (design != null && !design.isNewDesign() && StringUtilities.isNotEmpty(string = design.getDesignPath())) {
            return this.getVCSClientHelper().getStatuses(design, this.checkRemoteStatus(), this.acceptAll(), bl);
        }
        return null;
    }

    protected abstract VCSClientHelper getVCSClientHelper();

    protected abstract boolean checkRemoteStatus();

    protected boolean acceptAll() {
        return false;
    }
}

