/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.vcs;

import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JTable;
import oracle.dbtools.crest.fcp.vcs.IChangeListPanel;
import oracle.dbtools.crest.fcp.vcs.StorableObjectStatus;
import oracle.dbtools.crest.fcp.vcs.VersioningTreeNode;
import oracle.ide.model.Displayable;
import oracle.jdeveloper.vcs.vop.VersionOperationModel;
import oracle.jdeveloper.vcs.vop.VersionOperationTablePanel;
import oracle.jdevimpl.vcs.vop.ClientVersionOperationModel;

public class ChangeListTablePanel
extends VersionOperationTablePanel
implements IChangeListPanel {
    protected JTable table = (JTable)this.getInternalComponent();
    protected List<StorableObjectStatus> statuses;

    @Override
    public List<StorableObjectStatus> update() {
        if (this.statuses != null) {
            return this.update(this.statuses);
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public List<StorableObjectStatus> update(List<StorableObjectStatus> list) {
        ArrayList<StorableObjectStatus> arrayList = null;
        ClientVersionOperationModel clientVersionOperationModel = new ClientVersionOperationModel();
        if (list != null) {
            arrayList = new ArrayList<StorableObjectStatus>();
            ArrayList<FilePathDisplayable> arrayList2 = new ArrayList<FilePathDisplayable>(list.size());
            for (StorableObjectStatus storableObjectStatus : list) {
                if (!storableObjectStatus.isAdded() || storableObjectStatus.getRevision() != null) continue;
                arrayList.add(storableObjectStatus);
                arrayList2.add(new FilePathDisplayable(storableObjectStatus.getFilePath()));
            }
            this.statuses = arrayList;
            clientVersionOperationModel.add(arrayList2);
        }
        this.installModel((VersionOperationModel)clientVersionOperationModel);
        return arrayList;
    }

    @Override
    public List<StorableObjectStatus> getStatuses() {
        return this.statuses;
    }

    @Override
    public List<File> getSelectedFilePaths(List<VersioningTreeNode> list, boolean bl, boolean bl2) {
        ArrayList<File> arrayList = new ArrayList<File>(this.table.getSelectedRowCount());
        for (int n : this.table.getSelectedRows()) {
            arrayList.add(((FilePathDisplayable)this.table.getValueAt(n, 0)).getFilePath());
        }
        return arrayList;
    }

    @Override
    public VersioningTreeNode getSelectedNode() {
        return null;
    }

    @Override
    public boolean hasSelection() {
        return this.table.getSelectedColumnCount() > 0;
    }

    @Override
    public boolean hasSingleSelection() {
        return this.table.getSelectedColumnCount() == 1;
    }

    @Override
    public Component getUnderlyingComponent() {
        return this.getInternalComponent();
    }

    private class FilePathDisplayable
    implements Displayable {
        private File filePath;

        private FilePathDisplayable(File file) {
            this.filePath = file;
        }

        public File getFilePath() {
            return this.filePath;
        }

        public String getShortLabel() {
            return this.filePath.getPath();
        }

        public String getLongLabel() {
            return this.getShortLabel();
        }

        public Icon getIcon() {
            return null;
        }

        public String getToolTipText() {
            return this.getShortLabel();
        }
    }
}

