/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.preferences;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dbtools.crest.fcp.preferences.AbstractPP;
import oracle.dbtools.crest.fcp.preferences.ThirdPartyJDBCDriversPreferences;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.util.Messages;
import oracle.ide.Ide;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFilter;
import oracle.ide.panels.TraversableContext;

final class ThirdPartyJDBCDriversPP
extends AbstractPP {
    private static final long serialVersionUID = -7981976760107531787L;
    private static final String BTN_ADD = Messages.getString("OptionsDialog.Add");
    private static final String BTN_REMOVE = Messages.getString("OptionsDialog.Remove");
    private static final String BTN_UP = Messages.getString("OptionsDialog.MoveUp");
    private static final String BTN_DOWN = Messages.getString("OptionsDialog.MoveDown");
    private DefaultListModel lmJdbcDrivers;
    private JList lsJdbcDrivers;
    private String currentJdbcDriverFolder = "";
    private JPanel driversPanel;
    private JScrollPane driversScrollPane;
    private static File lastFolder = null;

    public ThirdPartyJDBCDriversPP() {
        this.setHelpID("THIRD_PARTY_JDBC_DRIVERS_PREFS_PANEL");
        this.driversPanel = new JPanel(new GridBagLayout());
        this.driversPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("OptionsDialog.ThirdPartyJDBCDrivers")));
        JPanel jPanel = new JPanel(new GridLayout(1, 2));
        jPanel.setPreferredSize(new Dimension(325, 35));
        GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
        JButton jButton = new JButton(gUIConfiguration.getIcon("ADD_ICON", this.getPreferredIconSize()));
        jButton.setToolTipText(BTN_ADD);
        jButton.addActionListener(new AddJDBCDriverAction());
        final JButton jButton2 = new JButton(gUIConfiguration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
        jButton2.setToolTipText(BTN_REMOVE);
        jButton2.addActionListener(new RemoveJDBCDriverAction());
        final JButton jButton3 = new JButton(gUIConfiguration.getIcon("MOVE_UP_ICON", this.getPreferredIconSize()));
        jButton3.setToolTipText(BTN_UP);
        jButton3.addActionListener(new UpJDBCDriverAction());
        final JButton jButton4 = new JButton(gUIConfiguration.getIcon("MOVE_DOWN_ICON", this.getPreferredIconSize()));
        jButton4.setToolTipText(BTN_DOWN);
        jButton4.addActionListener(new DownJDBCDriverAction());
        JToolBar jToolBar = new JToolBar(0);
        jToolBar.setFloatable(false);
        jToolBar.addSeparator();
        jToolBar.add(jButton);
        jToolBar.add(jButton2);
        jToolBar.addSeparator();
        jToolBar.add(jButton3);
        jToolBar.add(jButton4);
        jPanel.add(jToolBar);
        jButton2.setEnabled(false);
        jButton3.setEnabled(false);
        jButton4.setEnabled(false);
        this.lmJdbcDrivers = new DefaultListModel();
        this.lsJdbcDrivers = new JList(this.lmJdbcDrivers);
        this.lsJdbcDrivers.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (ThirdPartyJDBCDriversPP.this.lsJdbcDrivers.getSelectedIndices().length > 0) {
                    ThirdPartyJDBCDriversPP.this.currentJdbcDriverFolder = new File((String)ThirdPartyJDBCDriversPP.this.lsJdbcDrivers.getSelectedValue()).getParent();
                    jButton2.setEnabled(true);
                    jButton3.setEnabled(true);
                    jButton4.setEnabled(true);
                } else {
                    jButton2.setEnabled(false);
                    jButton3.setEnabled(false);
                    jButton4.setEnabled(false);
                }
            }
        });
        this.driversScrollPane = new JScrollPane(this.lsJdbcDrivers);
        this.driversPanel.add((Component)jPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 11, 2, new Insets(5, 5, 5, 5), 0, -1));
        this.driversPanel.add((Component)this.driversScrollPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, -1));
        this.add(this.driversPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(5, 5, 5, 5), 0, -1));
    }

    public void onEntry(TraversableContext traversableContext) {
        this.lmJdbcDrivers.clear();
        Iterator iterator = settings.getJDBCDrivers().iterator();
        while (iterator.hasNext()) {
            this.lmJdbcDrivers.addElement(iterator.next());
        }
        this.driversScrollPane.updateUI();
    }

    public void onExit(TraversableContext traversableContext) {
        settings.clearJDBCDrivers();
        Enumeration enumeration = this.lmJdbcDrivers.elements();
        while (enumeration.hasMoreElements()) {
            settings.addJDBCDriver((String)enumeration.nextElement());
        }
        ThirdPartyJDBCDriversPreferences thirdPartyJDBCDriversPreferences = this.getThirdPartyJDBCDriversPreferences(traversableContext);
        thirdPartyJDBCDriversPreferences.setJDBCDrivers(settings.getJDBCDrivers());
    }

    private ThirdPartyJDBCDriversPreferences getThirdPartyJDBCDriversPreferences(TraversableContext traversableContext) {
        return ThirdPartyJDBCDriversPreferences.getInstance(traversableContext.getPropertyStorage());
    }

    private class DownJDBCDriverAction
    implements ActionListener {
        private DownJDBCDriverAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = ThirdPartyJDBCDriversPP.this.lsJdbcDrivers.getSelectedIndices();
            if (nArray.length > 0) {
                for (int i = nArray.length - 1; i >= 0; --i) {
                    int n = nArray[i];
                    if (n >= ThirdPartyJDBCDriversPP.this.lmJdbcDrivers.getSize() - 1) continue;
                    Object e = ThirdPartyJDBCDriversPP.this.lmJdbcDrivers.getElementAt(n);
                    ThirdPartyJDBCDriversPP.this.lmJdbcDrivers.remove(n);
                    ThirdPartyJDBCDriversPP.this.lmJdbcDrivers.add(n + 1, e);
                    nArray[i] = n + 1;
                }
                ThirdPartyJDBCDriversPP.this.lsJdbcDrivers.updateUI();
                ThirdPartyJDBCDriversPP.this.lsJdbcDrivers.setSelectedIndices(nArray);
            }
        }
    }

    private class UpJDBCDriverAction
    implements ActionListener {
        private UpJDBCDriverAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = ThirdPartyJDBCDriversPP.this.lsJdbcDrivers.getSelectedIndices();
            if (nArray.length > 0) {
                for (int i = 0; i < nArray.length; ++i) {
                    int n = nArray[i];
                    if (n <= 0) continue;
                    Object e = ThirdPartyJDBCDriversPP.this.lmJdbcDrivers.getElementAt(n);
                    ThirdPartyJDBCDriversPP.this.lmJdbcDrivers.remove(n);
                    ThirdPartyJDBCDriversPP.this.lmJdbcDrivers.add(n - 1, e);
                    nArray[i] = n - 1;
                }
                ThirdPartyJDBCDriversPP.this.lsJdbcDrivers.updateUI();
                ThirdPartyJDBCDriversPP.this.lsJdbcDrivers.setSelectedIndices(nArray);
            }
        }
    }

    private class RemoveJDBCDriverAction
    implements ActionListener {
        private RemoveJDBCDriverAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = ThirdPartyJDBCDriversPP.this.lsJdbcDrivers.getSelectedIndices();
            if (nArray.length > 0) {
                for (int i = nArray.length - 1; i >= 0; --i) {
                    int n = nArray[i];
                    ThirdPartyJDBCDriversPP.this.lmJdbcDrivers.removeElementAt(n);
                }
            }
        }
    }

    private class AddJDBCDriverAction
    implements ActionListener {
        private AddJDBCDriverAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            URL[] uRLArray;
            URLFilter uRLFilter = new URLFilter(){

                public boolean accept(URL uRL) {
                    File file = new File(uRL.getPath());
                    return file.getName().toLowerCase().endsWith(".jar") || file.getName().toLowerCase().endsWith(".zip") || file.isDirectory();
                }

                public String toString() {
                    return Messages.getString("OptionsDialog.JDBCDrivers");
                }
            };
            URLChooser uRLChooser = DialogUtil.newURLChooser();
            uRLChooser.clearChooseableURLFilters();
            uRLChooser.setSelectionScope(0);
            uRLChooser.setSelectionMode(2);
            uRLChooser.setShowJarsAsDirs(false);
            uRLChooser.setURLFilter(uRLFilter);
            if (lastFolder != null) {
                uRLChooser.setSelectedURL(URLFactory.newDirURL((File)lastFolder));
            } else {
                String string = ThirdPartyJDBCDriversPP.this.getApplicationView().getSettings().getDefaultImportPath();
                if (string != null && string.length() > 0) {
                    uRLChooser.setSelectedURL(URLFactory.newDirURL((String)string));
                } else {
                    uRLArray = ThirdPartyJDBCDriversPP.this.getApplicationView().getUserHomeDirectory();
                    if (uRLArray != null) {
                        uRLChooser.setSelectedURL((URL)uRLArray);
                    }
                }
            }
            int n = uRLChooser.showOpenDialog((Component)Ide.getMainWindow(), Messages.getString("OptionsDialog.SelectDrivers"));
            if (n == 0) {
                uRLArray = uRLChooser.getSelectedURLs();
                for (int i = 0; i < uRLArray.length; ++i) {
                    File file = new File(uRLArray[i].getPath());
                    lastFolder = file.getParentFile();
                    if (file == null || ThirdPartyJDBCDriversPP.this.lmJdbcDrivers.contains(file.getAbsolutePath())) continue;
                    ThirdPartyJDBCDriversPP.this.lmJdbcDrivers.addElement(file.getAbsolutePath());
                }
            }
        }
    }
}

