/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.preferences;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.List;
import java.util.Set;
import oracle.dbtools.crest.model.designrules.DesignRule;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.designrules.DRTemporary;
import oracle.dbtools.crest.swingui.designrules.DesignRuleSet;
import oracle.dbtools.crest.util.options.Settings;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.PropertyStorage;

public class RuleSetPreferences
extends HashStructureAdapter {
    private static final String KEY = "OSDDM_RuleSets";
    private PropertyChangeSupport support = new PropertyChangeSupport((Object)this);

    protected RuleSetPreferences(HashStructure hashStructure) {
        super(hashStructure);
    }

    public static RuleSetPreferences getInstance(PropertyStorage propertyStorage) {
        return new RuleSetPreferences(RuleSetPreferences.findOrCreate((PropertyStorage)propertyStorage, (String)KEY));
    }

    public void setDesignruleSets(List list, ApplicationView applicationView) {
        HashStructure hashStructure = HashStructure.newInstance();
        for (DesignRuleSet designRuleSet : list) {
            HashStructure hashStructure2 = HashStructure.newInstance();
            hashStructure2.putString("name", designRuleSet.getName());
            for (DesignRule designRule : designRuleSet.getDesignRules()) {
                HashStructure hashStructure3 = HashStructure.newInstance();
                hashStructure3.putString("model_type", designRule.getContextString());
                hashStructure3.putString("object", designRule.getRuleHandler() != null ? designRule.getRuleHandler().getLabel() : "");
                hashStructure3.putString("name", designRule.getName());
                hashStructure2.putHashStructure(designRule.getRuleId(), hashStructure3);
            }
            designRuleSet.initDesignRules(applicationView);
            hashStructure.putHashStructure(designRuleSet.getObjectID(), hashStructure2);
        }
        this._hash.putHashStructure("rule_sets", hashStructure);
    }

    public HashStructure getDesignruleSets() {
        return this._hash.getHashStructure("rule_sets");
    }

    public void loadToSettings(Settings settings, ApplicationView applicationView) {
        HashStructure hashStructure = this.getDesignruleSets();
        if (hashStructure != null) {
            settings.getDesignRuleSets().clear();
            Set set = hashStructure.keySet();
            for (String string : set) {
                HashStructure hashStructure2 = hashStructure.getHashStructure(string);
                DesignRuleSet designRuleSet = new DesignRuleSet(hashStructure2.getString("name"), string);
                Set set2 = hashStructure2.keySet();
                for (String string2 : set2) {
                    if (string2.equals("name")) continue;
                    HashStructure hashStructure3 = hashStructure2.getHashStructure(string2);
                    DRTemporary dRTemporary = new DRTemporary();
                    dRTemporary.setRuleId(string2);
                    dRTemporary.setContextString(hashStructure3.getString("model_type"));
                    dRTemporary.setName(hashStructure3.getString("name"));
                    dRTemporary.setObject(hashStructure3.getString("object"));
                    designRuleSet.addDesignRuleTemporary(dRTemporary);
                }
                designRuleSet.initDesignRules(applicationView);
                settings.getDesignRuleSets().add(designRuleSet);
            }
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }
}

