/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.preferences;

import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import oracle.dbtools.crest.fcp.preferences.AbstractPP;
import oracle.dbtools.crest.fcp.preferences.NamingStandardPreferences;
import oracle.dbtools.crest.model.design.glossary.Glossary;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.glossary.GlossaryDialog;
import oracle.dbtools.crest.util.Messages;
import oracle.dbtools.crest.util.gui.swing.JCharField;
import oracle.dbtools.crest.util.options.namingstandards.GlossaryFile;
import oracle.dbtools.crest.util.options.namingstandards.NamingConstants;
import oracle.ide.Ide;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFilter;
import oracle.ide.panels.TraversableContext;

final class NamingStandardPP
extends AbstractPP
implements NamingConstants {
    private static final long serialVersionUID = 6672726956522996312L;
    private JComboBox separatorBox;
    private JTextField separatorText;
    private JTextField characterField;
    private JTextField dmsSeparator;
    private JCheckBox abbreviatedOnly;
    private JTable glossaryTable;
    private static final String separator = Messages.getString("OptionsDialog.SeparatorL");
    private static final String BTN_ADD = Messages.getString("OptionsDialog.Add");
    private static final String BTN_REMOVE = Messages.getString("OptionsDialog.Remove");
    private static final String space = Messages.getString("NamingStandardPP.Space");
    private static final String titleCase = Messages.getString("NamingStandardPP.TitleCase");
    private static final String character = Messages.getString("NamingStandardPP.Character");
    private final List glossariesList = new ArrayList();
    private JPanel mainPanel;
    private JPanel northPanel;
    private JPanel southPanel;
    private static File lastFolder = null;
    private LinkedHashMap map = new LinkedHashMap();

    public NamingStandardPP() {
        this.setHelpID("NAMING_STANDARD_PREFS_PANEL");
        this.mainPanel = new JPanel(new GridBagLayout());
        this.northPanel = new JPanel(new GridBagLayout());
        this.southPanel = new JPanel(new GridBagLayout());
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("OptionsDialog.LogicalModel")));
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        JLabel jLabel = new JLabel(separator);
        this.addItem(jPanel2, jLabel, 0, 0, 1, 1, 17, 100, 100);
        this.map.put("Space", space);
        this.map.put("Title Case", titleCase);
        this.map.put("Character", character);
        this.separatorBox = new JComboBox<Object>(this.map.values().toArray());
        this.separatorBox.setEditable(false);
        this.separatorBox.setSelectedItem(space);
        this.separatorBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (((String)NamingStandardPP.this.separatorBox.getSelectedItem()).equals(character)) {
                    NamingStandardPP.this.characterField.setEnabled(true);
                    NamingStandardPP.this.characterField.setEditable(true);
                } else {
                    NamingStandardPP.this.characterField.setText(" ");
                    NamingStandardPP.this.characterField.setEnabled(false);
                }
            }
        });
        this.addItem(jPanel2, this.separatorBox, 1, 0, 1, 1, 17, 100, 100);
        this.characterField = new JCharField();
        this.characterField.setText(" ");
        this.addItem(jPanel2, this.characterField, 2, 0, 1, 1, 17, 100, 100);
        this.addItem(jPanel, jPanel2, 0, 0, 1, 1, 17, 100, 100);
        this.northPanel.add((Component)jPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 2, new Insets(5, 5, 5, 5), 0, 0));
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel3.setBorder(BorderFactory.createTitledBorder(Messages.getString("OptionsDialog.RelationalModel")));
        JPanel jPanel4 = new JPanel(new FlowLayout(0));
        JLabel jLabel2 = new JLabel(separator);
        this.addItem(jPanel4, jLabel2, 0, 0, 1, 1, 17, 100, 100);
        this.separatorText = new JCharField();
        this.separatorText.setText("_");
        this.separatorText.setEditable(true);
        this.addItem(jPanel4, this.separatorText, 1, 0, 1, 1, 17, 100, 100);
        this.abbreviatedOnly = new JCheckBox(Messages.getString("OptionsDialog.AbbreviatedOnly"));
        this.addItem(jPanel4, this.abbreviatedOnly, 2, 0, 1, 1, 17, 100, 100);
        this.addItem(jPanel3, jPanel4, 0, 0, 1, 1, 17, 100, 100);
        this.northPanel.add((Component)jPanel3, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 11, 2, new Insets(5, 5, 5, 5), 0, 0));
        JPanel jPanel5 = new JPanel(new GridBagLayout());
        jPanel5.setBorder(BorderFactory.createTitledBorder(Messages.getString("OptionsDialog.Domain")));
        JPanel jPanel6 = new JPanel(new FlowLayout(0));
        JLabel jLabel3 = new JLabel(separator);
        this.addItem(jPanel6, jLabel3, 0, 0, 1, 1, 17, 100, 100);
        this.dmsSeparator = new JCharField();
        this.dmsSeparator.setText(" ");
        this.dmsSeparator.setEditable(true);
        this.addItem(jPanel6, this.dmsSeparator, 1, 0, 1, 1, 17, 100, 100);
        this.addItem(jPanel5, jPanel6, 0, 0, 1, 1, 17, 100, 100);
        this.northPanel.add((Component)jPanel5, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 11, 2, new Insets(5, 5, 5, 5), 0, 0));
        JPanel jPanel7 = new JPanel(new GridBagLayout());
        jPanel7.setBorder(BorderFactory.createTitledBorder(Messages.getString("OptionsDialog.Glossary")));
        JPanel jPanel8 = new JPanel(new GridBagLayout());
        jPanel8.setBackground(Color.WHITE);
        this.glossaryTable = new JTable(new GlossaryTableModel());
        this.glossaryTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    ((GlossaryFile)NamingStandardPP.this.glossariesList.get(NamingStandardPP.this.glossaryTable.getSelectedRow())).getFilePath();
                    Glossary glossary = new Glossary(new File(((GlossaryFile)NamingStandardPP.this.glossariesList.get(NamingStandardPP.this.glossaryTable.getSelectedRow())).getFilePath()));
                    GlossaryDialog glossaryDialog = new GlossaryDialog(NamingStandardPP.this.getApplicationView(), glossary);
                    glossaryDialog.showDialog();
                }
            }
        });
        JTableHeader jTableHeader = this.glossaryTable.getTableHeader();
        jTableHeader.setReorderingAllowed(false);
        jTableHeader.setResizingAllowed(false);
        JToolBar jToolBar = new JToolBar(0);
        jToolBar.setFloatable(false);
        jToolBar.addSeparator();
        GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
        JButton jButton = new JButton(gUIConfiguration.getIcon("ADD_ICON", 16));
        jButton.setToolTipText(BTN_ADD);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Serializable serializable;
                    URLFilter uRLFilter = new URLFilter(){

                        public boolean accept(URL uRL) {
                            File file = new File(uRL.getPath());
                            return file.getName().toLowerCase().endsWith(".glossary") || file.isDirectory();
                        }

                        public String toString() {
                            return Messages.getString("OptionsDialog.CWDGlossaryFiles");
                        }
                    };
                    URLChooser uRLChooser = DialogUtil.newURLChooser();
                    uRLChooser.clearChooseableURLFilters();
                    uRLChooser.setSelectionScope(0);
                    uRLChooser.setSelectionMode(0);
                    uRLChooser.setShowJarsAsDirs(false);
                    uRLChooser.setURLFilter(uRLFilter);
                    if (lastFolder != null) {
                        uRLChooser.setSelectedURL(URLFactory.newDirURL((File)lastFolder));
                    } else {
                        String string = NamingStandardPP.this.getApplicationView().getSettings().getDefaultImportPath();
                        if (string != null && string.length() > 0) {
                            uRLChooser.setSelectedURL(URLFactory.newDirURL((String)string));
                        } else {
                            serializable = NamingStandardPP.this.getApplicationView().getUserHomeDirectory();
                            if (serializable != null) {
                                uRLChooser.setSelectedURL((URL)serializable);
                            }
                        }
                    }
                    int n = uRLChooser.showOpenDialog((Component)Ide.getMainWindow(), Messages.getString("OptionsDialog.SelectGlossaryFile"));
                    if (n == 0 && (serializable = new File(uRLChooser.getSelectedURL().getPath())) != null) {
                        lastFolder = ((File)serializable).getParentFile();
                        Glossary glossary = new Glossary((File)serializable);
                        NamingStandardPP.this.glossariesList.add(new GlossaryFile(glossary.getName(), glossary.getDescription(), ((File)serializable).getAbsolutePath()));
                        NamingStandardPP.this.glossaryTable.updateUI();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        jToolBar.add(jButton);
        JButton jButton2 = new JButton(gUIConfiguration.getIcon("REMOVE_ICON", 16));
        jButton2.setToolTipText(BTN_REMOVE);
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = NamingStandardPP.this.glossaryTable.getSelectedRow();
                if (n != -1 && NamingStandardPP.this.glossariesList.size() > 0 && n < NamingStandardPP.this.glossariesList.size()) {
                    GlossaryFile glossaryFile = (GlossaryFile)NamingStandardPP.this.glossariesList.get(n);
                    NamingStandardPP.this.glossariesList.remove(glossaryFile);
                    NamingStandardPP.this.glossaryTable.updateUI();
                }
            }
        });
        jToolBar.add(jButton2);
        JScrollPane jScrollPane = new JScrollPane(this.glossaryTable);
        jPanel7.add((Component)jToolBar, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 11, 1, new Insets(2, 2, 2, 2), 0, 0));
        jPanel7.add((Component)jScrollPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 11, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.southPanel.add((Component)jPanel7, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.mainPanel.add((Component)this.northPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 11, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.mainPanel.add((Component)this.southPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 11, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add(this.mainPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.getApplicationView();
        if (ApplicationView.IS_VIEWER) {
            Component[] componentArray = jPanel2.getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                Component component = componentArray[i];
                component.setEnabled(false);
            }
            jPanel.validate();
            Component[] componentArray2 = jPanel4.getComponents();
            for (int i = 0; i < componentArray2.length; ++i) {
                Component component = componentArray2[i];
                component.setEnabled(false);
            }
            jPanel3.validate();
            Component[] componentArray3 = jPanel6.getComponents();
            for (int i = 0; i < componentArray3.length; ++i) {
                Component component = componentArray3[i];
                component.setEnabled(false);
            }
            jPanel5.validate();
            Component[] componentArray4 = jToolBar.getComponents();
            for (int i = 0; i < componentArray4.length; ++i) {
                Component component = componentArray4[i];
                component.setEnabled(false);
            }
            jToolBar.validate();
            this.glossaryTable.setEnabled(false);
        }
    }

    public void onEntry(TraversableContext traversableContext) {
        String string = (String)this.map.get(settings.getNamingStandardRule().getLogicalSep());
        this.separatorBox.setSelectedItem(string);
        this.characterField.setText(settings.getNamingStandardRule().getLogicalChar());
        this.separatorText.setText(settings.getNamingStandardRule().getRelSep());
        this.abbreviatedOnly.setSelected(settings.getNamingStandardRule().isAbbreviatedOnly());
        this.dmsSeparator.setText(settings.getNamingStandardRule().getDomainsSep());
        this.glossariesList.clear();
        for (GlossaryFile glossaryFile : settings.getNamingStandardRule().getGlossariesList()) {
            Glossary glossary = new Glossary(new File(glossaryFile.getFilePath()));
            this.glossariesList.add(new GlossaryFile(glossary.getName(), glossary.getDescription(), glossary.getFileName()));
        }
        this.glossaryTable.updateUI();
    }

    public void onExit(TraversableContext traversableContext) {
        String string = "";
        for (Map.Entry object : this.map.entrySet()) {
            if (!object.getValue().equals(this.separatorBox.getSelectedItem().toString())) continue;
            string = (String)object.getKey();
            break;
        }
        settings.getNamingStandardRule().setLogicalSep(string);
        settings.getNamingStandardRule().setLogicalChar(this.characterField.getText());
        settings.getNamingStandardRule().setRelSep(this.separatorText.getText());
        settings.getNamingStandardRule().setAbbreviatedOnly(this.abbreviatedOnly.isSelected());
        settings.getNamingStandardRule().setDomainsSep(this.dmsSeparator.getText());
        settings.getNamingStandardRule().getGlossariesList().clear();
        settings.getNamingStandardRule().getGlossariesList().addAll(this.glossariesList);
        if (this.getCurrentDesign().getName().equals("Untitled_1") && this.getApplicationView().getDesigns().size() == 1) {
            NamingStandardPreferences namingStandardPreferences = this.getNamingStandardPreferences(traversableContext);
            namingStandardPreferences.getNamingStandardRule().setLogicalSep(string);
            namingStandardPreferences.getNamingStandardRule().setLogicalChar(this.characterField.getText());
            namingStandardPreferences.getNamingStandardRule().setRelSep(this.separatorText.getText());
            namingStandardPreferences.getNamingStandardRule().setAbbreviatedOnly(this.abbreviatedOnly.isSelected());
            namingStandardPreferences.getNamingStandardRule().setDomainsSep(this.dmsSeparator.getText());
            namingStandardPreferences.getNamingStandardRule().getGlossariesList().clear();
            namingStandardPreferences.getNamingStandardRule().getGlossariesList().addAll(this.glossariesList);
            namingStandardPreferences.rebuildHashStructure();
        }
    }

    private boolean fileExists(String string) {
        for (GlossaryFile glossaryFile : this.glossariesList) {
            if (!glossaryFile.getFilePath().equals(string)) continue;
            return true;
        }
        return false;
    }

    private NamingStandardPreferences getNamingStandardPreferences(TraversableContext traversableContext) {
        return NamingStandardPreferences.getInstance(traversableContext.getPropertyStorage());
    }

    public class GlossaryTableModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return NamingStandardPP.this.glossariesList.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("OptionsDialog.Name");
            }
            if (n == 1) {
                return Messages.getString("OptionsDialog.Description");
            }
            if (n == 2) {
                return Messages.getString("OptionsDialog.File");
            }
            return null;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            GlossaryFile glossaryFile = (GlossaryFile)NamingStandardPP.this.glossariesList.get(n);
            if (n2 == 0) {
                return glossaryFile.getFileName();
            }
            if (n2 == 1) {
                return glossaryFile.getDescription();
            }
            if (n2 == 2) {
                return glossaryFile.getFilePath();
            }
            return n * n2;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }
}

