/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.preferences;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import oracle.dbtools.crest.util.options.Settings;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.PropertyStorage;

public final class ModelingPreferences
extends HashStructureAdapter {
    private static final String KEY = "OSDDM_ModelingPP";
    private static final String DPP = "def_proj_path";
    private static final String DIP = "def_import_path";
    private static final String DSP = "def_save_path";
    private static final String DRP = "def_reports_path";
    private static final String DSAXP = "def_saxon_path";
    private static final String DST = "def_sys_types_path";
    private static final String SSRMD = "show_select_rel_model_dialog";
    private static final String SPDN = "show_properties_dialog_on_new";
    private static final String LDLO = "load_dl_settings_on_open";
    private static final String RPDLSC = "restore_dl_settings_after_close";
    private static final String RLS = "reload_last_state";
    private static final String SIL = "show_import_log";
    private PropertyChangeSupport support = new PropertyChangeSupport((Object)this);

    private ModelingPreferences(HashStructure hashStructure) {
        super(hashStructure);
    }

    public static ModelingPreferences getInstance(PropertyStorage propertyStorage) {
        return new ModelingPreferences(ModelingPreferences.findOrCreate((PropertyStorage)propertyStorage, (String)KEY));
    }

    public void setDefaultDesignsPath(String string) {
        this._hash.putString(DPP, string);
    }

    public String getDefaultDesignsPath() {
        return this._hash.getString(DPP);
    }

    public void setDefaultImportPath(String string) {
        this._hash.putString(DIP, string);
    }

    public String getDefaultImportPath() {
        return this._hash.getString(DIP);
    }

    public void setDefaultSavePath(String string) {
        this._hash.putString(DSP, string);
    }

    public String getDefaultSavePath() {
        return this._hash.getString(DSP);
    }

    public String getDefaultReportsPath() {
        return this._hash.getString(DRP);
    }

    public void setDefaultReportsPath(String string) {
        this._hash.putString(DRP, string);
    }

    public String getDefaultSaxonPath() {
        return this._hash.getString(DSAXP);
    }

    public void setDefaultSaxonPath(String string) {
        this._hash.putString(DSAXP, string);
    }

    public String getDefaultSystemTypesPath() {
        return this._hash.getString(DST);
    }

    public void setDefaultSystemTypesPath(String string) {
        this._hash.putString(DST, string);
    }

    public boolean isShowSelectRelModelDialog() {
        return this._hash.getBoolean(SSRMD);
    }

    public void setShowSelectRelModelDialog(boolean bl) {
        this._hash.putBoolean(SSRMD, bl);
    }

    public boolean isShowPropertiesDialogOnNew() {
        return this._hash.getBoolean(SPDN);
    }

    public void setShowPropertiesDialogOnNew(boolean bl) {
        this._hash.putBoolean(SPDN, bl);
    }

    public boolean isLoadDLSettingsOnOpen() {
        return this._hash.getBoolean(LDLO);
    }

    public void setLoadDLSettingsOnOpen(boolean bl) {
        this._hash.putBoolean(LDLO, bl);
    }

    public boolean isRestorePreviousDLSettingsAfterClose() {
        return this._hash.getBoolean(RPDLSC);
    }

    public void setRestorePreviousDLSettingsAfterClose(boolean bl) {
        this._hash.putBoolean(RPDLSC, bl);
    }

    public boolean isShowImportLog() {
        return this._hash.getBoolean(SIL);
    }

    public void setShowImportLog(boolean bl) {
        this._hash.putBoolean(SIL, bl);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    public boolean isReloadLastState() {
        return this._hash.getBoolean(RLS);
    }

    public void setReloadLastState(boolean bl) {
        this._hash.putBoolean(RLS, bl);
    }

    private boolean contains(String string) {
        return this._hash.containsKey(string);
    }

    public void loadToSettings(Settings settings) {
        if (this.contains(DPP)) {
            settings.setDefaultDesignsPath(this.getDefaultDesignsPath());
        }
        if (this.contains(DIP)) {
            settings.setDefaultImportPath(this.getDefaultImportPath());
        }
        if (this.contains(DRP)) {
            settings.setDefaultReportsPath(this.getDefaultReportsPath());
        }
        if (this.contains(DSAXP)) {
            settings.setDefaultSaxonPath(this.getDefaultSaxonPath());
        }
        if (this.contains(DSP)) {
            settings.setDefaultSavePath(this.getDefaultSavePath());
        }
        if (this.contains(DST)) {
            settings.initDefaultSystemTypesPath(this.getDefaultSystemTypesPath());
        }
        if (this.contains(LDLO)) {
            settings.setLoadDLSettingsOnOpen(this.isLoadDLSettingsOnOpen());
        }
        if (this.contains(RPDLSC)) {
            settings.setRestorePreviousDLSettingsAfterClose(this.isRestorePreviousDLSettingsAfterClose());
        }
        if (this.contains(SIL)) {
            settings.setShowImportLog(this.isShowImportLog());
        }
        if (this.contains(SPDN)) {
            settings.setShowPropertiesDialogOnNew(this.isShowPropertiesDialogOnNew());
        }
        if (this.contains(SSRMD)) {
            settings.setShowSelectRelModelDialog(this.isShowSelectRelModelDialog());
        }
        if (this.contains(RLS)) {
            settings.setReloadLastState(this.isReloadLastState());
        }
    }

    public void loadFromSettings(Settings settings) {
        this.setDefaultDesignsPath(settings.getDefaultDesignsPath());
        this.setDefaultImportPath(settings.getDefaultImportPath());
        this.setDefaultSavePath(settings.getDefaultSavePath());
        this.setDefaultReportsPath(settings.getDefaultReportsPath());
        this.setDefaultSaxonPath(settings.getDefaultSaxonPath());
        this.setDefaultSystemTypesPath(settings.getDefaultSystemTypesPath());
        this.setShowSelectRelModelDialog(settings.showSelectRelModelDialog());
        this.setShowPropertiesDialogOnNew(settings.showPropertiesDialogOnNew());
        this.setLoadDLSettingsOnOpen(settings.isRestorePreviousDLSettingsAfterClose());
        this.setRestorePreviousDLSettingsAfterClose(settings.isRestorePreviousDLSettingsAfterClose());
        this.setShowImportLog(settings.showImportLog());
    }
}

