/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.preferences;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.util.options.PreferredDomain;
import oracle.dbtools.crest.util.options.Settings;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.PropertyStorage;

public final class ModelPreferences
extends HashStructureAdapter {
    private static final String KEY = "OSDDM_ModelPP";
    private static final String D_RDBMS_T = "default_rdbms_type";
    private static final String D_RDBMS_S = "default_rdbms_site";
    private static final String NA = "nulls_allowed";
    private static final String CDD = "column_default_datatype";
    private static final String PD = "preferred_domains";
    private static final String UPD = "use_preferred_domains";
    private static final String PL = "preferred_logical_types";
    private static final String UPL = "use_preferred_logical_types";
    private PropertyChangeSupport support = new PropertyChangeSupport((Object)this);

    private ModelPreferences(HashStructure hashStructure) {
        super(hashStructure);
    }

    public static ModelPreferences getInstance(PropertyStorage propertyStorage) {
        return new ModelPreferences(ModelPreferences.findOrCreate((PropertyStorage)propertyStorage, (String)KEY));
    }

    public String getDefaultRDBMSSite() {
        return this._hash.getString(D_RDBMS_S);
    }

    public void setDefaultRDBMSSite(String string) {
        this._hash.putString(D_RDBMS_S, string);
    }

    public int getDefaultRDBMSType() {
        return this._hash.getInt(D_RDBMS_T);
    }

    public void setDefaultRDBMSType(int n) {
        this._hash.putInt(D_RDBMS_T, n);
    }

    public boolean isNullsAllowed() {
        return this._hash.getBoolean(NA);
    }

    public void setNullsAllowed(boolean bl) {
        this._hash.putBoolean(NA, bl);
    }

    public String getColumnDefaultDatatype() {
        return this._hash.getString(CDD);
    }

    public void setColumnDefaultDatatype(String string) {
        this._hash.putString(CDD, string);
    }

    public HashStructure getPreferredLogicaltypes() {
        return this._hash.getHashStructure(PL);
    }

    public void setPreferredLogicaltypes(List list) {
        HashStructure hashStructure = HashStructure.newInstance();
        int n = 0;
        for (LogicalDatatype logicalDatatype : list) {
            HashStructure hashStructure2 = HashStructure.newInstance();
            hashStructure2.putString("name", logicalDatatype.getName());
            hashStructure2.putString("id", logicalDatatype.getObjectID());
            hashStructure.putHashStructure(Integer.toString(++n), hashStructure2);
        }
        this._hash.putHashStructure(PL, hashStructure);
    }

    public HashStructure getPreferredDomains() {
        return this._hash.getHashStructure(PD);
    }

    public void setPreferredDomains(List list) {
        HashStructure hashStructure = HashStructure.newInstance();
        int n = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ++n;
            PreferredDomain preferredDomain = (PreferredDomain)iterator.next();
            HashStructure hashStructure2 = HashStructure.newInstance();
            hashStructure2.putString("name", preferredDomain.getName());
            hashStructure2.putString("filename", preferredDomain.getFileName());
            hashStructure2.putString("id", preferredDomain.getObjectId());
            hashStructure.putHashStructure(Integer.toString(n), hashStructure2);
        }
        this._hash.putHashStructure(PD, hashStructure);
    }

    public String getUsePreferredLogicalTypes() {
        return this._hash.getString(UPL);
    }

    public void setUsePreferredLogicalTypes(boolean bl) {
        this._hash.putBoolean(UPL, bl);
    }

    public String getUsePreferredDomains() {
        return this._hash.getString(UPD);
    }

    public void setUsePreferredDomains(boolean bl) {
        this._hash.putBoolean(UPD, bl);
    }

    private boolean contains(String string) {
        return this._hash.containsKey(string);
    }

    public void loadToSettings(Settings settings) {
        HashStructure hashStructure;
        Iterator iterator;
        TreeSet<Integer> treeSet;
        Set set;
        HashStructure hashStructure2;
        if (this.contains(D_RDBMS_T)) {
            settings.setDefaultRDBMSType(this.getDefaultRDBMSType());
        }
        if (this.contains(D_RDBMS_S)) {
            settings.setDefaultRDBMSSite(this.getDefaultRDBMSSite());
        }
        if (this.contains(NA)) {
            settings.setNullsAllowed(this.isNullsAllowed());
        }
        if (this.contains(CDD)) {
            settings.setColumnDefaultDatatype(this.getColumnDefaultDatatype());
        }
        if (this.contains(PL)) {
            settings.getPreferredLT().clear();
            hashStructure2 = this._hash.getHashStructure(PL);
            if (hashStructure2 != null) {
                set = hashStructure2.keySet();
                treeSet = new TreeSet<Integer>();
                iterator = set.iterator();
                while (iterator.hasNext()) {
                    treeSet.add(new Integer((String)iterator.next()));
                }
                for (Integer n : treeSet) {
                    hashStructure = hashStructure2.getHashStructure(Integer.toString(n));
                    settings.getPreferredLT().add(hashStructure.getString("id"));
                }
            }
        }
        if (this.contains(PD)) {
            settings.getPreferredDomains().clear();
            hashStructure2 = this._hash.getHashStructure(PD);
            if (hashStructure2 != null) {
                set = hashStructure2.keySet();
                treeSet = new TreeSet();
                iterator = set.iterator();
                while (iterator.hasNext()) {
                    treeSet.add(new Integer((String)iterator.next()));
                }
                for (Integer n : treeSet) {
                    hashStructure = hashStructure2.getHashStructure(Integer.toString(n));
                    PreferredDomain preferredDomain = new PreferredDomain();
                    preferredDomain.setFileName(hashStructure.getString("filename"));
                    preferredDomain.setObjectId(hashStructure.getString("id"));
                    preferredDomain.setName(hashStructure.getString("name"));
                    settings.getPreferredDomains().add(preferredDomain);
                }
            }
        }
    }

    public void loadFromSettings(Settings settings) {
        this.setDefaultRDBMSSite(settings.getDefaultRDBMSSite());
        this.setDefaultRDBMSType(settings.getDefaultRDBMSType());
        this.setColumnDefaultDatatype(settings.getColumnDefaultDatatype());
        this.setNullsAllowed(settings.getNullsAllowed());
        HashStructure hashStructure = this.getPreferredLogicaltypes();
        if (hashStructure != null) {
            hashStructure.clear();
        }
        this.setPreferredLogicaltypes(settings.getPreferredLogicaltypes());
        HashStructure hashStructure2 = this.getPreferredDomains();
        if (hashStructure2 != null) {
            hashStructure2.clear();
        }
        this.setPreferredDomains(settings.getPreferredDomains());
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }
}

