/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.preferences;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.dbtools.crest.fcp.preferences.AbstractPP;
import oracle.dbtools.crest.fcp.preferences.ModelPhysicalOraclePreferences;
import oracle.dbtools.crest.util.Messages;
import oracle.dbtools.crest.util.options.oracle.OracleIndexTemplate;
import oracle.dbtools.crest.util.options.oracle.OracleIndexTemplateDialog;
import oracle.dbtools.crest.util.options.oracle.OracleTableTemplate;
import oracle.dbtools.crest.util.options.oracle.OracleTableTemplateDialog;
import oracle.ide.panels.TraversableContext;

final class ModelPhysicalOraclePP
extends AbstractPP {
    private static final long serialVersionUID = -3185294406341791172L;
    private static final String DIALOG_NAME = Messages.getString("OptionsDialog.NameElementProvider");
    private JTextField defaultOracleOwner;
    private JTextField defaultOracleTablespace;
    private JCheckBox chbOracleTableTemplate;
    private JCheckBox chbOracleIndexTemplate;
    private JButton bnOracleTableTemplate;
    private JButton bnOracleIndexTemplate;
    private JTextField defaultOracleTriggerName;
    private JTextField defaultOracleSequenceName;
    private final OracleTableTemplate oracleTableTemplate = settings.getOracleTableTemplate();
    private final OracleIndexTemplate oracleIndexTemplate = settings.getOracleIndexTemplate();

    public ModelPhysicalOraclePP() {
        this.setHelpID("MODEL_PHYSICAL_ORACLE_PREFS_PANEL");
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("OptionsDialog.Defaults")));
        JLabel jLabel = new JLabel(Messages.getString("OptionsDialog.DefaultUser"));
        this.addItem(jPanel, jLabel, 0, 0, 1, 1, 17, 0, 100);
        this.defaultOracleOwner = new JTextField();
        this.addItem(jPanel, this.defaultOracleOwner, 1, 0, 2, 1, 17, 100, 100);
        jLabel = new JLabel(Messages.getString("OptionsDialog.DefaultTablespace"));
        this.addItem(jPanel, jLabel, 0, 1, 1, 1, 17, 0, 100);
        this.defaultOracleTablespace = new JTextField();
        this.addItem(jPanel, this.defaultOracleTablespace, 1, 1, 2, 1, 17, 100, 100);
        this.chbOracleTableTemplate = new JCheckBox(Messages.getString("OptionsDialog.UseTableTemplate"));
        this.addItem(jPanel, this.chbOracleTableTemplate, 0, 2, 1, 1, 17, 0, 100);
        this.bnOracleTableTemplate = new JButton(Messages.getString("OptionsDialog.ViewEdit"));
        this.addItem(jPanel, this.bnOracleTableTemplate, 1, 2, 1, 1, 17, 0, 100);
        this.chbOracleTableTemplate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ModelPhysicalOraclePP.this.bnOracleTableTemplate.setEnabled(ModelPhysicalOraclePP.this.chbOracleTableTemplate.isSelected());
            }
        });
        this.bnOracleTableTemplate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                new OracleTableTemplateDialog(ModelPhysicalOraclePP.this.getApplicationView(), ModelPhysicalOraclePP.this.oracleTableTemplate).showDialog();
            }
        });
        this.chbOracleIndexTemplate = new JCheckBox(Messages.getString("OptionsDialog.UseIndexTemplate"));
        this.addItem(jPanel, this.chbOracleIndexTemplate, 0, 3, 1, 1, 17, 0, 100);
        this.bnOracleIndexTemplate = new JButton(Messages.getString("OptionsDialog.ViewEdit"));
        this.addItem(jPanel, this.bnOracleIndexTemplate, 1, 3, 1, 1, 17, 0, 100);
        this.chbOracleIndexTemplate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ModelPhysicalOraclePP.this.bnOracleIndexTemplate.setEnabled(ModelPhysicalOraclePP.this.chbOracleIndexTemplate.isSelected());
            }
        });
        this.bnOracleIndexTemplate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                new OracleIndexTemplateDialog(ModelPhysicalOraclePP.this.getApplicationView(), ModelPhysicalOraclePP.this.oracleIndexTemplate).showDialog();
            }
        });
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setBorder(BorderFactory.createTitledBorder(Messages.getString("OptionsDialog.AutoIncrementColumnTemplates")));
        this.addItem(jPanel2, new JLabel(Messages.getString("OptionsDialog.TriggerName")), 0, 0, 1, 1, 17, 0, 100);
        this.defaultOracleTriggerName = new JTextField();
        this.addItem(jPanel2, this.defaultOracleTriggerName, 1, 0, 1, 1, 17, 100, 100);
        JButton jButton = new JButton(Messages.getString("OptionsDialog.AddVariable"));
        this.addItem(jPanel2, jButton, 2, 0, 1, 1, 17, 0, 100);
        jButton.addActionListener(new AddVariableActionListener(this.defaultOracleTriggerName));
        this.addItem(jPanel2, new JLabel(Messages.getString("OptionsDialog.SequenceName")), 0, 1, 1, 1, 17, 0, 100);
        this.defaultOracleSequenceName = new JTextField();
        this.addItem(jPanel2, this.defaultOracleSequenceName, 1, 1, 1, 1, 17, 100, 100);
        jButton = new JButton(Messages.getString("OptionsDialog.AddVariable"));
        this.addItem(jPanel2, jButton, 2, 1, 1, 1, 17, 0, 100);
        jButton.addActionListener(new AddVariableActionListener(this.defaultOracleSequenceName));
        this.add(jPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 11, 2, new Insets(5, 5, 5, 5), 0, -1));
        this.add(jPanel2, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 11, 2, new Insets(5, 5, 5, 5), 0, -1));
    }

    public void onEntry(TraversableContext traversableContext) {
        this.defaultOracleOwner.setText(settings.getDefaultOracleUser());
        this.defaultOracleTablespace.setText(settings.getDefaultOracleTablespace());
        this.chbOracleTableTemplate.setSelected(settings.useOracleTableTemplate());
        this.chbOracleIndexTemplate.setSelected(settings.useOracleIndexTemplate());
        this.bnOracleTableTemplate.setEnabled(this.chbOracleTableTemplate.isSelected());
        this.bnOracleIndexTemplate.setEnabled(this.chbOracleIndexTemplate.isSelected());
        this.defaultOracleTriggerName.setText(settings.getDefaultOracleTriggerName());
        this.defaultOracleSequenceName.setText(settings.getDefaultOracleSequenceName());
    }

    public void onExit(TraversableContext traversableContext) {
        settings.setDefaultOracleUser(this.defaultOracleOwner.getText());
        settings.setDefaultOracleTablespace(this.defaultOracleTablespace.getText());
        boolean bl = this.chbOracleTableTemplate.isSelected();
        boolean bl2 = this.chbOracleIndexTemplate.isSelected();
        settings.setUseOracleTableTemplate(bl);
        settings.setUseOracleIndexTemplate(bl2);
        if (bl) {
            this.oracleTableTemplate.copyTo(settings.getOracleTableTemplate());
        }
        if (bl2) {
            this.oracleIndexTemplate.copyTo(settings.getOracleIndexTemplate());
        }
        settings.setDefaultOracleTriggerName(this.defaultOracleTriggerName.getText());
        settings.setDefaultOracleSequenceName(this.defaultOracleSequenceName.getText());
        ModelPhysicalOraclePreferences modelPhysicalOraclePreferences = this.getModelPhysicalOraclePreferences(traversableContext);
        modelPhysicalOraclePreferences.setDefaultOracleUser(this.defaultOracleOwner.getText());
        modelPhysicalOraclePreferences.setDefaultOracleTablespace(this.defaultOracleTablespace.getText());
        modelPhysicalOraclePreferences.setUseOracleTableTemplate(bl);
        modelPhysicalOraclePreferences.setUseOracleIndexTemplate(bl2);
        modelPhysicalOraclePreferences.setDefaultOracleTriggerName(this.defaultOracleTriggerName.getText());
        modelPhysicalOraclePreferences.setDefaultOracleSequenceName(this.defaultOracleSequenceName.getText());
        modelPhysicalOraclePreferences.setTableTemplate(this.oracleTableTemplate);
        modelPhysicalOraclePreferences.setIndexTemplate(this.oracleIndexTemplate);
    }

    @Override
    protected String getDialogName() {
        return DIALOG_NAME;
    }

    private ModelPhysicalOraclePreferences getModelPhysicalOraclePreferences(TraversableContext traversableContext) {
        return ModelPhysicalOraclePreferences.getInstance(traversableContext.getPropertyStorage());
    }

    private class AddVariableActionListener
    implements ActionListener {
        private JTextField textField;

        private AddVariableActionListener(JTextField jTextField) {
            this.textField = jTextField;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String[][] stringArray = new String[][]{{"{table}", Messages.getString("ModelPhysicalOraclePP.TableName")}, {"{table abbr}", Messages.getString("ModelPhysicalOraclePP.TableAbbreviation")}, {"{column}", Messages.getString("ModelPhysicalOraclePP.ColumnName")}, {"{column abbr}", Messages.getString("ModelPhysicalOraclePP.ColumnAbbreviation")}};
            ModelPhysicalOraclePP.this.createDialog(stringArray, this.textField);
        }
    }
}

