/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.preferences;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import oracle.dbtools.crest.fcp.preferences.AbstractPP;
import oracle.dbtools.crest.fcp.preferences.ModelLogicalPreferences;
import oracle.dbtools.crest.util.Messages;
import oracle.ide.panels.TraversableContext;

final class ModelLogicalPP
extends AbstractPP {
    private static final long serialVersionUID = 6864529153340657983L;
    private JCheckBox chbSourceOptional;
    private JCheckBox chbTargetOptional;
    private JCheckBox chbFirstUniqueForIdentifyingRelation;
    private JCheckBox chbKeepFKNamesSynchronized;

    public ModelLogicalPP() {
        this.setHelpID("MODEL_LOGICAL_PREFS_PANEL");
        this.createRelationCardinality();
        this.createIdentifyingRelationships();
        this.createFKAttributeNameSychronization();
    }

    public void onEntry(TraversableContext traversableContext) {
        this.chbSourceOptional.setSelected(settings.isSourceOptional());
        this.chbTargetOptional.setSelected(settings.isTargetOptional());
        this.chbFirstUniqueForIdentifyingRelation.setSelected(settings.isUseFirstUniqueForIdentifyingRelation());
        this.chbKeepFKNamesSynchronized.setSelected(settings.isKeepFKNamesSynchronized());
    }

    public void onExit(TraversableContext traversableContext) {
        settings.setSourceOptional(this.chbSourceOptional.isSelected());
        settings.setTargetOptional(this.chbTargetOptional.isSelected());
        settings.setUseFirstUniqueForIdentifyingRelation(this.chbFirstUniqueForIdentifyingRelation.isSelected());
        ModelLogicalPreferences modelLogicalPreferences = this.getModelLogicalPreferences(traversableContext);
        modelLogicalPreferences.setSourceOptional(this.chbSourceOptional.isSelected());
        modelLogicalPreferences.setTargetOptional(this.chbTargetOptional.isSelected());
        modelLogicalPreferences.setUseFirstUniqueForIdentifyingRelation(this.chbFirstUniqueForIdentifyingRelation.isSelected());
        if (this.chbKeepFKNamesSynchronized.isSelected() && !settings.isKeepFKNamesSynchronized()) {
            settings.setKeepFKNamesSynchronized(this.chbKeepFKNamesSynchronized.isSelected());
            modelLogicalPreferences.setKeepFKNamesSynchronized(this.chbKeepFKNamesSynchronized.isSelected());
            this.getCurrentDesign().getLogicalDesign().synchronizeFKAttributesName();
        } else {
            settings.setKeepFKNamesSynchronized(this.chbKeepFKNamesSynchronized.isSelected());
            modelLogicalPreferences.setKeepFKNamesSynchronized(this.chbKeepFKNamesSynchronized.isSelected());
        }
        settings.setKeepFKNamesSynchronized(this.chbKeepFKNamesSynchronized.isSelected());
        modelLogicalPreferences.setKeepFKNamesSynchronized(this.chbKeepFKNamesSynchronized.isSelected());
    }

    private void createRelationCardinality() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("OptionsDialog.RelationCardinality")));
        this.chbSourceOptional = new JCheckBox(Messages.getString("OptionsDialog.SourceOptional"));
        this.addItem(jPanel, this.chbSourceOptional, 0, 0, 1, 1, 17, 1, 100);
        this.chbTargetOptional = new JCheckBox(Messages.getString("OptionsDialog.TargetOptional"));
        this.addItem(jPanel, this.chbTargetOptional, 0, 1, 1, 1, 17, 1, 100);
        this.add(jPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 11, 2, new Insets(5, 5, 5, 5), 0, -1));
    }

    private void createIdentifyingRelationships() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("OptionsDialog.PKOptionForIdentifyingRelationships")));
        this.chbFirstUniqueForIdentifyingRelation = new JCheckBox(Messages.getString("OptionsDialog.UseAndSetfirstUKAsPK"));
        this.addItem(jPanel, this.chbFirstUniqueForIdentifyingRelation, 0, 0, 1, 1, 17, 1, 100);
        this.add(jPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 11, 2, new Insets(5, 5, 5, 5), 0, -1));
    }

    private void createFKAttributeNameSychronization() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("OptionsDialog.FKAttributeNameSynchronization")));
        this.chbKeepFKNamesSynchronized = new JCheckBox(Messages.getString("OptionsDialog.KeepAsNameOfOriginatingAttribute"));
        this.addItem(jPanel, this.chbKeepFKNamesSynchronized, 0, 0, 1, 1, 17, 1, 100);
        this.add(jPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 11, 2, new Insets(5, 5, 5, 5), 0, -1));
    }

    private ModelLogicalPreferences getModelLogicalPreferences(TraversableContext traversableContext) {
        return ModelLogicalPreferences.getInstance(traversableContext.getPropertyStorage());
    }
}

