/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.preferences;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import oracle.dbtools.crest.fcp.preferences.AbstractPP;
import oracle.dbtools.crest.fcp.preferences.DiagramRelationalModelPreferences;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.util.Messages;
import oracle.ide.panels.ApplyEvent;
import oracle.ide.panels.TraversableContext;

final class DiagramRelationalModelPP
extends AbstractPP {
    private static final long serialVersionUID = -988773740717759657L;
    private JRadioButton rbFK2PK;
    private JRadioButton rbPK2FK;
    private boolean oldFK2PKArrow;

    public DiagramRelationalModelPP() {
        this.setHelpID("DIAGRAM_RELATIONAL_MODEL_PREFS_PANEL");
        JPanel jPanel = new JPanel(new GridBagLayout());
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setBorder(BorderFactory.createTitledBorder(Messages.getString("OptionsDialog.ForeignKeyArrowDirection")));
        this.rbFK2PK = new JRadioButton(Messages.getString("OptionsDialog.FromForeignKeyToPrimaryKey"));
        this.rbPK2FK = new JRadioButton(Messages.getString("OptionsDialog.FromPrimaryKeyToForeignKey"));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.rbFK2PK);
        buttonGroup.add(this.rbPK2FK);
        this.addItem(jPanel2, this.rbFK2PK, 0, 0, 1, 1, 17, 1, 100);
        this.addItem(jPanel2, this.rbPK2FK, 0, 1, 1, 1, 17, 1, 100);
        this.addItem(jPanel, jPanel2, 0, 0, 1, 1, 17, 1, 100);
        this.add(jPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 2, new Insets(5, 5, 5, 5), 0, -1));
    }

    public void onEntry(TraversableContext traversableContext) {
        this.oldFK2PKArrow = settings.isFk2pkArrow();
        if (settings.isFk2pkArrow()) {
            this.rbFK2PK.setSelected(true);
        } else {
            this.rbPK2FK.setSelected(true);
        }
    }

    public void onExit(TraversableContext traversableContext) {
        settings.setFk2pkArrow(this.rbFK2PK.isSelected());
        DiagramRelationalModelPreferences diagramRelationalModelPreferences = this.getDiagramRelationalModelPreferences(traversableContext);
        diagramRelationalModelPreferences.setFk2pkArrow(this.rbFK2PK.isSelected());
    }

    @Override
    public void apply(ApplyEvent applyEvent) {
        super.apply(applyEvent);
        boolean bl = settings.isFk2pkArrow();
        if (this.oldFK2PKArrow != bl) {
            this.oldFK2PKArrow = bl;
            Iterator iterator = this.getCurrentDesign().getRelationalDesigns().iterator();
            while (iterator.hasNext()) {
                RelationalDesign relationalDesign = (RelationalDesign)iterator.next();
                relationalDesign.updateFKViews();
            }
        }
    }

    private DiagramRelationalModelPreferences getDiagramRelationalModelPreferences(TraversableContext traversableContext) {
        return DiagramRelationalModelPreferences.getInstance(traversableContext.getPropertyStorage());
    }
}

