/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.preferences;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import oracle.dbtools.crest.util.SubstitutionPattern;
import oracle.dbtools.crest.util.options.Settings;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.PropertyStorage;

public final class DDLMigrationPreferences
extends HashStructureAdapter {
    private static final String KEY = "OSDDM_DDLMigrationPP";
    private static final String SUBST_LIST = "substitution_patterns";
    private PropertyChangeSupport support = new PropertyChangeSupport((Object)this);

    protected DDLMigrationPreferences(HashStructure hashStructure) {
        super(hashStructure);
    }

    public static DDLMigrationPreferences getInstance(PropertyStorage propertyStorage) {
        return new DDLMigrationPreferences(DDLMigrationPreferences.findOrCreate((PropertyStorage)propertyStorage, (String)KEY));
    }

    public HashStructure getSubstList() {
        return this._hash.getHashStructure(SUBST_LIST);
    }

    public void setSubstList(List list) {
        Iterator iterator = list.iterator();
        HashStructure hashStructure = HashStructure.newInstance();
        int n = 0;
        while (iterator.hasNext()) {
            ++n;
            SubstitutionPattern substitutionPattern = (SubstitutionPattern)iterator.next();
            HashStructure hashStructure2 = HashStructure.newInstance();
            hashStructure2.putString("oldstring", substitutionPattern.getSourceString());
            hashStructure2.putString("newstring", substitutionPattern.getReplacementString());
            hashStructure2.putString("comments", substitutionPattern.getComments());
            hashStructure2.putBoolean("selected", substitutionPattern.isSelected());
            hashStructure2.putBoolean("casesensitive", substitutionPattern.isCaseSensitive());
            hashStructure.putHashStructure(Integer.toString(n), hashStructure2);
        }
        this._hash.putHashStructure(SUBST_LIST, hashStructure);
    }

    private boolean contains(String string) {
        return this._hash.containsKey(string);
    }

    public void loadToSettings(Settings settings) {
        List list = settings.getSubstitutionList();
        list.clear();
        HashStructure hashStructure = this.getSubstList();
        if (hashStructure != null) {
            Set set = hashStructure.keySet();
            TreeSet<Integer> treeSet = new TreeSet<Integer>();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                treeSet.add(new Integer((String)iterator.next()));
            }
            for (Integer n : treeSet) {
                HashStructure hashStructure2 = hashStructure.getHashStructure(Integer.toString(n));
                SubstitutionPattern substitutionPattern = new SubstitutionPattern(hashStructure2.getString("oldstring"), hashStructure2.getString("newstring"), hashStructure2.getBoolean("selected"), hashStructure2.getBoolean("casesensitive"), hashStructure2.getString("comments"));
                list.add(substitutionPattern);
            }
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    public void loadFromSettings(Settings settings) {
        HashStructure hashStructure = this.getSubstList();
        if (hashStructure != null) {
            hashStructure.clear();
        }
        this.setSubstList(settings.getSubstitutionList());
    }
}

