/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.preferences;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.LinkedHashMap;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.Spring;
import javax.swing.SpringLayout;
import javax.swing.table.AbstractTableModel;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.options.Settings;
import oracle.ide.Ide;
import oracle.ide.panels.ApplyEvent;
import oracle.ide.panels.ApplyListener;
import oracle.ide.panels.DefaultTraversablePanel;

public abstract class AbstractPP
extends DefaultTraversablePanel
implements ApplyListener {
    private static final long serialVersionUID = -2110266704679839622L;
    protected String names = "";
    protected static Settings global_settings;
    public static Settings settings;
    private ApplicationView appView = this.getApplicationView();
    private String gs;
    private static boolean oldBoxInBox;
    private static int oldNotation;
    private static final String PRIME_WORD_L;
    private static final String CLASS_WORD_L;
    private static final String MODIFIER_L;
    private static final String QUALIFIER_L;
    public static LinkedHashMap namePartMap;

    public AbstractPP() {
        if (settings == null) {
            global_settings = this.appView.getSettings();
            this.gs = global_settings.saveSettingsToString();
            settings = new Settings(this.appView);
            settings.loadSettingsFromString(this.gs, true);
            settings.loadDLSettings(this.getCurrentDesign().getDLSettings().getDesignLevelSettings());
            oldNotation = global_settings.getNotation();
            oldBoxInBox = global_settings.isBoxInBox();
        }
        this.initConstants();
        this.setLayout(new GridBagLayout());
    }

    public final void setObjectConstraints(JPanel jPanel, Component component, int n, int n2) {
        SpringLayout.Constraints constraints = ((SpringLayout)jPanel.getLayout()).getConstraints(component);
        constraints.setX(Spring.constant(n));
        constraints.setY(Spring.constant(n2));
    }

    public void setBG(Component component) {
        component.setBackground(Color.WHITE);
        if (!component.getFont().isPlain()) {
            component.setFont(new Font(component.getFont().getName(), 0, component.getFont().getSize()));
        }
    }

    public final int getPreferredIconSize() {
        return 16;
    }

    public final Dimension getPreferredPanelSize() {
        return new Dimension(580, 380);
    }

    public ApplicationView getApplicationView() {
        return ApplicationView.getInstance();
    }

    public Design getCurrentDesign() {
        return this.getApplicationView().getCurrentDesign();
    }

    public void cancel(ApplyEvent applyEvent) {
    }

    public void apply(ApplyEvent applyEvent) {
        this.getCurrentDesign().setDlSettings(settings.saveSettingsToString());
        this.getCurrentDesign().setDlSettingsChanged(true);
        if (this.getCurrentDesign().getName().equals("Untitled_1") && this.appView.getDesigns().size() == 1) {
            global_settings.loadSettingsFromString(settings.saveSettingsToString(), true);
            this.appView.getInitialSettings().loadSettingsFromString(settings.saveSettingsToString(), true);
        } else {
            global_settings.loadSettingsFromString(settings.saveSettingsToString(), false);
            this.appView.getInitialSettings().loadSettingsFromString(settings.saveSettingsToString(), false);
        }
        int n = settings.getNotation();
        boolean bl = false;
        if (oldNotation != n) {
            bl = true;
            this.names = "".equals(this.names) ? "\"Notation\"" : this.names + ", \"Notation\"";
        }
        boolean bl2 = settings.isBoxInBox();
        boolean bl3 = false;
        if (oldBoxInBox != bl2) {
            bl3 = true;
            this.names = "".equals(this.names) ? "\"Box-In-Box Presentation\"" : this.names + ", \"Box-In-Box Presentation\"";
        }
        if (!"".equals(this.names)) {
            int n2 = JOptionPane.showOptionDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("OptionsDialog.ApplyNewSettings"), this.names), MessageFormat.format(Messages.getString("OptionsDialog.ChangeIn"), this.names), 0, 3, null, new String[]{Messages.getString("OptionsDialog.Yes"), Messages.getString("OptionsDialog.No")}, Messages.getString("OptionsDialog.No"));
            if (n2 == 0) {
                this.getApplicationView().updateSettings(bl, bl3);
            } else {
                this.getApplicationView().updateSettings(false, false);
            }
        } else {
            this.getApplicationView().updateSettings(false, false);
        }
        settings.refreshDefaultRDBMSSites();
        settings.refreshDefaultTypes();
        settings.refreshDefaultDomains();
    }

    protected void addItem(JPanel jPanel, JComponent jComponent, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.weightx = n6;
        gridBagConstraints.weighty = n7;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        gridBagConstraints.anchor = n5;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)jComponent, gridBagConstraints);
    }

    protected void addItem(JPanel jPanel, JComponent jComponent, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.weightx = n6;
        gridBagConstraints.weighty = n7;
        gridBagConstraints.insets = new Insets(n8, n9, n10, n11);
        gridBagConstraints.anchor = n5;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)jComponent, gridBagConstraints);
    }

    protected String getDialogName() {
        return null;
    }

    protected void createDialog(String[][] stringArray, JTextField jTextField) {
        KeyDialog keyDialog = new KeyDialog(this.getApplicationView(), this.getDialogName());
        keyDialog.setValues(stringArray);
        keyDialog.setVisible(true);
        StringBuffer stringBuffer = new StringBuffer();
        int n = jTextField.getCaretPosition();
        int n2 = jTextField.getText().length();
        if (n == 0) {
            stringBuffer.append(keyDialog.getProviderName());
        }
        if (n2 != 0) {
            for (int i = 0; i < n2; ++i) {
                String string;
                stringBuffer.append(jTextField.getText().charAt(i));
                if (n != i + 1 || (string = keyDialog.getProviderName()) == null) continue;
                stringBuffer.append(string);
            }
            jTextField.setText(stringBuffer.toString());
        } else {
            jTextField.setText(keyDialog.getProviderName());
        }
    }

    private void initConstants() {
        namePartMap.put("Prime Word", PRIME_WORD_L);
        namePartMap.put("Class Word", CLASS_WORD_L);
        namePartMap.put("Modifier", MODIFIER_L);
        namePartMap.put("Qualifier", QUALIFIER_L);
    }

    static {
        PRIME_WORD_L = Messages.getString("NamingStandardEntityPP.PrimeWord");
        CLASS_WORD_L = Messages.getString("NamingStandardEntityPP.ClassWord");
        MODIFIER_L = Messages.getString("NamingStandardEntityPP.Modifier");
        QUALIFIER_L = Messages.getString("NamingStandardEntityPP.Qualifier");
        namePartMap = new LinkedHashMap();
    }

    static class NameProvider {
        private String name = "";

        NameProvider() {
        }

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }
    }

    public static class KeyDialog
    extends JDialog {
        private static final String KEY_ESCAPE = "ESCAPE";
        private JTable nameTable;
        private JScrollPane pane;
        private JPanel buttonsPanel;
        private String[][] values = new String[0][];
        private NameProvider provider = new NameProvider();
        private Action escapeAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                KeyDialog.this.dispose();
            }
        };

        public KeyDialog(ApplicationView applicationView, String string) {
            super(applicationView.getFrame());
            this.setTitle(string);
            this.nameTable = new JTable(new KeyTableModel());
            this.nameTable.setSelectionMode(0);
            this.nameTable.setTableHeader(null);
            this.pane = new JScrollPane(this.nameTable);
            this.pane.setPreferredSize(new Dimension(500, 130));
            this.getContentPane().add(this.pane);
            this.getContentPane().add((Component)this.getButtonPanel(), "South");
            this.setResizable(false);
            this.setModal(true);
            this.pack();
            CommonUtil.centerOnScreen(this);
            int n = 1;
            JComponent jComponent = (JComponent)this.getContentPane();
            jComponent.getInputMap(n).put(KeyStroke.getKeyStroke(KEY_ESCAPE), KEY_ESCAPE);
            jComponent.getActionMap().put(KEY_ESCAPE, this.escapeAction);
        }

        protected JPanel getButtonPanel() {
            if (this.buttonsPanel == null) {
                this.buttonsPanel = new JPanel();
                JButton jButton = new JButton(Messages.getString("OptionsDialog.OK"));
                jButton.setMnemonic(79);
                jButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
                jButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (KeyDialog.this.nameTable.getSelectedRow() != -1) {
                            KeyDialog.this.provider.setName(KeyDialog.this.nameTable.getValueAt(KeyDialog.this.nameTable.getSelectedRow(), 0).toString());
                        }
                        KeyDialog.this.dispose();
                    }
                });
                JButton jButton2 = new JButton(Messages.getString("OptionsDialog.Cancel"));
                jButton2.setMnemonic(67);
                jButton2.setPreferredSize(MessageDialogs.BUTTON_SIZE);
                jButton2.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        KeyDialog.this.dispose();
                    }
                });
                this.buttonsPanel.add(jButton);
                this.buttonsPanel.add(jButton2);
            }
            return this.buttonsPanel;
        }

        public String getProviderName() {
            return this.provider.getName();
        }

        public void setValues(String[][] stringArray) {
            this.values = stringArray;
        }

        class KeyTableModel
        extends AbstractTableModel {
            KeyTableModel() {
            }

            @Override
            public int getColumnCount() {
                return 2;
            }

            @Override
            public int getRowCount() {
                return KeyDialog.this.values.length;
            }

            @Override
            public Object getValueAt(int n, int n2) {
                return KeyDialog.this.values[n][n2];
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        }
    }
}

