/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp;

import oracle.dbtools.crest.fcp.BrowserDockable;
import oracle.dbtools.crest.fcp.NavigatorDockable;
import oracle.dbtools.crest.fcp.vcs.svn.SVNChangeListWindow;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockableFactory;
import oracle.ide.docking.DockingParam;
import oracle.ide.layout.ViewId;
import oracle.ide.log.LogManager;

public class EXTDockableFactory
implements DockableFactory {
    public static final String FAMILY = "EXTDockable";
    private BrowserDockable browserDockable;
    private NavigatorDockable navigatorDockable;
    private SVNChangeListWindow svnChangeListWindow;

    public EXTDockableFactory() {
        DockStation dockStation = DockStation.getDockStation();
        dockStation.registerDockableFactory(FAMILY, (DockableFactory)this);
    }

    public void install() {
        DockStation dockStation = DockStation.getDockStation();
        DockingParam dockingParam = new DockingParam();
        dockingParam.setPosition(0);
        dockStation.dock((Dockable)this.getBrowserDockable(), dockingParam);
        dockingParam = new DockingParam();
        dockingParam.setPosition(1);
        dockStation.dock((Dockable)this.getNavigatorDockable(), dockingParam);
        dockingParam = new DockingParam();
        dockingParam.setPosition((Dockable)LogManager.getIdeLogWindow(), 4);
        dockStation.dock((Dockable)this.getSVNChangeListWindow(), dockingParam);
    }

    public Dockable getDockable(ViewId viewId) {
        Object object = BrowserDockable.VIEW_ID.equals((Object)viewId) ? this.getBrowserDockable() : (NavigatorDockable.VIEW_ID.equals((Object)viewId) ? this.getNavigatorDockable() : (SVNChangeListWindow.VIEW_ID.equals((Object)viewId) ? this.getSVNChangeListWindow() : null));
        return object;
    }

    public BrowserDockable getBrowserDockable() {
        if (this.browserDockable == null) {
            this.browserDockable = new BrowserDockable();
        }
        return this.browserDockable;
    }

    public NavigatorDockable getNavigatorDockable() {
        if (this.navigatorDockable == null) {
            this.navigatorDockable = new NavigatorDockable();
        }
        return this.navigatorDockable;
    }

    public SVNChangeListWindow getSVNChangeListWindow() {
        if (this.svnChangeListWindow == null) {
            this.svnChangeListWindow = new SVNChangeListWindow();
        }
        return this.svnChangeListWindow;
    }
}

