/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp;

import java.awt.Component;
import java.util.EventObject;
import javax.swing.SwingUtilities;
import oracle.dbtools.crest.fcp.DMDiagramNode;
import oracle.dbtools.crest.fcp.DataModelerController;
import oracle.dbtools.crest.fcp.OpenEditorRunner;
import oracle.dbtools.crest.model.design.datatypes.DataTypesDesign;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.multidimensional.MultidimensionalDesign;
import oracle.dbtools.crest.model.design.process.DataFlowDesign;
import oracle.dbtools.crest.model.design.process.TransformationTask;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.ide.Context;
import oracle.ide.controller.Controller;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.help.HelpInfo;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.UpdateMessage;
import oracle.ide.view.View;

public class DMDiagramEditor
extends Editor {
    private Component comp = null;
    private Context context;
    private HelpInfo helpInfo;
    private DataModelerController controller = null;

    public void open() {
    }

    public Component getGUI() {
        return this.comp;
    }

    public synchronized Context getContext(EventObject eventObject) {
        if (this.context != null) {
            this.context.setSelection(this.getSelection());
            this.context.setEvent(eventObject);
            this.context.setView((View)this);
        }
        return this.context;
    }

    public synchronized void setContext(Context context) {
        Element element;
        if (context != null && context != this.context && (element = context.getElement()) instanceof DMDiagramNode) {
            this.comp = ((DMDiagramNode)element).getComponent();
            this.context = context;
        }
    }

    public Component getComponent() {
        return this.comp;
    }

    public void setcomponent(Component component) {
        this.comp = component;
    }

    public void update(Object object, UpdateMessage updateMessage) {
    }

    public static Editor openNewDiagram(Component component) {
        DesignPartView.NamedTabbedPane namedTabbedPane;
        if (component instanceof DesignPartView.NamedTabbedPane && (namedTabbedPane = (DesignPartView.NamedTabbedPane)component).getTabCount() == 0 && namedTabbedPane.getDesignPartView() != null) {
            namedTabbedPane.add(namedTabbedPane.getDesignPartView());
            namedTabbedPane.setSelectedComponent(namedTabbedPane.getDesignPartView());
            namedTabbedPane.addChangeListener(namedTabbedPane.getDesignPartView().getApplicationView());
        }
        namedTabbedPane = Context.newIdeContext((Node)new DMDiagramNode(component));
        OpenEditorOptions openEditorOptions = new OpenEditorOptions((Context)namedTabbedPane, EmptyEditor.class);
        if (SwingUtilities.isEventDispatchThread()) {
            return EditorManager.getEditorManager().openEditor(openEditorOptions);
        }
        OpenEditorRunner openEditorRunner = new OpenEditorRunner(openEditorOptions);
        SwingUtilities.invokeLater(openEditorRunner);
        while (!openEditorRunner.isFinished()) {
            try {
                Thread.sleep(200L);
            }
            catch (Exception exception) {}
        }
        return openEditorRunner.getEditor();
    }

    public Object getEditorAttribute(String string) {
        if ("scrollable".equals(string)) {
            return Boolean.FALSE;
        }
        if (string == "horizontal_scrollbar_policy") {
            return null;
        }
        if (string == "vertical_scrollbar_policy") {
            return null;
        }
        return super.getEditorAttribute(string);
    }

    protected String getHelpID() {
        DesignPartView designPartView = this.getDesignPartView();
        if (designPartView != null) {
            if (designPartView.getDesignPart() instanceof LogicalDesign) {
                return "LOGICAL_MODEL_PROPERTIES_DIALOG";
            }
            if (designPartView.getDesignPart() instanceof RelationalDesign) {
                return "RELATIONAL_MODEL_PROPERTIES_DIALOG";
            }
            if (designPartView.getDesignPart() instanceof DataTypesDesign) {
                return "DATATYPES_MODEL_PROPERTIES_DIALOG";
            }
            if (designPartView.getDesignPart() instanceof MultidimensionalDesign) {
                return "MULTIDIMENSIONAL_MODEL_PROPERTIES_DIALOG";
            }
            if (designPartView.getDesignPart() instanceof DataFlowDesign) {
                return "DATA_FLOW_PROPERTIES_DIALOG";
            }
            if (designPartView.getDesignPart() instanceof TransformationTask) {
                return "TRANSFORMATION_TASK_PROPERTIES_DIALOG";
            }
        }
        return "data_modeling.htm";
    }

    public HelpInfo getHelpInfo() {
        if (this.helpInfo == null) {
            this.helpInfo = new HelpInfo(this.getHelpID());
        }
        return this.helpInfo;
    }

    public synchronized Controller getController() {
        if (this.controller == null) {
            this.controller = new DataModelerController();
        }
        return this.controller;
    }

    public DesignPartView getDesignPartView() {
        DesignPartView designPartView = null;
        if (this.comp instanceof DesignPartView) {
            designPartView = (DesignPartView)this.comp;
        } else if (this.comp instanceof DesignPartView.NamedTabbedPane) {
            DesignPartView.NamedTabbedPane namedTabbedPane = (DesignPartView.NamedTabbedPane)this.comp;
            designPartView = namedTabbedPane.getSelectedComponent() instanceof DesignPartView ? (DesignPartView)namedTabbedPane.getSelectedComponent() : namedTabbedPane.getDesignPartView();
        }
        return designPartView;
    }

    private class EmptyEditor {
        private EmptyEditor() {
        }
    }
}

