/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.xmla;

import java.awt.Component;
import java.awt.Dimension;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;
import oracle.dbtools.crest.exports.Messages;
import oracle.dbtools.crest.exports.xmla.XMLADataTypesMapping;
import oracle.dbtools.crest.exports.xmla.XMLAExportOptions;
import oracle.dbtools.crest.imports.xmla.XMLAConstants;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainedObjectWithDomain;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.AttributeView;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.EntityView;
import oracle.dbtools.crest.model.design.multidimensional.Cube;
import oracle.dbtools.crest.model.design.multidimensional.Hierarchy;
import oracle.dbtools.crest.model.design.multidimensional.Level;
import oracle.dbtools.crest.model.design.multidimensional.Measure;
import oracle.dbtools.crest.model.design.multidimensional.MultidimensionalDesign;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.LogReport;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.logging.ExportLogger;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.ide.Ide;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFilter;
import oracle.ide.util.IdeUtil;

public class XMLAExporter
implements XMLAConstants {
    public static final String NEW_LINE = "\n";
    public static final String TAB = "    ";
    private Design design;
    private static final Logger LOGGER = new Logger(XMLAExporter.class);
    private ApplicationView appView;
    private StringBuffer content = new StringBuffer();
    private MultidimensionalDesign mdmDesign;
    private String schema = "DEFAULT_SCHEMA";
    private String catalog = "DEMO_DB";
    private List appendedDimensions;
    private ExportLogger exportLog;

    public XMLAExporter(ApplicationView applicationView) {
        this.appView = applicationView;
        this.design = applicationView.getCurrentDesign();
        this.appendedDimensions = new ArrayList();
        this.exportLog = new ExportLogger();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void export() {
        block7: {
            try {
                XMLAExportOptions xMLAExportOptions = new XMLAExportOptions(this.appView);
                boolean bl = xMLAExportOptions.showDialog();
                if (bl) {
                    this.mdmDesign = xMLAExportOptions.getMultidimensionalDesign();
                    this.exportLog.setModelName(this.mdmDesign.getName());
                    this.catalog = xMLAExportOptions.getCatalog();
                    if (this.mdmDesign == null) break block7;
                    boolean bl2 = false;
                    try {
                        this.prepareContent();
                        bl2 = this.saveOutput();
                        break block7;
                    }
                    finally {
                        if (bl2 && this.appView.getSettings().showImportLog()) {
                            LogReport logReport = new LogReport(this.appView);
                            logReport.setLog(this.exportLog.generateReport(this.appView));
                            logReport.showDialog(new Dimension(750, 550));
                        }
                    }
                }
                ApplicationView.log(Messages.getString("XMLAExporter.ExportCanceled"));
            }
            catch (Exception exception) {
                LOGGER.error("Error Exporting to Microsoft XMLA File", exception);
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), Messages.getString("XMLAExporter.UnableToExportToMicrosoftXMLAFile"), Messages.getString("XMLAExporter.Error"), 0);
            }
        }
    }

    private void prepareContent() {
        this.appendCreateHeader();
        this.appendObjectDefinition();
        this.appendCreateEnd();
    }

    private void appendCreateHeader() {
        this.content.append("<Create xmlns=\"http://schemas.microsoft.com/analysisservices/2003/engine\">");
    }

    private void appendObjectDefinition() {
        this.content.append(NEW_LINE);
        this.content.append(TAB);
        this.content.append("<ObjectDefinition>");
        this.content.append(NEW_LINE);
        this.appendTabs(2);
        this.content.append("<Database xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">");
        this.appendID(this.catalog, 3);
        this.appendName(this.catalog, 3);
        this.appendDescription("A Unified Dimensional Model generated by Oracle SQL Developer Modeler.", 3);
        this.appendDataSourceImpersonationInfo();
        this.appendDimensions();
        this.appendCubes();
        this.appendDataSources();
        this.appendDataSourceViews();
        this.content.append(NEW_LINE);
        this.appendTabs(2);
        this.content.append("</Database>");
        this.content.append(NEW_LINE);
        this.content.append(TAB);
        this.content.append("</ObjectDefinition>");
    }

    private void appendCreateEnd() {
        this.content.append(NEW_LINE);
        this.content.append("</Create>");
    }

    private void appendTabs(int n) {
        for (int i = 0; i < n; ++i) {
            this.content.append(TAB);
        }
    }

    private void appendID(String string, int n) {
        this.content.append(NEW_LINE);
        this.appendTabs(n);
        this.content.append("<ID>");
        this.content.append(string);
        this.content.append("</ID>");
    }

    private void appendName(String string, int n) {
        this.content.append(NEW_LINE);
        this.appendTabs(n);
        this.content.append("<Name>");
        this.content.append(string);
        this.content.append("</Name>");
    }

    private void appendUsage(String string, int n) {
        this.content.append(NEW_LINE);
        this.appendTabs(n);
        this.content.append("<Usage>");
        this.content.append(string);
        this.content.append("</Usage>");
    }

    private void appendElement(String string, String string2, int n) {
        this.content.append(NEW_LINE);
        this.appendTabs(n);
        this.content.append("<" + string + ">");
        this.content.append(string2);
        this.content.append("</" + string + ">");
    }

    private void appendDescription(String string, int n) {
        this.content.append(NEW_LINE);
        this.appendTabs(n);
        this.content.append("<Description>");
        this.content.append(string);
        this.content.append("</Description>");
    }

    private void appendDataSourceImpersonationInfo() {
        this.content.append(NEW_LINE);
        this.appendTabs(3);
        this.content.append("<DataSourceImpersonationInfo>");
        this.content.append(NEW_LINE);
        this.appendTabs(4);
        this.content.append("<ImpersonationMode>Default</ImpersonationMode>");
        this.content.append(NEW_LINE);
        this.appendTabs(3);
        this.content.append("</DataSourceImpersonationInfo>");
    }

    private void appendDimensions() {
        this.content.append(NEW_LINE);
        this.appendTabs(3);
        this.content.append("<Dimensions>");
        Iterator iterator = this.mdmDesign.getDimensionSet().iterator();
        while (iterator.hasNext()) {
            oracle.dbtools.crest.model.design.multidimensional.Dimension dimension = (oracle.dbtools.crest.model.design.multidimensional.Dimension)iterator.next();
            if (dimension.getAllAttributes().size() > 0) {
                this.appendDimension(dimension);
                this.appendedDimensions.add(dimension);
                continue;
            }
            this.exportLog.addWarning("DIMENSION '" + dimension.getName() + "' has no attributes and can not be exported", true);
            LOGGER.warn("XMLAExporter.appendDimensions(): Dimension '" + dimension.getName() + "' has no attributes!");
        }
        this.content.append(NEW_LINE);
        this.appendTabs(3);
        this.content.append("</Dimensions>");
    }

    private void appendDimension(oracle.dbtools.crest.model.design.multidimensional.Dimension dimension) {
        this.content.append(NEW_LINE);
        this.appendTabs(4);
        this.content.append("<Dimension>");
        this.appendID("DIM " + dimension.getName(), 5);
        this.appendName(dimension.getName(), 5);
        this.appendSource();
        this.appendAttributes(dimension);
        this.appendHierarchies(dimension);
        this.content.append(NEW_LINE);
        this.appendTabs(4);
        this.content.append("</Dimension>");
    }

    private void appendSource() {
        this.content.append(NEW_LINE);
        this.appendTabs(4);
        this.content.append("<Source xsi:type=\"DataSourceViewBinding\">");
        this.content.append(NEW_LINE);
        this.appendTabs(5);
        this.content.append("<DataSourceViewID>");
        this.content.append(this.schema);
        this.content.append("</DataSourceViewID>");
        this.content.append(NEW_LINE);
        this.appendTabs(4);
        this.content.append("</Source>");
    }

    private void appendAttributeRelationship(String string, int n) {
        this.content.append(NEW_LINE);
        this.appendTabs(n);
        this.content.append("<AttributeRelationship>");
        this.content.append(NEW_LINE);
        this.appendTabs(n + 1);
        this.content.append("<AttributeID>");
        this.content.append(string);
        this.content.append("</AttributeID>");
        this.content.append(NEW_LINE);
        this.appendTabs(n + 1);
        this.content.append("<Name>");
        this.content.append(string);
        this.content.append("</Name>");
        this.content.append(NEW_LINE);
        this.appendTabs(n);
        this.content.append("</AttributeRelationship>");
    }

    private void appendColumnSource(ContainedObject containedObject, int n) {
        this.content.append(NEW_LINE);
        this.appendTabs(n);
        this.content.append("<Source xsi:type=\"ColumnBinding\">");
        this.content.append(NEW_LINE);
        this.appendTabs(n + 1);
        this.content.append("<TableID>");
        this.content.append(containedObject.getContainer().getName());
        this.content.append("</TableID>");
        this.content.append(NEW_LINE);
        this.appendTabs(n + 1);
        this.content.append("<ColumnID>");
        this.content.append(containedObject.getName());
        this.content.append("</ColumnID>");
        this.content.append(NEW_LINE);
        this.appendTabs(n);
        this.content.append("</Source>");
    }

    private void appendAttributes(oracle.dbtools.crest.model.design.multidimensional.Dimension dimension) {
        ArrayList arrayList = new ArrayList();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        this.content.append(NEW_LINE);
        this.appendTabs(4);
        this.content.append("<Attributes>");
        Iterator iterator = dimension.getAllLevels().iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            DesignObject designObject = (Level)iterator.next();
            this.appendLevel((Level)designObject, bl, arrayList, arrayList2);
            bl = false;
        }
        for (DesignObject designObject : arrayList) {
            if (arrayList2.contains(((ContainedObject)designObject).getName().toUpperCase())) continue;
            this.appendAttribute((ContainedObject)designObject);
            arrayList2.add(((ContainedObject)designObject).getName().toUpperCase());
        }
        this.content.append(NEW_LINE);
        this.appendTabs(4);
        this.content.append("</Attributes>");
    }

    private void appendLevel(Level level, boolean bl, List list, List list2) {
        if (!level.isValueBasedHierarchy()) {
            Object object;
            this.content.append(NEW_LINE);
            this.appendTabs(5);
            this.content.append("<Attribute>");
            String string = level.getName();
            this.appendID(string, 6);
            this.appendName(string, 6);
            if (bl) {
                this.appendUsage("Key", 6);
            }
            this.content.append(NEW_LINE);
            this.appendTabs(6);
            this.content.append("<KeyColumns>");
            for (ContainedObject containedObject : level.getLevelKey()) {
                this.content.append(NEW_LINE);
                this.appendTabs(7);
                this.content.append("<KeyColumn>");
                object = containedObject instanceof Attribute ? XMLADataTypesMapping.getAppropriateDatatype(((Attribute)containedObject).getDatatypeString("SQL Server 2005")) : XMLADataTypesMapping.getAppropriateDatatype(((AttributeView)containedObject).getDataType());
                this.appendElement("DataType", (String)object, 8);
                this.appendColumnSource(containedObject, 8);
                this.content.append(NEW_LINE);
                this.appendTabs(7);
                this.content.append("</KeyColumn>");
            }
            this.content.append(NEW_LINE);
            this.appendTabs(6);
            this.content.append("</KeyColumns>");
            if (level.getDescriptiveAttributes().size() > 0) {
                ContainedObject containedObject;
                containedObject = (ContainedObject)level.getDescriptiveAttributes().get(0);
                this.content.append(NEW_LINE);
                this.appendTabs(6);
                this.content.append("<NameColumn>");
                this.appendElement("DataType", "WChar", 7);
                this.appendColumnSource(containedObject, 7);
                this.content.append(NEW_LINE);
                this.appendTabs(6);
                this.content.append("</NameColumn>");
                if (level.getDescriptiveAttributes().size() > 1) {
                    this.content.append(NEW_LINE);
                    this.appendTabs(6);
                    this.content.append("<AttributeRelationships>");
                    object = level.getDescriptiveAttributes().toArray();
                    for (int i = 1; i < ((Object[])object).length; ++i) {
                        containedObject = (ContainedObject)object[i];
                        if (!list.contains(containedObject)) {
                            list.add(containedObject);
                        }
                        this.appendAttributeRelationship(containedObject.getName(), 7);
                    }
                    this.content.append(NEW_LINE);
                    this.appendTabs(6);
                    this.content.append("</AttributeRelationships>");
                }
            }
            this.content.append(NEW_LINE);
            this.appendTabs(5);
            this.content.append("</Attribute>");
            list2.add(string.toUpperCase());
        } else {
            Object object;
            ContainedObject containedObject2;
            this.content.append(NEW_LINE);
            this.appendTabs(5);
            this.content.append("<Attribute>");
            String string = level.getName();
            this.appendID(string, 6);
            this.appendName(string, 6);
            this.appendUsage("Parent", 6);
            this.content.append(NEW_LINE);
            this.appendTabs(6);
            this.content.append("<KeyColumns>");
            for (ContainedObject containedObject2 : level.getParentKey()) {
                this.content.append(NEW_LINE);
                this.appendTabs(7);
                this.content.append("<KeyColumn>");
                object = containedObject2 instanceof Attribute ? XMLADataTypesMapping.getAppropriateDatatype(((Attribute)containedObject2).getDatatypeString("SQL Server 2005")) : XMLADataTypesMapping.getAppropriateDatatype(((AttributeView)containedObject2).getDataType());
                this.appendElement("DataType", (String)object, 8);
                this.appendColumnSource(containedObject2, 8);
                this.content.append(NEW_LINE);
                this.appendTabs(7);
                this.content.append("</KeyColumn>");
            }
            this.content.append(NEW_LINE);
            this.appendTabs(6);
            this.content.append("</KeyColumns>");
            if (level.getDescriptiveAttributes().size() > 0) {
                containedObject2 = (ContainedObject)level.getDescriptiveAttributes().get(0);
                this.content.append(NEW_LINE);
                this.appendTabs(6);
                this.content.append("<NameColumn>");
                this.appendElement("DataType", "WChar", 7);
                this.appendColumnSource(containedObject2, 7);
                this.content.append(NEW_LINE);
                this.appendTabs(6);
                this.content.append("</NameColumn>");
            }
            this.content.append(NEW_LINE);
            this.appendTabs(5);
            this.content.append("</Attribute>");
            list2.add(string.toUpperCase());
            this.content.append(NEW_LINE);
            this.appendTabs(5);
            this.content.append("<Attribute>");
            string = level.getName() + " Attribute";
            this.appendID(string, 6);
            this.appendName(string, 6);
            if (bl) {
                this.appendUsage("Key", 6);
            }
            this.content.append(NEW_LINE);
            this.appendTabs(6);
            this.content.append("<KeyColumns>");
            for (ContainedObject containedObject2 : level.getLevelKey()) {
                this.content.append(NEW_LINE);
                this.appendTabs(7);
                this.content.append("<KeyColumn>");
                object = containedObject2 instanceof Attribute ? XMLADataTypesMapping.getAppropriateDatatype(((Attribute)containedObject2).getDatatypeString("SQL Server 2005")) : XMLADataTypesMapping.getAppropriateDatatype(((AttributeView)containedObject2).getDataType());
                this.appendElement("DataType", (String)object, 8);
                this.appendColumnSource(containedObject2, 8);
                this.content.append(NEW_LINE);
                this.appendTabs(7);
                this.content.append("</KeyColumn>");
            }
            this.content.append(NEW_LINE);
            this.appendTabs(6);
            this.content.append("</KeyColumns>");
            if (level.getDescriptiveAttributes().size() > 0) {
                containedObject2 = (ContainedObject)level.getDescriptiveAttributes().get(0);
                this.content.append(NEW_LINE);
                this.appendTabs(6);
                this.content.append("<NameColumn>");
                this.appendElement("DataType", "WChar", 7);
                this.appendColumnSource(containedObject2, 7);
                this.content.append(NEW_LINE);
                this.appendTabs(6);
                this.content.append("</NameColumn>");
                if (level.getDescriptiveAttributes().size() > 1) {
                    this.content.append(NEW_LINE);
                    this.appendTabs(6);
                    this.content.append("<AttributeRelationships>");
                    object = level.getDescriptiveAttributes().toArray();
                    for (int i = 1; i < ((Object[])object).length; ++i) {
                        containedObject2 = (ContainedObject)object[i];
                        if (!list.contains(containedObject2)) {
                            list.add(containedObject2);
                        }
                        this.appendAttributeRelationship(containedObject2.getName(), 7);
                    }
                    this.content.append(NEW_LINE);
                    this.appendTabs(6);
                    this.content.append("</AttributeRelationships>");
                }
            }
            this.content.append(NEW_LINE);
            this.appendTabs(5);
            this.content.append("</Attribute>");
            list2.add(string.toUpperCase());
        }
    }

    private void appendAttribute(ContainedObject containedObject) {
        this.content.append(NEW_LINE);
        this.appendTabs(5);
        this.content.append("<Attribute>");
        this.appendID(containedObject.getName(), 6);
        this.appendName(containedObject.getName(), 6);
        this.content.append(NEW_LINE);
        this.appendTabs(6);
        this.content.append("<KeyColumns>");
        this.content.append(NEW_LINE);
        this.appendTabs(7);
        this.content.append("<KeyColumn>");
        String string = containedObject instanceof Attribute ? (containedObject.getSourceType().equalsIgnoreCase("Derived") ? "WChar" : XMLADataTypesMapping.getAppropriateDatatype(((Attribute)containedObject).getDatatypeString("SQL Server 2005"))) : XMLADataTypesMapping.getAppropriateDatatype(((AttributeView)containedObject).getDataType());
        this.appendElement("DataType", string, 8);
        this.appendColumnSource(containedObject, 8);
        this.content.append(NEW_LINE);
        this.appendTabs(7);
        this.content.append("</KeyColumn>");
        this.content.append(NEW_LINE);
        this.appendTabs(6);
        this.content.append("</KeyColumns>");
        this.content.append(NEW_LINE);
        this.appendTabs(5);
        this.content.append("</Attribute>");
    }

    private void appendHierarchies(oracle.dbtools.crest.model.design.multidimensional.Dimension dimension) {
        Hierarchy hierarchy;
        this.content.append(NEW_LINE);
        this.appendTabs(4);
        this.content.append("<Hierarchies>");
        Iterator iterator = dimension.getHierarchies().iterator();
        while (iterator.hasNext() && ((hierarchy = (Hierarchy)iterator.next()).getLevels().size() != 1 || !((Level)hierarchy.getLevels().get(0)).isValueBasedHierarchy())) {
            this.content.append(NEW_LINE);
            this.appendTabs(5);
            this.content.append("<Hierarchy>");
            this.appendID("Hierarchy " + hierarchy.getName(), 6);
            this.appendName("Hierarchy " + hierarchy.getName(), 6);
            this.content.append(NEW_LINE);
            this.appendTabs(6);
            this.content.append("<Levels>");
            Object[] objectArray = hierarchy.getLevels().toArray();
            for (int i = objectArray.length - 1; i >= 0; --i) {
                Level level = (Level)objectArray[i];
                this.content.append(NEW_LINE);
                this.appendTabs(7);
                this.content.append("<Level>");
                this.appendID(level.getName(), 8);
                this.appendName(level.getName(), 8);
                this.appendElement("SourceAttributeID", level.getName(), 8);
                this.content.append(NEW_LINE);
                this.appendTabs(7);
                this.content.append("</Level>");
            }
            this.content.append(NEW_LINE);
            this.appendTabs(6);
            this.content.append("</Levels>");
            this.content.append(NEW_LINE);
            this.appendTabs(5);
            this.content.append("</Hierarchy>");
        }
        this.content.append(NEW_LINE);
        this.appendTabs(4);
        this.content.append("</Hierarchies>");
    }

    private boolean canExtractCube(Cube cube) {
        for (Measure measure : cube.getMeasures()) {
            if (measure.getMeasureFact() == null) continue;
            return true;
        }
        return false;
    }

    private void appendCubes() {
        Object object;
        this.content.append(NEW_LINE);
        this.appendTabs(3);
        this.content.append("<Cubes>");
        this.content.append(NEW_LINE);
        this.appendTabs(4);
        this.content.append("<Cube>");
        this.appendID(this.schema, 5);
        this.appendName(this.schema, 5);
        this.content.append(NEW_LINE);
        this.appendTabs(5);
        this.content.append("<Dimensions>");
        Iterator iterator = this.mdmDesign.getDimensionSet().iterator();
        while (iterator.hasNext()) {
            object = (oracle.dbtools.crest.model.design.multidimensional.Dimension)iterator.next();
            if (!this.appendedDimensions.contains(object)) continue;
            this.content.append(NEW_LINE);
            this.appendTabs(6);
            this.content.append("<Dimension>");
            this.appendID("DIM " + ((DesignObject)object).getName(), 7);
            this.appendName(((DesignObject)object).getName(), 7);
            this.appendElement("DimensionID", "DIM " + ((DesignObject)object).getName(), 7);
            this.content.append(NEW_LINE);
            this.appendTabs(6);
            this.content.append("</Dimension>");
        }
        this.content.append(NEW_LINE);
        this.appendTabs(5);
        this.content.append("</Dimensions>");
        this.content.append(NEW_LINE);
        this.appendTabs(5);
        this.content.append("<MeasureGroups>");
        object = this.mdmDesign.getCubeSet().iterator();
        while (object.hasNext()) {
            Object object2;
            Object object32;
            Cube cube = (Cube)object.next();
            if (!this.canExtractCube(cube)) continue;
            this.content.append(NEW_LINE);
            this.appendTabs(6);
            this.content.append("<MeasureGroup>");
            this.appendID(cube.getName(), 6);
            this.appendName(cube.getName(), 6);
            this.content.append(NEW_LINE);
            this.appendTabs(6);
            this.content.append("<Measures>");
            for (Object object32 : cube.getMeasures()) {
                if (((Measure)object32).getMeasureFact() == null) continue;
                this.content.append(NEW_LINE);
                this.appendTabs(7);
                this.content.append("<Measure>");
                this.appendID(((DesignObject)object32).getName(), 8);
                this.appendName(((DesignObject)object32).getName(), 8);
                if (((Measure)object32).getAggregateFunctions().size() > 0) {
                    object2 = (Measure.AggregateFunction)((Measure)object32).getAggregateFunctions().get(0);
                    this.appendElement("AggregateFunction", ((Measure.AggregateFunction)object2).getName(), 8);
                    this.appendElement("DataType", "Integer", 9);
                }
                this.content.append(NEW_LINE);
                this.appendTabs(8);
                this.content.append("<Source>");
                object2 = ((Measure)object32).getMeasureFact().getSourceType().equalsIgnoreCase("Derived") ? "Double" : (((Measure)object32).getMeasureFact() instanceof Attribute ? XMLADataTypesMapping.getAppropriateDatatype(((ContainedObjectWithDomain)((Measure)object32).getMeasureFact()).getDatatypeString("SQL Server 2005")) : XMLADataTypesMapping.getAppropriateDatatype(((AttributeView)((Measure)object32).getMeasureFact()).getDataType()));
                this.appendElement("DataType", (String)object2, 9);
                this.appendColumnSource(((Measure)object32).getMeasureFact(), 9);
                this.content.append(NEW_LINE);
                this.appendTabs(8);
                this.content.append("</Source>");
                this.content.append(NEW_LINE);
                this.appendTabs(7);
                this.content.append("</Measure>");
            }
            this.content.append(NEW_LINE);
            this.appendTabs(6);
            this.content.append("</Measures>");
            this.content.append(NEW_LINE);
            this.appendTabs(6);
            this.content.append("<Dimensions>");
            object32 = cube.getDimensions().iterator();
            while (object32.hasNext()) {
                object2 = (oracle.dbtools.crest.model.design.multidimensional.Dimension)object32.next();
                if (!this.appendedDimensions.contains(object2)) continue;
                this.content.append(NEW_LINE);
                this.appendTabs(7);
                this.content.append("<Dimension xsi:type=\"RegularMeasureGroupDimension\">");
                this.appendElement("CubeDimensionID", "DIM " + ((DesignObject)object2).getName(), 8);
                this.appendCubeDimAttributes((oracle.dbtools.crest.model.design.multidimensional.Dimension)object2);
                this.content.append(NEW_LINE);
                this.appendTabs(7);
                this.content.append("</Dimension>");
            }
            this.content.append(NEW_LINE);
            this.appendTabs(6);
            this.content.append("</Dimensions>");
            this.content.append(NEW_LINE);
            this.appendTabs(6);
            this.content.append("</MeasureGroup>");
        }
        this.content.append(NEW_LINE);
        this.appendTabs(5);
        this.content.append("</MeasureGroups>");
        this.content.append(NEW_LINE);
        this.appendTabs(5);
        this.content.append("<Source>");
        this.appendElement("DataSourceViewID", this.schema, 6);
        this.content.append(NEW_LINE);
        this.appendTabs(5);
        this.content.append("</Source>");
        this.content.append(NEW_LINE);
        this.appendTabs(4);
        this.content.append("</Cube>");
        this.content.append(NEW_LINE);
        this.appendTabs(3);
        this.content.append("</Cubes>");
    }

    private void appendDataSources() {
        this.content.append(NEW_LINE);
        this.appendTabs(3);
        this.content.append("<DataSources>");
        this.content.append(NEW_LINE);
        this.appendTabs(4);
        this.content.append("<DataSource xsi:type=\"RelationalDataSource\">");
        this.appendID(this.schema, 5);
        this.appendName(this.schema, 5);
        this.content.append(NEW_LINE);
        this.appendTabs(5);
        this.content.append("<ImpersonationInfo>");
        this.content.append(NEW_LINE);
        this.appendTabs(6);
        this.content.append("<ImpersonationMode>ImpersonateServiceAccount</ImpersonationMode>");
        this.content.append(NEW_LINE);
        this.appendTabs(5);
        this.content.append("</ImpersonationInfo>");
        this.content.append("<ConnectionString>Provider=SQLNCLI.1;Data Source=Localhost;Persist Security Info=False;Integrated Security=SSPI;Initial Catalog=" + this.catalog + "</ConnectionString>");
        this.content.append(NEW_LINE);
        this.appendTabs(4);
        this.content.append("</DataSource>");
        this.content.append(NEW_LINE);
        this.appendTabs(3);
        this.content.append("</DataSources>");
    }

    private void appendDataSourceViews() {
        this.content.append(NEW_LINE);
        this.appendTabs(3);
        this.content.append("<DataSourceViews>");
        this.content.append(NEW_LINE);
        this.appendTabs(4);
        this.content.append("<DataSourceView>");
        this.appendID(this.schema, 5);
        this.appendName(this.schema, 5);
        this.content.append(NEW_LINE);
        this.appendTabs(5);
        this.content.append("<DataSourceID>" + this.schema + "</DataSourceID> ");
        this.content.append(NEW_LINE);
        this.appendTabs(5);
        this.content.append("<Schema>");
        String string = this.convertName(this.schema);
        this.content.append(NEW_LINE);
        this.appendTabs(6);
        this.content.append("<xs:schema id=\"" + string + "\" xmlns=\"\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xmlns:msdata=\"urn:schemas-microsoft-com:xml-msdata\" xmlns:msprop=\"urn:schemas-microsoft-com:xml-msprop\">");
        this.content.append(NEW_LINE);
        this.appendTabs(7);
        this.content.append("<xs:element name=\"" + string + "\" msdata:IsDataSet=\"true\" msdata:UseCurrentLocale=\"true\">");
        this.content.append(NEW_LINE);
        this.appendTabs(8);
        this.content.append("<xs:complexType>");
        this.content.append(NEW_LINE);
        this.appendTabs(9);
        this.content.append("<xs:choice minOccurs=\"0\" maxOccurs=\"unbounded\">");
        this.appendTables();
        this.content.append(NEW_LINE);
        this.appendTabs(9);
        this.content.append("</xs:choice>");
        this.content.append(NEW_LINE);
        this.appendTabs(8);
        this.content.append("</xs:complexType>");
        this.content.append(NEW_LINE);
        this.appendTabs(7);
        this.content.append("</xs:element>");
        this.content.append(NEW_LINE);
        this.appendTabs(6);
        this.content.append("</xs:schema>");
        this.content.append(NEW_LINE);
        this.appendTabs(5);
        this.content.append("</Schema>");
        this.content.append(NEW_LINE);
        this.appendTabs(4);
        this.content.append("</DataSourceView>");
        this.content.append(NEW_LINE);
        this.appendTabs(3);
        this.content.append("</DataSourceViews>");
    }

    private void appendTables() {
        String string;
        String string2;
        String string3;
        ContainedObject containedObject;
        int n;
        ContainedObject[] containedObjectArray;
        String string4;
        ContainerObject containerObject;
        Iterator iterator = this.design.getLogicalDesign().getEntitySet().iterator();
        while (iterator.hasNext()) {
            containerObject = (Entity)iterator.next();
            string4 = containerObject.getName();
            this.content.append(NEW_LINE);
            this.appendTabs(10);
            this.content.append("<xs:element name=\"" + string4 + "\" msprop:FriendlyName=\"" + string4 + "\" msprop:DbSchemaName=\"dbo\" msprop:DbTableName=\"" + string4 + "\" msprop:TableType=\"Table\">");
            this.content.append(NEW_LINE);
            this.appendTabs(11);
            this.content.append("<xs:complexType>");
            this.content.append(NEW_LINE);
            this.appendTabs(12);
            this.content.append("<xs:sequence>");
            containedObjectArray = containerObject.getElements();
            for (n = 0; n < containedObjectArray.length; ++n) {
                containedObject = containedObjectArray[n];
                string3 = containedObject.getName();
                if (containedObject.getSourceType().equalsIgnoreCase("Derived")) {
                    string2 = containedObject.getFormulaDesc();
                    string2 = string2.replaceAll("\"", "&quot;");
                    this.content.append(NEW_LINE);
                    this.appendTabs(13);
                    this.content.append("<xs:element name=\"" + containedObject.getName() + "\" msdata:ReadOnly=\"true\" msprop:ComputedColumnExpression=\"" + string2 + "\" msprop:IsLogical=\"True\" type=\"xs:string\" minOccurs=\"0\" />");
                    continue;
                }
                string2 = containedObject.getSize();
                if ("".equalsIgnoreCase(string2)) {
                    string2 = "-1";
                }
                string = containedObject instanceof Attribute ? XMLADataTypesMapping.getAppropriateDatatype(((Attribute)containedObject).getDatatypeString("SQL Server 2005")) : XMLADataTypesMapping.getAppropriateDatatype(((AttributeView)containedObject).getDataType());
                string = XMLADataTypesMapping.getAppropriateColumnDatatype(string.toUpperCase());
                this.content.append(NEW_LINE);
                this.appendTabs(13);
                this.content.append("<xs:element name=\"" + string3 + "\" msdata:ReadOnly=\"true\" msdata:AutoIncrement=\"true\" msprop:FriendlyName=\"" + string3 + "\" msprop:DbColumnName=\"" + string3 + "\" msprop:DataSize=\"" + string2 + "\" type=\"xs:" + string + "\" />");
            }
            this.content.append(NEW_LINE);
            this.appendTabs(12);
            this.content.append("</xs:sequence>");
            this.content.append(NEW_LINE);
            this.appendTabs(11);
            this.content.append("</xs:complexType>");
            this.content.append(NEW_LINE);
            this.appendTabs(10);
            this.content.append("</xs:element>");
        }
        iterator = this.design.getLogicalDesign().getEntityViewSet().iterator();
        while (iterator.hasNext()) {
            containerObject = (EntityView)iterator.next();
            string4 = containerObject.getName();
            this.content.append(NEW_LINE);
            this.appendTabs(10);
            this.content.append("<xs:element name=\"" + string4 + "\" msprop:FriendlyName=\"" + string4 + "\" msprop:DbSchemaName=\"dbo\" msprop:DbTableName=\"" + string4 + "\" msprop:TableType=\"View\">");
            this.content.append(NEW_LINE);
            this.appendTabs(11);
            this.content.append("<xs:complexType>");
            this.content.append(NEW_LINE);
            this.appendTabs(12);
            this.content.append("<xs:sequence>");
            containedObjectArray = containerObject.getElements();
            for (n = 0; n < containedObjectArray.length; ++n) {
                containedObject = containedObjectArray[n];
                string3 = containedObject.getName();
                string2 = containedObject.getSize();
                if ("".equalsIgnoreCase(string2)) {
                    string2 = "-1";
                }
                string = containedObject instanceof Attribute ? XMLADataTypesMapping.getAppropriateDatatype(((Attribute)containedObject).getDatatypeString("SQL Server 2005")) : XMLADataTypesMapping.getAppropriateDatatype(((AttributeView)containedObject).getDataType());
                string = XMLADataTypesMapping.getAppropriateColumnDatatype(string.toUpperCase());
                this.content.append(NEW_LINE);
                this.appendTabs(13);
                this.content.append("<xs:element name=\"" + string3 + "\" msprop:FriendlyName=\"" + string3 + "\" msprop:DbColumnName=\"" + string3 + "\" msprop:DataSize=\"" + string2 + "\" type=\"xs:" + string + "\" />");
            }
            this.content.append(NEW_LINE);
            this.appendTabs(12);
            this.content.append("</xs:sequence>");
            this.content.append(NEW_LINE);
            this.appendTabs(11);
            this.content.append("</xs:complexType>");
            this.content.append(NEW_LINE);
            this.appendTabs(10);
            this.content.append("</xs:element>");
        }
    }

    private String convertName(String string) {
        String string2 = "";
        String string3 = "_x0020_";
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            string2 = string2 + string4 + string3;
        }
        if (string2.endsWith(string3)) {
            string2 = string2.substring(0, string2.length() - string3.length());
        }
        return string2;
    }

    private void appendCubeDimAttributes(oracle.dbtools.crest.model.design.multidimensional.Dimension dimension) {
        ArrayList arrayList = new ArrayList();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        this.content.append(NEW_LINE);
        this.appendTabs(8);
        this.content.append("<Attributes>");
        Iterator iterator = dimension.getAllLevels().iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            DesignObject designObject = (Level)iterator.next();
            this.appendCubeDimLevel((Level)designObject, bl, arrayList, arrayList2);
            bl = false;
        }
        for (DesignObject designObject : arrayList) {
            if (arrayList2.contains(((ContainedObject)designObject).getName().toUpperCase())) continue;
            this.appendCubeDimAttribute((ContainedObject)designObject);
            arrayList2.add(((ContainedObject)designObject).getName().toUpperCase());
        }
        this.content.append(NEW_LINE);
        this.appendTabs(8);
        this.content.append("</Attributes>");
    }

    private void appendCubeDimLevel(Level level, boolean bl, List list, List list2) {
        if (!level.isValueBasedHierarchy()) {
            this.content.append(NEW_LINE);
            this.appendTabs(9);
            this.content.append("<Attribute>");
            String string = level.getName();
            this.appendElement("AttributeID", string, 10);
            this.content.append(NEW_LINE);
            this.appendTabs(10);
            this.content.append("<KeyColumns>");
            for (Object[] objectArray : level.getLevelKey()) {
                this.content.append(NEW_LINE);
                this.appendTabs(11);
                this.content.append("<KeyColumn>");
                String string2 = objectArray instanceof Attribute ? XMLADataTypesMapping.getAppropriateDatatype(((Attribute)objectArray).getDatatypeString("SQL Server 2005")) : XMLADataTypesMapping.getAppropriateDatatype(((AttributeView)objectArray).getDataType());
                this.appendElement("DataType", string2, 12);
                if (bl) {
                    this.appendColumnSource((ContainedObject)objectArray, 12);
                } else {
                    this.content.append(NEW_LINE);
                    this.appendTabs(12);
                    this.content.append("<Source xsi:type=\"InheritedBinding\" />");
                }
                this.content.append(NEW_LINE);
                this.appendTabs(11);
                this.content.append("</KeyColumn>");
            }
            this.content.append(NEW_LINE);
            this.appendTabs(10);
            this.content.append("</KeyColumns>");
            if (bl) {
                this.appendElement("Type", "Granularity", 10);
            }
            if (level.getDescriptiveAttributes().size() > 0) {
                Object[] objectArray;
                objectArray = level.getDescriptiveAttributes().toArray();
                for (int i = 1; i < objectArray.length; ++i) {
                    ContainedObject containedObject = (ContainedObject)objectArray[i];
                    if (list.contains(containedObject)) continue;
                    list.add(containedObject);
                }
            }
            this.content.append(NEW_LINE);
            this.appendTabs(9);
            this.content.append("</Attribute>");
            list2.add(string.toUpperCase());
        } else {
            this.content.append(NEW_LINE);
            this.appendTabs(9);
            this.content.append("<Attribute>");
            String string = level.getName() + " Attribute";
            this.appendElement("AttributeID", string, 10);
            this.content.append(NEW_LINE);
            this.appendTabs(10);
            this.content.append("<KeyColumns>");
            for (Object[] objectArray : level.getLevelKey()) {
                this.content.append(NEW_LINE);
                this.appendTabs(11);
                this.content.append("<KeyColumn>");
                String string3 = objectArray instanceof Attribute ? XMLADataTypesMapping.getAppropriateDatatype(((Attribute)objectArray).getDatatypeString("SQL Server 2005")) : XMLADataTypesMapping.getAppropriateDatatype(((AttributeView)objectArray).getDataType());
                this.appendElement("DataType", string3, 12);
                if (bl) {
                    this.appendColumnSource((ContainedObject)objectArray, 12);
                } else {
                    this.content.append(NEW_LINE);
                    this.appendTabs(12);
                    this.content.append("<Source xsi:type=\"InheritedBinding\" />");
                }
                this.content.append(NEW_LINE);
                this.appendTabs(11);
                this.content.append("</KeyColumn>");
            }
            this.content.append(NEW_LINE);
            this.appendTabs(10);
            this.content.append("</KeyColumns>");
            if (bl) {
                this.appendElement("Type", "Granularity", 10);
            }
            if (level.getDescriptiveAttributes().size() > 0) {
                Object[] objectArray;
                objectArray = level.getDescriptiveAttributes().toArray();
                for (int i = 1; i < objectArray.length; ++i) {
                    ContainedObject containedObject = (ContainedObject)objectArray[i];
                    if (list.contains(containedObject)) continue;
                    list.add(containedObject);
                }
            }
            this.content.append(NEW_LINE);
            this.appendTabs(9);
            this.content.append("</Attribute>");
            list2.add(string.toUpperCase());
        }
    }

    private void appendCubeDimAttribute(ContainedObject containedObject) {
        this.content.append(NEW_LINE);
        this.appendTabs(9);
        this.content.append("<Attribute>");
        this.appendElement("AttributeID", containedObject.getName(), 10);
        this.content.append(NEW_LINE);
        this.appendTabs(10);
        this.content.append("<KeyColumns>");
        this.content.append(NEW_LINE);
        this.appendTabs(11);
        this.content.append("<KeyColumn>");
        String string = containedObject instanceof Attribute ? (containedObject.getSourceType().equalsIgnoreCase("Derived") ? "WChar" : XMLADataTypesMapping.getAppropriateDatatype(((Attribute)containedObject).getDatatypeString("SQL Server 2005"))) : XMLADataTypesMapping.getAppropriateDatatype(((AttributeView)containedObject).getDataType());
        this.appendElement("DataType", string, 12);
        this.content.append(NEW_LINE);
        this.appendTabs(12);
        this.content.append("<Source xsi:type=\"InheritedBinding\" />");
        this.content.append(NEW_LINE);
        this.appendTabs(11);
        this.content.append("</KeyColumn>");
        this.content.append(NEW_LINE);
        this.appendTabs(10);
        this.content.append("</KeyColumns>");
        this.content.append(NEW_LINE);
        this.appendTabs(9);
        this.content.append("</Attribute>");
    }

    public boolean saveOutput() {
        try {
            Object object;
            URLFilter uRLFilter = new URLFilter(){

                public boolean accept(URL uRL) {
                    File file = new File(uRL.getPath());
                    return file.getName().toLowerCase().endsWith(".xmla") || file.isDirectory();
                }

                public String toString() {
                    return Messages.getString("XMLAExporter.XMLAFiles");
                }
            };
            URLChooser uRLChooser = DialogUtil.newURLChooser();
            uRLChooser.clearChooseableURLFilters();
            uRLChooser.setSelectionScope(0);
            uRLChooser.setSelectionMode(0);
            uRLChooser.setShowJarsAsDirs(false);
            uRLChooser.setURLFilter(uRLFilter);
            String string = this.appView.getSettings().getDefaultSavePath();
            if (string != null) {
                uRLChooser.setSelectedURL(URLFactory.newDirURL((String)string));
            } else {
                object = this.appView.getUserHomeDirectory();
                if (object != null) {
                    uRLChooser.setSelectedURL((URL)object);
                }
            }
            object = this.design.getName() + ".xmla";
            uRLChooser.setFileNameURL((String)object);
            int n = uRLChooser.showSaveDialog((Component)Ide.getMainWindow(), Messages.getString("XMLAExporter.SaveToXMLAFile"));
            if (n == 0) {
                File file = new File(uRLChooser.getSelectedURL().getPath());
                if (file != null && this.saveFile(file)) {
                    ApplicationView.log(Messages.getString("XMLAExporter.ExportedOk"));
                    JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), Messages.getString("XMLAExporter.ExportedOk"));
                    return true;
                }
                ApplicationView.log(Messages.getString("XMLAExporter.ExportCanceled"));
            } else {
                ApplicationView.log(Messages.getString("XMLAExporter.ExportCanceled"));
            }
        }
        catch (IOException iOException) {
            LOGGER.error("", iOException);
            MessageDialogs.showErrorMessage((Component)Ide.getMainWindow(), iOException.getMessage());
        }
        catch (Throwable throwable) {
            MessageDialogs.showErrorMessage((Component)Ide.getMainWindow(), throwable.getMessage());
        }
        return false;
    }

    protected boolean saveFile(File file) throws IOException {
        int n;
        if (file.exists() && (n = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("XMLAExporter.FileExists"), file.getAbsolutePath()), Messages.getString("XMLAExporter.Warning"), 0, 3)) == 1) {
            return false;
        }
        file.getParentFile().mkdirs();
        file.createNewFile();
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(file)), IdeUtil.getIdeEncoding());
        outputStreamWriter.write(this.content.toString());
        outputStreamWriter.flush();
        outputStreamWriter.close();
        return true;
    }

    public GUIConfiguration getConfiguration() {
        return GUIConfiguration.getInstance();
    }
}

