/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.xmla;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.dbtools.crest.exports.Messages;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.multidimensional.MultidimensionalDesign;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.ide.Ide;

public class XMLAExportOptions
extends CustomDialog {
    private File logicalFile = null;
    private JDialog dialog;
    private boolean result;
    private DefaultListModel listModel;
    private static final int FIELD_WIDTH = 200;
    private static final int FIELD_HEIGHT = 20;
    private Dimension prefDimension = new Dimension(200, 20);
    private JTextField tfCatalog;
    private JComboBox cbMDM;
    private Design design;
    private MultidimensionalDesign multidimensionalDesign;
    private String catalog = "";

    public XMLAExportOptions(ApplicationView applicationView) {
        super(applicationView);
        this.setLayout(new BorderLayout());
        this.result = false;
        this.design = applicationView.getCurrentDesign();
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new GridLayout(0, 1));
        jPanel2.setBorder(BorderFactory.createTitledBorder(""));
        JLabel jLabel = new JLabel(Messages.getString("XMLAExportOptions.DatabaseName"));
        jLabel.setPreferredSize(this.prefDimension);
        this.tfCatalog = new JTextField(applicationView.getDesignName());
        this.tfCatalog.setPreferredSize(this.prefDimension);
        JPanel jPanel3 = this.newRow(jLabel, this.tfCatalog);
        jPanel2.add(jPanel3);
        MultidimensionalDesign multidimensionalDesign = this.design.getMultidimensionalDesign();
        JLabel jLabel2 = new JLabel(Messages.getString("XMLAExportOptions.DimensionalModel"));
        jLabel2.setPreferredSize(this.prefDimension);
        this.cbMDM = new JComboBox<Object>(this.design.getMultidimensionalDesigns().toArray());
        this.cbMDM.setFont(this.cbMDM.getFont().deriveFont(0));
        this.cbMDM.setPreferredSize(this.prefDimension);
        this.cbMDM.setSelectedItem(multidimensionalDesign);
        jPanel3 = this.newRow(jLabel2, this.cbMDM);
        jPanel2.add(jPanel3);
        JPanel jPanel4 = new JPanel(new FlowLayout(2));
        JButton jButton = new JButton(Messages.getString("XMLAExportOptions.OK"));
        jButton.setMnemonic(79);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                XMLAExportOptions.this.result = XMLAExportOptions.this.checkSettings();
                if (XMLAExportOptions.this.result) {
                    XMLAExportOptions.this.close();
                }
            }
        });
        jPanel4.add(jButton);
        JButton jButton2 = new JButton(Messages.getString("XMLAExportOptions.Cancel"));
        jButton2.setMnemonic(67);
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                XMLAExportOptions.this.result = false;
                XMLAExportOptions.this.close();
            }
        });
        jPanel4.add(jButton2);
        JButton jButton3 = new JButton(this.getHelpAction());
        jButton3.setMnemonic(72);
        jPanel4.add(jButton3);
        jButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jButton2.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jButton3.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jPanel.add((Component)jPanel2, "Center");
        jPanel.add((Component)jPanel4, "South");
        this.add(jPanel);
    }

    @Override
    protected void close() {
        this.getDialog().dispose();
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog((Frame)this.getApplicationView().getFrame(), Messages.getString("XMLAExportOptions.XMLAExportOptions"));
            this.dialog.getContentPane().add(this);
            this.setDefaultActions(this.dialog);
            this.dialog.setModal(true);
            this.dialog.pack();
            this.dialog.setResizable(false);
            CommonUtil.centerOnScreen(this.dialog);
        }
        return this.dialog;
    }

    @Override
    protected String getHelpIndex() {
        return "EXPORT_XMLA_DIALOG";
    }

    public boolean showDialog() {
        this.getDialog().setVisible(true);
        return this.result;
    }

    public File getLogicalFile() {
        return this.logicalFile;
    }

    public Object[] getRelationalFiles() {
        return this.listModel.toArray();
    }

    private boolean checkSettings() {
        this.catalog = this.tfCatalog.getText();
        if ("".equalsIgnoreCase(this.catalog)) {
            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), Messages.getString("XMLAExportOptions.YouHveToSpecifyDatabaseName"), Messages.getString("XMLAExportOptions.Warning"), 2);
            return false;
        }
        this.multidimensionalDesign = (MultidimensionalDesign)this.cbMDM.getSelectedItem();
        return true;
    }

    private JPanel newRow(JLabel jLabel, Component component) {
        JPanel jPanel = new JPanel();
        jPanel.add(jLabel);
        jPanel.add(component);
        return jPanel;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public MultidimensionalDesign getMultidimensionalDesign() {
        return this.multidimensionalDesign;
    }
}

