/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.awt.Component;
import java.awt.Cursor;
import java.sql.Connection;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JOptionPane;
import oracle.dbtools.crest.exports.Messages;
import oracle.dbtools.crest.exports.reports.DifferentVersionException;
import oracle.dbtools.crest.exports.reports.RSBusinessInfo;
import oracle.dbtools.crest.exports.reports.RSDataTypesModel;
import oracle.dbtools.crest.exports.reports.RSDesign;
import oracle.dbtools.crest.exports.reports.RSDiagrams;
import oracle.dbtools.crest.exports.reports.RSDomains;
import oracle.dbtools.crest.exports.reports.RSLogicalModel;
import oracle.dbtools.crest.exports.reports.RSLogicalTypes;
import oracle.dbtools.crest.exports.reports.RSMappings;
import oracle.dbtools.crest.exports.reports.RSMeasurements;
import oracle.dbtools.crest.exports.reports.RSMultidimensionalModel;
import oracle.dbtools.crest.exports.reports.RSProcessModel;
import oracle.dbtools.crest.exports.reports.RSRDBMSSites;
import oracle.dbtools.crest.exports.reports.RSRelationalModel;
import oracle.dbtools.crest.exports.reports.SchemaFactory;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ProgressDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.ide.Ide;

public class ReportsHandler {
    private ApplicationView appView;
    private ProgressDialog monitor;
    private Connection connection = null;
    private String comments;
    private Map map;
    private boolean exportDiagramsAsPDF = false;
    private Design design;
    private static final Logger LOGGER = new Logger(ReportsHandler.class);

    public ReportsHandler(ApplicationView applicationView, Connection connection, String string, boolean bl) {
        this.appView = applicationView;
        this.design = this.appView.getCurrentDesign();
        this.connection = connection;
        this.comments = string;
        this.exportDiagramsAsPDF = bl;
        this.map = new TreeMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void export() {
        Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(3));
        try {
            boolean bl = false;
            this.monitor = new ProgressDialog(this.appView, "", 0, 100);
            try {
                this.monitor.setNote(Messages.getString("ReportsHandler.ConnectingDatabase"));
                this.monitor.setProgress(1);
                if (this.checkDB()) {
                    this.monitor.setNote(Messages.getString("ReportsHandler.ExportingDesign"));
                    this.monitor.setProgress(5);
                    RSDesign.export(this.design, this.map, this.connection, this.comments);
                    RSRDBMSSites.export(this.design, this.map, this.connection);
                    this.monitor.setNote(Messages.getString("ReportsHandler.ExportingLogicalTypes"));
                    this.monitor.setProgress(10);
                    RSLogicalTypes.export(this.design, this.map, this.connection);
                    this.monitor.setNote(Messages.getString("ReportsHandler.ExportingDomains"));
                    this.monitor.setProgress(15);
                    RSDomains.export(this.design, this.map, this.connection);
                    this.monitor.setNote(Messages.getString("ReportsHandler.ExportingDataTypesModel"));
                    this.monitor.setProgress(20);
                    RSDataTypesModel.export(this.design, this.map, this.connection, this.monitor);
                    this.monitor.setNote(Messages.getString("ReportsHandler.ExportingLogicalModel"));
                    this.monitor.setProgress(25);
                    RSLogicalModel.export(this.design, this.map, this.connection, this.monitor);
                    this.monitor.setNote(Messages.getString("ReportsHandler.ExportingRelationalModels"));
                    this.monitor.setProgress(35);
                    RSRelationalModel.export(this.design, this.map, this.connection, this.monitor);
                    this.monitor.setNote(Messages.getString("ReportsHandler.ExportingMultidimensionalModel"));
                    this.monitor.setProgress(50);
                    RSMultidimensionalModel.export(this.design, this.map, this.connection, this.monitor);
                    this.monitor.setNote(Messages.getString("ReportsHandler.ExportingProcessModel"));
                    this.monitor.setProgress(60);
                    RSProcessModel.export(this.design, this.map, this.connection, this.monitor);
                    this.monitor.setNote(Messages.getString("ReportsHandler.ExportingDiagrams"));
                    this.monitor.setProgress(70);
                    RSDiagrams.export(this.design, this.map, this.connection, this.exportDiagramsAsPDF);
                    this.monitor.setNote(Messages.getString("ReportsHandler.ExportingMappings"));
                    this.monitor.setProgress(80);
                    RSMappings.export(this.design, this.map, this.connection);
                    this.monitor.setNote(Messages.getString("ReportsHandler.ExportingBusinessInformation"));
                    this.monitor.setProgress(90);
                    RSBusinessInfo.export(this.design, this.map, this.connection, this.monitor);
                    this.monitor.setNote(Messages.getString("ReportsHandler.ExportingMeasurements"));
                    this.monitor.setProgress(95);
                    RSMeasurements.export(this.design, this.map, this.connection, this.monitor);
                    this.monitor.setNote(Messages.getString("ReportsHandler.CommitData"));
                    this.monitor.setProgress(99);
                    this.connection.commit();
                    this.monitor.setNote(Messages.getString("ReportsHandler.ExportComplete"));
                    this.monitor.setProgress(100);
                    bl = true;
                }
                if (this.connection != null) {
                    this.connection.close();
                }
            }
            finally {
                this.monitor.close();
            }
            if (bl) {
                MessageDialogs.showMessage(Messages.getString("ReportsHandler.DesignExportedSuccessfully"));
            }
        }
        catch (Exception exception) {
            if (this.connection != null) {
                try {
                    this.connection.rollback();
                    this.connection.close();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
            if (exception.toString().indexOf("ORA-01017") > -1) {
                LOGGER.error("Error Exporting to Reporting Schema: Error=" + exception.getMessage());
                MessageDialogs.showErrorMessage(Messages.getString("ReportsHandler.ErrorUserPassword"));
            } else {
                LOGGER.error("Error Exporting to Reporting Schema: ", exception);
                MessageDialogs.showErrorMessage(Messages.getString("ReportsHandler.ErrorSeeLogFile"));
            }
        }
        finally {
            Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkDB() throws Exception {
        if (this.connection != null) {
            boolean bl = this.connection.getAutoCommit();
            this.connection.setAutoCommit(false);
            try {
                float f = SchemaFactory.schemaVersion(this.connection);
                if (f == 0.0f) {
                    this.monitor.setNote(Messages.getString("ReportsHandler.SettingReportingSchema"));
                    this.monitor.setProgress(2);
                    boolean bl2 = SchemaFactory.createSchema(this.connection);
                    return bl2;
                }
                if (f != 1.6f) {
                    throw new DifferentVersionException();
                }
            }
            catch (DifferentVersionException differentVersionException) {
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), Messages.getString("ReportsHandler.SchemaVersionOutOfDate"), Messages.getString("ReportsHandler.Warning"), 2);
                boolean bl3 = false;
                return bl3;
            }
            finally {
                this.connection.setAutoCommit(bl);
            }
            return true;
        }
        return false;
    }
}

