/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import oracle.dbtools.crest.exports.reports.RSComments;
import oracle.dbtools.crest.exports.reports.RSDynamicProperties;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.exports.reports.RSObjectNotes;
import oracle.dbtools.crest.exports.reports.RSSourceTargetMappings;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.process.Transformation;
import oracle.dbtools.crest.model.design.process.TransformationTask;

public class RSTransformations
extends RSGeneral {
    public static void export(Map map, Connection connection, TransformationTask transformationTask) throws Exception {
        ArrayList<Object> arrayList = new ArrayList<Object>(1000);
        int n = 0;
        String string = "INSERT INTO DMRS_TRANSFORMATIONS (Transformation_ID, Transformation_OVID, Transformation_Name, Transformation_Task_ID, Transformation_Task_OVID, Transformation_Task_Name, Filter_Condition, Join_Condition, Primary, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement preparedStatement = connection.prepareStatement(string);
        Iterator iterator = transformationTask.getTransformationSet().iterator();
        while (iterator.hasNext()) {
            Object object3 = (Transformation)iterator.next();
            Object object2 = RSTransformations.getOrCreateOVID(map, ((ModelIDObject)object3).getObjectID());
            preparedStatement.setString(1, ((ModelIDObject)object3).getObjectID());
            preparedStatement.setString(2, (String)object2);
            preparedStatement.setString(3, ((DesignObject)object3).getName());
            preparedStatement.setString(4, transformationTask.getObjectID());
            preparedStatement.setString(5, (String)map.get(transformationTask.getObjectID()));
            preparedStatement.setString(6, transformationTask.getName());
            preparedStatement.setString(7, ((Transformation)object3).getFilterCondition());
            preparedStatement.setString(8, ((Transformation)object3).getJoinCondition());
            preparedStatement.setString(9, ((Transformation)object3).isPrimary() ? "Y" : "N");
            preparedStatement.setString(10, (String)map.get(transformationTask.getDesign().getObjectID()));
            preparedStatement.addBatch();
            arrayList.add(object3);
            if (++n != 1000) continue;
            n = 0;
            preparedStatement.executeBatch();
            for (Object object3 : arrayList) {
                RSObjectNotes.export(map, connection, (ModelIDObject)object3);
                RSComments.export(map, connection, (ModelIDObject)object3);
                RSSourceTargetMappings.export(map, connection, (ModelIDObject)object3);
                RSDynamicProperties.export(transformationTask.getDesign(), map, connection, (ModelIDObject)object3);
            }
            arrayList.clear();
        }
        if (n > 0) {
            n = 0;
            preparedStatement.executeBatch();
            for (Object object2 : arrayList) {
                RSObjectNotes.export(map, connection, (ModelIDObject)object2);
                RSComments.export(map, connection, (ModelIDObject)object2);
                RSSourceTargetMappings.export(map, connection, (ModelIDObject)object2);
                RSDynamicProperties.export(transformationTask.getDesign(), map, connection, (ModelIDObject)object2);
            }
            arrayList.clear();
        }
        preparedStatement.close();
        preparedStatement = null;
    }
}

