/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.exports.reports.RSComments;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.exports.reports.RSNotes;
import oracle.dbtools.crest.exports.reports.RSTaskParams;
import oracle.dbtools.crest.exports.reports.RSTransformationFlows;
import oracle.dbtools.crest.exports.reports.RSTransformations;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.process.InfoStore;
import oracle.dbtools.crest.model.design.process.Process;
import oracle.dbtools.crest.model.design.process.TransformationPackage;
import oracle.dbtools.crest.model.design.process.TransformationTask;

public class RSTransformationTasks
extends RSGeneral {
    public static void export(Map map, Connection connection, TransformationPackage transformationPackage) throws Exception {
        ArrayList<Object> arrayList = new ArrayList<Object>(1000);
        int n = 0;
        boolean bl = false;
        ArrayList<TransformationTask> arrayList2 = new ArrayList<TransformationTask>();
        String string = "INSERT INTO DMRS_TRANSFORMATION_TASKS (Transformation_Task_ID, Transformation_Task_OVID, Transformation_Task_Name, Transformation_Package_ID, Transformation_Package_OVID, Transformation_Package_Name, Process_ID, Process_OVID, Process_Name, Top_Level, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement preparedStatement = connection.prepareStatement(string);
        Iterator iterator = transformationPackage.getTransformationTaskSet().iterator();
        while (iterator.hasNext()) {
            Object object3 = (TransformationTask)iterator.next();
            Object object2 = RSTransformationTasks.getOrCreateOVID(map, ((ModelIDObject)object3).getObjectID());
            arrayList2.add((TransformationTask)object3);
            String string2 = (String)map.get(((ModelObject)object3).getDesign().getObjectID());
            Process process = ((TransformationTask)object3).getProcess();
            preparedStatement.setString(1, ((ModelIDObject)object3).getObjectID());
            preparedStatement.setString(2, (String)object2);
            preparedStatement.setString(3, ((ModelObject)object3).getName());
            preparedStatement.setString(4, transformationPackage.getObjectID());
            preparedStatement.setString(5, (String)map.get(transformationPackage.getObjectID()));
            preparedStatement.setString(6, transformationPackage.getName());
            if (process != null) {
                preparedStatement.setString(7, process.getObjectID());
                preparedStatement.setString(8, RSTransformationTasks.getOrCreateOVID(map, process.getObjectID()));
                preparedStatement.setString(9, process.getName());
            } else {
                preparedStatement.setString(7, null);
                preparedStatement.setString(8, null);
                preparedStatement.setString(9, null);
            }
            preparedStatement.setString(10, ((TransformationTask)object3).isTopLevel() ? "Y" : "N");
            preparedStatement.setString(11, string2);
            preparedStatement.addBatch();
            arrayList.add(object3);
            if (++n != 1000) continue;
            n = 0;
            preparedStatement.executeBatch();
            for (Object object3 : arrayList) {
                RSComments.export(map, connection, (ModelIDObject)object3);
            }
            arrayList.clear();
        }
        RSTransformationTasks.exportInfoStores(map, connection, arrayList2);
        if (n > 0) {
            n = 0;
            preparedStatement.executeBatch();
            for (Object object2 : arrayList) {
                RSComments.export(map, connection, (ModelIDObject)object2);
            }
            arrayList.clear();
        }
        preparedStatement.close();
        preparedStatement = null;
    }

    private static void exportInfoStores(Map map, Connection connection, List list) throws Exception {
        int n = 0;
        int n2 = 0;
        String string = "INSERT INTO DMRS_TRANSFORMATION_TASK_INFOS (Transformation_Task_ID, Transformation_Task_OVID, Transformation_Task_Name, Info_Store_ID, Info_Store_OVID, Info_Store_Name, Source_Target_Flag, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement preparedStatement = connection.prepareStatement(string);
        for (TransformationTask transformationTask : list) {
            Object object;
            Object object22;
            String string2 = (String)map.get(transformationTask.getDesign().getObjectID());
            for (Object object22 : transformationTask.getSources()) {
                object = (String)map.get(((ModelIDObject)object22).getObjectID());
                preparedStatement.setString(1, transformationTask.getObjectID());
                preparedStatement.setString(2, (String)map.get(transformationTask.getObjectID()));
                preparedStatement.setString(3, transformationTask.getName());
                preparedStatement.setString(4, ((ModelIDObject)object22).getObjectID());
                preparedStatement.setString(5, (String)object);
                preparedStatement.setString(6, ((DesignObject)object22).getName());
                preparedStatement.setString(7, "S");
                preparedStatement.setString(8, string2);
                preparedStatement.addBatch();
                if (++n != 1000) continue;
                n = 0;
                preparedStatement.executeBatch();
            }
            object22 = transformationTask.getTargets().iterator();
            while (object22.hasNext()) {
                object = (InfoStore)object22.next();
                String string3 = (String)map.get(((ModelIDObject)object).getObjectID());
                preparedStatement.setString(1, transformationTask.getObjectID());
                preparedStatement.setString(2, (String)map.get(transformationTask.getObjectID()));
                preparedStatement.setString(3, transformationTask.getName());
                preparedStatement.setString(4, ((ModelIDObject)object).getObjectID());
                preparedStatement.setString(5, string3);
                preparedStatement.setString(6, ((DesignObject)object).getName());
                preparedStatement.setString(7, "T");
                preparedStatement.setString(8, string2);
                preparedStatement.addBatch();
                if (++n2 != 1000) continue;
                n2 = 0;
                preparedStatement.executeBatch();
            }
            RSTaskParams.export(map, connection, transformationTask, transformationTask.getInputParamsObject());
            RSTaskParams.export(map, connection, transformationTask, transformationTask.getOutputParamsObject());
            RSTransformationFlows.export(map, connection, transformationTask);
            RSTransformations.export(map, connection, transformationTask);
            RSNotes.export(map, connection, transformationTask);
        }
        if (n > 0) {
            n = 0;
            preparedStatement.executeBatch();
        }
        preparedStatement.close();
        preparedStatement = null;
    }
}

