/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import oracle.dbtools.crest.exports.reports.RSComments;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.exports.reports.RSObjectNotes;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.process.AbstractProcessObject;
import oracle.dbtools.crest.model.design.process.Flow;
import oracle.dbtools.crest.model.design.process.TransformationFlow;
import oracle.dbtools.crest.model.design.process.TransformationTask;

public class RSTransformationFlows
extends RSGeneral {
    public static void export(Map map, Connection connection, TransformationTask transformationTask) throws Exception {
        ArrayList<Object> arrayList = new ArrayList<Object>(1000);
        int n = 0;
        String string = "INSERT INTO DMRS_TRANSFORMATION_FLOWS (Transformation_Flow_ID, Transformation_Flow_OVID, Transformation_Flow_Name, Transformation_Task_ID, Transformation_Task_OVID, Transformation_Task_Name, Source_ID, Source_OVID, Source_Name, Destination_ID, Destination_OVID, Destination_Name, Source_Type, Destination_Type, System_Objective, Logging, Op_Create, Op_Read, Op_Update, Op_Delete, CRUD_Code, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement preparedStatement = connection.prepareStatement(string);
        Iterator iterator = transformationTask.getFlowSet().iterator();
        while (iterator.hasNext()) {
            Object object3 = (TransformationFlow)iterator.next();
            Object object2 = RSTransformationFlows.getOrCreateOVID(map, ((ModelIDObject)object3).getObjectID());
            AbstractProcessObject abstractProcessObject = ((Flow)object3).getSource();
            AbstractProcessObject abstractProcessObject2 = ((Flow)object3).getDestination();
            preparedStatement.setString(1, ((ModelIDObject)object3).getObjectID());
            preparedStatement.setString(2, (String)object2);
            preparedStatement.setString(3, ((DesignObject)object3).getName());
            preparedStatement.setString(4, transformationTask.getObjectID());
            preparedStatement.setString(5, (String)map.get(transformationTask.getObjectID()));
            preparedStatement.setString(6, transformationTask.getName());
            if (abstractProcessObject != null) {
                preparedStatement.setString(7, abstractProcessObject.getObjectID());
                preparedStatement.setString(8, RSTransformationFlows.getOrCreateOVID(map, abstractProcessObject.getObjectID()));
                preparedStatement.setString(9, abstractProcessObject.getName());
                preparedStatement.setString(13, abstractProcessObject.getObjectTypeName());
            } else {
                preparedStatement.setString(7, null);
                preparedStatement.setString(8, null);
                preparedStatement.setString(9, null);
                preparedStatement.setString(13, null);
            }
            if (abstractProcessObject2 != null) {
                preparedStatement.setString(10, abstractProcessObject2.getObjectID());
                preparedStatement.setString(11, RSTransformationFlows.getOrCreateOVID(map, abstractProcessObject2.getObjectID()));
                preparedStatement.setString(12, abstractProcessObject2.getName());
                preparedStatement.setString(14, abstractProcessObject2.getObjectTypeName());
            } else {
                preparedStatement.setString(10, null);
                preparedStatement.setString(11, null);
                preparedStatement.setString(12, null);
                preparedStatement.setString(14, null);
            }
            preparedStatement.setString(15, ((Flow)object3).getSystemObjective());
            preparedStatement.setString(16, ((Flow)object3).isLogging() ? "Y" : "N");
            preparedStatement.setString(17, ((Flow)object3).isOpCreate() ? "Y" : "N");
            preparedStatement.setString(18, ((Flow)object3).isOpRead() ? "Y" : "N");
            preparedStatement.setString(19, ((Flow)object3).isOpUpdate() ? "Y" : "N");
            preparedStatement.setString(20, ((Flow)object3).isOpDelete() ? "Y" : "N");
            String string2 = "";
            if (((Flow)object3).isOpCreate()) {
                string2 = "C";
            }
            if (((Flow)object3).isOpRead()) {
                string2 = string2 + "R";
            }
            if (((Flow)object3).isOpUpdate()) {
                string2 = string2 + "U";
            }
            if (((Flow)object3).isOpDelete()) {
                string2 = string2 + "D";
            }
            preparedStatement.setString(21, string2);
            preparedStatement.setString(22, (String)map.get(transformationTask.getDesign().getObjectID()));
            preparedStatement.addBatch();
            arrayList.add(object3);
            if (++n != 1000) continue;
            n = 0;
            preparedStatement.executeBatch();
            for (Object object3 : arrayList) {
                RSObjectNotes.export(map, connection, (ModelIDObject)object3);
                RSComments.export(map, connection, (ModelIDObject)object3);
            }
            arrayList.clear();
        }
        if (n > 0) {
            n = 0;
            preparedStatement.executeBatch();
            for (Object object2 : arrayList) {
                RSObjectNotes.export(map, connection, (ModelIDObject)object2);
                RSComments.export(map, connection, (ModelIDObject)object2);
            }
            arrayList.clear();
        }
        preparedStatement.close();
        preparedStatement = null;
    }
}

