/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import oracle.dbtools.crest.exports.reports.RSColumnGroups;
import oracle.dbtools.crest.exports.reports.RSComments;
import oracle.dbtools.crest.exports.reports.RSCommentsInRDBMS;
import oracle.dbtools.crest.exports.reports.RSDynamicProperties;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.exports.reports.RSObjectNotes;
import oracle.dbtools.crest.exports.reports.RSPKOidColumns;
import oracle.dbtools.crest.exports.reports.RSSpatialColumnDefinition;
import oracle.dbtools.crest.exports.reports.RSTableConstraints;
import oracle.dbtools.crest.exports.reports.RSTableIncludeScripts;
import oracle.dbtools.crest.model.ClassificationType;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.util.GUID;

public class RSTables
extends RSGeneral {
    public static void export(Design design, Map map, Connection connection) throws Exception {
        ArrayList<Table> arrayList = new ArrayList<Table>(1000);
        int n = 0;
        String string = "INSERT INTO DMRS_TABLES (Table_Name, Abbreviation, Object_ID, OVID, Import_ID, Model_ID, Model_OVID, Structured_Type_ID, Structured_Type_OVID, Structured_Type_Name, Number_Data_Elements, Classification_Type_ID, Classification_Type_OVID, Classification_Type_Name, Allow_Type_Substitution, Min_Volume, Expected_Volume, Max_Volume, Growth_Rate_Percents, Growth_Rate_Interval, Normal_Form, Temporary_Object_Scope, Adequately_Normalized, Substitution_Parent, Substitution_Parent_OVID, Engineer, Spatial_Table, OID_is_PK, OID_is_User_Defined, Include_Scripts_Into_DDL, Model_Name, Substitution_Parent_Name, Design_OVID, Schema_OVID, Schema_Name, Source_Info_OVID, Source_DataDict_Schema_Name, Source_DataDict_Object_Name) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement preparedStatement = connection.prepareStatement(string);
        Iterator iterator = design.getRelationalDesigns().iterator();
        while (iterator.hasNext()) {
            RelationalDesign relationalDesign = (RelationalDesign)iterator.next();
            String object = (String)map.get(relationalDesign.getObjectID());
            Iterator iterator2 = relationalDesign.getTableSet().iterator();
            while (iterator2.hasNext()) {
                String string2;
                Iterator iterator3;
                Table table = (Table)iterator2.next();
                String string3 = new GUID().toString();
                map.put(table.getObjectID(), string3);
                preparedStatement.setString(1, table.getName());
                preparedStatement.setString(2, table.getAbbreviation());
                preparedStatement.setString(3, table.getObjectID());
                preparedStatement.setString(4, string3);
                preparedStatement.setString(5, table.getImportedId());
                preparedStatement.setString(6, relationalDesign.getObjectID());
                preparedStatement.setString(7, object);
                preparedStatement.setString(8, table.getBasedOnStructuredType() != null ? table.getBasedOnStructuredType().getObjectID() : null);
                preparedStatement.setString(9, table.getBasedOnStructuredType() != null ? (String)map.get(table.getBasedOnStructuredType().getObjectID()) : null);
                preparedStatement.setString(10, table.getBasedOnStructuredType() != null ? table.getBasedOnStructuredType().getName() : null);
                preparedStatement.setInt(11, table.getElements().length);
                preparedStatement.setString(12, null);
                preparedStatement.setString(13, null);
                preparedStatement.setString(14, null);
                if (!"".equalsIgnoreCase(table.getTypeID()) && (iterator3 = design.getDLSettings().getClassificationTypeByID(table.getTypeID())) != null) {
                    string2 = (String)ctMap.get(((ClassificationType)((Object)iterator3)).getTypeID());
                    preparedStatement.setString(12, table.getTypeID());
                    preparedStatement.setString(13, string2);
                    preparedStatement.setString(14, ((ClassificationType)((Object)iterator3)).getTypeName());
                }
                preparedStatement.setString(15, table.isAllowTypeSubstitution() ? "Y" : "N");
                preparedStatement.setObject(16, table.getMinVolumes());
                preparedStatement.setObject(17, table.getExpectedVolumes());
                preparedStatement.setObject(18, table.getMaxVolumes());
                preparedStatement.setInt(19, table.getGrowthPercentInt());
                preparedStatement.setString(20, table.getGrowthType());
                preparedStatement.setString(21, table.getNormalForm());
                preparedStatement.setString(22, table.getScope());
                preparedStatement.setString(23, "YES".equalsIgnoreCase(table.getAdequatelyNormalized()) ? "Y" : "N");
                preparedStatement.setString(24, table.getTypeSubstitution() != null ? table.getTypeSubstitution().getObjectID() : null);
                preparedStatement.setString(25, table.getTypeSubstitution() != null ? RSTables.getOrCreateOVID(map, table.getTypeSubstitution().getObjectID()) : null);
                preparedStatement.setString(26, table.getShouldEngineer() ? "Y" : "N");
                preparedStatement.setString(27, table.isSpatialTable() ? "Y" : "N");
                preparedStatement.setString(28, table.isOidIsPK() ? "Y" : "N");
                preparedStatement.setString(29, table.isUserDefinedOid() ? "Y" : "N");
                preparedStatement.setString(30, table.getShouldGenerateScript() ? "Y" : "N");
                preparedStatement.setString(31, relationalDesign.getName());
                preparedStatement.setString(32, table.getTypeSubstitution() != null ? table.getTypeSubstitution().getName() : null);
                preparedStatement.setString(33, (String)map.get(design.getObjectID()));
                preparedStatement.setString(34, table.getSchemaObject() != null ? (String)map.get(table.getSchemaObject().getObjectID()) : null);
                preparedStatement.setString(35, table.getSchemaObject() != null ? table.getSchemaObject().getName() : null);
                if (!"".equals(table.getSourceDDLFile())) {
                    iterator3 = "D" + table.getSourceDDLFile() + relationalDesign.getObjectID();
                    string2 = (String)map.get(iterator3);
                    preparedStatement.setString(36, string2);
                    preparedStatement.setString(37, null);
                    preparedStatement.setString(38, null);
                } else if (!"".equals(table.getSourceConnName())) {
                    iterator3 = "B" + table.getSourceConnName() + relationalDesign.getObjectID();
                    string2 = (String)map.get(iterator3);
                    preparedStatement.setString(36, string2);
                    preparedStatement.setString(37, table.getSourceObjSchema());
                    preparedStatement.setString(38, table.getSourceObjName());
                } else {
                    preparedStatement.setString(36, null);
                    preparedStatement.setString(37, null);
                    preparedStatement.setString(38, null);
                }
                preparedStatement.addBatch();
                arrayList.add(table);
                if (++n != 1000) continue;
                n = 0;
                preparedStatement.executeBatch();
                iterator3 = arrayList.iterator();
                while (iterator3.hasNext()) {
                    table = (Table)iterator3.next();
                    RSObjectNotes.export(map, connection, table);
                    RSComments.export(map, connection, table);
                    RSCommentsInRDBMS.export(map, connection, table);
                    RSTableConstraints.export(map, connection, table);
                    RSSpatialColumnDefinition.export(map, connection, table);
                    RSTableIncludeScripts.export(map, connection, table);
                    RSPKOidColumns.export(map, connection, table);
                    RSColumnGroups.export(map, connection, table);
                    RSDynamicProperties.export(design, map, connection, table);
                }
                arrayList.clear();
            }
        }
        if (n > 0) {
            n = 0;
            preparedStatement.executeBatch();
            for (Table table : arrayList) {
                RSObjectNotes.export(map, connection, table);
                RSComments.export(map, connection, table);
                RSCommentsInRDBMS.export(map, connection, table);
                RSTableConstraints.export(map, connection, table);
                RSSpatialColumnDefinition.export(map, connection, table);
                RSTableIncludeScripts.export(map, connection, table);
                RSPKOidColumns.export(map, connection, table);
                RSColumnGroups.export(map, connection, table);
                RSDynamicProperties.export(design, map, connection, table);
            }
            arrayList.clear();
        }
        preparedStatement.close();
        preparedStatement = null;
    }
}

