/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.process.Process;
import oracle.dbtools.crest.model.design.process.TargetElement;
import oracle.dbtools.crest.model.design.process.Transformation;

public class RSSourceTargetMappings
extends RSGeneral {
    public static void export(Map map, Connection connection, ModelIDObject modelIDObject) throws Exception {
        int n = 0;
        ArrayList<TargetElement> arrayList = new ArrayList<TargetElement>();
        String string = "INSERT INTO DMRS_MAPPING_TARGETS (Object_ID, Object_OVID, Object_Name, Target_ID, Target_OVID, Target_Name, Object_Type, Target_Type, Transformation_Type, Description, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement preparedStatement = connection.prepareStatement(string);
        if (modelIDObject instanceof Process || modelIDObject instanceof Transformation) {
            String string2 = (String)map.get(modelIDObject.getDesign().getObjectID());
            String string3 = (String)map.get(modelIDObject.getObjectID());
            Iterator iterator = modelIDObject instanceof Process ? ((Process)modelIDObject).getTargetElements().iterator() : ((Transformation)modelIDObject).getTargetElements().iterator();
            while (iterator.hasNext()) {
                TargetElement targetElement = (TargetElement)iterator.next();
                DesignObject designObject = targetElement.getTarget();
                String string4 = RSSourceTargetMappings.getOrCreateOVID(map, designObject.getObjectID());
                arrayList.add(targetElement);
                preparedStatement.setString(1, modelIDObject.getObjectID());
                preparedStatement.setString(2, string3);
                preparedStatement.setString(3, modelIDObject.getName());
                preparedStatement.setString(4, designObject.getObjectID());
                preparedStatement.setString(5, string4);
                preparedStatement.setString(6, designObject.getName());
                preparedStatement.setString(7, modelIDObject.getObjectTypeName());
                preparedStatement.setString(8, designObject.getObjectTypeName());
                preparedStatement.setString(9, targetElement.getTransformationType());
                preparedStatement.setString(10, targetElement.getDescription());
                preparedStatement.setString(11, string2);
                preparedStatement.addBatch();
                if (++n != 1000) continue;
                n = 0;
                preparedStatement.executeBatch();
            }
            RSSourceTargetMappings.exportSources(map, connection, arrayList, string2, string3, modelIDObject);
        }
        if (n > 0) {
            n = 0;
            preparedStatement.executeBatch();
        }
        preparedStatement.close();
        preparedStatement = null;
    }

    private static void exportSources(Map map, Connection connection, List list, String string, String string2, ModelIDObject modelIDObject) throws Exception {
        int n = 0;
        String string3 = "INSERT INTO DMRS_MAPPING_TARGET_SOURCES (Object_ID, Object_OVID, Object_Name, Target_ID, Target_OVID, Target_Name, Source_ID, Source_OVID, Source_Name, Object_Type, Target_Type, Source_Type, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement preparedStatement = connection.prepareStatement(string3);
        for (TargetElement targetElement : list) {
            DesignObject designObject = targetElement.getTarget();
            for (DesignObject designObject2 : targetElement.getSources()) {
                String string4 = RSSourceTargetMappings.getOrCreateOVID(map, designObject2.getObjectID());
                preparedStatement.setString(1, modelIDObject.getObjectID());
                preparedStatement.setString(2, string2);
                preparedStatement.setString(3, modelIDObject.getName());
                preparedStatement.setString(4, designObject.getObjectID());
                preparedStatement.setString(5, (String)map.get(designObject.getObjectID()));
                preparedStatement.setString(6, designObject.getName());
                preparedStatement.setString(7, designObject2.getObjectID());
                preparedStatement.setString(8, string4);
                preparedStatement.setString(9, designObject2.getName());
                preparedStatement.setString(10, modelIDObject.getObjectTypeName());
                preparedStatement.setString(11, designObject.getObjectTypeName());
                preparedStatement.setString(12, designObject2.getObjectTypeName());
                preparedStatement.setString(13, string);
                preparedStatement.addBatch();
                if (++n != 1000) continue;
                n = 0;
                preparedStatement.executeBatch();
            }
        }
        if (n > 0) {
            n = 0;
            preparedStatement.executeBatch();
        }
        preparedStatement.close();
        preparedStatement = null;
    }
}

