/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.exports.reports.RSComments;
import oracle.dbtools.crest.exports.reports.RSDynamicProperties;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.exports.reports.RSObjectNotes;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.multidimensional.Cube;
import oracle.dbtools.crest.model.design.multidimensional.Dimension;
import oracle.dbtools.crest.model.design.multidimensional.Hierarchy;
import oracle.dbtools.crest.model.design.multidimensional.Level;
import oracle.dbtools.crest.model.design.multidimensional.Measure;
import oracle.dbtools.crest.model.design.multidimensional.MultidimensionalDesign;
import oracle.dbtools.crest.model.design.multidimensional.Slice;

public class RSSlices
extends RSGeneral {
    public static void export(Design design, Map map, Connection connection) throws Exception {
        ArrayList<Slice> arrayList = new ArrayList<Slice>(1000);
        int n = 0;
        ArrayList<Slice> arrayList2 = new ArrayList<Slice>();
        String string = "INSERT INTO DMRS_SLICES (Slice_ID, Slice_Name, Slice_OVID, Model_ID, Model_Name, Model_OVID, Cube_ID, Cube_Name, Cube_OVID, Entity_ID, Entity_Name, Entity_OVID, Oracle_Long_Name, Oracle_Plural_Name, Oracle_Short_Name, Is_Fully_Realized, Is_Read_Only, Description, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement preparedStatement = connection.prepareStatement(string);
        Iterator iterator = design.getMultidimensionalDesigns().iterator();
        while (iterator.hasNext()) {
            MultidimensionalDesign multidimensionalDesign = (MultidimensionalDesign)iterator.next();
            String object = (String)map.get(multidimensionalDesign.getObjectID());
            String string2 = (String)map.get(multidimensionalDesign.getDesign().getObjectID());
            arrayList2.clear();
            Iterator iterator2 = multidimensionalDesign.getSliceSet().iterator();
            while (iterator2.hasNext()) {
                Slice slice2 = (Slice)iterator2.next();
                String string3 = RSSlices.getOrCreateOVID(map, slice2.getObjectID());
                arrayList2.add(slice2);
                Cube cube = slice2.getCube();
                Entity entity = slice2.getEntity();
                preparedStatement.setString(1, slice2.getObjectID());
                preparedStatement.setString(2, slice2.getName());
                preparedStatement.setString(3, string3);
                preparedStatement.setString(4, multidimensionalDesign.getObjectID());
                preparedStatement.setString(5, multidimensionalDesign.getName());
                preparedStatement.setString(6, object);
                if (cube != null) {
                    preparedStatement.setString(7, cube.getObjectID());
                    preparedStatement.setString(8, cube.getName());
                    preparedStatement.setString(9, RSSlices.getOrCreateOVID(map, cube.getObjectID()));
                } else {
                    preparedStatement.setString(7, null);
                    preparedStatement.setString(8, null);
                    preparedStatement.setString(9, null);
                }
                if (entity != null) {
                    preparedStatement.setString(10, entity.getObjectID());
                    preparedStatement.setString(11, entity.getName());
                    preparedStatement.setString(12, (String)map.get(entity.getObjectID()));
                } else {
                    preparedStatement.setString(10, null);
                    preparedStatement.setString(11, null);
                    preparedStatement.setString(12, null);
                }
                preparedStatement.setString(13, slice2.getOracleLongName());
                preparedStatement.setString(14, slice2.getOraclePluralName());
                preparedStatement.setString(15, slice2.getOracleShortName());
                preparedStatement.setString(16, slice2.isFullyRealized() ? "Y" : "N");
                preparedStatement.setString(17, slice2.isReadOnlySlice() ? "Y" : "N");
                preparedStatement.setString(18, slice2.getDescription());
                preparedStatement.setString(19, string2);
                preparedStatement.addBatch();
                arrayList.add(slice2);
                if (++n != 1000) continue;
                n = 0;
                preparedStatement.executeBatch();
                for (Slice slice2 : arrayList) {
                    RSObjectNotes.export(map, connection, slice2);
                    RSComments.export(map, connection, slice2);
                    RSDynamicProperties.export(design, map, connection, slice2);
                }
                arrayList.clear();
            }
            RSSlices.exportDimensionHierarchyLevel(map, connection, arrayList2, string2);
            RSSlices.exportMeasures(map, connection, arrayList2, string2);
        }
        if (n > 0) {
            n = 0;
            preparedStatement.executeBatch();
            for (Slice slice : arrayList) {
                RSObjectNotes.export(map, connection, slice);
                RSComments.export(map, connection, slice);
                RSDynamicProperties.export(design, map, connection, slice);
            }
            arrayList.clear();
        }
        preparedStatement.close();
        preparedStatement = null;
    }

    private static void exportDimensionHierarchyLevel(Map map, Connection connection, List list, String string) throws Exception {
        int n = 0;
        String string2 = "INSERT INTO DMRS_SLICE_DIM_HIER_LEVEL (Slice_ID, Slice_Name, Slice_OVID, Dimension_ID, Dimension_Name, Dimension_OVID, Hierarchy_ID, Hierarchy_Name, Hierarchy_OVID, Level_ID, Level_Name, Level_OVID, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement preparedStatement = connection.prepareStatement(string2);
        for (Slice slice : list) {
            for (Slice.SelectedLevel selectedLevel : slice.getSelectedLevels()) {
                Dimension dimension = selectedLevel.getDimension();
                Hierarchy hierarchy = selectedLevel.getHierarchy();
                Level level = selectedLevel.getLevel();
                preparedStatement.setString(1, slice.getObjectID());
                preparedStatement.setString(2, slice.getName());
                preparedStatement.setString(3, (String)map.get(slice.getObjectID()));
                if (dimension != null) {
                    preparedStatement.setString(4, dimension.getObjectID());
                    preparedStatement.setString(5, dimension.getName());
                    preparedStatement.setString(6, RSSlices.getOrCreateOVID(map, dimension.getObjectID()));
                } else {
                    preparedStatement.setString(4, null);
                    preparedStatement.setString(5, null);
                    preparedStatement.setString(6, null);
                }
                if (hierarchy != null) {
                    preparedStatement.setString(7, hierarchy.getObjectID());
                    preparedStatement.setString(8, hierarchy.getName());
                    preparedStatement.setString(9, RSSlices.getOrCreateOVID(map, hierarchy.getObjectID()));
                } else {
                    preparedStatement.setString(7, null);
                    preparedStatement.setString(8, null);
                    preparedStatement.setString(9, null);
                }
                if (level != null) {
                    preparedStatement.setString(10, level.getObjectID());
                    preparedStatement.setString(11, level.getName());
                    preparedStatement.setString(12, RSSlices.getOrCreateOVID(map, level.getObjectID()));
                } else {
                    preparedStatement.setString(10, null);
                    preparedStatement.setString(11, null);
                    preparedStatement.setString(12, null);
                }
                preparedStatement.setString(13, string);
                preparedStatement.addBatch();
                if (++n != 1000) continue;
                n = 0;
                preparedStatement.executeBatch();
            }
        }
        if (n > 0) {
            n = 0;
            preparedStatement.executeBatch();
        }
        preparedStatement.close();
        preparedStatement = null;
    }

    private static void exportMeasures(Map map, Connection connection, List list, String string) throws Exception {
        int n = 0;
        String string2 = "INSERT INTO DMRS_SLICE_MEASURES (Slice_ID, Slice_Name, Slice_OVID, Measure_ID, Measure_Name, Measure_OVID, Aggregate_Function_ID, Aggregate_Function_Name, Aggregate_Function_OVID, Measure_Alias, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement preparedStatement = connection.prepareStatement(string2);
        for (Slice slice : list) {
            for (Slice.MeasureWrapper measureWrapper : slice.getAllMeasureWrappers()) {
                Measure measure = measureWrapper.getMeasure();
                if (measure == null) continue;
                String string3 = RSSlices.getOrCreateOVID(map, measure.getObjectID());
                Measure.AggregateFunction aggregateFunction = measureWrapper.getAggrFunction();
                preparedStatement.setString(1, slice.getObjectID());
                preparedStatement.setString(2, slice.getName());
                preparedStatement.setString(3, (String)map.get(slice.getObjectID()));
                preparedStatement.setString(4, measure.getObjectID());
                preparedStatement.setString(5, measure.getName());
                preparedStatement.setString(6, string3);
                if (aggregateFunction != null) {
                    preparedStatement.setString(7, aggregateFunction.getObjectID());
                    preparedStatement.setString(8, aggregateFunction.getName());
                    preparedStatement.setString(9, RSSlices.getOrCreateOVID(map, aggregateFunction.getObjectID()));
                } else {
                    preparedStatement.setString(7, null);
                    preparedStatement.setString(8, null);
                    preparedStatement.setString(9, null);
                }
                preparedStatement.setString(10, measureWrapper.getMeasureAlias());
                preparedStatement.setString(11, string);
                preparedStatement.addBatch();
                if (++n != 1000) continue;
                n = 0;
                preparedStatement.executeBatch();
            }
        }
        if (n > 0) {
            n = 0;
            preparedStatement.executeBatch();
        }
        preparedStatement.close();
        preparedStatement = null;
    }
}

