/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.exports.reports.RSComments;
import oracle.dbtools.crest.exports.reports.RSDynamicProperties;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.exports.reports.RSObjectNotes;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.multidimensional.AbstractMDObject;
import oracle.dbtools.crest.model.design.multidimensional.MultidimensionalDesign;
import oracle.dbtools.crest.model.design.multidimensional.RollupLink;

public class RSRollupLinks
extends RSGeneral {
    public static void export(Design design, Map map, Connection connection) throws Exception {
        ArrayList<RollupLink> arrayList = new ArrayList<RollupLink>(1000);
        int n = 0;
        ArrayList<RollupLink> arrayList2 = new ArrayList<RollupLink>();
        String string = "INSERT INTO DMRS_ROLLUP_LINKS (Rollup_Link_ID, Rollup_Link_Name, Rollup_Link_OVID, Model_ID, Model_Name, Model_OVID, Parent_Object_ID, Parent_Object_Name, Parent_Object_OVID, Child_Object_ID, Child_Object_Name, Child_Object_OVID, Fact_Entity_ID, Fact_Entity_Name, Fact_Entity_OVID, Parent_Object_Type, Child_Object_Type, Oracle_Long_Name, Oracle_Plural_Name, Oracle_Short_Name, Default_Aggr_Operator, Is_Role_Playing, Is_Sparse_Dimension, Description, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement preparedStatement = connection.prepareStatement(string);
        Iterator iterator = design.getMultidimensionalDesigns().iterator();
        while (iterator.hasNext()) {
            MultidimensionalDesign multidimensionalDesign = (MultidimensionalDesign)iterator.next();
            String object = (String)map.get(multidimensionalDesign.getObjectID());
            String string2 = (String)map.get(multidimensionalDesign.getDesign().getObjectID());
            arrayList2.clear();
            Iterator iterator2 = multidimensionalDesign.getRollupLinkSet().iterator();
            while (iterator2.hasNext()) {
                RollupLink rollupLink2 = (RollupLink)iterator2.next();
                String string3 = RSRollupLinks.getOrCreateOVID(map, rollupLink2.getObjectID());
                arrayList2.add(rollupLink2);
                AbstractMDObject abstractMDObject = rollupLink2.getParentLevel();
                AbstractMDObject abstractMDObject2 = rollupLink2.getChildLevel();
                ContainerObject containerObject = rollupLink2.getFactEntity();
                preparedStatement.setString(1, rollupLink2.getObjectID());
                preparedStatement.setString(2, rollupLink2.getName());
                preparedStatement.setString(3, string3);
                preparedStatement.setString(4, multidimensionalDesign.getObjectID());
                preparedStatement.setString(5, multidimensionalDesign.getName());
                preparedStatement.setString(6, object);
                if (abstractMDObject != null) {
                    preparedStatement.setString(7, abstractMDObject.getObjectID());
                    preparedStatement.setString(8, abstractMDObject.getName());
                    preparedStatement.setString(9, RSRollupLinks.getOrCreateOVID(map, abstractMDObject.getObjectID()));
                    preparedStatement.setString(16, abstractMDObject.getObjectTypeName());
                } else {
                    preparedStatement.setString(7, null);
                    preparedStatement.setString(8, null);
                    preparedStatement.setString(9, null);
                    preparedStatement.setString(16, null);
                }
                if (abstractMDObject2 != null) {
                    preparedStatement.setString(10, abstractMDObject2.getObjectID());
                    preparedStatement.setString(11, abstractMDObject2.getName());
                    preparedStatement.setString(12, RSRollupLinks.getOrCreateOVID(map, abstractMDObject2.getObjectID()));
                    preparedStatement.setString(17, abstractMDObject2.getObjectTypeName());
                } else {
                    preparedStatement.setString(10, null);
                    preparedStatement.setString(11, null);
                    preparedStatement.setString(12, null);
                    preparedStatement.setString(17, null);
                }
                if (containerObject != null && containerObject instanceof Entity) {
                    preparedStatement.setString(13, containerObject.getObjectID());
                    preparedStatement.setString(14, containerObject.getName());
                    preparedStatement.setString(15, (String)map.get(containerObject.getObjectID()));
                } else {
                    preparedStatement.setString(13, null);
                    preparedStatement.setString(14, null);
                    preparedStatement.setString(15, null);
                }
                preparedStatement.setString(18, rollupLink2.getOracleLongName());
                preparedStatement.setString(19, rollupLink2.getOraclePluralName());
                preparedStatement.setString(20, rollupLink2.getOracleShortName());
                preparedStatement.setString(21, rollupLink2.getDefaultAggregationOperator());
                preparedStatement.setString(22, rollupLink2.isRolePlaying() ? "Y" : "N");
                preparedStatement.setString(23, rollupLink2.isSparseDimension() ? "Y" : "N");
                preparedStatement.setString(24, rollupLink2.getDescription());
                preparedStatement.setString(25, string2);
                preparedStatement.addBatch();
                arrayList.add(rollupLink2);
                if (++n != 1000) continue;
                n = 0;
                preparedStatement.executeBatch();
                for (RollupLink rollupLink2 : arrayList) {
                    RSObjectNotes.export(map, connection, rollupLink2);
                    RSComments.export(map, connection, rollupLink2);
                    RSDynamicProperties.export(design, map, connection, rollupLink2);
                }
                arrayList.clear();
            }
            RSRollupLinks.exportAttributes(map, connection, arrayList2, string2);
        }
        if (n > 0) {
            n = 0;
            preparedStatement.executeBatch();
            for (RollupLink rollupLink : arrayList) {
                RSObjectNotes.export(map, connection, rollupLink);
                RSComments.export(map, connection, rollupLink);
                RSDynamicProperties.export(design, map, connection, rollupLink);
            }
            arrayList.clear();
        }
        preparedStatement.close();
        preparedStatement = null;
    }

    private static void exportAttributes(Map map, Connection connection, List list, String string) throws Exception {
        int n = 0;
        String string2 = "INSERT INTO DMRS_ROLLUP_LINK_ATTRS (Rollup_Link_ID, Rollup_Link_Name, Rollup_Link_OVID, Attribute_ID, Attribute_Name, Attribute_OVID, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement preparedStatement = connection.prepareStatement(string2);
        for (RollupLink rollupLink : list) {
            for (Attribute attribute : rollupLink.getChildToParentAttributes()) {
                String string3 = (String)map.get(attribute.getObjectID());
                preparedStatement.setString(1, rollupLink.getObjectID());
                preparedStatement.setString(2, rollupLink.getName());
                preparedStatement.setString(3, (String)map.get(rollupLink.getObjectID()));
                preparedStatement.setString(4, attribute.getObjectID());
                preparedStatement.setString(5, attribute.getName());
                preparedStatement.setString(6, string3);
                preparedStatement.setString(7, string);
                preparedStatement.addBatch();
                if (++n != 1000) continue;
                n = 0;
                preparedStatement.executeBatch();
            }
        }
        if (n > 0) {
            n = 0;
            preparedStatement.executeBatch();
        }
        preparedStatement.close();
        preparedStatement = null;
    }
}

