/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.Iterator;
import java.util.Map;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;

public class RSRDBMSSites
extends RSGeneral {
    public static void export(Design design, Map map, Connection connection) throws Exception {
        int n = 0;
        String string = "INSERT INTO DMRS_RDBMS_SITES (Site_Name, Site_ID, Site_OVID, RDBMS_Type, Design_OVID) VALUES (?, ?, ?, ?, ?)";
        PreparedStatement preparedStatement = connection.prepareStatement(string);
        Iterator iterator = design.getRDBMSSiteSet().iterator();
        while (iterator.hasNext()) {
            RDBMSSite rDBMSSite = (RDBMSSite)iterator.next();
            preparedStatement.setString(1, rDBMSSite.getName());
            preparedStatement.setString(2, rDBMSSite.getObjectID());
            preparedStatement.setString(3, RSRDBMSSites.getOrCreateOVID(map, rDBMSSite.getObjectID()));
            preparedStatement.setInt(4, rDBMSSite.getType().getType());
            preparedStatement.setString(5, (String)map.get(design.getObjectID()));
            preparedStatement.addBatch();
            if (++n != 1000) continue;
            n = 0;
            preparedStatement.executeBatch();
        }
        if (n > 0) {
            n = 0;
            preparedStatement.executeBatch();
        }
        preparedStatement.close();
        preparedStatement = null;
    }
}

