/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import oracle.dbtools.crest.exports.reports.RSComments;
import oracle.dbtools.crest.exports.reports.RSDynamicProperties;
import oracle.dbtools.crest.exports.reports.RSFootnotes;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.exports.reports.RSObjectNotes;
import oracle.dbtools.crest.exports.reports.RSSourceTargetMappings;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.process.DataFlowDesign;
import oracle.dbtools.crest.model.design.process.Process;
import oracle.dbtools.crest.model.design.process.ProcessModel;
import oracle.dbtools.crest.model.design.process.TransformationTask;

public class RSProcesses
extends RSGeneral {
    public static void export(Design design, Map map, Connection connection) throws Exception {
        ArrayList<Process> arrayList = new ArrayList<Process>(1000);
        int n = 0;
        String string = "INSERT INTO DMRS_PROCESSES (Process_ID, Process_OVID, Process_Name, Diagram_ID, Diagram_OVID, Diagram_Name, Transformation_Task_ID, Transformation_Task_OVID, Transformation_Task_Name, Parent_Process_ID, Parent_Process_OVID, Parent_Process_Name, Process_Number, Process_Type, Process_Mode, Priority, Frequency_Times, Frequency_Time_Unit, Peak_Periods_String, Parameters_Wrappers_String, Interactive_Max_Response_Time, Interactive_Response_Time_Unit, Batch_Min_Transactions, Batch_Time_Unit, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement preparedStatement = connection.prepareStatement(string);
        ProcessModel processModel = design.getProcessModel();
        Iterator iterator = processModel.getDataFlowDesigns().iterator();
        while (iterator.hasNext()) {
            DataFlowDesign dataFlowDesign = (DataFlowDesign)iterator.next();
            String object = RSProcesses.getOrCreateOVID(map, dataFlowDesign.getObjectID());
            Iterator iterator2 = dataFlowDesign.getProcessSet().iterator();
            while (iterator2.hasNext()) {
                Process process3 = (Process)iterator2.next();
                String string2 = RSProcesses.getOrCreateOVID(map, process3.getObjectID());
                TransformationTask transformationTask = process3.getTransformationTask();
                Process process2 = process3.getParentProcess();
                preparedStatement.setString(1, process3.getObjectID());
                preparedStatement.setString(2, string2);
                preparedStatement.setString(3, process3.getName());
                preparedStatement.setString(4, dataFlowDesign.getObjectID());
                preparedStatement.setString(5, object);
                preparedStatement.setString(6, !"".equals(dataFlowDesign.getName()) ? dataFlowDesign.getName() : dataFlowDesign.getObjectTypeName());
                if (transformationTask != null) {
                    preparedStatement.setString(7, transformationTask.getObjectID());
                    preparedStatement.setString(8, RSProcesses.getOrCreateOVID(map, transformationTask.getObjectID()));
                    preparedStatement.setString(9, transformationTask.getName());
                } else {
                    preparedStatement.setString(7, null);
                    preparedStatement.setString(8, null);
                    preparedStatement.setString(9, null);
                }
                if (process2 != null) {
                    preparedStatement.setString(10, process2.getObjectID());
                    preparedStatement.setString(11, RSProcesses.getOrCreateOVID(map, process2.getObjectID()));
                    preparedStatement.setString(12, process2.getName());
                } else {
                    preparedStatement.setString(10, null);
                    preparedStatement.setString(11, null);
                    preparedStatement.setString(12, null);
                }
                preparedStatement.setString(13, process3.getProcessNumber());
                if (process3.getType() == 2) {
                    preparedStatement.setString(14, "Use Transformation Task");
                } else if (process3.getType() == 1) {
                    preparedStatement.setString(14, "Composite");
                } else {
                    preparedStatement.setString(14, "Primitive");
                }
                preparedStatement.setString(15, process3.getMode());
                preparedStatement.setString(16, process3.getPriority());
                preparedStatement.setInt(17, process3.getFrequencyTimes());
                preparedStatement.setString(18, process3.getFrequencyTimeUnit());
                preparedStatement.setString(19, process3.getPeakPeriodsString());
                preparedStatement.setString(20, process3.getParamsWrappersString());
                preparedStatement.setInt(21, process3.getInteractiveLongestResponseTime());
                preparedStatement.setString(22, process3.getInteractiveResponseTimeUnit());
                preparedStatement.setInt(23, process3.getBatchMinimumTransactions());
                preparedStatement.setString(24, process3.getBatchTimeUnit());
                preparedStatement.setString(25, (String)map.get(design.getObjectID()));
                preparedStatement.addBatch();
                arrayList.add(process3);
                if (++n != 1000) continue;
                n = 0;
                preparedStatement.executeBatch();
                for (Process process3 : arrayList) {
                    RSObjectNotes.export(map, connection, process3);
                    RSComments.export(map, connection, process3);
                    RSFootnotes.export(map, connection, process3);
                    RSSourceTargetMappings.export(map, connection, process3);
                    RSDynamicProperties.export(design, map, connection, process3);
                }
                arrayList.clear();
            }
        }
        if (n > 0) {
            n = 0;
            preparedStatement.executeBatch();
            for (Process process : arrayList) {
                RSObjectNotes.export(map, connection, process);
                RSComments.export(map, connection, process);
                RSFootnotes.export(map, connection, process);
                RSSourceTargetMappings.export(map, connection, process);
                RSDynamicProperties.export(design, map, connection, process);
            }
            arrayList.clear();
        }
        preparedStatement.close();
        preparedStatement = null;
    }
}

