/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.util.Map;
import oracle.dbtools.crest.exports.Messages;
import oracle.dbtools.crest.exports.reports.RSEvents;
import oracle.dbtools.crest.exports.reports.RSExternalAgents;
import oracle.dbtools.crest.exports.reports.RSExternalDatas;
import oracle.dbtools.crest.exports.reports.RSFlows;
import oracle.dbtools.crest.exports.reports.RSInfoStores;
import oracle.dbtools.crest.exports.reports.RSInfoStructures;
import oracle.dbtools.crest.exports.reports.RSModel;
import oracle.dbtools.crest.exports.reports.RSProcessAttributes;
import oracle.dbtools.crest.exports.reports.RSProcessEntities;
import oracle.dbtools.crest.exports.reports.RSProcesses;
import oracle.dbtools.crest.exports.reports.RSRecordStructures;
import oracle.dbtools.crest.exports.reports.RSRoles;
import oracle.dbtools.crest.exports.reports.RSTransformationPackages;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.process.ProcessModel;
import oracle.dbtools.crest.swingui.ProgressDialog;
import oracle.dbtools.crest.util.GUID;

public class RSProcessModel
extends RSModel {
    public static void export(Design design, Map map, Connection connection, ProgressDialog progressDialog) throws Exception {
        ProcessModel processModel = design.getProcessModel();
        String string = new GUID().toString();
        map.put(processModel.getObjectID(), string);
        RSProcessModel.export(processModel, map, connection, "Process", null);
        progressDialog.setNote(Messages.getString("RSProcessModel.ExportingProcessEntities"));
        RSProcessEntities.export(design, map, connection);
        progressDialog.setNote(Messages.getString("RSProcessModel.ExportingProcessAttributes"));
        RSProcessAttributes.export(design, map, connection);
        progressDialog.setNote(Messages.getString("RSProcessModel.ExportingInformationStructures"));
        RSInfoStructures.export(design, map, connection);
        progressDialog.setNote(Messages.getString("RSProcessModel.ExportingEvents"));
        RSEvents.export(design, map, connection);
        progressDialog.setNote(Messages.getString("RSProcessModel.ExportingInformationStores"));
        RSInfoStores.export(design, map, connection);
        progressDialog.setNote(Messages.getString("RSProcessModel.ExportingExternalDatas"));
        RSExternalDatas.export(design, map, connection);
        progressDialog.setNote(Messages.getString("RSProcessModel.ExportingRecordStructures"));
        RSRecordStructures.export(design, map, connection);
        progressDialog.setNote(Messages.getString("RSProcessModel.ExportingProcesses"));
        RSProcesses.export(design, map, connection);
        progressDialog.setNote(Messages.getString("RSProcessModel.ExportingFlows"));
        RSFlows.export(design, map, connection);
        progressDialog.setNote(Messages.getString("RSProcessModel.ExportingExternalAgents"));
        RSExternalAgents.export(design, map, connection);
        progressDialog.setNote(Messages.getString("RSProcessModel.ExportingTransformations"));
        RSTransformationPackages.export(design, map, connection);
        progressDialog.setNote(Messages.getString("RSProcessModel.ExportingRoles"));
        RSRoles.export(design, map, connection);
    }
}

