/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.Iterator;
import java.util.Map;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.process.DataFlowDesign;
import oracle.dbtools.crest.model.design.process.Process;
import oracle.dbtools.crest.model.design.process.ProcessModel;

public class RSProcessAttributes
extends RSGeneral {
    public static void export(Design design, Map map, Connection connection) throws Exception {
        int n = 0;
        String string = "INSERT INTO DMRS_PROCESS_ATTRIBUTES (Process_ID, Process_OVID, Entity_ID, Entity_OVID, Flow_ID, Flow_OVID, DFD_ID, DFD_OVID, Process_Name, Entity_Name, Flow_Name, DFD_Name, OP_Read, OP_Create, OP_Update, OP_Delete, CRUD_Code, Flow_Direction, Attribute_ID, Attribute_OVID, Attribute_Name, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement preparedStatement = connection.prepareStatement(string);
        ProcessModel processModel = design.getProcessModel();
        Iterator iterator = processModel.getDataFlowDesigns().iterator();
        while (iterator.hasNext()) {
            DataFlowDesign dataFlowDesign = (DataFlowDesign)iterator.next();
            String string2 = RSProcessAttributes.getOrCreateOVID(map, dataFlowDesign.getObjectID());
            String string3 = dataFlowDesign.getTopLevelDataFlowDesign().getName();
            Iterator iterator2 = dataFlowDesign.getProcessSet().iterator();
            while (iterator2.hasNext()) {
                Process process = (Process)iterator2.next();
                String string4 = RSProcessAttributes.getOrCreateOVID(map, process.getObjectID());
                if (process.getType() != 0) continue;
                for (Process.ProcessedObject processedObject : process.getProcessedAttributesAndFlows(false)) {
                    Attribute attribute = (Attribute)processedObject.getObject();
                    preparedStatement.setString(1, process.getObjectID());
                    preparedStatement.setString(2, string4);
                    preparedStatement.setString(3, attribute.getContainer().getObjectID());
                    preparedStatement.setString(4, (String)map.get(attribute.getContainer().getObjectID()));
                    preparedStatement.setString(5, processedObject.getFlow().getObjectID());
                    preparedStatement.setString(6, RSProcessAttributes.getOrCreateOVID(map, processedObject.getFlow().getObjectID()));
                    preparedStatement.setString(7, dataFlowDesign.getObjectID());
                    preparedStatement.setString(8, string2);
                    preparedStatement.setString(9, process.getName());
                    preparedStatement.setString(10, attribute.getContainer().getName());
                    preparedStatement.setString(11, processedObject.getFlow().getName());
                    preparedStatement.setString(12, string3);
                    preparedStatement.setString(13, processedObject.isOpRead() ? "Y" : "N");
                    preparedStatement.setString(14, processedObject.isOpCreate() ? "Y" : "N");
                    preparedStatement.setString(15, processedObject.isOpUpdate() ? "Y" : "N");
                    preparedStatement.setString(16, processedObject.isOpDelete() ? "Y" : "N");
                    if (processedObject.isOpRead()) {
                        preparedStatement.setString(17, "R");
                    } else {
                        String string5 = "";
                        if (processedObject.isOpCreate()) {
                            string5 = "C";
                        }
                        if (processedObject.isOpUpdate()) {
                            string5 = string5 + "U";
                        }
                        if (processedObject.isOpDelete()) {
                            string5 = string5 + "D";
                        }
                        preparedStatement.setString(17, string5);
                    }
                    preparedStatement.setString(18, processedObject.isInbound() ? "IN" : "OUT");
                    preparedStatement.setString(19, attribute.getObjectID());
                    preparedStatement.setString(20, (String)map.get(attribute.getObjectID()));
                    preparedStatement.setString(21, attribute.getName());
                    preparedStatement.setString(22, (String)map.get(design.getObjectID()));
                    preparedStatement.addBatch();
                    if (++n != 1000) continue;
                    n = 0;
                    preparedStatement.executeBatch();
                }
            }
        }
        if (n > 0) {
            n = 0;
            preparedStatement.executeBatch();
        }
        preparedStatement.close();
        preparedStatement = null;
    }
}

