/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.Map;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.relational.Table;

public class RSPKOidColumns
extends RSGeneral {
    public static void export(Map map, Connection connection, Table table) throws Exception {
        int n = 0;
        String string = "INSERT INTO DMRS_PK_OID_COLUMNS (Column_ID, Column_OVID, Table_ID, Table_OVID, Table_Name, Column_Name,Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement preparedStatement = connection.prepareStatement(string);
        for (ContainedObject containedObject : table.getOidPKColumns()) {
            String string2 = RSPKOidColumns.getOrCreateOVID(map, containedObject.getObjectID());
            preparedStatement.setString(1, containedObject.getObjectID());
            preparedStatement.setString(2, string2);
            preparedStatement.setString(3, table.getObjectID());
            preparedStatement.setString(4, (String)map.get(table.getObjectID()));
            preparedStatement.setString(5, table.getName());
            preparedStatement.setString(6, containedObject.getName());
            preparedStatement.setString(7, (String)map.get(table.getDesign().getObjectID()));
            preparedStatement.addBatch();
            if (++n != 1000) continue;
            n = 0;
            preparedStatement.executeBatch();
        }
        if (n > 0) {
            n = 0;
            preparedStatement.executeBatch();
        }
        preparedStatement.close();
        preparedStatement = null;
    }
}

