/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.imports.MappingDatatypeNameLogicalDataType;
import oracle.dbtools.crest.model.LongNameObject;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.datatype.StandardDatatypeNames;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.storage.RDBMSType;
import oracle.dbtools.crest.util.GUID;

public class RSLogicalTypes
extends RSGeneral {
    public static void export(Design design, Map map, Connection connection) throws Exception {
        Object object;
        Object object2;
        Object object3;
        String[] stringArray;
        LongNameObject longNameObject;
        ArrayList arrayList = new ArrayList(1000);
        int n = 0;
        String string = (String)map.get(design.getObjectID());
        String string2 = "INSERT INTO DMRS_LOGICAL_TYPES (Design_ID, Design_OVID, Design_Name, Logical_Type_ID, OVID, LT_Name) VALUES (?, ?, ?, ?, ?, ?)";
        PreparedStatement preparedStatement = connection.prepareStatement(string2);
        Iterator iterator = design.getLogicalDatatypeSet().iterator();
        while (iterator.hasNext()) {
            longNameObject = (LogicalDatatype)iterator.next();
            stringArray = new GUID().toString();
            map.put(((ModelIDObject)longNameObject).getObjectID(), stringArray);
            preparedStatement.setString(1, design.getObjectID());
            preparedStatement.setString(2, string);
            preparedStatement.setString(3, design.getName());
            preparedStatement.setString(4, ((ModelIDObject)longNameObject).getObjectID());
            preparedStatement.setString(5, (String)stringArray);
            preparedStatement.setString(6, ((DesignObject)longNameObject).getName());
            preparedStatement.addBatch();
            if (++n != 1000) continue;
            n = 0;
            preparedStatement.executeBatch();
        }
        if (n > 0) {
            n = 0;
            preparedStatement.executeBatch();
        }
        preparedStatement.close();
        preparedStatement = null;
        string2 = "INSERT INTO DMRS_LOGICAL_TO_NATIVE (Design_ID, Design_OVID, Design_Name, Logical_Type_ID, Logical_Type_OVID, LT_Name, Native_Type, RDBMS_Type, RDBMS_Version, Has_Size, Has_Precision, Has_Scale) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        preparedStatement = connection.prepareStatement(string2);
        iterator = design.getLogicalDatatypeSet().iterator();
        while (iterator.hasNext()) {
            longNameObject = (LogicalDatatype)iterator.next();
            stringArray = (String)map.get(((ModelIDObject)longNameObject).getObjectID());
            Map map2 = ((LogicalDatatype)longNameObject).getToPhysical();
            object3 = design.getDefaultRDBMSTypeSet().iterator();
            while (object3.hasNext()) {
                object2 = (RDBMSType)object3.next();
                object = ((LogicalDatatype)longNameObject).createDataType(((RDBMSType)object2).getName(), map2);
                if (object == null) continue;
                preparedStatement.setString(1, design.getObjectID());
                preparedStatement.setString(2, string);
                preparedStatement.setString(3, design.getName());
                preparedStatement.setString(4, ((ModelIDObject)longNameObject).getObjectID());
                preparedStatement.setString(5, (String)stringArray);
                preparedStatement.setString(6, ((DesignObject)longNameObject).getName());
                preparedStatement.setString(7, object.getName());
                preparedStatement.setString(8, ((RDBMSType)object2).getProductName());
                preparedStatement.setString(9, ((RDBMSType)object2).getVersionName());
                preparedStatement.setString(10, object.hasSize() && RSLogicalTypes.hasSize(object.getSize()) ? "Y" : "N");
                preparedStatement.setString(11, object.hasPrecision() && object.getPrecision() > 0 ? "Y" : "N");
                preparedStatement.setString(12, object.hasScale() && object.getScale() > 0 ? "Y" : "N");
                preparedStatement.addBatch();
                if (++n != 1000) continue;
                n = 0;
                preparedStatement.executeBatch();
            }
        }
        if (n > 0) {
            n = 0;
            preparedStatement.executeBatch();
        }
        preparedStatement.close();
        preparedStatement = null;
        string2 = "INSERT INTO DMRS_NATIVE_TO_LOGICAL (RDBMS_Type, RDBMS_Version, Native_Type, LT_Name, Logical_Type_ID, Logical_Type_OVID, Design_ID, Design_OVID, Design_Name) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";
        preparedStatement = connection.prepareStatement(string2);
        iterator = design.getDefaultRDBMSTypeSet().iterator();
        while (iterator.hasNext()) {
            longNameObject = (RDBMSType)iterator.next();
            stringArray = StandardDatatypeNames.getAllPossibleDatatypes((RDBMSType)longNameObject);
            for (int i = 0; i < stringArray.length; ++i) {
                object3 = stringArray[i];
                if (((String)object3).equalsIgnoreCase("UNKNOWN")) continue;
                object2 = StandardDatatypeNames.getUsedDatatypeName((String)object3);
                if (!((String)object3).equals(object2 = StandardDatatypeNames.getTransformedDatatypeName((String)object2, (RDBMSType)longNameObject))) continue;
                object = MappingDatatypeNameLogicalDataType.getLogicalDatatype((RDBMSType)longNameObject, (String)object2);
                if (object == null) {
                    object = MappingDatatypeNameLogicalDataType.getLogicalDatatype((RDBMSType)longNameObject, (String)object3);
                }
                if (object == null) continue;
                preparedStatement.setString(1, ((RDBMSType)longNameObject).getProductName());
                preparedStatement.setString(2, ((RDBMSType)longNameObject).getVersionName());
                preparedStatement.setString(3, (String)object3);
                preparedStatement.setString(4, ((DesignObject)object).getName());
                preparedStatement.setString(5, ((ModelIDObject)object).getObjectID());
                preparedStatement.setString(6, (String)map.get(((ModelIDObject)object).getObjectID()));
                preparedStatement.setString(7, design.getObjectID());
                preparedStatement.setString(8, string);
                preparedStatement.setString(9, design.getName());
                preparedStatement.addBatch();
                if (++n != 1000) continue;
                n = 0;
                preparedStatement.executeBatch();
            }
        }
        if (n > 0) {
            n = 0;
            preparedStatement.executeBatch();
        }
        preparedStatement.close();
        preparedStatement = null;
    }

    private static boolean hasSize(String string) {
        if (string != null && !"".equalsIgnoreCase(string)) {
            return !"0".equalsIgnoreCase(string);
        }
        return false;
    }
}

