/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.exports.reports.RSComments;
import oracle.dbtools.crest.exports.reports.RSDynamicProperties;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.exports.reports.RSObjectNotes;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.multidimensional.CalculatedAttribute;
import oracle.dbtools.crest.model.design.multidimensional.Level;
import oracle.dbtools.crest.model.design.multidimensional.MultidimensionalDesign;
import oracle.dbtools.crest.model.design.multidimensional.SlowChangingAttribute;
import oracle.dbtools.crest.model.design.relational.Column;

public class RSLevels
extends RSGeneral {
    public static void export(Design design, Map map, Connection connection) throws Exception {
        ArrayList<Level> arrayList = new ArrayList<Level>(1000);
        int n = 0;
        ArrayList<Level> arrayList2 = new ArrayList<Level>();
        String string = "INSERT INTO DMRS_LEVELS (Level_ID, Level_Name, Level_OVID, Model_ID, Model_Name, Model_OVID, Entity_ID, Entity_Name, Entity_OVID, Name_Column_ID, Name_Column_Name, Name_Column_OVID, Value_Column_ID, Value_Column_Name, Value_Column_OVID, Oracle_Long_Name, Oracle_Plural_Name, Oracle_Short_Name, Root_Identification, Identification_Value, Selection_Criteria, Selection_Criteria_Description, Is_Value_Based_Hierarchy, Description, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement preparedStatement = connection.prepareStatement(string);
        Iterator iterator = design.getMultidimensionalDesigns().iterator();
        while (iterator.hasNext()) {
            MultidimensionalDesign multidimensionalDesign = (MultidimensionalDesign)iterator.next();
            String object = (String)map.get(multidimensionalDesign.getObjectID());
            String string2 = (String)map.get(multidimensionalDesign.getDesign().getObjectID());
            arrayList2.clear();
            Iterator iterator2 = multidimensionalDesign.getLevelSet().iterator();
            while (iterator2.hasNext()) {
                Level level2 = (Level)iterator2.next();
                String string3 = RSLevels.getOrCreateOVID(map, level2.getObjectID());
                arrayList2.add(level2);
                ContainerObject containerObject = level2.getLevelEntity();
                ContainedObject containedObject = level2.getNameColumn();
                ContainedObject containedObject2 = level2.getValueColumn();
                preparedStatement.setString(1, level2.getObjectID());
                preparedStatement.setString(2, level2.getName());
                preparedStatement.setString(3, string3);
                preparedStatement.setString(4, multidimensionalDesign.getObjectID());
                preparedStatement.setString(5, multidimensionalDesign.getName());
                preparedStatement.setString(6, object);
                if (containerObject != null && containerObject instanceof Entity) {
                    preparedStatement.setString(7, containerObject.getObjectID());
                    preparedStatement.setString(8, containerObject.getName());
                    preparedStatement.setString(9, RSLevels.getOrCreateOVID(map, containerObject.getObjectID()));
                } else {
                    preparedStatement.setString(7, null);
                    preparedStatement.setString(8, null);
                    preparedStatement.setString(9, null);
                }
                if (containedObject != null && containedObject instanceof Column) {
                    preparedStatement.setString(10, containedObject.getObjectID());
                    preparedStatement.setString(11, containedObject.getName());
                    preparedStatement.setString(12, RSLevels.getOrCreateOVID(map, containedObject.getObjectID()));
                } else {
                    preparedStatement.setString(10, null);
                    preparedStatement.setString(11, null);
                    preparedStatement.setString(12, null);
                }
                if (containedObject2 != null && containedObject2 instanceof Column) {
                    preparedStatement.setString(13, containedObject2.getObjectID());
                    preparedStatement.setString(14, containedObject2.getName());
                    preparedStatement.setString(15, RSLevels.getOrCreateOVID(map, containedObject2.getObjectID()));
                } else {
                    preparedStatement.setString(13, null);
                    preparedStatement.setString(14, null);
                    preparedStatement.setString(15, null);
                }
                preparedStatement.setString(16, level2.getOracleLongName());
                preparedStatement.setString(17, level2.getOraclePluralName());
                preparedStatement.setString(18, level2.getOracleShortName());
                preparedStatement.setString(19, level2.getRootIdentification());
                preparedStatement.setString(20, level2.getIdentificationValue());
                preparedStatement.setString(21, level2.getSelectionCriteria());
                preparedStatement.setString(22, level2.getSelectionCriteriaDescription());
                preparedStatement.setString(23, level2.isValueBasedHierarchy() ? "Y" : "N");
                preparedStatement.setString(24, level2.getDescription());
                preparedStatement.setString(25, string2);
                preparedStatement.addBatch();
                arrayList.add(level2);
                if (++n != 1000) continue;
                n = 0;
                preparedStatement.executeBatch();
                for (Level level2 : arrayList) {
                    RSObjectNotes.export(map, connection, level2);
                    RSComments.export(map, connection, level2);
                    RSDynamicProperties.export(design, map, connection, level2);
                }
                arrayList.clear();
            }
            RSLevels.exportAttributes(map, connection, arrayList2, string2);
        }
        if (n > 0) {
            n = 0;
            preparedStatement.executeBatch();
            for (Level level : arrayList) {
                RSObjectNotes.export(map, connection, level);
                RSComments.export(map, connection, level);
                RSDynamicProperties.export(design, map, connection, level);
            }
            arrayList.clear();
        }
        preparedStatement.close();
        preparedStatement = null;
    }

    private static void exportAttributes(Map map, Connection connection, List list, String string) throws Exception {
        String string2 = "INSERT INTO DMRS_LEVEL_ATTRS (Level_ID, Level_Name, Level_OVID, Attribute_ID, Attribute_Name, Attribute_OVID, Is_Default_Attr, Is_Level_Key_Attr, Is_Parent_Key_Attr, Is_Descriptive_Key_Attr, Is_Calculated_Attr, Descriptive_Name, Descriptive_Is_Indexed, Descriptive_Slow_Changing, Calculated_Expr, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement preparedStatement = connection.prepareStatement(string2);
        String string3 = "UPDATE DMRS_LEVEL_ATTRS SET Is_Level_Key_Attr = 'Y' WHERE Level_OVID = ? AND Attribute_OVID = ? ";
        PreparedStatement preparedStatement2 = connection.prepareStatement(string3);
        String string4 = "UPDATE DMRS_LEVEL_ATTRS SET Is_Parent_Key_Attr = 'Y' WHERE Level_OVID = ? AND Attribute_OVID = ? ";
        PreparedStatement preparedStatement3 = connection.prepareStatement(string4);
        String string5 = "UPDATE DMRS_LEVEL_ATTRS SET Is_Descriptive_Key_Attr = 'Y', Descriptive_Name = ?, Descriptive_Is_Indexed = ?, Descriptive_Slow_Changing = ? WHERE Level_OVID = ? AND Attribute_OVID = ? ";
        PreparedStatement preparedStatement4 = connection.prepareStatement(string5);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Level level : list) {
            String string6;
            Object object;
            Object object22;
            Object object3;
            Object object42;
            String string7 = (String)map.get(level.getObjectID());
            DesignObject designObject = level.getDefaultAttribute();
            if (designObject != null && designObject instanceof Attribute) {
                String string8 = (String)map.get(designObject.getObjectID());
                preparedStatement.setString(1, level.getObjectID());
                preparedStatement.setString(2, level.getName());
                preparedStatement.setString(3, string7);
                preparedStatement.setString(4, designObject.getObjectID());
                preparedStatement.setString(5, designObject.getName());
                preparedStatement.setString(6, string8);
                preparedStatement.setString(7, "Y");
                preparedStatement.setString(8, "N");
                preparedStatement.setString(9, "N");
                preparedStatement.setString(10, "N");
                preparedStatement.setString(11, "N");
                preparedStatement.setString(12, null);
                preparedStatement.setString(13, null);
                preparedStatement.setString(14, null);
                preparedStatement.setString(15, null);
                preparedStatement.setString(16, string);
                preparedStatement.executeUpdate();
            }
            for (Object object42 : level.getLevelKey()) {
                if (!(object42 instanceof Attribute)) continue;
                object3 = (String)map.get(((ModelIDObject)object42).getObjectID());
                object22 = string7 + (String)object3;
                if (arrayList.contains(object22)) {
                    preparedStatement2.setString(1, string7);
                    preparedStatement2.setString(2, (String)object3);
                    preparedStatement2.executeUpdate();
                    continue;
                }
                preparedStatement.setString(1, level.getObjectID());
                preparedStatement.setString(2, level.getName());
                preparedStatement.setString(3, string7);
                preparedStatement.setString(4, ((ModelIDObject)object42).getObjectID());
                preparedStatement.setString(5, ((ContainedObject)object42).getName());
                preparedStatement.setString(6, (String)object3);
                preparedStatement.setString(7, "N");
                preparedStatement.setString(8, "Y");
                preparedStatement.setString(9, "N");
                preparedStatement.setString(10, "N");
                preparedStatement.setString(11, "N");
                preparedStatement.setString(12, null);
                preparedStatement.setString(13, null);
                preparedStatement.setString(14, null);
                preparedStatement.setString(15, null);
                preparedStatement.setString(16, string);
                preparedStatement.executeUpdate();
                arrayList.add(object22);
            }
            object42 = level.getParentKey().iterator();
            while (object42.hasNext()) {
                object3 = (ContainedObject)object42.next();
                if (!(object3 instanceof Attribute)) continue;
                object22 = (String)map.get(((ModelIDObject)object3).getObjectID());
                object = string7 + (String)object22;
                if (arrayList.contains(object)) {
                    preparedStatement3.setString(1, string7);
                    preparedStatement3.setString(2, (String)object22);
                    preparedStatement3.executeUpdate();
                    continue;
                }
                preparedStatement.setString(1, level.getObjectID());
                preparedStatement.setString(2, level.getName());
                preparedStatement.setString(3, string7);
                preparedStatement.setString(4, ((ModelIDObject)object3).getObjectID());
                preparedStatement.setString(5, ((ContainedObject)object3).getName());
                preparedStatement.setString(6, (String)object22);
                preparedStatement.setString(7, "N");
                preparedStatement.setString(8, "N");
                preparedStatement.setString(9, "Y");
                preparedStatement.setString(10, "N");
                preparedStatement.setString(11, "N");
                preparedStatement.setString(12, null);
                preparedStatement.setString(13, null);
                preparedStatement.setString(14, null);
                preparedStatement.setString(15, null);
                preparedStatement.setString(16, string);
                preparedStatement.executeUpdate();
                arrayList.add(object);
            }
            for (Object object22 : level.getSlowChangingAttributes()) {
                object = ((SlowChangingAttribute)object22).getAttribute();
                if (!(object instanceof Attribute)) continue;
                string6 = (String)map.get(((ModelIDObject)object).getObjectID());
                String string9 = string7 + string6;
                if (arrayList.contains(string9)) {
                    preparedStatement4.setString(1, ((SlowChangingAttribute)object22).getName());
                    preparedStatement4.setString(2, ((SlowChangingAttribute)object22).isIndexed() ? "Y" : "N");
                    preparedStatement4.setString(3, ((SlowChangingAttribute)object22).getType());
                    preparedStatement4.setString(4, string7);
                    preparedStatement4.setString(5, string6);
                    preparedStatement4.executeUpdate();
                    continue;
                }
                preparedStatement.setString(1, level.getObjectID());
                preparedStatement.setString(2, level.getName());
                preparedStatement.setString(3, string7);
                preparedStatement.setString(4, ((ModelIDObject)object).getObjectID());
                preparedStatement.setString(5, ((ContainedObject)object).getName());
                preparedStatement.setString(6, string6);
                preparedStatement.setString(7, "N");
                preparedStatement.setString(8, "N");
                preparedStatement.setString(9, "N");
                preparedStatement.setString(10, "Y");
                preparedStatement.setString(11, "N");
                preparedStatement.setString(12, ((SlowChangingAttribute)object22).getName());
                preparedStatement.setString(13, ((SlowChangingAttribute)object22).isIndexed() ? "Y" : "N");
                preparedStatement.setString(14, ((SlowChangingAttribute)object22).getType());
                preparedStatement.setString(15, null);
                preparedStatement.setString(16, string);
                preparedStatement.executeUpdate();
                arrayList.add(string9);
            }
            object22 = level.getCalculatedAttributes().iterator();
            while (object22.hasNext()) {
                object = (CalculatedAttribute)object22.next();
                string6 = RSLevels.getOrCreateOVID(map, ((ModelIDObject)object).getObjectID());
                preparedStatement.setString(1, level.getObjectID());
                preparedStatement.setString(2, level.getName());
                preparedStatement.setString(3, string7);
                preparedStatement.setString(4, ((ModelIDObject)object).getObjectID());
                preparedStatement.setString(5, ((DesignObject)object).getName());
                preparedStatement.setString(6, string6);
                preparedStatement.setString(7, "N");
                preparedStatement.setString(8, "N");
                preparedStatement.setString(9, "N");
                preparedStatement.setString(10, "N");
                preparedStatement.setString(11, "Y");
                preparedStatement.setString(12, null);
                preparedStatement.setString(13, null);
                preparedStatement.setString(14, null);
                preparedStatement.setString(15, ((CalculatedAttribute)object).getFunction());
                preparedStatement.setString(16, string);
                preparedStatement.executeUpdate();
            }
        }
        preparedStatement4.close();
        preparedStatement4 = null;
        preparedStatement3.close();
        preparedStatement3 = null;
        preparedStatement2.close();
        preparedStatement2 = null;
        preparedStatement.close();
        preparedStatement = null;
    }
}

