/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import oracle.dbtools.crest.exports.reports.RSComments;
import oracle.dbtools.crest.exports.reports.RSDynamicProperties;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.exports.reports.RSObjectNotes;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.process.InfoStructure;
import oracle.dbtools.crest.model.design.process.ProcessModel;

public class RSInfoStructures
extends RSGeneral {
    public static void export(Design design, Map map, Connection connection) throws Exception {
        String string = "INSERT INTO DMRS_INFO_STRUCTURES (Info_Structure_ID, Info_Structure_OVID, Info_Structure_Name, Model_ID, Model_OVID, Model_Name, Growth_Rate_Unit, Growth_Rate_Percent, Volume, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement preparedStatement = connection.prepareStatement(string);
        ArrayList<Object> arrayList = new ArrayList<Object>(1000);
        int n = 0;
        ProcessModel processModel = design.getProcessModel();
        Iterator iterator = processModel.getInfoStructureSet().iterator();
        while (iterator.hasNext()) {
            Object object3 = (InfoStructure)iterator.next();
            Object object2 = RSInfoStructures.getOrCreateOVID(map, ((ModelIDObject)object3).getObjectID());
            preparedStatement.setString(1, ((ModelIDObject)object3).getObjectID());
            preparedStatement.setString(2, (String)object2);
            preparedStatement.setString(3, ((DesignObject)object3).getName());
            preparedStatement.setString(4, processModel.getObjectID());
            preparedStatement.setString(5, (String)map.get(processModel.getObjectID()));
            preparedStatement.setString(6, processModel.getName());
            preparedStatement.setString(7, ((InfoStructure)object3).getGrowthRateUnit());
            preparedStatement.setInt(8, ((InfoStructure)object3).getGrowthRatePercent());
            preparedStatement.setInt(9, ((InfoStructure)object3).getVolume());
            preparedStatement.setString(10, (String)map.get(design.getObjectID()));
            preparedStatement.addBatch();
            arrayList.add(object3);
            if (++n != 1000) continue;
            n = 0;
            preparedStatement.executeBatch();
            for (Object object3 : arrayList) {
                RSObjectNotes.export(map, connection, (ModelIDObject)object3);
                RSComments.export(map, connection, (ModelIDObject)object3);
                RSDynamicProperties.export(design, map, connection, (ModelIDObject)object3);
            }
            arrayList.clear();
        }
        if (n > 0) {
            n = 0;
            preparedStatement.executeBatch();
            for (Object object2 : arrayList) {
                RSObjectNotes.export(map, connection, (ModelIDObject)object2);
                RSComments.export(map, connection, (ModelIDObject)object2);
                RSDynamicProperties.export(design, map, connection, (ModelIDObject)object2);
            }
            arrayList.clear();
        }
        preparedStatement.close();
        preparedStatement = null;
    }
}

