/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.exports.reports.RSComments;
import oracle.dbtools.crest.exports.reports.RSDynamicProperties;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.exports.reports.RSObjectNotes;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.multidimensional.Dimension;
import oracle.dbtools.crest.model.design.multidimensional.Hierarchy;
import oracle.dbtools.crest.model.design.multidimensional.Level;
import oracle.dbtools.crest.model.design.multidimensional.MultidimensionalDesign;
import oracle.dbtools.crest.model.design.multidimensional.RollupLink;

public class RSHierarchies
extends RSGeneral {
    public static void export(Design design, Map map, Connection connection) throws Exception {
        ArrayList<Hierarchy> arrayList = new ArrayList<Hierarchy>(1000);
        int n = 0;
        ArrayList<Hierarchy> arrayList2 = new ArrayList<Hierarchy>();
        String string = "INSERT INTO DMRS_HIERARCHIES (Hierarchy_ID, Hierarchy_Name, Hierarchy_OVID, Model_ID, Model_Name, Model_OVID, Dimension_ID, Dimension_Name, Dimension_OVID, Oracle_Long_Name, Oracle_Plural_Name, Oracle_Short_Name, Is_Default_Hierarchy, Is_Ragged_Hierarchy, Is_Value_Based_Hierarchy, Description, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement preparedStatement = connection.prepareStatement(string);
        Iterator iterator = design.getMultidimensionalDesigns().iterator();
        while (iterator.hasNext()) {
            MultidimensionalDesign multidimensionalDesign = (MultidimensionalDesign)iterator.next();
            String object = (String)map.get(multidimensionalDesign.getObjectID());
            String string2 = (String)map.get(multidimensionalDesign.getDesign().getObjectID());
            arrayList2.clear();
            Iterator iterator2 = multidimensionalDesign.getHierarchySet().iterator();
            while (iterator2.hasNext()) {
                Hierarchy hierarchy2 = (Hierarchy)iterator2.next();
                String string3 = RSHierarchies.getOrCreateOVID(map, hierarchy2.getObjectID());
                arrayList2.add(hierarchy2);
                Dimension dimension = hierarchy2.getDimension();
                preparedStatement.setString(1, hierarchy2.getObjectID());
                preparedStatement.setString(2, hierarchy2.getName());
                preparedStatement.setString(3, string3);
                preparedStatement.setString(4, multidimensionalDesign.getObjectID());
                preparedStatement.setString(5, multidimensionalDesign.getName());
                preparedStatement.setString(6, object);
                if (dimension != null) {
                    preparedStatement.setString(7, dimension.getObjectID());
                    preparedStatement.setString(8, dimension.getName());
                    preparedStatement.setString(9, RSHierarchies.getOrCreateOVID(map, dimension.getObjectID()));
                } else {
                    preparedStatement.setString(7, null);
                    preparedStatement.setString(8, null);
                    preparedStatement.setString(9, null);
                }
                preparedStatement.setString(10, hierarchy2.getOracleLongName());
                preparedStatement.setString(11, hierarchy2.getOraclePluralName());
                preparedStatement.setString(12, hierarchy2.getOracleShortName());
                preparedStatement.setString(13, hierarchy2.isDefaultHierarchy() ? "Y" : "N");
                preparedStatement.setString(14, hierarchy2.isRaggedHierarchy() ? "Y" : "N");
                preparedStatement.setString(15, hierarchy2.isValueBasedHierarchy() ? "Y" : "N");
                preparedStatement.setString(16, hierarchy2.getDescription());
                preparedStatement.setString(17, string2);
                preparedStatement.addBatch();
                arrayList.add(hierarchy2);
                if (++n != 1000) continue;
                n = 0;
                preparedStatement.executeBatch();
                for (Hierarchy hierarchy2 : arrayList) {
                    RSObjectNotes.export(map, connection, hierarchy2);
                    RSComments.export(map, connection, hierarchy2);
                    RSDynamicProperties.export(design, map, connection, hierarchy2);
                }
                arrayList.clear();
            }
            RSHierarchies.exportLevels(map, connection, arrayList2, string2);
            RSHierarchies.exportRollupLinks(map, connection, arrayList2, string2);
        }
        if (n > 0) {
            n = 0;
            preparedStatement.executeBatch();
            for (Hierarchy hierarchy : arrayList) {
                RSObjectNotes.export(map, connection, hierarchy);
                RSComments.export(map, connection, hierarchy);
                RSDynamicProperties.export(design, map, connection, hierarchy);
            }
            arrayList.clear();
        }
        preparedStatement.close();
        preparedStatement = null;
    }

    private static void exportLevels(Map map, Connection connection, List list, String string) throws Exception {
        int n = 0;
        String string2 = "INSERT INTO DMRS_HIERARCHY_LEVELS (Hierarchy_ID, Hierarchy_Name, Hierarchy_OVID, Level_ID, Level_Name, Level_OVID, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement preparedStatement = connection.prepareStatement(string2);
        for (Hierarchy hierarchy : list) {
            for (Level level : hierarchy.getLevels()) {
                String string3 = RSHierarchies.getOrCreateOVID(map, level.getObjectID());
                preparedStatement.setString(1, hierarchy.getObjectID());
                preparedStatement.setString(2, hierarchy.getName());
                preparedStatement.setString(3, (String)map.get(hierarchy.getObjectID()));
                preparedStatement.setString(4, level.getObjectID());
                preparedStatement.setString(5, level.getName());
                preparedStatement.setString(6, string3);
                preparedStatement.setString(7, string);
                preparedStatement.addBatch();
                if (++n != 1000) continue;
                n = 0;
                preparedStatement.executeBatch();
            }
        }
        if (n > 0) {
            n = 0;
            preparedStatement.executeBatch();
        }
        preparedStatement.close();
        preparedStatement = null;
    }

    private static void exportRollupLinks(Map map, Connection connection, List list, String string) throws Exception {
        int n = 0;
        String string2 = "INSERT INTO DMRS_HIERARCHY_ROLLUP_LINKS (Hierarchy_ID, Hierarchy_Name, Hierarchy_OVID, Rollup_Link_ID, Rollup_Link_Name, Rollup_Link_OVID, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement preparedStatement = connection.prepareStatement(string2);
        for (Hierarchy hierarchy : list) {
            for (RollupLink rollupLink : hierarchy.getLinks()) {
                String string3 = RSHierarchies.getOrCreateOVID(map, rollupLink.getObjectID());
                preparedStatement.setString(1, hierarchy.getObjectID());
                preparedStatement.setString(2, hierarchy.getName());
                preparedStatement.setString(3, (String)map.get(hierarchy.getObjectID()));
                preparedStatement.setString(4, rollupLink.getObjectID());
                preparedStatement.setString(5, rollupLink.getName());
                preparedStatement.setString(6, string3);
                preparedStatement.setString(7, string);
                preparedStatement.addBatch();
                if (++n != 1000) continue;
                n = 0;
                preparedStatement.executeBatch();
            }
        }
        if (n > 0) {
            n = 0;
            preparedStatement.executeBatch();
        }
        preparedStatement.close();
        preparedStatement = null;
    }
}

