/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.Map;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.model.design.glossary.Glossary;
import oracle.dbtools.crest.util.GUID;

public class RSGlossary
extends RSGeneral {
    public static void export(Glossary glossary, Map map, Connection connection, String string) throws Exception {
        String string2 = glossary.getId();
        String string3 = new GUID().toString();
        map.put(string2, string3);
        String string4 = "INSERT INTO DMRS_GLOSSARIES (Glossary_ID, Glossary_OVID, Glossary_Name, File_Name, Description, Incomplete_Modifiers, Case_Sensitive, Unique_Abbrevs, Separator_Type, Separator_Char, Date_Published, Published_By, Persistence_Version, Version_Comments) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, sysdate, ?, ?, ?)";
        PreparedStatement preparedStatement = connection.prepareStatement(string4);
        preparedStatement.setString(1, string2);
        preparedStatement.setString(2, string3);
        preparedStatement.setString(3, glossary.getName());
        preparedStatement.setString(4, glossary.getShortFileName());
        if (glossary.getDescription().length() > 4000) {
            preparedStatement.setString(5, glossary.getDescription().substring(0, 4000));
        } else {
            preparedStatement.setString(5, glossary.getDescription());
        }
        preparedStatement.setString(6, glossary.isIncompleteModifiers() ? "Y" : "N");
        preparedStatement.setString(7, glossary.isCaseSensitive() ? "Y" : "N");
        preparedStatement.setString(8, glossary.isUniqueAbbreviations() ? "Y" : "N");
        preparedStatement.setString(9, glossary.getSeparatorType());
        if (glossary.getSeparatorType().equalsIgnoreCase("SPACE")) {
            preparedStatement.setString(10, " ");
        } else {
            preparedStatement.setString(10, String.valueOf(glossary.getMW_SeparatorChar()));
        }
        preparedStatement.setString(11, System.getProperty("user.name"));
        preparedStatement.setFloat(12, 1.6f);
        preparedStatement.setString(13, string);
        preparedStatement.executeUpdate();
        preparedStatement.close();
        preparedStatement = null;
    }
}

