/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.exports.reports.RSComments;
import oracle.dbtools.crest.exports.reports.RSDynamicProperties;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.exports.reports.RSObjectNotes;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.process.AbstractProcessObject;
import oracle.dbtools.crest.model.design.process.DataFlowDesign;
import oracle.dbtools.crest.model.design.process.Event;
import oracle.dbtools.crest.model.design.process.Flow;
import oracle.dbtools.crest.model.design.process.InfoStructure;
import oracle.dbtools.crest.model.design.process.ProcessModel;

public class RSFlows
extends RSGeneral {
    public static void export(Design design, Map map, Connection connection) throws Exception {
        ArrayList<Flow> arrayList = new ArrayList<Flow>(1000);
        int n = 0;
        ArrayList<Flow> arrayList2 = new ArrayList<Flow>();
        String string = "INSERT INTO DMRS_FLOWS (Flow_ID, Flow_OVID, Flow_Name, Diagram_ID, Diagram_OVID, Diagram_Name, Event_ID, Event_OVID, Event_Name, Source_ID, Source_OVID, Source_Name, Destination_ID, Destination_OVID, Destination_Name, Parent_ID, Parent_OVID, Parent_Name, Source_Type, Destination_Type, System_Objective, Logging, Op_Create, Op_Read, Op_Update, Op_Delete, CRUD_Code, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement preparedStatement = connection.prepareStatement(string);
        ProcessModel processModel = design.getProcessModel();
        Iterator iterator = processModel.getDataFlowDesigns().iterator();
        while (iterator.hasNext()) {
            DataFlowDesign dataFlowDesign = (DataFlowDesign)iterator.next();
            String object = RSFlows.getOrCreateOVID(map, dataFlowDesign.getObjectID());
            Iterator iterator2 = dataFlowDesign.getFlowSet().iterator();
            arrayList2.clear();
            while (iterator2.hasNext()) {
                Flow flow2 = (Flow)iterator2.next();
                String string2 = RSFlows.getOrCreateOVID(map, flow2.getObjectID());
                arrayList2.add(flow2);
                Event event = flow2.getEvent();
                AbstractProcessObject abstractProcessObject = flow2.getSource();
                AbstractProcessObject abstractProcessObject2 = flow2.getDestination();
                AbstractProcessObject abstractProcessObject3 = flow2.getParentObject();
                preparedStatement.setString(1, flow2.getObjectID());
                preparedStatement.setString(2, string2);
                preparedStatement.setString(3, flow2.getName());
                preparedStatement.setString(4, dataFlowDesign.getObjectID());
                preparedStatement.setString(5, object);
                preparedStatement.setString(6, !"".equals(dataFlowDesign.getName()) ? dataFlowDesign.getName() : dataFlowDesign.getObjectTypeName());
                if (event != null) {
                    preparedStatement.setString(7, event.getObjectID());
                    preparedStatement.setString(8, RSFlows.getOrCreateOVID(map, event.getObjectID()));
                    preparedStatement.setString(9, event.getName());
                } else {
                    preparedStatement.setString(7, null);
                    preparedStatement.setString(8, null);
                    preparedStatement.setString(9, null);
                }
                if (abstractProcessObject != null) {
                    preparedStatement.setString(10, abstractProcessObject.getObjectID());
                    preparedStatement.setString(11, RSFlows.getOrCreateOVID(map, abstractProcessObject.getObjectID()));
                    preparedStatement.setString(12, abstractProcessObject.getName());
                    preparedStatement.setString(19, abstractProcessObject.getObjectTypeName());
                } else {
                    preparedStatement.setString(10, null);
                    preparedStatement.setString(11, null);
                    preparedStatement.setString(12, null);
                    preparedStatement.setString(19, null);
                }
                if (abstractProcessObject2 != null) {
                    preparedStatement.setString(13, abstractProcessObject2.getObjectID());
                    preparedStatement.setString(14, RSFlows.getOrCreateOVID(map, abstractProcessObject2.getObjectID()));
                    preparedStatement.setString(15, abstractProcessObject2.getName());
                    preparedStatement.setString(20, abstractProcessObject2.getObjectTypeName());
                } else {
                    preparedStatement.setString(13, null);
                    preparedStatement.setString(14, null);
                    preparedStatement.setString(15, null);
                    preparedStatement.setString(20, null);
                }
                if (abstractProcessObject3 != null) {
                    preparedStatement.setString(16, abstractProcessObject3.getObjectID());
                    preparedStatement.setString(17, RSFlows.getOrCreateOVID(map, abstractProcessObject3.getObjectID()));
                    preparedStatement.setString(18, abstractProcessObject3.getName());
                } else {
                    preparedStatement.setString(16, null);
                    preparedStatement.setString(17, null);
                    preparedStatement.setString(18, null);
                }
                preparedStatement.setString(21, flow2.getSystemObjective());
                preparedStatement.setString(22, flow2.isLogging() ? "Y" : "N");
                preparedStatement.setString(23, flow2.isOpCreate() ? "Y" : "N");
                preparedStatement.setString(24, flow2.isOpRead() ? "Y" : "N");
                preparedStatement.setString(25, flow2.isOpUpdate() ? "Y" : "N");
                preparedStatement.setString(26, flow2.isOpDelete() ? "Y" : "N");
                String string3 = "";
                if (flow2.isOpCreate()) {
                    string3 = "C";
                }
                if (flow2.isOpRead()) {
                    string3 = string3 + "R";
                }
                if (flow2.isOpUpdate()) {
                    string3 = string3 + "U";
                }
                if (flow2.isOpDelete()) {
                    string3 = string3 + "D";
                }
                preparedStatement.setString(27, string3);
                preparedStatement.setString(28, (String)map.get(design.getObjectID()));
                preparedStatement.addBatch();
                arrayList.add(flow2);
                if (++n != 1000) continue;
                n = 0;
                preparedStatement.executeBatch();
                for (Flow flow2 : arrayList) {
                    RSObjectNotes.export(map, connection, flow2);
                    RSComments.export(map, connection, flow2);
                    RSDynamicProperties.export(design, map, connection, flow2);
                }
                arrayList.clear();
            }
            RSFlows.exportFlowsIS(map, connection, arrayList2, design);
        }
        if (n > 0) {
            n = 0;
            preparedStatement.executeBatch();
            for (Flow flow : arrayList) {
                RSObjectNotes.export(map, connection, flow);
                RSComments.export(map, connection, flow);
                RSDynamicProperties.export(design, map, connection, flow);
            }
            arrayList.clear();
        }
        preparedStatement.close();
        preparedStatement = null;
    }

    private static void exportFlowsIS(Map map, Connection connection, List list, Design design) throws Exception {
        int n = 0;
        String string = "INSERT INTO DMRS_FLOW_INFO_STRUCTURES (Flow_ID, Flow_OVID, Flow_Name, Info_Structure_ID, Info_Structure_OVID, Info_Structure_Name, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement preparedStatement = connection.prepareStatement(string);
        for (Flow flow : list) {
            for (InfoStructure infoStructure : flow.getInfoStructures()) {
                String string2 = (String)map.get(infoStructure.getObjectID());
                preparedStatement.setString(1, flow.getObjectID());
                preparedStatement.setString(2, (String)map.get(flow.getObjectID()));
                preparedStatement.setString(3, flow.getName());
                preparedStatement.setString(4, infoStructure.getObjectID());
                preparedStatement.setString(5, string2);
                preparedStatement.setString(6, infoStructure.getName());
                preparedStatement.setString(7, (String)map.get(design.getObjectID()));
                preparedStatement.addBatch();
                if (++n != 1000) continue;
                n = 0;
                preparedStatement.executeBatch();
            }
        }
        if (n > 0) {
            n = 0;
            preparedStatement.executeBatch();
        }
        preparedStatement.close();
        preparedStatement = null;
    }
}

