/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.exports.reports.RSComments;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.exports.reports.RSObjectNotes;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.process.DataFlowDesign;
import oracle.dbtools.crest.model.design.process.ExternalAgent;
import oracle.dbtools.crest.model.design.process.ExternalData;
import oracle.dbtools.crest.model.design.process.Flow;
import oracle.dbtools.crest.model.design.process.ProcessModel;

public class RSExternalAgents
extends RSGeneral {
    public static void export(Design design, Map map, Connection connection) throws Exception {
        ArrayList<ExternalAgent> arrayList = new ArrayList<ExternalAgent>(1000);
        int n = 0;
        ArrayList<ExternalAgent> arrayList2 = new ArrayList<ExternalAgent>();
        String string = "INSERT INTO DMRS_EXTERNAL_AGENTS (External_Agent_ID, External_Agent_OVID, External_Agent_Name, Diagram_ID, Diagram_OVID, Diagram_Name, External_Agent_Type, File_Location, File_Source, File_Name, File_Type, File_Owner, Data_Capture_Type, Field_Separator, Text_Delimiter, Skip_Records, Self_Describing, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement preparedStatement = connection.prepareStatement(string);
        String string2 = (String)map.get(design.getObjectID());
        ProcessModel processModel = design.getProcessModel();
        Iterator iterator = processModel.getDataFlowDesigns().iterator();
        while (iterator.hasNext()) {
            DataFlowDesign dataFlowDesign = (DataFlowDesign)iterator.next();
            String object = (String)map.get(dataFlowDesign.getObjectID());
            Iterator iterator2 = dataFlowDesign.getExternalAgentSet().iterator();
            arrayList2.clear();
            while (iterator2.hasNext()) {
                ExternalAgent externalAgent2 = (ExternalAgent)iterator2.next();
                String string3 = RSExternalAgents.getOrCreateOVID(map, externalAgent2.getObjectID());
                arrayList2.add(externalAgent2);
                preparedStatement.setString(1, externalAgent2.getObjectID());
                preparedStatement.setString(2, string3);
                preparedStatement.setString(3, externalAgent2.getName());
                preparedStatement.setString(4, dataFlowDesign.getObjectID());
                preparedStatement.setString(5, object);
                preparedStatement.setString(6, !"".equals(dataFlowDesign.getName()) ? dataFlowDesign.getName() : dataFlowDesign.getObjectTypeName());
                if (externalAgent2.getType() == 0) {
                    preparedStatement.setString(7, "Organizational Unit");
                } else if (externalAgent2.getType() == 1) {
                    preparedStatement.setString(7, "System");
                } else if (externalAgent2.getType() == 2) {
                    preparedStatement.setString(7, "Role");
                } else {
                    preparedStatement.setString(7, "Other");
                }
                preparedStatement.setString(8, externalAgent2.getLocation());
                preparedStatement.setString(9, externalAgent2.getSource());
                preparedStatement.setString(10, externalAgent2.getFileName());
                preparedStatement.setString(11, externalAgent2.getFileType());
                preparedStatement.setString(12, externalAgent2.getOwner());
                preparedStatement.setString(13, externalAgent2.getTransferType());
                preparedStatement.setString(14, externalAgent2.getFieldSeparator());
                preparedStatement.setString(15, externalAgent2.getTextDelimiter());
                preparedStatement.setInt(16, externalAgent2.getSkipRecords());
                preparedStatement.setString(17, externalAgent2.isSelfDescribing() ? "Y" : "N");
                preparedStatement.setString(18, string2);
                preparedStatement.addBatch();
                arrayList.add(externalAgent2);
                if (++n != 1000) continue;
                n = 0;
                preparedStatement.executeBatch();
                for (ExternalAgent externalAgent2 : arrayList) {
                    RSObjectNotes.export(map, connection, externalAgent2);
                    RSComments.export(map, connection, externalAgent2);
                }
                arrayList.clear();
            }
            RSExternalAgents.exportFlows(map, connection, arrayList2, string2);
            RSExternalAgents.exportRelationships(map, connection, arrayList2, string2);
        }
        if (n > 0) {
            n = 0;
            preparedStatement.executeBatch();
            for (ExternalAgent externalAgent : arrayList) {
                RSObjectNotes.export(map, connection, externalAgent);
                RSComments.export(map, connection, externalAgent);
            }
            arrayList.clear();
        }
        preparedStatement.close();
        preparedStatement = null;
    }

    private static void exportFlows(Map map, Connection connection, List list, String string) throws Exception {
        int n = 0;
        String string2 = "INSERT INTO DMRS_EXT_AGENT_FLOWS (External_Agent_ID, External_Agent_OVID, External_Agent_Name, Flow_ID, Flow_OVID, Flow_Name, Incoming_Outgoing_Flag, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement preparedStatement = connection.prepareStatement(string2);
        for (ExternalAgent externalAgent : list) {
            Object object;
            Object object22;
            for (Object object22 : externalAgent.getIncomingFlows()) {
                object = (String)map.get(((ModelIDObject)object22).getObjectID());
                preparedStatement.setString(1, externalAgent.getObjectID());
                preparedStatement.setString(2, (String)map.get(externalAgent.getObjectID()));
                preparedStatement.setString(3, externalAgent.getName());
                preparedStatement.setString(4, ((ModelIDObject)object22).getObjectID());
                preparedStatement.setString(5, (String)object);
                preparedStatement.setString(6, ((DesignObject)object22).getName());
                preparedStatement.setString(7, "I");
                preparedStatement.setString(8, string);
                preparedStatement.addBatch();
                if (++n != 1000) continue;
                n = 0;
                preparedStatement.executeBatch();
            }
            if (n > 0) {
                n = 0;
                preparedStatement.executeBatch();
            }
            object22 = externalAgent.getOutgoingFlows().iterator();
            while (object22.hasNext()) {
                object = (Flow)object22.next();
                String string3 = (String)map.get(((ModelIDObject)object).getObjectID());
                preparedStatement.setString(1, externalAgent.getObjectID());
                preparedStatement.setString(2, (String)map.get(externalAgent.getObjectID()));
                preparedStatement.setString(3, externalAgent.getName());
                preparedStatement.setString(4, ((ModelIDObject)object).getObjectID());
                preparedStatement.setString(5, string3);
                preparedStatement.setString(6, ((DesignObject)object).getName());
                preparedStatement.setString(7, "O");
                preparedStatement.setString(8, string);
                preparedStatement.addBatch();
                if (++n != 1000) continue;
                n = 0;
                preparedStatement.executeBatch();
            }
            if (n <= 0) continue;
            n = 0;
            preparedStatement.executeBatch();
        }
        preparedStatement.close();
        preparedStatement = null;
    }

    private static void exportRelationships(Map map, Connection connection, List list, String string) throws Exception {
        int n = 0;
        String string2 = "INSERT INTO DMRS_EXT_AGENT_EXT_DATAS (External_Agent_ID, External_Agent_OVID, External_Agent_Name, External_Data_ID, External_Data_OVID, External_Data_Name, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement preparedStatement = connection.prepareStatement(string2);
        for (ExternalAgent externalAgent : list) {
            for (ExternalData externalData : externalAgent.getExternalDatas()) {
                String string3 = (String)map.get(externalData.getObjectID());
                preparedStatement.setString(1, externalAgent.getObjectID());
                preparedStatement.setString(2, (String)map.get(externalAgent.getObjectID()));
                preparedStatement.setString(3, externalAgent.getName());
                preparedStatement.setString(4, externalData.getObjectID());
                preparedStatement.setString(5, string3);
                preparedStatement.setString(6, externalData.getName());
                preparedStatement.setString(7, string);
                preparedStatement.addBatch();
                if (++n != 1000) continue;
                n = 0;
                preparedStatement.executeBatch();
            }
        }
        if (n > 0) {
            n = 0;
            preparedStatement.executeBatch();
        }
        preparedStatement.close();
        preparedStatement = null;
    }
}

