/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.RepaintManager;
import oracle.dbtools.crest.exports.reports.RSComments;
import oracle.dbtools.crest.exports.reports.RSDiagramElements;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.exports.reports.RSObjectNotes;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.multidimensional.MultidimensionalDesign;
import oracle.dbtools.crest.model.design.process.DataFlowDesign;
import oracle.dbtools.crest.model.design.process.TransformationPackage;
import oracle.dbtools.crest.model.design.process.TransformationTask;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.placeholder.DesignPartViewPlaceHolder;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.diagram.Diagram;
import oracle.dbtools.crest.swingui.printing.PDFDocument;
import oracle.dbtools.crest.swingui.process.DPVProcess;
import oracle.dbtools.crest.swingui.process.DPVTransformation;
import oracle.sql.BLOB;
import org.apache.batik.transcoder.TranscoderOutput;

public class RSDiagrams
extends RSGeneral {
    public static void export(Design design, Map map, Connection connection, boolean bl) throws Exception {
        Object object;
        Iterator iterator;
        String string = "INSERT INTO DMRS_Diagrams (Diagram_Name, Object_ID, OVID, Diagram_Type, Is_Display, Visible, Master_Diagram_ID, Master_Diagram_OVID, Model_ID, Model_OVID, Model_Name, Notation, Show_All_Details, Show_Names_Only, Show_Elements, Show_Datatype, Show_Keys, Autoroute, Box_In_box, Master_Diagram_Name, Diagram_SVG, Diagram_PDF, Subview_ID, Subview_OVID, Subview_Name, Display_ID, Display_OVID, Display_Name, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement preparedStatement = connection.prepareStatement(string);
        ArrayList<DesignPartView> arrayList = new ArrayList<DesignPartView>();
        boolean bl2 = false;
        boolean bl3 = false;
        bl2 = RSDiagrams.ensureMainViewVisible(design.getLogicalDesign());
        if (bl) {
            RSDiagrams.showDisplays(design.getLogicalDesign().getMainView());
        }
        arrayList.add(design.getLogicalDesign().getMainView());
        arrayList.addAll(RSDiagrams.getDisplays(design.getLogicalDesign().getMainView()));
        Iterator iterator2 = design.getLogicalDesign().getLogicalDesignSubviews().iterator();
        while (iterator2.hasNext()) {
            DesignPartViewPlaceHolder repositoryObject2 = (DesignPartViewPlaceHolder)iterator2.next();
            bl3 = RSDiagrams.ensureDisplayViewVisible(repositoryObject2);
            if (bl) {
                RSDiagrams.showDisplays(repositoryObject2.getDesignPartView());
            }
            arrayList.add(repositoryObject2.getDesignPartView());
            arrayList.addAll(RSDiagrams.getDisplays(repositoryObject2.getDesignPartView()));
            RSDiagrams.resetDisplayViewVisible(repositoryObject2, bl3);
        }
        RSDiagrams.resetMainViewVisible(design.getLogicalDesign(), bl2);
        iterator2 = design.getMultidimensionalDesigns().iterator();
        while (iterator2.hasNext()) {
            MultidimensionalDesign multidimensionalDesign = (MultidimensionalDesign)iterator2.next();
            bl2 = RSDiagrams.ensureMainViewVisible(multidimensionalDesign);
            if (bl) {
                RSDiagrams.showDisplays(multidimensionalDesign.getMainView());
            }
            arrayList.add(multidimensionalDesign.getMainView());
            RSDiagrams.resetMainViewVisible(multidimensionalDesign, bl2);
        }
        iterator2 = design.getRelationalDesigns().iterator();
        while (iterator2.hasNext()) {
            RelationalDesign relationalDesign = (RelationalDesign)iterator2.next();
            bl2 = RSDiagrams.ensureMainViewVisible(relationalDesign);
            if (bl) {
                RSDiagrams.showDisplays(relationalDesign.getMainView());
            }
            arrayList.add(relationalDesign.getMainView());
            arrayList.addAll(RSDiagrams.getDisplays(relationalDesign.getMainView()));
            iterator = relationalDesign.getDesignSubviews().iterator();
            while (iterator.hasNext()) {
                object = (DesignPartViewPlaceHolder)iterator.next();
                bl3 = RSDiagrams.ensureDisplayViewVisible((DesignPartViewPlaceHolder)object);
                if (bl) {
                    RSDiagrams.showDisplays(((DesignPartViewPlaceHolder)object).getDesignPartView());
                }
                arrayList.add(((DesignPartViewPlaceHolder)object).getDesignPartView());
                arrayList.addAll(RSDiagrams.getDisplays(((DesignPartViewPlaceHolder)object).getDesignPartView()));
                RSDiagrams.resetDisplayViewVisible((DesignPartViewPlaceHolder)object, bl3);
            }
            RSDiagrams.resetMainViewVisible(relationalDesign, bl2);
        }
        bl2 = RSDiagrams.ensureMainViewVisible(design.getDataTypesDesign());
        if (bl) {
            RSDiagrams.showDisplays(design.getDataTypesDesign().getMainView());
        }
        arrayList.add(design.getDataTypesDesign().getMainView());
        arrayList.addAll(RSDiagrams.getDisplays(design.getDataTypesDesign().getMainView()));
        iterator2 = design.getDataTypesDesign().getDesignSubviews().iterator();
        while (iterator2.hasNext()) {
            DesignPartViewPlaceHolder designPartViewPlaceHolder = (DesignPartViewPlaceHolder)iterator2.next();
            bl3 = RSDiagrams.ensureDisplayViewVisible(designPartViewPlaceHolder);
            if (bl) {
                RSDiagrams.showDisplays(designPartViewPlaceHolder.getDesignPartView());
            }
            arrayList.add(designPartViewPlaceHolder.getDesignPartView());
            arrayList.addAll(RSDiagrams.getDisplays(designPartViewPlaceHolder.getDesignPartView()));
            RSDiagrams.resetDisplayViewVisible(designPartViewPlaceHolder, bl3);
        }
        RSDiagrams.resetMainViewVisible(design.getDataTypesDesign(), bl2);
        iterator2 = design.getProcessModel().getDataFlowDesigns().iterator();
        while (iterator2.hasNext()) {
            DataFlowDesign dataFlowDesign = (DataFlowDesign)iterator2.next();
            bl2 = RSDiagrams.ensureMainViewVisible(dataFlowDesign);
            arrayList.add(dataFlowDesign.getMainView());
            RSObjectNotes.export(map, connection, dataFlowDesign);
            RSComments.export(map, connection, dataFlowDesign);
            RSDiagrams.resetMainViewVisible(dataFlowDesign, bl2);
        }
        iterator2 = design.getProcessModel().getTransformationPackageSet().iterator();
        while (iterator2.hasNext()) {
            TransformationPackage transformationPackage = (TransformationPackage)iterator2.next();
            iterator = transformationPackage.getTransformationTaskSet().iterator();
            while (iterator.hasNext()) {
                object = (TransformationTask)iterator.next();
                bl2 = RSDiagrams.ensureMainViewVisible((DesignPart)object);
                arrayList.add(((TransformationTask)object).getMainView());
                RSDiagrams.resetMainViewVisible((DesignPart)object, bl2);
            }
        }
        for (DesignPartView designPartView : arrayList) {
            if (designPartView instanceof DPVProcess || designPartView instanceof DPVTransformation) {
                preparedStatement.setString(1, RSDiagrams.getDiagramName(designPartView));
                preparedStatement.setString(2, designPartView.getDesignPart().getObjectID());
                preparedStatement.setString(3, RSDiagrams.getOrCreateOVID(map, designPartView.getDesignPart().getObjectID()));
            } else {
                preparedStatement.setString(1, RSDiagrams.getDiagramName(designPartView));
                preparedStatement.setString(2, designPartView.getDPVId());
                preparedStatement.setString(3, RSDiagrams.getOrCreateOVID(map, designPartView.getDPVId()));
            }
            preparedStatement.setString(4, designPartView.isMainDiagram() ? "MainView" : "Subview");
            preparedStatement.setString(5, designPartView.isDisplay() ? "Y" : "N");
            preparedStatement.setString(6, designPartView.isVisible() ? "Y" : "N");
            preparedStatement.setString(7, designPartView.isDisplay() ? designPartView.getMasterDPV().getDPVId() : null);
            preparedStatement.setString(8, designPartView.isDisplay() ? RSDiagrams.getOrCreateOVID(map, designPartView.getMasterDPV().getDPVId()) : null);
            if (designPartView instanceof DPVProcess || designPartView instanceof DPVTransformation) {
                preparedStatement.setString(9, design.getProcessModel().getObjectID());
                preparedStatement.setString(10, (String)map.get(design.getProcessModel().getObjectID()));
                preparedStatement.setString(11, design.getProcessModel().getName());
            } else {
                preparedStatement.setString(9, designPartView.getDesignPart().getObjectID());
                preparedStatement.setString(10, (String)map.get(designPartView.getDesignPart().getObjectID()));
                preparedStatement.setString(11, designPartView.getDesignPart().getName());
            }
            preparedStatement.setString(12, designPartView.getNotation() == 0 ? "Bachman" : "Barker");
            preparedStatement.setString(13, designPartView.showAllDetails() ? "Y" : "N");
            preparedStatement.setString(14, designPartView.isShowNamesOnly() ? "Y" : "N");
            preparedStatement.setString(15, designPartView.showElements() ? "Y" : "N");
            preparedStatement.setString(16, designPartView.showDatatype() ? "Y" : "N");
            preparedStatement.setString(17, designPartView.showKeys() ? "Y" : "N");
            preparedStatement.setString(18, designPartView.isAutoRoute() ? "Y" : "N");
            preparedStatement.setString(19, designPartView.isBoxInBox() ? "Y" : "N");
            preparedStatement.setString(20, designPartView.isDisplay() ? RSDiagrams.getDiagramName(designPartView.getMasterDPV()) : null);
            preparedStatement.setObject(21, null);
            iterator = null;
            if (bl) {
                object = RSDiagrams.generatePDF(designPartView);
                if (object != null) {
                    int n;
                    FileInputStream fileInputStream = new FileInputStream((File)object);
                    iterator = BLOB.createTemporary((Connection)connection, (boolean)false, (int)10);
                    iterator.open(1);
                    OutputStream outputStream = iterator.setBinaryStream(1L);
                    byte[] byArray = new byte[1024];
                    while ((n = fileInputStream.read(byArray)) > 0) {
                        outputStream.write(byArray, 0, n);
                    }
                    fileInputStream.close();
                    outputStream.flush();
                    outputStream.close();
                    iterator.close();
                    preparedStatement.setBlob(22, (Blob)((Object)iterator));
                } else {
                    preparedStatement.setObject(22, null);
                }
            } else {
                preparedStatement.setObject(22, null);
            }
            preparedStatement.setString(23, designPartView.isMainDiagram() ? null : designPartView.getDPVId());
            preparedStatement.setString(24, designPartView.isMainDiagram() ? null : RSDiagrams.getOrCreateOVID(map, designPartView.getDPVId()));
            preparedStatement.setString(25, designPartView.isMainDiagram() ? null : RSDiagrams.getDiagramName(designPartView));
            preparedStatement.setString(26, designPartView.isDisplay() ? designPartView.getDPVId() : null);
            preparedStatement.setString(27, designPartView.isDisplay() ? RSDiagrams.getOrCreateOVID(map, designPartView.getDPVId()) : null);
            preparedStatement.setString(28, designPartView.isDisplay() ? RSDiagrams.getDiagramName(designPartView) : null);
            preparedStatement.setString(29, (String)map.get(design.getObjectID()));
            preparedStatement.executeUpdate();
            if (iterator != null) {
                iterator.freeTemporary();
            }
            RSDiagramElements.export(map, connection, designPartView);
        }
        preparedStatement.close();
        preparedStatement = null;
        if (bl) {
            RSDiagrams.clearPDF();
        }
    }

    public static String getDiagramName(DesignPartView designPartView) {
        String string = "";
        if (designPartView instanceof DPVProcess || designPartView instanceof DPVTransformation) {
            string = designPartView.getDesignPart().getName();
            if (string == null || "".equals(string)) {
                string = designPartView.getDesignPart().getObjectTypeName();
            }
        } else {
            string = designPartView.getName();
            if ((string == null || "".equals(string)) && ((string = designPartView.getDesignPart().getName()) == null || "".equals(string))) {
                string = designPartView.getDesignPart().getObjectTypeName();
            }
        }
        return string;
    }

    private static boolean ensureMainViewVisible(DesignPart designPart) {
        boolean bl = designPart.isMainViewVisible();
        if (designPart.isLoaded() && designPart.isVisible()) {
            designPart.setMainViewVisible(true);
        }
        return bl;
    }

    private static void resetMainViewVisible(DesignPart designPart, boolean bl) {
        if (!bl) {
            designPart.setMainViewVisible(false);
        }
    }

    private static boolean ensureDisplayViewVisible(DesignPartViewPlaceHolder designPartViewPlaceHolder) {
        boolean bl = designPartViewPlaceHolder.getVisible();
        designPartViewPlaceHolder.setVisible(true);
        return bl;
    }

    private static void resetDisplayViewVisible(DesignPartViewPlaceHolder designPartViewPlaceHolder, boolean bl) {
        if (!bl) {
            designPartViewPlaceHolder.setVisible(false);
        }
    }

    protected static List getDisplays(DesignPartView designPartView) {
        ArrayList<DesignPartView> arrayList = new ArrayList<DesignPartView>();
        Iterator iterator = designPartView.getDisplays().iterator();
        while (iterator.hasNext()) {
            DesignPartViewPlaceHolder designPartViewPlaceHolder = (DesignPartViewPlaceHolder)iterator.next();
            arrayList.add(designPartViewPlaceHolder.getDesignPartView());
        }
        return arrayList;
    }

    protected static void clearPDF() {
        File file = new File(System.getProperty("java.io.tmpdir"), "diagram.pdf");
        if (file.exists()) {
            boolean bl = file.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static File generatePDF(DesignPartView designPartView) throws Exception {
        File file = new File(System.getProperty("java.io.tmpdir"), "diagram.pdf");
        if (file.exists()) {
            boolean bl = file.delete();
        }
        Diagram diagram = designPartView.getWorkSpace();
        double d = diagram.getScale();
        diagram.actualSize();
        RepaintManager repaintManager = RepaintManager.currentManager(diagram);
        repaintManager.setDoubleBufferingEnabled(false);
        try {
            PDFDocument pDFDocument = new PDFDocument();
            Dimension dimension = diagram.getPreferredScrollableViewportSize();
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            TranscoderOutput transcoderOutput = new TranscoderOutput((OutputStream)fileOutputStream);
            pDFDocument.transcode(diagram, transcoderOutput, (float)dimension.getWidth(), (float)dimension.getHeight());
            fileOutputStream.flush();
            ((OutputStream)fileOutputStream).close();
        }
        finally {
            repaintManager.setDoubleBufferingEnabled(true);
            diagram.setScale(d);
        }
        if (file.exists()) {
            return file;
        }
        return null;
    }

    private static void showDisplays(DesignPartView designPartView) {
        if (designPartView != null) {
            Object object;
            DesignPartView.NamedTabbedPane namedTabbedPane = designPartView.getTabbedPane();
            TreeMap<String, DesignPartView> treeMap = new TreeMap<String, DesignPartView>();
            Component[] componentArray = namedTabbedPane.getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                if (!(componentArray[i] instanceof DesignPartView)) continue;
                object = (DesignPartView)componentArray[i];
                treeMap.put(((DesignPartView)object).getDPVId(), (DesignPartView)object);
            }
            if (treeMap.containsKey(designPartView.getDPVId())) {
                Component component = namedTabbedPane.getSelectedComponent();
                namedTabbedPane.setSelectedComponent(designPartView);
                object = designPartView.getDisplays().iterator();
                while (object.hasNext()) {
                    DesignPartViewPlaceHolder designPartViewPlaceHolder = (DesignPartViewPlaceHolder)object.next();
                    String string = designPartViewPlaceHolder.getDesignPartView().getDPVId();
                    if (!treeMap.containsKey(string)) continue;
                    namedTabbedPane.setSelectedComponent((DesignPartView)treeMap.get(string));
                }
                namedTabbedPane.setSelectedComponent(component);
            }
        }
    }
}

