/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.Iterator;
import java.util.Map;
import oracle.dbtools.crest.exports.reports.RSDiagrams;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.EditableFonts;
import oracle.dbtools.crest.model.design.FontObject;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TVConnector;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.diagram.graph.PortView;
import oracle.dbtools.crest.swingui.process.DPVProcess;
import oracle.dbtools.crest.swingui.process.DPVTransformation;

public class RSDiagramElements
extends RSGeneral {
    public static void export(Map map, Connection connection, DesignPartView designPartView) throws Exception {
        int n = 0;
        String string = "INSERT INTO DMRS_Diagram_Elements (Name, Type, Geometry_Type, Object_ID, OVID, View_ID, Source_ID, Source_OVID, Source_View_ID, Target_ID, Target_OVID, Target_View_ID, Model_ID, Model_OVID, Location_X, Location_Y, Height, Width, BG_Color, FG_Color, Use_Default_Color, Formatting, Points, Diagram_OVID, Diagram_ID, Diagram_Name, Source_Name, Target_Name, Model_Name, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ? )";
        PreparedStatement preparedStatement = connection.prepareStatement(string);
        for (TopView topView : designPartView.getTopviewsList()) {
            DesignObject designObject = topView.getModel();
            preparedStatement.setString(1, designObject.getName());
            preparedStatement.setString(2, designObject.getObjectTypeName());
            preparedStatement.setString(3, topView instanceof TVConnector ? "Line" : "Shape");
            preparedStatement.setString(4, designObject.getObjectID());
            preparedStatement.setString(5, RSDiagramElements.getOrCreateOVID(map, designObject.getObjectID()));
            preparedStatement.setString(6, topView.getViewID());
            preparedStatement.setString(7, RSDiagramElements.getSourceID(topView));
            preparedStatement.setString(8, RSDiagramElements.getSourceID(topView) != null ? (String)map.get(RSDiagramElements.getSourceID(topView)) : null);
            preparedStatement.setString(9, RSDiagramElements.getSourceViewID(topView));
            preparedStatement.setString(10, RSDiagramElements.getTargetID(topView));
            preparedStatement.setString(11, RSDiagramElements.getTargetID(topView) != null ? (String)map.get(RSDiagramElements.getTargetID(topView)) : null);
            preparedStatement.setString(12, RSDiagramElements.getTargetViewID(topView));
            if (designPartView instanceof DPVProcess || designPartView instanceof DPVTransformation) {
                preparedStatement.setString(13, topView.getDesign().getProcessModel().getObjectID());
                preparedStatement.setString(14, (String)map.get(topView.getDesign().getProcessModel().getObjectID()));
                preparedStatement.setString(29, topView.getDesign().getProcessModel().getName());
            } else {
                preparedStatement.setString(13, designObject.getDesignPartId());
                preparedStatement.setString(14, (String)map.get(designObject.getDesignPartId()));
                preparedStatement.setString(29, designObject.getDesignPart().getName());
            }
            if (topView instanceof TVConnector) {
                Rectangle rectangle = ((TVConnector)topView).getLineBounds();
                if (rectangle != null) {
                    preparedStatement.setDouble(15, rectangle.getX());
                    preparedStatement.setDouble(16, rectangle.getY());
                    preparedStatement.setDouble(17, rectangle.getWidth());
                    preparedStatement.setDouble(18, rectangle.getHeight());
                } else {
                    preparedStatement.setDouble(15, 0.0);
                    preparedStatement.setDouble(16, 0.0);
                    preparedStatement.setDouble(17, 0.0);
                    preparedStatement.setDouble(18, 0.0);
                }
            } else {
                preparedStatement.setDouble(15, topView.getLocation().getX());
                preparedStatement.setDouble(16, topView.getLocation().getY());
                preparedStatement.setDouble(17, topView.getSize().getWidth());
                preparedStatement.setDouble(18, topView.getSize().getHeight());
            }
            preparedStatement.setObject(19, topView.getModel() != null && topView.getBackgroundColor() != null ? Integer.valueOf(topView.getBackgroundColor().getRGB()) : null);
            preparedStatement.setObject(20, topView.getModel() != null && topView.getForegroundColor() != null ? Integer.valueOf(topView.getForegroundColor().getRGB()) : null);
            preparedStatement.setString(21, topView.getModel() != null && topView.useDefaultColor() ? "Y" : "N");
            preparedStatement.setString(22, RSDiagramElements.getFormatting(designObject));
            preparedStatement.setString(23, RSDiagramElements.getPoints(topView));
            if (designPartView instanceof DPVProcess || designPartView instanceof DPVTransformation) {
                preparedStatement.setString(24, (String)map.get(designPartView.getDesignPart().getObjectID()));
                preparedStatement.setString(25, designPartView.getDesignPart().getObjectID());
                preparedStatement.setString(26, RSDiagrams.getDiagramName(designPartView));
            } else {
                preparedStatement.setString(24, (String)map.get(designPartView.getDPVId()));
                preparedStatement.setString(25, designPartView.getDPVId());
                preparedStatement.setString(26, RSDiagrams.getDiagramName(designPartView));
            }
            preparedStatement.setString(27, RSDiagramElements.getSourceName(topView));
            preparedStatement.setString(28, RSDiagramElements.getTargetName(topView));
            preparedStatement.setString(30, (String)map.get(topView.getDesign().getObjectID()));
            preparedStatement.addBatch();
            if (++n != 1000) continue;
            n = 0;
            preparedStatement.executeBatch();
        }
        if (n > 0) {
            n = 0;
            preparedStatement.executeBatch();
        }
        preparedStatement.close();
        preparedStatement = null;
    }

    private static String getFormatting(DesignObject designObject) {
        if (designObject instanceof EditableFonts && ((EditableFonts)((Object)designObject)).getEditableFonts() != null) {
            StringBuffer stringBuffer = new StringBuffer();
            Iterator iterator = ((EditableFonts)((Object)designObject)).getEditableFonts().iterator();
            boolean bl = true;
            while (iterator.hasNext()) {
                if (!bl) {
                    stringBuffer.append(";");
                } else {
                    bl = false;
                }
                FontObject fontObject = (FontObject)iterator.next();
                stringBuffer.append(fontObject.getType()).append(",");
                stringBuffer.append(fontObject.getColor().getRGB()).append(",");
                stringBuffer.append(fontObject.getFont().getSize()).append(",");
                stringBuffer.append(fontObject.getFont().getStyle());
            }
            return stringBuffer.toString();
        }
        return null;
    }

    private static String getPoints(TopView topView) {
        if (topView instanceof TVConnector) {
            StringBuffer stringBuffer = new StringBuffer();
            Iterator iterator = ((TVConnector)topView).getActualPoints().iterator();
            boolean bl = true;
            while (iterator.hasNext()) {
                Point2D point2D;
                Object e = iterator.next();
                if (!bl) {
                    stringBuffer.append(";");
                } else {
                    bl = false;
                }
                if ((point2D = e instanceof PortView ? ((PortView)e).getPoint() : (Point2D)e) == null) continue;
                stringBuffer.append(point2D.getX()).append(",").append(point2D.getY());
            }
            return stringBuffer.toString();
        }
        return null;
    }

    private static String getSourceID(TopView topView) {
        TopView topView2;
        if (topView instanceof TVConnector && (topView2 = ((TVConnector)topView).getSourceTopView()) != null) {
            return topView2.getModel().getObjectID();
        }
        return null;
    }

    private static String getTargetID(TopView topView) {
        TopView topView2;
        if (topView instanceof TVConnector && (topView2 = ((TVConnector)topView).getTargetTopView()) != null) {
            return topView2.getModel().getObjectID();
        }
        return null;
    }

    private static String getSourceName(TopView topView) {
        TopView topView2;
        if (topView instanceof TVConnector && (topView2 = ((TVConnector)topView).getSourceTopView()) != null) {
            return topView2.getModel().getName();
        }
        return null;
    }

    private static String getTargetName(TopView topView) {
        TopView topView2;
        if (topView instanceof TVConnector && (topView2 = ((TVConnector)topView).getTargetTopView()) != null) {
            return topView2.getModel().getName();
        }
        return null;
    }

    private static String getSourceViewID(TopView topView) {
        TopView topView2;
        if (topView instanceof TVConnector && (topView2 = ((TVConnector)topView).getSourceTopView()) != null) {
            return topView2.getViewID();
        }
        return null;
    }

    private static String getTargetViewID(TopView topView) {
        TopView topView2;
        if (topView instanceof TVConnector && (topView2 = ((TVConnector)topView).getTargetTopView()) != null) {
            return topView2.getViewID();
        }
        return null;
    }
}

