/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import oracle.dbtools.crest.exports.reports.RSComments;
import oracle.dbtools.crest.exports.reports.RSDynamicProperties;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.exports.reports.RSObjectNotes;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.datatypes.AbstractDTObject;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.DataTypesDesign;
import oracle.dbtools.crest.model.design.datatypes.DistinctType;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.util.GUID;

public class RSCollectionTypes
extends RSGeneral {
    public static void export(Design design, Map map, Connection connection, DataTypesDesign dataTypesDesign, String string) throws Exception {
        ArrayList<Object> arrayList = new ArrayList<Object>(1000);
        int n = 0;
        String string2 = (String)map.get(design.getDesign().getObjectID());
        String string3 = "INSERT INTO DMRS_COLLECTION_TYPES (Design_ID, Design_OVID, Design_Name, Collection_Type_ID, Collection_Type_OVID, Collection_Type_Name, C_Type, DataType_ID, DataType_OVID, DataType_Name, DT_Type, DT_Ref, Max_Element, Predefined,Char_Units, T_Size, T_Precision, T_Scale, DataType_Kind, Domain_Name, Model_OVID, model_Name) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement preparedStatement = connection.prepareStatement(string3);
        Iterator iterator = dataTypesDesign.getCollectionTypeSet().iterator();
        while (iterator.hasNext()) {
            Object object;
            Object object22 = (CollectionType)iterator.next();
            Object object3 = new GUID().toString();
            map.put(((ModelIDObject)object22).getObjectID(), object3);
            preparedStatement.setString(1, design.getObjectID());
            preparedStatement.setString(2, string2);
            preparedStatement.setString(3, design.getName());
            preparedStatement.setString(4, ((ModelIDObject)object22).getObjectID());
            preparedStatement.setString(5, (String)object3);
            preparedStatement.setString(6, ((DesignObject)object22).getName());
            preparedStatement.setString(7, ((CollectionType)object22).getType());
            if (((CollectionType)object22).getDataType() != null) {
                preparedStatement.setString(8, ((CollectionType)object22).getDataType().getObjectID());
                preparedStatement.setString(9, (String)map.get(((CollectionType)object22).getDataType().getObjectID()));
                preparedStatement.setString(10, ((CollectionType)object22).getDataType().getName());
                preparedStatement.setString(11, ((CollectionType)object22).getDataType().getObjectTypeName());
            } else {
                preparedStatement.setString(8, null);
                preparedStatement.setString(9, null);
                preparedStatement.setString(10, null);
                preparedStatement.setString(11, null);
            }
            preparedStatement.setString(12, ((CollectionType)object22).getElementType().isReference() ? "Y" : "N");
            preparedStatement.setInt(13, ((CollectionType)object22).getMaxElement());
            preparedStatement.setString(14, ((AbstractDTObject)object22).isPredefined() ? "Y" : "N");
            DesignObject designObject = ((CollectionType)object22).getDataType();
            if (designObject == null) {
                preparedStatement.setString(15, null);
                preparedStatement.setString(16, null);
                preparedStatement.setString(17, null);
                preparedStatement.setString(18, null);
                preparedStatement.setString(19, null);
                preparedStatement.setString(20, null);
            } else if (designObject instanceof Domain) {
                object = (Domain)designObject;
                preparedStatement.setString(15, ((Domain)object).getUnits());
                preparedStatement.setInt(16, RSCollectionTypes.getIntValue(((Domain)object).getSize()));
                preparedStatement.setInt(17, RSCollectionTypes.getIntValue(((Domain)object).getPrecision()));
                preparedStatement.setInt(18, RSCollectionTypes.getIntValue(((Domain)object).getScale()));
                preparedStatement.setString(19, "Domain");
                preparedStatement.setString(20, ((DesignObject)object).getName());
            } else if (designObject instanceof LogicalDatatype) {
                object = ((CollectionType)object22).getElementType();
                preparedStatement.setString(15, ((TypeElement)object).getUnits());
                preparedStatement.setString(16, ((TypeElement)object).getSize());
                preparedStatement.setInt(17, ((TypeElement)object).getPrecision());
                preparedStatement.setInt(18, ((TypeElement)object).getScale());
                preparedStatement.setString(19, "Logical Type");
                preparedStatement.setString(20, null);
            } else if (designObject instanceof DistinctType) {
                preparedStatement.setString(15, null);
                preparedStatement.setString(16, null);
                preparedStatement.setString(17, null);
                preparedStatement.setString(18, null);
                preparedStatement.setString(19, "Distinct Type");
                preparedStatement.setString(20, null);
            } else if (designObject instanceof StructuredType) {
                preparedStatement.setString(15, null);
                preparedStatement.setString(16, null);
                preparedStatement.setString(17, null);
                preparedStatement.setString(18, null);
                preparedStatement.setString(19, "Structured Type");
                preparedStatement.setString(20, null);
            } else if (designObject instanceof CollectionType) {
                preparedStatement.setString(15, null);
                preparedStatement.setString(16, null);
                preparedStatement.setString(17, null);
                preparedStatement.setString(18, null);
                preparedStatement.setString(19, "Collection Type");
                preparedStatement.setString(20, null);
            }
            preparedStatement.setString(21, string);
            preparedStatement.setString(22, ((DesignObject)object22).getDesignPart().getName());
            preparedStatement.addBatch();
            arrayList.add(object22);
            if (++n != 1000) continue;
            n = 0;
            preparedStatement.executeBatch();
            for (Object object22 : arrayList) {
                RSObjectNotes.export(map, connection, (ModelIDObject)object22);
                RSComments.export(map, connection, (ModelIDObject)object22);
                RSDynamicProperties.export(design, map, connection, (ModelIDObject)object22);
            }
            arrayList.clear();
        }
        if (n > 0) {
            n = 0;
            preparedStatement.executeBatch();
            for (Object object3 : arrayList) {
                RSObjectNotes.export(map, connection, (ModelIDObject)object3);
                RSComments.export(map, connection, (ModelIDObject)object3);
                RSDynamicProperties.export(design, map, connection, (ModelIDObject)object3);
            }
            arrayList.clear();
        }
        preparedStatement.close();
        preparedStatement = null;
    }
}

