/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.exports.reports.RSComments;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.exports.reports.RSObjectNotes;
import oracle.dbtools.crest.model.ChangeRequest;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.sql.CLOB;

public class RSChangeRequests
extends RSGeneral {
    public static void export(Design design, Map map, Connection connection) throws Exception {
        ArrayList<Object> arrayList = new ArrayList<Object>(1000);
        int n = 0;
        ArrayList<ChangeRequest> arrayList2 = new ArrayList<ChangeRequest>();
        String string = "INSERT INTO DMRS_CHANGE_REQUESTS (Design_ID, Design_OVID, Design_Name, Change_Request_ID, Change_Request_OVID, Change_Request_Name, Request_Status, Request_Date_String, Completion_Date_String, Is_Completed, Reason) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement preparedStatement = connection.prepareStatement(string);
        String string2 = (String)map.get(design.getObjectID());
        Iterator iterator = design.getChangeRequestSet().iterator();
        while (iterator.hasNext()) {
            Object object3 = (ChangeRequest)iterator.next();
            Object object2 = RSChangeRequests.getOrCreateOVID(map, ((ModelIDObject)object3).getObjectID());
            arrayList2.add((ChangeRequest)object3);
            preparedStatement.setString(1, design.getObjectID());
            preparedStatement.setString(2, string2);
            preparedStatement.setString(3, design.getName());
            preparedStatement.setString(4, ((ModelIDObject)object3).getObjectID());
            preparedStatement.setString(5, (String)object2);
            preparedStatement.setString(6, ((DesignObject)object3).getName());
            preparedStatement.setString(7, ((ChangeRequest)object3).getStatus());
            preparedStatement.setString(8, ((ChangeRequest)object3).getRequestDate());
            preparedStatement.setString(9, ((ChangeRequest)object3).getCompletionDate());
            preparedStatement.setString(10, ((ChangeRequest)object3).isCompleted() ? "Y" : "N");
            preparedStatement.setString(11, ((ChangeRequest)object3).getReason());
            preparedStatement.addBatch();
            arrayList.add(object3);
            if (++n != 1000) continue;
            n = 0;
            preparedStatement.executeBatch();
            for (Object object3 : arrayList) {
                RSObjectNotes.export(map, connection, (ModelIDObject)object3);
                RSComments.export(map, connection, (ModelIDObject)object3);
                RSChangeRequests.exportImplementationNote(map, connection, (ChangeRequest)object3);
            }
            arrayList.clear();
        }
        RSChangeRequests.exportElements(map, connection, arrayList2, string2);
        if (n > 0) {
            preparedStatement.executeBatch();
            for (Object object2 : arrayList) {
                RSObjectNotes.export(map, connection, (ModelIDObject)object2);
                RSComments.export(map, connection, (ModelIDObject)object2);
                RSChangeRequests.exportImplementationNote(map, connection, (ChangeRequest)object2);
            }
            arrayList.clear();
        }
        preparedStatement.close();
        preparedStatement = null;
    }

    private static void exportImplementationNote(Map map, Connection connection, ChangeRequest changeRequest) throws Exception {
        String string = changeRequest.getImplDescription().trim();
        if (string != null && !"".equalsIgnoreCase(string)) {
            String string2 = "INSERT INTO DMRS_Large_Text (Object_ID, OVID, Object_Name, Type, Text, Design_OVID) VALUES (?, ?, ?, ?, ?, ?)";
            PreparedStatement preparedStatement = connection.prepareStatement(string2);
            preparedStatement.setString(1, changeRequest.getObjectID());
            preparedStatement.setString(2, (String)map.get(changeRequest.getObjectID()));
            preparedStatement.setString(3, changeRequest.getName());
            preparedStatement.setString(4, "Implementation Note");
            CLOB cLOB = CLOB.createTemporary((Connection)connection, (boolean)false, (int)10);
            cLOB.setString(1L, string);
            preparedStatement.setClob(5, (Clob)cLOB);
            preparedStatement.setString(6, (String)map.get(changeRequest.getDesign().getObjectID()));
            preparedStatement.executeUpdate();
            cLOB.freeTemporary();
            preparedStatement.close();
            preparedStatement = null;
        }
    }

    private static void exportElements(Map map, Connection connection, List list, String string) throws Exception {
        int n = 0;
        String string2 = "INSERT INTO DMRS_CHANGE_REQUEST_ELEMENTS (Change_Request_ID, Change_Request_OVID, Change_Request_Name, Element_ID, Element_OVID, Element_Name, Element_Type, Design_OVID, Element_Model_Name ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement preparedStatement = connection.prepareStatement(string2);
        for (ChangeRequest changeRequest : list) {
            for (DesignObject designObject : changeRequest.getObjects()) {
                String string3 = RSChangeRequests.getOrCreateOVID(map, designObject.getObjectID());
                preparedStatement.setString(1, changeRequest.getObjectID());
                preparedStatement.setString(2, (String)map.get(changeRequest.getObjectID()));
                preparedStatement.setString(3, changeRequest.getName());
                preparedStatement.setString(4, designObject.getObjectID());
                preparedStatement.setString(5, string3);
                preparedStatement.setString(6, designObject.getName());
                preparedStatement.setString(7, designObject.getObjectTypeName());
                preparedStatement.setString(8, string);
                preparedStatement.setString(9, designObject.getDesignPart().getName());
                preparedStatement.addBatch();
                if (++n != 1000) continue;
                n = 0;
                preparedStatement.executeBatch();
            }
        }
        if (n > 0) {
            n = 0;
            preparedStatement.executeBatch();
        }
        preparedStatement.close();
        preparedStatement = null;
    }
}

