/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.Map;
import oracle.dbtools.crest.exports.Messages;
import oracle.dbtools.crest.exports.reports.RSChangeRequests;
import oracle.dbtools.crest.exports.reports.RSComments;
import oracle.dbtools.crest.exports.reports.RSContacts;
import oracle.dbtools.crest.exports.reports.RSDocuments;
import oracle.dbtools.crest.exports.reports.RSEmails;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.exports.reports.RSLocations;
import oracle.dbtools.crest.exports.reports.RSObjectNotes;
import oracle.dbtools.crest.exports.reports.RSResourceLocators;
import oracle.dbtools.crest.exports.reports.RSResponsibleParties;
import oracle.dbtools.crest.exports.reports.RSTelephones;
import oracle.dbtools.crest.model.businessinfo.BusinessInfoDesign;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.swingui.ProgressDialog;

public class RSBusinessInfo
extends RSGeneral {
    public static void export(Design design, Map map, Connection connection, ProgressDialog progressDialog) throws Exception {
        String string = "INSERT INTO DMRS_BUSINESS_INFO (Design_ID, Design_OVID, Design_Name, Business_Info_ID, Business_Info_OVID, Business_Info_Name) VALUES (?, ?, ?, ?, ?, ?)";
        PreparedStatement preparedStatement = connection.prepareStatement(string);
        BusinessInfoDesign businessInfoDesign = design.getBusinessInfoDesign();
        String string2 = RSBusinessInfo.getOrCreateOVID(map, businessInfoDesign.getObjectID());
        preparedStatement.setString(1, design.getObjectID());
        preparedStatement.setString(2, (String)map.get(design.getObjectID()));
        preparedStatement.setString(3, design.getName());
        preparedStatement.setString(4, businessInfoDesign.getObjectID());
        preparedStatement.setString(5, string2);
        preparedStatement.setString(6, businessInfoDesign.getName());
        preparedStatement.executeUpdate();
        RSObjectNotes.export(map, connection, businessInfoDesign);
        RSComments.export(map, connection, businessInfoDesign);
        progressDialog.setNote(Messages.getString("RSBusinessInfo.ExportingDocuments"));
        RSDocuments.export(design, map, connection);
        progressDialog.setNote(Messages.getString("RSBusinessInfo.ExportingResponsibleParties"));
        RSResponsibleParties.export(design, map, connection);
        progressDialog.setNote(Messages.getString("RSBusinessInfo.ExportingContacts"));
        RSContacts.export(design, map, connection);
        progressDialog.setNote(Messages.getString("RSBusinessInfo.ExportingEmails"));
        RSEmails.export(design, map, connection);
        progressDialog.setNote(Messages.getString("RSBusinessInfo.ExportingLocations"));
        RSLocations.export(design, map, connection);
        progressDialog.setNote(Messages.getString("RSBusinessInfo.ExportingTelephones"));
        RSTelephones.export(design, map, connection);
        progressDialog.setNote(Messages.getString("RSBusinessInfo.ExportingLocators"));
        RSResourceLocators.export(design, map, connection);
        progressDialog.setNote(Messages.getString("RSBusinessInfo.ExportingChangeRequests"));
        RSChangeRequests.export(design, map, connection);
        preparedStatement.close();
        preparedStatement = null;
    }
}

