/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.oracleaw;

import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.io.FileWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import oracle.AWAction.BuildDatabase;
import oracle.AWAction.Interaction;
import oracle.AWXML.AW;
import oracle.AWXML.AWConnection;
import oracle.AWXML.AggregationArgument;
import oracle.AWXML.AggregationDefinition;
import oracle.AWXML.AggregationHierarchySpecification;
import oracle.AWXML.AggregationOperator;
import oracle.AWXML.AttributeProjection;
import oracle.AWXML.AttributeSourceExpression;
import oracle.AWXML.BaseObject;
import oracle.AWXML.BaseOperator;
import oracle.AWXML.ConfigurationParameters;
import oracle.AWXML.CubeDimRef;
import oracle.AWXML.CubeDimensionSourceExpression;
import oracle.AWXML.CubeMapGroup;
import oracle.AWXML.DerivedMeasure;
import oracle.AWXML.DimensionKeySourceExpression;
import oracle.AWXML.DimensionMapGroup;
import oracle.AWXML.DimensionMemberExpression;
import oracle.AWXML.HierarchicalParentSourceExpression;
import oracle.AWXML.Hierarchy;
import oracle.AWXML.HierarchyLevelAssociation;
import oracle.AWXML.Level;
import oracle.AWXML.Measure;
import oracle.AWXML.MeasureSourceExpression;
import oracle.AWXML.OlapMeasure;
import oracle.AWXML.OlapMeasureInput;
import oracle.AWXML.Parameter;
import oracle.AWXML.PreComputeClause;
import oracle.AWXML.SolveDefDimRef;
import oracle.AWXML.SolveDefinition;
import oracle.AWXML.SourceColumn;
import oracle.AWXML.WhereClause;
import oracle.dbtools.crest.exports.Messages;
import oracle.dbtools.crest.exports.oracleaw.AWExportOptions;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.AttributeView;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.multidimensional.AbstractMDObject;
import oracle.dbtools.crest.model.design.multidimensional.CalculatedAttribute;
import oracle.dbtools.crest.model.design.multidimensional.Cube;
import oracle.dbtools.crest.model.design.multidimensional.Dimension;
import oracle.dbtools.crest.model.design.multidimensional.Level;
import oracle.dbtools.crest.model.design.multidimensional.Link;
import oracle.dbtools.crest.model.design.multidimensional.Measure;
import oracle.dbtools.crest.model.design.multidimensional.MeasureFolder;
import oracle.dbtools.crest.model.design.multidimensional.MultidimensionalDesign;
import oracle.dbtools.crest.model.design.multidimensional.RollupLink;
import oracle.dbtools.crest.model.design.multidimensional.Slice;
import oracle.dbtools.crest.model.design.multidimensional.SlowChangingAttribute;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.metadata.ID_ObjectPropertyTranslator;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.LogReport;
import oracle.dbtools.crest.swingui.ProgressDialog;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.express.spl.SPLExecutor;
import oracle.ide.Ide;
import oracle.jdbc.OracleConnection;

public class OracleAWExporter {
    public static String EXPORT_RECREATE_AW = Messages.getString("OracleAWExporter.0");
    public static String EXPORT_METADATA_TO_FILE = Messages.getString("OracleAWExporter.1");
    public static String EXPORT_NEW_CALC_MEASURES = Messages.getString("OracleAWExporter.2");
    public static String EXPORT_ALL_CALC_MEASURES = Messages.getString("OracleAWExporter.3");
    public static String[] EXPORT_TYPES = new String[]{EXPORT_RECREATE_AW, EXPORT_NEW_CALC_MEASURES, EXPORT_ALL_CALC_MEASURES, EXPORT_METADATA_TO_FILE};
    private ApplicationView appView;
    private static final Logger LOGGER = new Logger(OracleAWExporter.class);
    private MultidimensionalDesign mdmDesign;
    private MultidimensionalDesign tmdmDesign;
    private String schema = "CVSAMPLE";
    private String exportType = EXPORT_NEW_CALC_MEASURES;
    private StorageDesign storDesign;
    private RelationalDesign physDesign;
    private RelationalDesign tphysDesign;
    private Connection connection;
    private String connectString;
    private String user = null;
    private AWConnection awConnection;
    private String awName = "test1";
    private AW globalAW;
    private Map dimMap;
    private Map hierMap;
    Vector _keys = new Vector(0);
    Vector _cols = new Vector(0);
    Vector _levels = new Vector(0);
    Vector _levColumns = new Vector(0);
    Vector _dimList = new Vector(0);
    Vector _measures = new Vector(0);
    Vector _measCols = new Vector(0);
    private boolean valid = true;
    private boolean warning = false;
    private StringBuffer validationSB;
    private StringBuffer warningsSB;
    private List globMeas = new ArrayList();
    private ProgressDialog monitor;
    private Interaction curInteraction;
    private String fileName;
    private boolean buildAW = true;
    private Map measMap = new TreeMap();
    private boolean validated = false;
    private String LD_NAME = "Long_Description";
    private String SD_NAME = "Short_Description";
    private String END_DATE_NAME = "End_Date";
    private String TIME_SPAN_NAME = "Time_Span";
    private String err;
    private Design design;
    boolean atached = false;
    boolean created = false;
    boolean commited = false;
    List selectedObjects;
    List globLevDesc = new ArrayList();
    boolean validTimeDim = true;
    Map awdimTOdim = new TreeMap();
    Map levMap = new TreeMap();
    private List sortedMeasures = new ArrayList();
    private List tracedMeasures = new ArrayList();
    List measureDependencies;
    boolean cyclicRef = false;
    boolean error = false;
    StringBuffer eb = new StringBuffer();
    private boolean overwrite = false;
    private Map awmeasToMeasure = new TreeMap();
    private Map awmeasMap = new TreeMap();
    private Map additionalAWMeasures = new TreeMap();
    private Map oldNewMap = new TreeMap();
    private List exportedMeasures = new ArrayList();
    private List exportedFolders = new ArrayList();
    private List awMeasureFolders = new ArrayList();

    public OracleAWExporter(ApplicationView applicationView) {
        this.appView = applicationView;
        this.design = applicationView.getCurrentDesign();
    }

    public void export() {
        this.warningsSB = new StringBuffer("  There are warnings generated during validation phase:\n\n");
        this.validationSB = new StringBuffer("  There are errors during validation phase!\n\n");
        this.mdmDesign = this.tmdmDesign = this.design.getMultidimensionalDesign();
        this.physDesign = this.tphysDesign = this.design.getRelationalDesign();
        if (this.design.getMultidimensionalDesigns().size() == 1 && this.design.getRelationalDesigns().size() == 1) {
            this.validate();
        }
        if (this.valid) {
            boolean bl;
            CustomDialog customDialog;
            if (this.validated && this.warning) {
                customDialog = new LogReport(this.appView);
                ((LogReport)customDialog).setName("Validation Log");
                ((LogReport)customDialog).setLog(this.warningsSB.toString());
                ((LogReport)customDialog).showModalDialog(new Dimension(750, 550));
            }
            if (bl = ((AWExportOptions)(customDialog = new AWExportOptions(this.getApplicationView()))).showDialog()) {
                this.mdmDesign = ((AWExportOptions)customDialog).getMultidimensionalDesign();
                this.schema = ((AWExportOptions)customDialog).getSchema();
                this.storDesign = ((AWExportOptions)customDialog).getStorageDesign();
                this.physDesign = ((AWExportOptions)customDialog).getPhysicalDesign();
                this.connection = ((AWExportOptions)customDialog).getConnection();
                this.awName = ((AWExportOptions)customDialog).getAWName();
                this.buildAW = ((AWExportOptions)customDialog).isPopulateCubes();
                this.exportType = ((AWExportOptions)customDialog).getExportMode();
                this.fileName = ((AWExportOptions)customDialog).getFileName();
                this.selectedObjects = ((AWExportOptions)customDialog).getSelectedObjects();
                if (this.mdmDesign != null) {
                    if (!this.validated) {
                        this.validate();
                    }
                    if (this.valid) {
                        if (this.exportType.equals(EXPORT_METADATA_TO_FILE)) {
                            new Thread(new Runner()).start();
                        } else if (this.validConnection()) {
                            if (this.exportType.equals(EXPORT_ALL_CALC_MEASURES) || this.exportType.equals(EXPORT_NEW_CALC_MEASURES)) {
                                new Thread(new CalcMeasuresRunner()).start();
                            } else {
                                new Thread(new Runner()).start();
                            }
                        }
                    } else {
                        LogReport logReport = new LogReport(this.appView);
                        logReport.setName("Validation Log");
                        if (this.warning) {
                            logReport.setLog(this.validationSB.toString() + "\n\n" + this.warningsSB.toString());
                        } else {
                            logReport.setLog(this.validationSB.toString());
                        }
                        logReport.setLog(this.validationSB.toString());
                        logReport.showDialog(new Dimension(750, 550));
                    }
                }
            }
        } else {
            LogReport logReport = new LogReport(this.appView);
            logReport.setName("Validation Log");
            if (this.warning) {
                logReport.setLog(this.validationSB.toString() + "\n\n" + this.warningsSB.toString());
            } else {
                logReport.setLog(this.validationSB.toString());
            }
            logReport.showDialog(new Dimension(750, 550));
        }
    }

    private void validate() {
        AbstractMDObject abstractMDObject;
        Iterator iterator = this.mdmDesign.getLevelSet().iterator();
        while (iterator.hasNext()) {
            abstractMDObject = (oracle.dbtools.crest.model.design.multidimensional.Level)iterator.next();
            this.validateLevel((oracle.dbtools.crest.model.design.multidimensional.Level)abstractMDObject);
        }
        iterator = this.mdmDesign.getDimensionSet().iterator();
        while (iterator.hasNext()) {
            abstractMDObject = (oracle.dbtools.crest.model.design.multidimensional.Dimension)iterator.next();
            this.validateDimension((oracle.dbtools.crest.model.design.multidimensional.Dimension)abstractMDObject);
        }
        iterator = this.mdmDesign.getCubeSet().iterator();
        while (iterator.hasNext()) {
            abstractMDObject = (Cube)iterator.next();
            this.validateCube((Cube)abstractMDObject);
        }
    }

    private void createAW() {
        this.addDimensions();
    }

    private boolean validConnection() {
        try {
            int n = this.connectString.indexOf(64);
            if (n >= 0) {
                this.connectString = this.connectString.substring(n + 1);
            }
            System.out.println("Connecting to " + this.connectString);
            if (!(this.connection instanceof OracleConnection)) {
                throw new Exception();
            }
            this.awConnection = new AWConnection((OracleConnection)this.connection);
        }
        catch (Exception exception) {
            System.out.println("Error connecting to " + this.connectString + ".\n" + exception);
            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("OracleAWExporter.ErrorConnectingTo"), this.connectString) + exception.getLocalizedMessage(), Messages.getString("OracleAWExporter.Error"), 0);
            this.closeConnection();
            return false;
        }
        return true;
    }

    private void deleteExistingAW(AWConnection aWConnection, String string, String string2) {
        try {
            OracleConnection oracleConnection = (OracleConnection)aWConnection.getSQLConnection();
            SPLExecutor sPLExecutor = new SPLExecutor(oracleConnection);
            sPLExecutor.initialize();
            try {
                System.out.println("Deleting " + string + "." + string2 + " if it exists.");
                sPLExecutor.executeCommand("aw delete " + string + "." + string2);
                System.out.println("Deleted " + string + "." + string2 + ".");
            }
            catch (Exception exception) {
                String string3 = exception.toString();
                String string4 = "";
                if (string3.indexOf("ORA-33276") > -1) {
                    string4 = MessageFormat.format(Messages.getString("OracleAWExporter.AnalyticWorkspaceAttached"), string, string2);
                    this.atached = true;
                } else {
                    if (string3.indexOf("ORA-33262") > -1) {
                        return;
                    }
                    string4 = string3;
                }
                System.out.println(string4);
            }
        }
        catch (SQLException sQLException) {
            System.out.println("Could not initialize the SPL executor. " + sQLException);
        }
    }

    private boolean readAWDefinitions(AWConnection aWConnection, String string, String string2) {
        try {
            this.globalAW = AW.readAWDefinitions((AWConnection)aWConnection, (String)string2, (String)"RW");
        }
        catch (Exception exception) {
            String string3 = exception.toString();
            String string4 = "";
            if (string3.indexOf("ORA-33276") > -1) {
                string4 = MessageFormat.format(Messages.getString("OracleAWExporter.AnalyticWorkspaceAttached"), string, string2);
                this.atached = true;
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), string4, Messages.getString("OracleAWExporter.Error"), 0);
            } else if (string3.indexOf("ORA-33262") > -1) {
                string4 = MessageFormat.format(Messages.getString("OracleAWExporter.AnalyticWorkspaceDoesntExist"), string, string2);
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), string4, Messages.getString("OracleAWExporter.Error"), 0);
            } else if (string3.indexOf("ORA-34344") > -1) {
                string4 = MessageFormat.format(Messages.getString("OracleAWExporter.AnalyticWorkspaceDoesntExistOrAttached"), string, string2);
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), string4, Messages.getString("OracleAWExporter.Error"), 0);
            } else {
                string4 = string3;
            }
            System.out.println(string4);
            LOGGER.error("Error in reading Analytic Workspace definitions: ", exception);
            return false;
        }
        return true;
    }

    private ModelIDObject getCorrespondentObject(ModelIDObject modelIDObject) {
        if (this.storDesign != null) {
            Column column;
            if (modelIDObject instanceof Entity) {
                Table table = ((Entity)modelIDObject).getEngTable(this.physDesign);
                if (table != null) {
                    TableProxy tableProxy = (TableProxy)this.storDesign.getTableProxySet().getProxy(table.getObjectID());
                    return tableProxy;
                }
            } else if (modelIDObject instanceof Attribute && (column = ((Attribute)modelIDObject).getEngColumn(this.physDesign)) != null) {
                return this.storDesign.getColumnProxySet().getProxy(column.getObjectID());
            }
        } else {
            if (modelIDObject instanceof Entity) {
                Table table = ((Entity)modelIDObject).getEngTable(this.physDesign);
                if (table == null) {
                    return modelIDObject;
                }
                return table;
            }
            if (modelIDObject instanceof Attribute) {
                Column column = ((Attribute)modelIDObject).getEngColumn(this.physDesign);
                if (column == null) {
                    return modelIDObject;
                }
                return column;
            }
        }
        return modelIDObject;
    }

    private String getSchema(ModelIDObject modelIDObject) {
        ModelIDObject modelIDObject2;
        String string = null;
        if (modelIDObject instanceof TableProxy) {
            string = this.getSchemaImplementation((TableProxy)modelIDObject);
        } else if (modelIDObject instanceof Entity) {
            ModelIDObject modelIDObject3 = this.getCorrespondentObject(modelIDObject);
            if (modelIDObject3 instanceof TableProxy) {
                string = this.getSchemaImplementation((TableProxy)modelIDObject3);
            }
        } else if (modelIDObject instanceof Attribute) {
            ModelIDObject modelIDObject4 = this.getCorrespondentObject(((Attribute)modelIDObject).getContainerWithKeyObject());
            if (modelIDObject4 instanceof TableProxy) {
                string = this.getSchemaImplementation((TableProxy)modelIDObject4);
            }
        } else if (modelIDObject instanceof CalculatedAttribute && (modelIDObject2 = this.getCorrespondentObject(((CalculatedAttribute)modelIDObject).getLevel().getLevelEntity())) instanceof TableProxy) {
            string = this.getSchemaImplementation((TableProxy)modelIDObject2);
        }
        if (string != null && !"".equals(string)) {
            return string;
        }
        return this.schema;
    }

    private String getSchemaImplementation(TableProxy tableProxy) {
        StorageObject storageObject = tableProxy.getUserSchema();
        if (storageObject != null) {
            return storageObject.getName();
        }
        String string = tableProxy.getSchemaImplementationName();
        if (!"".equals(string)) {
            return string;
        }
        return null;
    }

    public void clearCubeMapVectors() {
        this._measures.removeAllElements();
        this._measCols.removeAllElements();
        this._levels.removeAllElements();
        this._cols.removeAllElements();
        this._dimList.removeAllElements();
    }

    public void associateCubeDimensions(oracle.AWXML.Cube cube, Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            CubeDimRef cubeDimRef = cube.createCubeDimRef();
            oracle.AWXML.Dimension dimension = (oracle.AWXML.Dimension)vector.elementAt(i);
            cubeDimRef.setDimension(dimension);
        }
    }

    public void createCubeMap(oracle.AWXML.Cube cube, Vector vector, Vector vector2, Vector vector3, Vector vector4) {
        SourceColumn sourceColumn;
        StringTokenizer stringTokenizer;
        Object object;
        CubeDimensionSourceExpression cubeDimensionSourceExpression;
        int n;
        CubeMapGroup cubeMapGroup = cube.createSourceCubeMapGroup();
        for (n = 0; n < vector.size(); ++n) {
            cubeDimensionSourceExpression = cubeMapGroup.CreateKeyMap();
            object = vector.elementAt(n);
            if (object instanceof Level) {
                cubeDimensionSourceExpression.addLevel((Level)object);
                cubeDimensionSourceExpression.setTargetObject(((Level)object).getOwner());
            } else if (object instanceof oracle.AWXML.Dimension) {
                cubeDimensionSourceExpression.setDimension((oracle.AWXML.Dimension)object);
                cubeDimensionSourceExpression.setTargetObject((BaseObject)object);
            }
            stringTokenizer = new StringTokenizer((String)vector2.elementAt(n), ",");
            while (stringTokenizer.hasMoreTokens()) {
                sourceColumn = cubeDimensionSourceExpression.CreateSourceColumn();
                sourceColumn.setColumn(stringTokenizer.nextToken());
            }
        }
        for (n = 0; n < vector3.size(); ++n) {
            cubeDimensionSourceExpression = (Measure)vector3.elementAt(n);
            cubeDimensionSourceExpression.setAutoSolve("NO_AUTO_SOLVE");
            object = (String)vector4.elementAt(n);
            stringTokenizer = cubeMapGroup.CreateAttributeMap();
            stringTokenizer.setTargetObject((BaseObject)cubeDimensionSourceExpression);
            sourceColumn = stringTokenizer.CreateSourceColumn();
            sourceColumn.setColumn(object);
        }
    }

    public void createCubeMap2(oracle.AWXML.Cube cube, Cube cube2, Vector vector, Vector vector2, Vector vector3, List list) {
        Object object;
        Object object2;
        Object object3;
        CubeDimensionSourceExpression cubeDimensionSourceExpression;
        int n;
        CubeMapGroup cubeMapGroup = cube.createSourceCubeMapGroup();
        for (n = 0; n < vector.size(); ++n) {
            cubeDimensionSourceExpression = cubeMapGroup.CreateKeyMap();
            object3 = (LevelDesc)vector.elementAt(n);
            if (((LevelDesc)object3).level != null && ((LevelDesc)object3).level.isValueBasedHierarchy()) {
                cubeDimensionSourceExpression.setDimension(((LevelDesc)object3).odimension);
                cubeDimensionSourceExpression.setTargetObject((BaseObject)((LevelDesc)object3).odimension);
            } else {
                cubeDimensionSourceExpression.addLevel(((LevelDesc)object3).olevel);
                cubeDimensionSourceExpression.setTargetObject(((LevelDesc)object3).olevel.getOwner());
            }
            for (Object object4 : cube2.getRollUpLink(((LevelDesc)object3).dim).getChildToParentAttributes()) {
                object2 = this.getCorrespondentObject((ModelIDObject)object4);
                if (object2 == null) continue;
                object = this.getSchema((ModelIDObject)object4) + "." + ((ModelObject)object2).getLongName();
                SourceColumn sourceColumn = cubeDimensionSourceExpression.CreateSourceColumn();
                sourceColumn.setColumn(((String)object).toUpperCase());
            }
        }
        for (n = 0; n < vector2.size(); ++n) {
            Object object4;
            cubeDimensionSourceExpression = (Measure)vector2.elementAt(n);
            cubeDimensionSourceExpression.setAutoSolve("NO_AUTO_SOLVE");
            object3 = (String)vector3.elementAt(n);
            MeasureSourceExpression measureSourceExpression = cubeMapGroup.CreateAttributeMap();
            measureSourceExpression.setTargetObject((BaseObject)cubeDimensionSourceExpression);
            object4 = measureSourceExpression.CreateSourceColumn();
            object4.setColumn((String)object3);
            object2 = (String)list.get(n);
            if ("".equals(object2)) continue;
            object = measureSourceExpression.createRestriction();
            object.setWhereClause((String)object2);
        }
    }

    private void addDimensions() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Iterator iterator = this.mdmDesign.getDimensionSet().iterator();
        while (iterator.hasNext()) {
            Object object = (oracle.dbtools.crest.model.design.multidimensional.Dimension)iterator.next();
            this.addDimension((oracle.dbtools.crest.model.design.multidimensional.Dimension)object);
        }
        for (Object object : this.selectedObjects) {
            AbstractMDObject abstractMDObject;
            if (((AWExportOptions.SelObject)object).object instanceof Cube && ((AWExportOptions.SelObject)object).selected) {
                Object object2;
                Object object3;
                Object object4;
                Object object52;
                abstractMDObject = (Cube)((AWExportOptions.SelObject)object).object;
                if (((Cube)abstractMDObject).hasRolePlayingDimensions()) continue;
                this.clearCubeMapVectors();
                oracle.AWXML.Cube cube = this.globalAW.createCube();
                String string = abstractMDObject.getName().replaceAll(" ", "_");
                cube.setName(string);
                cube.setLongName(abstractMDObject.getOracleLongName());
                cube.setShortName(abstractMDObject.getOracleShortName());
                abstractMDObject.setNameInOracleAW(cube.getName());
                Vector<oracle.AWXML.Dimension> vector = new Vector<oracle.AWXML.Dimension>(((Cube)abstractMDObject).getDimensions().size());
                for (Object object52 : ((Cube)abstractMDObject).getDimensions()) {
                    object4 = (oracle.AWXML.Dimension)this.dimMap.get(((ModelIDObject)object52).getObjectID());
                    vector.add((oracle.AWXML.Dimension)object4);
                    object3 = null;
                    if (((oracle.dbtools.crest.model.design.multidimensional.Dimension)object52).getBaseLevel() == null) continue;
                    object3 = ((oracle.dbtools.crest.model.design.multidimensional.Dimension)object52).getBaseLevel();
                    object2 = this.getLevelDesc(this.globLevDesc, (oracle.dbtools.crest.model.design.multidimensional.Level)object3, (oracle.dbtools.crest.model.design.multidimensional.Dimension)object52);
                    if (((oracle.dbtools.crest.model.design.multidimensional.Level)object3).isValueBasedHierarchy()) {
                        if (object2 != null) {
                            ((LevelDesc)object2).olevel = null;
                        } else {
                            object2 = new LevelDesc();
                            ((LevelDesc)object2).olevel = null;
                        }
                    }
                    if (object2 == null) continue;
                    ((LevelDesc)object2).odimension = object4;
                    ((LevelDesc)object2).dim = object52;
                    ((LevelDesc)object2).level = object3;
                    this._levels.add(object2);
                }
                object52 = "STANDARD";
                if (((Cube)abstractMDObject).isCompressedComposites()) {
                    object52 = "COMPRESSED";
                }
                cube.setSparseType((String)object52);
                cube.setUseGlobalIndex(Boolean.valueOf(((Cube)abstractMDObject).isUseGlobalComposites()));
                if (((Cube)abstractMDObject).isPartitioned() && ((Cube)abstractMDObject).getPartHierarchy() != null && ((Cube)abstractMDObject).getPartLevel() != null) {
                    object4 = (Hierarchy)this.hierMap.get(((Cube)abstractMDObject).getPartHierarchy().getObjectID());
                    object3 = (Level)this.levMap.get(((Cube)abstractMDObject).getPartLevel().getObjectID() + ((Cube)abstractMDObject).getPartDimension().getObjectID());
                    cube.setPartitionHierarchy((Hierarchy)object4);
                    cube.setPartitionLevel((Level)object3);
                }
                this.associateCubeDimensions(cube, vector);
                this.sortedMeasures.clear();
                this.tracedMeasures.clear();
                this.sortMeasures(((Cube)abstractMDObject).getMeasures());
                object4 = new ArrayList();
                object3 = this.sortedMeasures.iterator();
                object2 = new ArrayList();
                while (object3.hasNext()) {
                    oracle.dbtools.crest.model.design.multidimensional.Measure measure = (oracle.dbtools.crest.model.design.multidimensional.Measure)object3.next();
                    if (!measure.isFormula() && !measure.isFactDimension()) {
                        String string2;
                        Object object6;
                        ContainedObject containedObject = measure.getMeasureFact();
                        if (containedObject != null && (object6 = this.getCorrespondentObject(containedObject)) != null) {
                            string2 = this.getSchema(containedObject) + "." + ((ModelObject)object6).getLongName();
                            this._measCols.add(string2.toUpperCase());
                            object4.add(measure.getWhereClause().trim());
                        }
                        object6 = cube.createMeasure();
                        string2 = measure.getName().replaceAll(" ", "_");
                        string2 = string2.replaceAll("[(]", "_");
                        string2 = string2.replaceAll("[)]", "_");
                        object6.setName(string2);
                        object6.setShortName(measure.getOracleShortName());
                        object6.setLongName(measure.getOracleLongName());
                        object6.setPluralName(measure.getOraclePluralName());
                        measure.setNameInOracleAW(object6.getName());
                        this._measures.add(object6);
                        arrayList.add(object6);
                        MeasureDesc measureDesc = new MeasureDesc();
                        measureDesc.awmeasure = object6;
                        measureDesc.awmeasureName = string2;
                        measureDesc.measure = measure;
                        this.globMeas.add(measureDesc);
                        this.measMap.put(measure.getObjectID(), object6);
                        object2.add(measureDesc);
                        continue;
                    }
                    if (measure.isFactDimension()) continue;
                    if (measure.isDefinedAsOracleAWCalculated() && measure.getOracleAWFormulaType().equalsIgnoreCase(oracle.dbtools.crest.model.design.multidimensional.Measure.AW_OLAP_FORMULA)) {
                        this.createOLAPMeasure(cube, measure, null, null);
                        continue;
                    }
                    this.createDerivedMeasure(cube, measure, null, null);
                }
                this.createCubeMap2(cube, (Cube)abstractMDObject, this._levels, this._measures, this._measCols, (List)object4);
                this.precomputeNA(cube, "AGGMAP_" + string, (Cube)abstractMDObject);
                this.precomputeMeasureForCubeNA(cube, (Cube)abstractMDObject, (List)object2);
                continue;
            }
            if (!(((AWExportOptions.SelObject)object).object instanceof Slice) || !((AWExportOptions.SelObject)object).selected) continue;
            abstractMDObject = (Slice)((AWExportOptions.SelObject)object).object;
            this.createSlice((Slice)abstractMDObject);
        }
        this.addMeasureFolders();
    }

    private void addMeasureFolder(MeasureFolder measureFolder, oracle.AWXML.MeasureFolder measureFolder2, boolean bl) {
        Object object;
        oracle.AWXML.MeasureFolder measureFolder3 = null;
        measureFolder3 = measureFolder2 != null ? measureFolder2.createMeasureFolder() : this.globalAW.createMeasureFolder();
        measureFolder3.setName(measureFolder.getName().toUpperCase().replaceAll(" ", "_"));
        measureFolder3.setShortName(measureFolder.getOracleShortName());
        measureFolder3.setLongName(measureFolder.getOracleLongName());
        measureFolder3.setPluralName(measureFolder.getOraclePluralName());
        measureFolder.setNameInOracleAW(measureFolder3.getName());
        for (int i = 0; i < measureFolder.getMeasures().size(); ++i) {
            Measure measure;
            ID_ObjectPropertyTranslator iD_ObjectPropertyTranslator;
            object = (MeasureFolder.MFElement)measureFolder.getMeasures().get(i);
            if (((MeasureFolder.MFElement)object).isMeasureWrapper()) {
                iD_ObjectPropertyTranslator = (Slice.MeasureWrapper)((MeasureFolder.MFElement)object).getMeasure();
                measure = (Measure)this.measMap.get(this.makeMeasureID((Slice)((MeasureFolder.MFElement)object).getParent(), (Slice.MeasureWrapper)iD_ObjectPropertyTranslator));
            } else {
                iD_ObjectPropertyTranslator = (oracle.dbtools.crest.model.design.multidimensional.Measure)((MeasureFolder.MFElement)object).getMeasure();
                measure = (Measure)this.measMap.get(((ModelIDObject)iD_ObjectPropertyTranslator).getObjectID());
            }
            if (measure == null) continue;
            measureFolder3.addMeasure(measure);
        }
        Iterator iterator = this.mdmDesign.getMeasureFolderSet().iterator();
        while (iterator.hasNext()) {
            object = (MeasureFolder)iterator.next();
            if (((MeasureFolder)object).getParentFolder() != measureFolder) continue;
            this.addMeasureFolder((MeasureFolder)object, measureFolder3, bl);
        }
        if (bl && measureFolder2 == null) {
            measureFolder3.Create(this.awConnection);
            this.exportedFolders.add(measureFolder3);
        }
    }

    private void addMeasureFolders() {
        Iterator iterator = this.mdmDesign.getMeasureFolderSet().iterator();
        while (iterator.hasNext()) {
            MeasureFolder measureFolder = (MeasureFolder)iterator.next();
            if (measureFolder.getParentFolder() != null) continue;
            this.addMeasureFolder(measureFolder, null, false);
        }
    }

    private boolean sliceContainsDimension(Slice slice, oracle.dbtools.crest.model.design.multidimensional.Dimension dimension) {
        for (Slice.SelectedLevel selectedLevel : slice.getSelectedLevels()) {
            if (selectedLevel.getDimension() != dimension) continue;
            return true;
        }
        return false;
    }

    private String makeMeasureID(Slice slice, Slice.MeasureWrapper measureWrapper) {
        String string = slice.getObjectID() + measureWrapper.getMeasure().getObjectID() + String.valueOf(measureWrapper.getAggrFunction().getObjectID());
        return string;
    }

    private void createSlice(Slice slice) {
        Object object;
        Object object2;
        Object object32;
        Cube cube = slice.getCube();
        boolean bl = false;
        this.clearCubeMapVectors();
        oracle.AWXML.Cube cube2 = this.globalAW.createCube();
        String string = slice.getName().replaceAll(" ", "_");
        cube2.setName(string);
        cube2.setLongName(slice.getName() + " - generated from Oracle SQL Developer Modeling Slice in Cube: " + slice.getCube().getName());
        slice.setNameInOracleAW(cube2.getName());
        Vector<oracle.AWXML.Dimension> vector = new Vector<oracle.AWXML.Dimension>(slice.getSelectedLevels().size());
        for (Object object32 : slice.getSelectedLevels()) {
            object2 = ((Slice.SelectedLevel)object32).getDimension();
            oracle.AWXML.Dimension dimension = (oracle.AWXML.Dimension)this.dimMap.get(((ModelIDObject)object2).getObjectID());
            vector.add(dimension);
            ID_ObjectPropertyTranslator iD_ObjectPropertyTranslator = null;
            if (((oracle.dbtools.crest.model.design.multidimensional.Dimension)object2).getBaseLevel() == null) continue;
            iD_ObjectPropertyTranslator = ((oracle.dbtools.crest.model.design.multidimensional.Dimension)object2).getBaseLevel();
            object = this.getLevelDesc(this.globLevDesc, (oracle.dbtools.crest.model.design.multidimensional.Level)iD_ObjectPropertyTranslator, (oracle.dbtools.crest.model.design.multidimensional.Dimension)object2);
            if (((oracle.dbtools.crest.model.design.multidimensional.Level)iD_ObjectPropertyTranslator).isValueBasedHierarchy()) {
                if (object != null) {
                    ((LevelDesc)object).olevel = null;
                } else {
                    object = new LevelDesc();
                    ((LevelDesc)object).olevel = null;
                }
            }
            ((LevelDesc)object).odimension = dimension;
            ((LevelDesc)object).dim = object2;
            ((LevelDesc)object).level = iD_ObjectPropertyTranslator;
            this._levels.add(object);
        }
        this.associateCubeDimensions(cube2, vector);
        if (cube.isPartitioned() && cube.getPartHierarchy() != null && cube.getPartLevel() != null && this.sliceContainsDimension(slice, cube.getPartDimension())) {
            object32 = (Hierarchy)this.hierMap.get(cube.getPartHierarchy().getObjectID());
            object2 = (Level)this.levMap.get(cube.getPartLevel().getObjectID() + cube.getPartDimension().getObjectID());
            cube2.setPartitionHierarchy((Hierarchy)object32);
            cube2.setPartitionLevel((Level)object2);
        }
        object32 = new ArrayList();
        slice.verifyMeasureWrappers();
        this.sortedMeasures.clear();
        this.tracedMeasures.clear();
        this.sortMeasures(slice.getCube().getMeasures());
        object2 = new ArrayList();
        for (ID_ObjectPropertyTranslator iD_ObjectPropertyTranslator : this.sortSliceMeasureWrappers(this.sortedMeasures, slice.getSelectedMeasureWrappers())) {
            object = ((Slice.MeasureWrapper)iD_ObjectPropertyTranslator).getMeasure();
            if (!((oracle.dbtools.crest.model.design.multidimensional.Measure)object).isFormula() && !((oracle.dbtools.crest.model.design.multidimensional.Measure)object).isFactDimension()) {
                Object object4;
                Object object5;
                Object object6;
                ContainedObject containedObject = ((oracle.dbtools.crest.model.design.multidimensional.Measure)object).getMeasureFact();
                if (containedObject != null && (object6 = this.getCorrespondentObject(containedObject)) != null) {
                    object5 = this.getSchema(containedObject) + "." + ((ModelObject)object6).getLongName();
                    this._measCols.add(((String)object5).toUpperCase());
                    object2.add(slice.getWhereClauseFor((Slice.MeasureWrapper)iD_ObjectPropertyTranslator));
                }
                object6 = cube2.createMeasure();
                object5 = ((DesignObject)object).getName().replaceAll(" ", "_");
                object5 = ((String)object5).replaceAll("[(]", "_");
                if (this.existsMeasureName((String)(object5 = ((String)object5).replaceAll("[)]", "_")))) {
                    object4 = ((Slice.MeasureWrapper)iD_ObjectPropertyTranslator).getAggrFunction().measureAlias;
                    object5 = this.existsMeasureName((String)object4) ? (this.existsMeasureName((String)(object4 = (String)object5 + "_" + string)) ? this.produceUniqueMeasureName((String)object5) : object4) : object4;
                }
                object6.setName((String)object5);
                object6.setShortName(((AbstractMDObject)object).getOracleShortName());
                object6.setLongName(((AbstractMDObject)object).getOracleLongName());
                object6.setPluralName(((AbstractMDObject)object).getOraclePluralName());
                ((AbstractMDObject)object).setNameInOracleAW(object6.getName());
                this._measures.add(object6);
                object4 = new MeasureDesc();
                ((MeasureDesc)object4).awmeasure = object6;
                ((MeasureDesc)object4).awmeasureName = object5;
                ((MeasureDesc)object4).measure = null;
                ((MeasureDesc)object4).mwrapper = iD_ObjectPropertyTranslator;
                this.globMeas.add(object4);
                this.measMap.put(this.makeMeasureID(slice, (Slice.MeasureWrapper)iD_ObjectPropertyTranslator), object6);
                object32.add(object4);
                continue;
            }
            if (((oracle.dbtools.crest.model.design.multidimensional.Measure)object).isDefinedAsOracleAWCalculated() && ((oracle.dbtools.crest.model.design.multidimensional.Measure)object).getOracleAWFormulaType().equalsIgnoreCase(oracle.dbtools.crest.model.design.multidimensional.Measure.AW_OLAP_FORMULA)) {
                this.createOLAPMeasure(cube2, (oracle.dbtools.crest.model.design.multidimensional.Measure)object, slice, (Slice.MeasureWrapper)iD_ObjectPropertyTranslator);
                continue;
            }
            this.createDerivedMeasure(cube2, (oracle.dbtools.crest.model.design.multidimensional.Measure)object, slice, (Slice.MeasureWrapper)iD_ObjectPropertyTranslator);
        }
        if (!bl) {
            this.createCubeMap2(cube2, slice.getCube(), this._levels, this._measures, this._measCols, (List)object2);
            this.precomputeNA(cube2, "AGGMAP_" + string, slice.getCube());
            this.precomputeMeasureForSliceNA(cube2, slice, (List)object32);
        }
    }

    private List sortSliceMeasureWrappers(List list, List list2) {
        ArrayList<Slice.MeasureWrapper> arrayList = new ArrayList<Slice.MeasureWrapper>();
        Object[] objectArray = list2.toArray();
        int n = list2.size();
        Iterator iterator = list.iterator();
        while (n > 0 && iterator.hasNext()) {
            oracle.dbtools.crest.model.design.multidimensional.Measure measure = (oracle.dbtools.crest.model.design.multidimensional.Measure)iterator.next();
            for (int i = 0; i < objectArray.length; ++i) {
                if (n > 0) {
                    Slice.MeasureWrapper measureWrapper = (Slice.MeasureWrapper)objectArray[i];
                    if (measureWrapper == null || measureWrapper.getMeasure() != measure) continue;
                    arrayList.add(measureWrapper);
                    objectArray[i] = null;
                    --n;
                    continue;
                }
                return arrayList;
            }
        }
        return arrayList;
    }

    private boolean existsMeasureName(String string) {
        for (MeasureDesc measureDesc : this.globMeas) {
            if (!measureDesc.awmeasure.getName().equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    private String produceUniqueMeasureName(String string) {
        int n = 0;
        if (this.existsMeasureName(string)) {
            String string2;
            while (this.existsMeasureName(string2 = string + "_" + Integer.toString(++n))) {
            }
            return string2;
        }
        return string;
    }

    private boolean getSparseFor(Cube cube, oracle.dbtools.crest.model.design.multidimensional.Dimension dimension) {
        RollupLink rollupLink = cube.getRollUpLink(dimension);
        if (rollupLink != null) {
            return rollupLink.isSparseDimension();
        }
        return false;
    }

    private String getOperatorFor(Cube cube, oracle.dbtools.crest.model.design.multidimensional.Dimension dimension) {
        RollupLink rollupLink = cube.getRollUpLink(dimension);
        if (rollupLink != null) {
            return rollupLink.getDefaultAggregationOperator();
        }
        return "SUM";
    }

    private void precomputeNA(oracle.AWXML.Cube cube, String string, Cube cube2) {
        AggregationDefinition aggregationDefinition = cube.getDefaultAggregationDefinition();
        if (aggregationDefinition == null) {
            aggregationDefinition = cube.createAggregationDefinition();
            cube.setDefaultAggregationDefinition(aggregationDefinition);
        }
        aggregationDefinition.setName(string);
        aggregationDefinition.getCalculationSpecification().clear();
        Vector vector = cube.getCubeDimRefs();
        for (CubeDimRef cubeDimRef : vector) {
            BaseOperator baseOperator;
            oracle.AWXML.Dimension dimension = cubeDimRef.getDimension();
            SolveDefDimRef solveDefDimRef = aggregationDefinition.createSolveDefDimRef();
            solveDefDimRef.setDimension(dimension);
            oracle.dbtools.crest.model.design.multidimensional.Dimension dimension2 = (oracle.dbtools.crest.model.design.multidimensional.Dimension)this.awdimTOdim.get(dimension.getName());
            cubeDimRef.setSparse(Boolean.valueOf(this.getSparseFor(cube2, dimension2)));
            String string2 = this.getOperatorFor(cube2, dimension2);
            AggregationHierarchySpecification aggregationHierarchySpecification = aggregationDefinition.createAggregationHierarchySpecification();
            aggregationHierarchySpecification.setDimension(dimension);
            ConfigurationParameters configurationParameters = new ConfigurationParameters((BaseObject)aggregationHierarchySpecification);
            this.setConfigurationParams(configurationParameters, true);
            aggregationHierarchySpecification.setAggregationArgument((AggregationArgument)configurationParameters);
            if (dimension2.getBaseLevel() != null && !dimension2.getBaseLevel().isValueBasedHierarchy()) {
                baseOperator = aggregationHierarchySpecification.createPreComputeClause();
                DimensionMemberExpression dimensionMemberExpression = baseOperator.createDimensionMemberExpression();
                dimensionMemberExpression.setExpression("ALL");
                dimensionMemberExpression.setExpressionType("EXCLUDE");
            }
            if ((baseOperator = (BaseOperator)aggregationHierarchySpecification.getAggregationOperator()) != null) {
                baseOperator.setOpcode(string2);
                continue;
            }
            baseOperator = new BaseOperator((BaseObject)aggregationHierarchySpecification);
            baseOperator.setOpcode(string2);
            aggregationHierarchySpecification.setAggregationOperator((AggregationOperator)baseOperator);
        }
    }

    private boolean validForDimension(oracle.dbtools.crest.model.design.multidimensional.Measure measure, oracle.dbtools.crest.model.design.multidimensional.Dimension dimension) {
        Measure.AggregateFunction aggregateFunction;
        return measure.getAdditivity().equalsIgnoreCase(oracle.dbtools.crest.model.design.multidimensional.Measure.SEMI_ADDITIVE) && (aggregateFunction = measure.getDefaultAggregationFunction()) != null && aggregateFunction.dimensions.indexOf(dimension) > -1;
    }

    private CubeDimRef getDimRefFor(oracle.AWXML.Cube cube, oracle.AWXML.Dimension dimension) {
        for (CubeDimRef cubeDimRef : cube.getCubeDimRefs()) {
            if (cubeDimRef.getDimension() != dimension) continue;
            return cubeDimRef;
        }
        return null;
    }

    public void precomputeMeasureForCubeNA(oracle.AWXML.Cube cube, Cube cube2, List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            AggregationDefinition aggregationDefinition = cube.createAggregationDefinition();
            MeasureDesc measureDesc = (MeasureDesc)iterator.next();
            oracle.dbtools.crest.model.design.multidimensional.Measure measure = measureDesc.measure;
            if (measure.isFactDimension()) continue;
            aggregationDefinition.setName(cube.getName() + "_" + measureDesc.awmeasure.getName());
            Measure.AggregateFunction aggregateFunction = measure.getDefaultAggregationFunction();
            String string = "NOAGG";
            if (aggregateFunction != null && !"".equals(aggregateFunction.name)) {
                string = aggregateFunction.name;
            }
            List list2 = aggregateFunction != null ? aggregateFunction.levels : null;
            for (oracle.dbtools.crest.model.design.multidimensional.Dimension dimension : cube2.getDimensions()) {
                BaseOperator baseOperator;
                oracle.AWXML.Dimension dimension2;
                CubeDimRef cubeDimRef;
                List list3 = dimension.getAllLevels();
                String string2 = string;
                if (measure.getAdditivity().equalsIgnoreCase(oracle.dbtools.crest.model.design.multidimensional.Measure.SEMI_ADDITIVE)) {
                    if (!this.validForDimension(measure, dimension)) {
                        string2 = "NOAGG";
                    }
                } else if (measure.getAdditivity().equalsIgnoreCase(oracle.dbtools.crest.model.design.multidimensional.Measure.NON_ADDITIVE)) {
                    string2 = "NOAGG";
                }
                if ((cubeDimRef = this.getDimRefFor(cube, dimension2 = (oracle.AWXML.Dimension)this.dimMap.get(dimension.getObjectID()))) != null) {
                    cubeDimRef.setSparse(Boolean.valueOf(this.getSparseFor(cube2, dimension)));
                }
                SolveDefDimRef solveDefDimRef = aggregationDefinition.createSolveDefDimRef();
                solveDefDimRef.setDimension(dimension2);
                AggregationHierarchySpecification aggregationHierarchySpecification = aggregationDefinition.createAggregationHierarchySpecification();
                aggregationHierarchySpecification.setDimension(dimension2);
                ConfigurationParameters configurationParameters = new ConfigurationParameters((BaseObject)aggregationHierarchySpecification);
                this.setConfigurationParams(configurationParameters, true);
                aggregationHierarchySpecification.setAggregationArgument((AggregationArgument)configurationParameters);
                PreComputeClause preComputeClause = aggregationHierarchySpecification.createPreComputeClause();
                DimensionMemberExpression dimensionMemberExpression = preComputeClause.createDimensionMemberExpression();
                dimensionMemberExpression.setExpression("ALL");
                dimensionMemberExpression.setExpressionType("EXCLUDE");
                if (dimension.getBaseLevel() != null && !dimension.getBaseLevel().isValueBasedHierarchy() && list2 != null) {
                    for (int i = 0; i < list2.size(); ++i) {
                        oracle.dbtools.crest.model.design.multidimensional.Level level = (oracle.dbtools.crest.model.design.multidimensional.Level)list2.get(i);
                        if (list3.indexOf(level) <= -1) continue;
                        dimensionMemberExpression = preComputeClause.createDimensionMemberExpression();
                        dimensionMemberExpression.setExpressionType("INCLUDE");
                        Level level2 = (Level)this.levMap.get(level.getObjectID() + dimension.getObjectID());
                        dimensionMemberExpression.setLevel(level2);
                    }
                }
                if ((baseOperator = (BaseOperator)aggregationHierarchySpecification.getAggregationOperator()) != null) {
                    baseOperator.setOpcode(string2);
                    continue;
                }
                baseOperator = new BaseOperator((BaseObject)aggregationHierarchySpecification);
                baseOperator.setOpcode(string2);
                aggregationHierarchySpecification.setAggregationOperator((AggregationOperator)baseOperator);
            }
            aggregationDefinition.setName(measureDesc.awmeasure.getName() + "_AGGM");
            measureDesc.awmeasure.setSolveDefinition((SolveDefinition)aggregationDefinition);
        }
    }

    public void precomputeMeasureForSliceNA(oracle.AWXML.Cube cube, Slice slice, List list) {
        Cube cube2 = slice.getCube();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            AggregationDefinition aggregationDefinition = cube.createAggregationDefinition();
            MeasureDesc measureDesc = (MeasureDesc)iterator.next();
            Slice.MeasureWrapper measureWrapper = measureDesc.mwrapper;
            oracle.dbtools.crest.model.design.multidimensional.Measure measure = measureWrapper.getMeasure();
            if (measure.isFactDimension()) continue;
            String string = cube.getName() + "_" + measureDesc.awmeasure.getName();
            if (string.length() > 30) {
                string = string.substring(0, 30);
            }
            aggregationDefinition.setName(cube.getName() + "_" + measureDesc.awmeasure.getName());
            Measure.AggregateFunction aggregateFunction = measureWrapper.getAggrFunction();
            String string2 = "NOAGG";
            if (aggregateFunction != null && !"".equals(aggregateFunction.name)) {
                string2 = aggregateFunction.name;
            }
            List list2 = aggregateFunction != null ? aggregateFunction.levels : null;
            for (Slice.SelectedLevel selectedLevel : slice.getSelectedLevels()) {
                BaseOperator baseOperator;
                oracle.AWXML.Dimension dimension;
                CubeDimRef cubeDimRef;
                oracle.dbtools.crest.model.design.multidimensional.Dimension dimension2 = selectedLevel.getDimension();
                List list3 = dimension2.getAllLevels();
                String string3 = string2;
                if (measure.getAdditivity().equalsIgnoreCase(oracle.dbtools.crest.model.design.multidimensional.Measure.SEMI_ADDITIVE)) {
                    if (!this.validForDimension(measure, dimension2)) {
                        string3 = "NOAGG";
                    }
                } else if (measure.getAdditivity().equalsIgnoreCase(oracle.dbtools.crest.model.design.multidimensional.Measure.NON_ADDITIVE)) {
                    string3 = "NOAGG";
                }
                if ((cubeDimRef = this.getDimRefFor(cube, dimension = (oracle.AWXML.Dimension)this.dimMap.get(dimension2.getObjectID()))) != null) {
                    cubeDimRef.setSparse(Boolean.valueOf(this.getSparseFor(cube2, dimension2)));
                }
                SolveDefDimRef solveDefDimRef = aggregationDefinition.createSolveDefDimRef();
                solveDefDimRef.setDimension(dimension);
                AggregationHierarchySpecification aggregationHierarchySpecification = aggregationDefinition.createAggregationHierarchySpecification();
                aggregationHierarchySpecification.setDimension(dimension);
                ConfigurationParameters configurationParameters = new ConfigurationParameters((BaseObject)aggregationHierarchySpecification);
                this.setConfigurationParams(configurationParameters, true);
                aggregationHierarchySpecification.setAggregationArgument((AggregationArgument)configurationParameters);
                PreComputeClause preComputeClause = aggregationHierarchySpecification.createPreComputeClause();
                DimensionMemberExpression dimensionMemberExpression = preComputeClause.createDimensionMemberExpression();
                dimensionMemberExpression.setExpression("ALL");
                dimensionMemberExpression.setExpressionType("EXCLUDE");
                if (dimension2.getBaseLevel() != null && !dimension2.getBaseLevel().isValueBasedHierarchy() && list2 != null) {
                    for (int i = 0; i < list2.size(); ++i) {
                        oracle.dbtools.crest.model.design.multidimensional.Level level = (oracle.dbtools.crest.model.design.multidimensional.Level)list2.get(i);
                        if (list3.indexOf(level) <= -1) continue;
                        dimensionMemberExpression = preComputeClause.createDimensionMemberExpression();
                        dimensionMemberExpression.setExpressionType("INCLUDE");
                        Level level2 = (Level)this.levMap.get(level.getObjectID() + dimension2.getObjectID());
                        dimensionMemberExpression.setLevel(level2);
                    }
                }
                if ((baseOperator = (BaseOperator)aggregationHierarchySpecification.getAggregationOperator()) != null) {
                    baseOperator.setOpcode(string3);
                    continue;
                }
                baseOperator = new BaseOperator((BaseObject)aggregationHierarchySpecification);
                baseOperator.setOpcode(string3);
                aggregationHierarchySpecification.setAggregationOperator((AggregationOperator)baseOperator);
            }
            aggregationDefinition.setName(measureDesc.awmeasure.getName() + "_AGGM");
            measureDesc.awmeasure.setSolveDefinition((SolveDefinition)aggregationDefinition);
        }
    }

    private void setConfigurationParams(ConfigurationParameters configurationParameters, boolean bl) {
        if (bl) {
            Parameter parameter = configurationParameters.createParameter();
            parameter.setKeyWord("NASKIP");
            parameter.setValue("YES");
        }
    }

    private void addDimension(oracle.dbtools.crest.model.design.multidimensional.Dimension dimension) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        oracle.dbtools.crest.model.design.multidimensional.Hierarchy hierarchy;
        Object object5;
        oracle.AWXML.Attribute attribute;
        Dimension.PermanentCalcMember permanentCalcMember2;
        oracle.AWXML.Attribute attribute2 = null;
        oracle.AWXML.Attribute attribute3 = null;
        ArrayList arrayList = new ArrayList();
        ArrayList<Hierarchy> arrayList2 = new ArrayList<Hierarchy>();
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
        String string = dimension.getName();
        oracle.AWXML.Dimension dimension2 = this.globalAW.createDimension();
        this.dimMap.put(dimension.getObjectID(), dimension2);
        dimension2.setName(string.replaceAll(" ", "_"));
        dimension2.setShortName(dimension.getOracleShortName());
        dimension2.setLongName(dimension.getOracleLongName());
        dimension2.setPluralName(dimension.getOraclePluralName());
        dimension.setNameInOracleAW(dimension2.getName());
        if (dimension.getBaseLevel() != null && dimension.getBaseLevel().isValueBasedHierarchy()) {
            dimension2.setUseNativeKey(true);
        } else {
            dimension2.setUseNativeKey(true);
        }
        this.awdimTOdim.put(dimension2.getName(), dimension);
        boolean bl = false;
        if (this.validTimeDim && dimension.isTimeDimension()) {
            dimension2.setIsTime(true);
            bl = true;
            attribute2 = dimension2.createAttribute();
            attribute3 = dimension2.createAttribute();
            attribute3.setName(this.END_DATE_NAME);
            attribute3.setClassification("END_DATE");
            attribute2.setName(this.TIME_SPAN_NAME);
            attribute2.setClassification("TIME_SPAN");
        }
        for (Dimension.PermanentCalcMember permanentCalcMember2 : dimension.getPermanentCalcMembers()) {
            if ("".equals(permanentCalcMember2.getExpression().trim())) continue;
            attribute = dimension2.createPermanentCalculatedMember();
            attribute.setName(permanentCalcMember2.getName().replaceAll(" ", "_"));
            attribute.setExpressionText(permanentCalcMember2.getExpression());
        }
        permanentCalcMember2 = this.createShortDescAttr(dimension2);
        attribute = this.createLongDescAttr(dimension2);
        Iterator iterator = dimension.getAllLevels().iterator();
        while (iterator.hasNext()) {
            this.clearLevelMapVectors();
            object5 = (oracle.dbtools.crest.model.design.multidimensional.Level)iterator.next();
            if (((oracle.dbtools.crest.model.design.multidimensional.Level)object5).isValueBasedHierarchy()) continue;
            hierarchy = dimension2.createLevel();
            this.levMap.put(((ModelIDObject)object5).getObjectID() + dimension.getObjectID(), hierarchy);
            object4 = new LevelDesc();
            object4.level = object5;
            object4.olevel = hierarchy;
            object4.dim = dimension;
            object4.odimension = dimension2;
            if (((oracle.dbtools.crest.model.design.multidimensional.Level)object5).getLevelKey().size() > 0) {
                object4.attribute = (Attribute)((oracle.dbtools.crest.model.design.multidimensional.Level)object5).getLevelKey().get(0);
                for (ID_ObjectPropertyTranslator iD_ObjectPropertyTranslator : ((oracle.dbtools.crest.model.design.multidimensional.Level)object5).getLevelKey()) {
                    object3 = this.getCorrespondentObject((ModelIDObject)iD_ObjectPropertyTranslator);
                    if (object3 == null) continue;
                    object2 = this.getSchema((ModelIDObject)iD_ObjectPropertyTranslator) + "." + ((ModelObject)object3).getLongName();
                    this._keys.add(object2);
                }
            }
            hierarchy.setName(((DesignObject)object5).getName().replaceAll(" ", "_"));
            hierarchy.setShortName(((AbstractMDObject)object5).getOracleShortName());
            hierarchy.setLongName(((AbstractMDObject)object5).getOracleLongName());
            hierarchy.setPluralName(((AbstractMDObject)object5).getOraclePluralName());
            ((AbstractMDObject)object5).setNameInOracleAW(hierarchy.getName());
            arrayList.clear();
            arrayList.addAll(((oracle.dbtools.crest.model.design.multidimensional.Level)object5).getDescriptiveAttributes());
            this.createSD_LD_TS_ED_Map(arrayList, (oracle.dbtools.crest.model.design.multidimensional.Level)object5, bl, (Level)hierarchy, dimension2);
            arrayList.clear();
            arrayList.addAll(((oracle.dbtools.crest.model.design.multidimensional.Level)object5).getSlowChangingAttributes());
            for (ID_ObjectPropertyTranslator iD_ObjectPropertyTranslator : arrayList) {
                object3 = ((SlowChangingAttribute)iD_ObjectPropertyTranslator).getAttribute();
                object2 = (oracle.AWXML.Attribute)treeMap.get(((ModelIDObject)object3).getObjectID());
                if (object2 == null) {
                    object2 = dimension2.createAttribute();
                    object2.setName(((SlowChangingAttribute)iD_ObjectPropertyTranslator).getName().replaceAll(" ", "_"));
                    treeMap.put(((ModelIDObject)object3).getObjectID(), object2);
                }
                if (((SlowChangingAttribute)iD_ObjectPropertyTranslator).isIndexed()) {
                    object = dimension2.createIndex();
                    object.setAttribute((oracle.AWXML.Attribute)object2);
                }
                this.setupAttributeProjection((Level)hierarchy, object2.getName(), (oracle.AWXML.Attribute)object2);
                object2.setClassification("USER");
                object = this.getCorrespondentObject((ModelIDObject)object3);
                if (object == null) continue;
                String string2 = this.getSchema((ModelIDObject)object3) + "." + ((ModelObject)object).getLongName();
                this._cols.add(string2);
            }
            this.createLevelMap((Level)hierarchy, this._keys, this._cols, dimension.getWhereClauseFor((oracle.dbtools.crest.model.design.multidimensional.Level)object5));
            arrayList2.add((Hierarchy)object4);
            this.globLevDesc.add(object4);
        }
        object5 = dimension.getHierarchies().iterator();
        while (object5.hasNext()) {
            hierarchy = (oracle.dbtools.crest.model.design.multidimensional.Hierarchy)object5.next();
            this.clearHierarchyMapVectors();
            object4 = dimension2.createHierarchy();
            object4.setName(hierarchy.getName().replaceAll(" ", "_"));
            hierarchy.setNameInOracleAW(object4.getName());
            this.hierMap.put(hierarchy.getObjectID(), object4);
            object4.setShortName(hierarchy.getOracleShortName());
            object4.setLongName(hierarchy.getOracleLongName());
            object4.setPluralName(hierarchy.getOraclePluralName());
            object4.setIsDefault(hierarchy.isDefaultHierarchy());
            for (int i = hierarchy.getLevels().size() - 1; i > -1; --i) {
                ID_ObjectPropertyTranslator iD_ObjectPropertyTranslator;
                iD_ObjectPropertyTranslator = (oracle.dbtools.crest.model.design.multidimensional.Level)hierarchy.getLevels().get(i);
                object3 = this.getLevelDesc(arrayList2, (oracle.dbtools.crest.model.design.multidimensional.Level)iD_ObjectPropertyTranslator, dimension);
                if (object3 == null) continue;
                this._levels.add(object3);
                object2 = this.getCorrespondentObject(((LevelDesc)object3).attribute);
                if (object2 == null) continue;
                object = this.getSchema(((LevelDesc)object3).attribute) + "." + ((ModelObject)object2).getLongName();
                this._levColumns.add(object);
            }
            if (hierarchy.isValueBasedHierarchy()) {
                this.createValubasedHierarchy(dimension2, (Hierarchy)object4, hierarchy, this._levColumns, attribute, (oracle.AWXML.Attribute)permanentCalcMember2, treeMap);
                continue;
            }
            this.createHierarchyMap2((Hierarchy)object4, this._levels, this._levColumns);
        }
    }

    private void createSD_LD_TS_ED_Map(List list, oracle.dbtools.crest.model.design.multidimensional.Level level, boolean bl, Level level2, oracle.AWXML.Dimension dimension) {
        Object object2;
        oracle.AWXML.Attribute attribute;
        Level.OraAWAttributes oraAWAttributes = level.getOraAWAttributes();
        ArrayList<Attribute> arrayList = new ArrayList<Attribute>();
        Attribute attribute2 = oraAWAttributes.shortDesc;
        if (attribute2 != null) {
            attribute = dimension.FindAttribute(this.SD_NAME);
            if (attribute != null) {
                this.setupAttributeProjection(level2, "Short Description", attribute);
            }
            arrayList.add(attribute2);
            object2 = this.getCorrespondentObject(attribute2);
            if (object2 != null) {
                String object3 = this.getSchema(attribute2) + "." + ((ModelObject)object2).getLongName();
                this._cols.add(object3);
            }
        }
        if ((attribute2 = oraAWAttributes.longDesc) != null) {
            attribute = dimension.FindAttribute(this.LD_NAME);
            if (attribute != null) {
                this.setupAttributeProjection(level2, "Long Description", attribute);
            }
            arrayList.add(attribute2);
            object2 = this.getCorrespondentObject(attribute2);
            if (object2 != null) {
                String string = this.getSchema(attribute2) + "." + ((ModelObject)object2).getLongName();
                this._cols.add(string);
            }
        }
        if (this.validTimeDim && bl) {
            attribute2 = oraAWAttributes.timeEnd;
            if (attribute2 != null) {
                attribute = dimension.FindAttribute(this.END_DATE_NAME);
                if (attribute != null) {
                    this.setupAttributeProjection(level2, "END_DATE", attribute);
                }
                arrayList.add(attribute2);
                object2 = this.getCorrespondentObject(attribute2);
                if (object2 != null) {
                    String string = this.getSchema(attribute2) + "." + ((ModelObject)object2).getLongName();
                    this._cols.add(string);
                }
            }
            if ((attribute2 = oraAWAttributes.timeSpan) != null) {
                attribute = dimension.FindAttribute(this.TIME_SPAN_NAME);
                if (attribute != null) {
                    this.setupAttributeProjection(level2, "TIME_SPAN", attribute);
                }
                arrayList.add(attribute2);
                object2 = this.getCorrespondentObject(attribute2);
                if (object2 != null) {
                    String string = this.getSchema(attribute2) + "." + ((ModelObject)object2).getLongName();
                    this._cols.add(string);
                }
            }
        }
        for (Attribute attribute3 : arrayList) {
            list.remove(attribute3);
        }
    }

    public void createValubasedHierarchy(oracle.AWXML.Dimension dimension, Hierarchy hierarchy, oracle.dbtools.crest.model.design.multidimensional.Hierarchy hierarchy2, Vector vector, oracle.AWXML.Attribute attribute, oracle.AWXML.Attribute attribute2, Map map) {
        Object object;
        Object object2;
        ModelIDObject modelIDObject2;
        Object object32;
        Object object4;
        Object object52;
        Object object6;
        oracle.AWXML.Attribute attribute3;
        if (hierarchy2.getLevels().size() == 0) {
            return;
        }
        DimensionMapGroup dimensionMapGroup = hierarchy.createSourceDimensionMapGroup();
        oracle.dbtools.crest.model.design.multidimensional.Level level = (oracle.dbtools.crest.model.design.multidimensional.Level)hierarchy2.getLevels().get(0);
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(level.getDescriptiveAttributes());
        Level.OraAWAttributes oraAWAttributes = level.getOraAWAttributes();
        ContainedObject containedObject = oraAWAttributes.shortDesc;
        AttributeProjection attributeProjection = null;
        if (containedObject != null) {
            attribute3 = dimension.FindAttribute(this.SD_NAME);
            if (attribute3 == null) {
                attribute3 = dimension.createAttribute();
                attribute3.setName(this.SD_NAME);
            }
            if (attribute3 != null) {
                attributeProjection = this.setupHierAttributeProjection(hierarchy, "Short Description", attribute3);
            }
            arrayList.remove(containedObject);
            object6 = this.getCorrespondentObject(containedObject);
            if (object6 != null) {
                object52 = this.getSchema(containedObject) + "." + ((ModelObject)object6).getLongName();
                this._cols.add(object52);
                object4 = dimensionMapGroup.CreateAttributeMap();
                object4.setTargetObject((BaseObject)attributeProjection);
                object32 = object4.CreateSourceColumn();
                object32.setColumn(((String)object52).toUpperCase());
            }
        }
        if ((containedObject = oraAWAttributes.longDesc) != null) {
            attribute3 = dimension.FindAttribute(this.LD_NAME);
            if (attribute3 == null) {
                attribute3 = dimension.createAttribute();
                attribute3.setName(this.LD_NAME);
            }
            if (attribute3 != null) {
                attributeProjection = this.setupHierAttributeProjection(hierarchy, "Long Description", attribute3);
            }
            arrayList.remove(containedObject);
            object6 = this.getCorrespondentObject(containedObject);
            if (object6 != null) {
                object52 = this.getSchema(containedObject) + "." + ((ModelObject)object6).getLongName();
                this._cols.add(object52);
                object4 = dimensionMapGroup.CreateAttributeMap();
                object4.setTargetObject((BaseObject)attributeProjection);
                object32 = object4.CreateSourceColumn();
                object32.setColumn(((String)object52).toUpperCase());
            }
        }
        arrayList.clear();
        arrayList.addAll(level.getSlowChangingAttributes());
        for (Object object52 : arrayList) {
            containedObject = ((SlowChangingAttribute)object52).getAttribute();
            attribute3 = (oracle.AWXML.Attribute)map.get(containedObject.getObjectID());
            if (attribute3 == null) {
                attribute3 = dimension.createAttribute();
                attribute3.setName(((SlowChangingAttribute)object52).getName());
                map.put(containedObject.getObjectID(), attribute3);
            }
            attributeProjection = this.setupHierAttributeProjection(hierarchy, attribute3.getName(), attribute3);
            attribute3.setClassification("USER");
            object4 = this.getCorrespondentObject(containedObject);
            if (object4 == null) continue;
            object32 = this.getSchema(containedObject) + "." + ((ModelObject)object4).getLongName();
            this._cols.add(object32);
            modelIDObject2 = dimensionMapGroup.CreateAttributeMap();
            modelIDObject2.setTargetObject((BaseObject)attributeProjection);
            object2 = modelIDObject2.CreateSourceColumn();
            object2.setColumn(((String)object32).toUpperCase());
        }
        hierarchy.setType("VALUE");
        object52 = dimensionMapGroup.CreateKeyMap();
        for (Object object32 : level.getLevelKey()) {
            modelIDObject2 = this.getCorrespondentObject((ModelIDObject)object32);
            if (modelIDObject2 == null) continue;
            object2 = this.getSchema((ModelIDObject)object32) + "." + modelIDObject2.getLongName();
            object = object52.CreateSourceColumn();
            object.setColumn(((String)object2).toUpperCase());
        }
        object32 = dimensionMapGroup.CreateParentMap();
        for (ModelIDObject modelIDObject2 : level.getParentKey()) {
            object2 = this.getCorrespondentObject(modelIDObject2);
            if (object2 == null) continue;
            object = this.getSchema(modelIDObject2) + "." + ((ModelObject)object2).getLongName();
            SourceColumn sourceColumn = object32.CreateSourceColumn();
            sourceColumn.setColumn(((String)object).toUpperCase());
        }
    }

    private void createHierarchyMap2(Hierarchy hierarchy, Vector vector, Vector vector2) {
        oracle.dbtools.crest.model.design.multidimensional.Level level = null;
        oracle.dbtools.crest.model.design.multidimensional.Level level2 = null;
        int n = 0;
        for (LevelDesc levelDesc : vector) {
            Object object;
            Object object2;
            ModelIDObject modelIDObject;
            Level level3 = levelDesc.olevel;
            level2 = levelDesc.level;
            HierarchyLevelAssociation hierarchyLevelAssociation = hierarchy.createHierarchyLevelAssociation();
            hierarchyLevelAssociation.setLevel(level3);
            DimensionMapGroup dimensionMapGroup = hierarchyLevelAssociation.createSourceDimensionMapGroup();
            DimensionKeySourceExpression dimensionKeySourceExpression = dimensionMapGroup.CreateKeyMap();
            for (Attribute attribute : level2.getLevelKey()) {
                modelIDObject = this.getCorrespondentObject(attribute);
                if (modelIDObject == null) continue;
                object2 = this.getSchema(attribute) + "." + modelIDObject.getLongName();
                object = dimensionKeySourceExpression.CreateSourceColumn();
                object.setColumn(((String)object2).toUpperCase());
            }
            if (n > 0) {
                Attribute attribute;
                attribute = dimensionMapGroup.CreateParentMap();
                if (level != null) {
                    modelIDObject = level2.getFirstLinkToTarget(level);
                    Iterator iterator = modelIDObject != null ? (((Link)modelIDObject).getRollupLink().getChildToParentAttributes().size() > 0 ? ((Link)modelIDObject).getRollupLink().getChildToParentAttributes().iterator() : level.getLevelKey().iterator()) : level.getLevelKey().iterator();
                    while (iterator.hasNext()) {
                        object2 = (Attribute)iterator.next();
                        object = this.getCorrespondentObject((ModelIDObject)object2);
                        if (object == null) continue;
                        String string = this.getSchema((ModelIDObject)object2) + "." + ((ModelObject)object).getLongName();
                        SourceColumn sourceColumn = attribute.CreateSourceColumn();
                        sourceColumn.setColumn(string.toUpperCase());
                    }
                }
            }
            ++n;
            level = level2;
        }
    }

    public oracle.AWXML.Attribute createLongDescAttr(oracle.AWXML.Dimension dimension) {
        oracle.AWXML.Attribute attribute = dimension.createAttribute();
        attribute.setName(this.LD_NAME);
        attribute.setClassification("MEMBER_LONG_DESCRIPTION");
        return attribute;
    }

    public oracle.AWXML.Attribute createShortDescAttr(oracle.AWXML.Dimension dimension) {
        oracle.AWXML.Attribute attribute = dimension.createAttribute();
        attribute.setName(this.SD_NAME);
        attribute.setClassification("MEMBER_SHORT_DESCRIPTION");
        return attribute;
    }

    public void createHierarchyMap(Hierarchy hierarchy, Vector vector, Vector vector2) {
        int n = 0;
        for (Level level : vector) {
            HierarchyLevelAssociation hierarchyLevelAssociation = hierarchy.createHierarchyLevelAssociation();
            hierarchyLevelAssociation.setLevel(level);
            DimensionMapGroup dimensionMapGroup = hierarchyLevelAssociation.createSourceDimensionMapGroup();
            DimensionKeySourceExpression dimensionKeySourceExpression = dimensionMapGroup.CreateKeyMap();
            SourceColumn sourceColumn = dimensionKeySourceExpression.CreateSourceColumn();
            sourceColumn.setColumn(((String)vector2.elementAt(n)).toUpperCase());
            if (n > 0) {
                HierarchicalParentSourceExpression hierarchicalParentSourceExpression = dimensionMapGroup.CreateParentMap();
                SourceColumn sourceColumn2 = hierarchicalParentSourceExpression.CreateSourceColumn();
                sourceColumn2.setColumn(((String)vector2.elementAt(n - 1)).toUpperCase());
            }
            ++n;
        }
    }

    private LevelDesc getLevelDesc(List list, oracle.dbtools.crest.model.design.multidimensional.Level level, oracle.dbtools.crest.model.design.multidimensional.Dimension dimension) {
        for (LevelDesc levelDesc : list) {
            if (levelDesc.level != level || levelDesc.dim != dimension) continue;
            return levelDesc;
        }
        return null;
    }

    public void createLevelMap(Level level, Vector vector, Vector vector2, String string) {
        int n;
        DimensionMapGroup dimensionMapGroup = level.createSourceDimensionMapGroup();
        DimensionKeySourceExpression dimensionKeySourceExpression = dimensionMapGroup.CreateKeyMap();
        for (n = 0; n < vector.size(); ++n) {
            SourceColumn sourceColumn = dimensionKeySourceExpression.CreateSourceColumn();
            sourceColumn.setColumn(((String)vector.elementAt(n)).toUpperCase());
        }
        if (!"".equals(string)) {
            WhereClause whereClause = dimensionKeySourceExpression.createRestriction();
            whereClause.setWhereClause(string);
        }
        n = 0;
        for (AttributeProjection attributeProjection : level.getAttributes()) {
            AttributeSourceExpression attributeSourceExpression = dimensionMapGroup.CreateAttributeMap();
            attributeSourceExpression.setTargetObject((BaseObject)attributeProjection);
            SourceColumn sourceColumn = attributeSourceExpression.CreateSourceColumn();
            sourceColumn.setColumn(((String)vector2.elementAt(n)).toUpperCase());
            ++n;
        }
    }

    public AttributeProjection setupHierAttributeProjection(Hierarchy hierarchy, String string, oracle.AWXML.Attribute attribute) {
        AttributeProjection attributeProjection = hierarchy.createAttributeProjection();
        attributeProjection.setAttribute(attribute);
        return attributeProjection;
    }

    public AttributeProjection setupAttributeProjection(Level level, String string, oracle.AWXML.Attribute attribute) {
        AttributeProjection attributeProjection = level.createAttributeProjection();
        attributeProjection.setAttribute(attribute);
        return attributeProjection;
    }

    public void clearLevelMapVectors() {
        this._keys.removeAllElements();
        this._cols.removeAllElements();
    }

    public void clearHierarchyMapVectors() {
        this._levels.removeAllElements();
        this._levColumns.removeAllElements();
    }

    private ApplicationView getApplicationView() {
        return this.appView;
    }

    public void setTempStatusMessage(String string) {
        this.appView.setTempStatusMessage(string);
    }

    public GUIConfiguration getConfiguration() {
        return GUIConfiguration.getInstance();
    }

    private void validateLevel(oracle.dbtools.crest.model.design.multidimensional.Level level) {
        ColumnProxy columnProxy;
        ContainerObject containerObject = level.getLevelEntity();
        Entity entity = null;
        if (containerObject != null && containerObject instanceof Entity) {
            entity = (Entity)containerObject;
        }
        if (entity != null) {
            if (this.storDesign != null) {
                TableProxy tableProxy = this.getTableProxy(entity);
                if (tableProxy == null) {
                    this.valid = false;
                    this.validationSB.append("\n There is no corresponding table for entity ").append(entity.getName());
                }
            } else if (entity.getEngTable(this.physDesign) == null) {
                this.valid = false;
                this.validationSB.append("\n There is no corresponding table for entity ").append(entity.getName());
            }
        }
        if (entity == null) {
            this.valid = false;
            this.validationSB.append("\nLevel Entity is not defined for " + level.getName());
        } else if (level.getLevelKey().size() == 0) {
            this.valid = false;
            this.validationSB.append("\nLevel key attributes are not defined for " + level.getName());
        }
        for (ContainedObject containedObject : level.getLevelKey()) {
            if (!(containedObject instanceof Attribute)) continue;
            if (this.storDesign != null) {
                columnProxy = this.getColumnProxy((Attribute)containedObject);
                if (columnProxy != null) continue;
                this.valid = false;
                this.validationSB.append("\n There is no corresponding column for attribute ").append(containedObject.getLongName());
                continue;
            }
            if (((Attribute)containedObject).getEngColumn(this.physDesign) != null) continue;
            this.valid = false;
            this.validationSB.append("\n There is no corresponding column for attribute ").append(containedObject.getLongName());
        }
        for (ContainedObject containedObject : level.getDescriptiveAttributes()) {
            if (!(containedObject instanceof Attribute)) continue;
            if (this.storDesign != null) {
                columnProxy = this.getColumnProxy((Attribute)containedObject);
                if (columnProxy != null) continue;
                this.valid = false;
                this.validationSB.append("\n There is no corresponding column for attribute ").append(containedObject.getLongName());
                continue;
            }
            if (((Attribute)containedObject).getEngColumn(this.physDesign) != null) continue;
            this.valid = false;
            this.validationSB.append("\n There is no corresponding column for attribute ").append(containedObject.getLongName());
        }
    }

    private ColumnProxy getColumnProxy(Attribute attribute) {
        Column column = attribute.getEngColumn(this.physDesign);
        if (column != null && this.storDesign != null) {
            ColumnProxy columnProxy = (ColumnProxy)this.storDesign.getColumnProxySet().getProxy(column.getObjectID());
            return columnProxy;
        }
        return null;
    }

    private TableProxy getTableProxy(Entity entity) {
        Table table = entity.getEngTable(this.physDesign);
        if (table != null && this.storDesign != null) {
            TableProxy tableProxy = (TableProxy)this.storDesign.getTableProxySet().getProxy(table.getObjectID());
            return tableProxy;
        }
        if (table == null) {
            // empty if block
        }
        return null;
    }

    public void xml_build_global_aw(String string) {
        this.curInteraction = new Interaction();
        this.curInteraction.setConnection(this.awConnection);
        BuildDatabase buildDatabase = (BuildDatabase)this.curInteraction.createAction("BUILDDATABASE");
        buildDatabase.setAWName(string);
        buildDatabase.setRunSolve(false);
        buildDatabase.Execute();
    }

    private Measure createDerivedMeasure(oracle.AWXML.Cube cube, oracle.dbtools.crest.model.design.multidimensional.Measure measure, Slice slice, Slice.MeasureWrapper measureWrapper) {
        String string;
        String string2 = measure.getName().replaceAll(" ", "_");
        string2 = string2.replaceAll("[(]", "_");
        if (this.existsMeasureName(string2 = string2.replaceAll("[)]", "_"))) {
            string = string2;
            string2 = this.existsMeasureName(string) ? this.produceUniqueMeasureName(string2) : string;
        }
        string = cube.createDerivedMeasure();
        string.setName(string2);
        string.setLongName(measure.getOracleLongName());
        string.setShortName(measure.getOracleShortName());
        string.setPluralName(measure.getOraclePluralName());
        measure.setNameInOracleAW(string.getName());
        String string3 = measure.getFormula();
        if (measure.isCustomFormula()) {
            string.setExpressionText(string3);
        } else {
            string3 = measureWrapper == null ? this.getMeasureExpression(measure) : this.getMeasureExpression(slice, measureWrapper);
            string.setExpressionText(string3);
        }
        if (slice == null || measureWrapper == null) {
            this.measMap.put(measure.getObjectID(), string);
        } else {
            this.measMap.put(this.makeMeasureID(slice, measureWrapper), string);
        }
        return string;
    }

    private Measure createOLAPMeasure(oracle.AWXML.Cube cube, oracle.dbtools.crest.model.design.multidimensional.Measure measure, Slice slice, Slice.MeasureWrapper measureWrapper) {
        Hierarchy hierarchy;
        AbstractMDObject abstractMDObject;
        OlapMeasureInput olapMeasureInput;
        String string;
        String string2;
        Measure measure2;
        oracle.AWXML.Dimension dimension = null;
        OlapMeasureInput olapMeasureInput2 = null;
        String string3 = this.getOperatorID(measure.getOLAPOperator());
        oracle.dbtools.crest.model.design.multidimensional.Measure measure3 = measure.getUsedOLAPMeasure();
        if (measure3 == null) {
            return null;
        }
        String string4 = measure3.getObjectID();
        if (slice == null) {
            measure2 = (Measure)this.measMap.get(string4);
        } else {
            string2 = slice.getObjectID() + string4 + String.valueOf(measureWrapper.getAggrFunction().getObjectID());
            measure2 = (Measure)this.measMap.get(string2);
        }
        if (measure2 == null) {
            return null;
        }
        string2 = measure.getName().replaceAll(" ", "_");
        string2 = string2.replaceAll("[(]", "_");
        if (this.existsMeasureName(string2 = string2.replaceAll("[)]", "_"))) {
            string = string2;
            string2 = this.existsMeasureName(string) ? this.produceUniqueMeasureName(string2) : string;
        }
        string = cube.createOlapMeasure();
        string.setName(string2);
        string.setLongName(measure.getOracleLongName());
        string.setShortName(measure.getOracleShortName());
        string.setPluralName(measure.getOraclePluralName());
        measure.setNameInOracleAW(string.getName());
        if (slice == null || measureWrapper == null) {
            this.measMap.put(measure.getObjectID(), string);
        } else {
            this.measMap.put(this.makeMeasureID(slice, measureWrapper), string);
        }
        string.setOlapOperator(string3);
        olapMeasureInput2 = string.createOlapMeasureInput();
        olapMeasureInput2.setKeyWord("MEASURE");
        olapMeasureInput2.setReferencedObj((BaseObject)measure2);
        OlapMeasureInput olapMeasureInput3 = string.createOlapMeasureInput();
        olapMeasureInput3.setKeyWord("DIMENSION");
        oracle.dbtools.crest.model.design.multidimensional.Dimension dimension2 = measure.getOLAPDimension();
        dimension = (oracle.AWXML.Dimension)this.dimMap.get(dimension2.getObjectID());
        if (dimension == null) {
            cube.removeOlapMeasure((OlapMeasure)string);
            return null;
        }
        olapMeasureInput3.setReferencedObj((BaseObject)dimension);
        if (string3.indexOf("PRIOR_PERIOD") > -1 || string3.indexOf("FUTURE_PERIOD") > -1 || string3.indexOf("PERIOD_TO_DATE") > -1 || string3.indexOf("SAME_PERIOD_ANCESTORS") > -1 || string3.indexOf("SHARE_TO") > -1 || string3.indexOf("RANK_") > -1 || string3.indexOf("CUMULATIVE_TOTAL") > -1) {
            olapMeasureInput = string.createOlapMeasureInput();
            olapMeasureInput.setKeyWord("HIERARCHY");
            abstractMDObject = measure.getOLAPHierarchy();
            hierarchy = (Hierarchy)this.hierMap.get(abstractMDObject.getObjectID());
            if (hierarchy == null) {
                cube.removeOlapMeasure((OlapMeasure)string);
                return null;
            }
            olapMeasureInput.setReferencedObj((BaseObject)hierarchy);
        }
        if (string3.indexOf("PERIOD_TO_DATE") > -1 || string3.indexOf("SHARE_TO_LEVEL") > -1) {
            olapMeasureInput = string.createOlapMeasureInput();
            olapMeasureInput.setKeyWord("LEVEL");
            abstractMDObject = measure.getOLAPLevel();
            hierarchy = (Level)this.levMap.get(abstractMDObject.getObjectID() + dimension2.getObjectID());
            if (hierarchy == null) {
                cube.removeOlapMeasure((OlapMeasure)string);
                return null;
            }
            olapMeasureInput.setReferencedObj((BaseObject)hierarchy);
        }
        if (string3.indexOf("LEAD") > -1 || string3.indexOf("LAG") > -1 || string3.indexOf("PRIOR_PERIOD") > -1 || string3.indexOf("FUTURE_PERIOD") > -1 || string3.indexOf("SAME_PERIOD_ANCESTORS") > -1) {
            olapMeasureInput = string.createOlapMeasureInput();
            olapMeasureInput.setKeyWord("OFFSET");
            olapMeasureInput.setScalarValue(String.valueOf(measure.getOLAPOffset()));
        }
        if (string3.indexOf("MOVING") > -1) {
            olapMeasureInput = string.createOlapMeasureInput();
            olapMeasureInput.setKeyWord("START");
            olapMeasureInput.setScalarValue(String.valueOf(measure.getOLAPStart()));
            abstractMDObject = string.createOlapMeasureInput();
            abstractMDObject.setKeyWord("STOP");
            abstractMDObject.setScalarValue(String.valueOf(measure.getOLAPStop()));
            hierarchy = string.createOlapMeasureInput();
            hierarchy.setKeyWord("STEP");
            hierarchy.setScalarValue(String.valueOf(measure.getOLAPStep()));
        }
        if (string3.indexOf("PERIOD_TO_DATE") > -1) {
            olapMeasureInput = string.createOlapMeasureInput();
            olapMeasureInput.setKeyWord("OPERATION");
            olapMeasureInput.setScalarValue(measure.getOLAPPeriodToDateOperation());
        }
        if (string3.indexOf("RANK_") > -1) {
            olapMeasureInput = string.createOlapMeasureInput();
            olapMeasureInput.setKeyWord("DIRECTION");
            olapMeasureInput.setScalarValue(measure.getRankDirectionCode());
        }
        return string;
    }

    private String getOperatorID(String string) {
        String string2 = "[^A-Z0-9_]";
        String string3 = string.toUpperCase();
        string3 = string3.replaceAll(string2, "_");
        return string3;
    }

    private List getMeasureDependencies(List list) {
        ArrayList<MeasureDependence> arrayList = new ArrayList<MeasureDependence>();
        for (oracle.dbtools.crest.model.design.multidimensional.Measure measure : list) {
            Object object;
            MeasureDependence measureDependence = new MeasureDependence(measure);
            if (!measure.isFormula()) {
                arrayList.add(measureDependence);
                continue;
            }
            if (measure.getOracleAWFormulaType().equalsIgnoreCase(oracle.dbtools.crest.model.design.multidimensional.Measure.AW_OLAP_FORMULA)) {
                object = measure.getUsedOLAPMeasure();
                if (object != null) {
                    measureDependence.dependOn.add(object);
                }
            } else if (!measure.isCustomFormula()) {
                object = measure.getFormula().toUpperCase();
                for (oracle.dbtools.crest.model.design.multidimensional.Measure measure2 : list) {
                    String string;
                    if (measure2 == measure || ((String)object).indexOf(string = "\"" + measure2.getName().toUpperCase().trim() + "\"") <= -1) continue;
                    measureDependence.dependOn.add(measure2);
                }
            }
            arrayList.add(measureDependence);
        }
        return arrayList;
    }

    private void sortMeasures(List list) {
        this.sortedMeasures.clear();
        this.tracedMeasures.clear();
        this.cyclicRef = false;
        this.measureDependencies = this.getMeasureDependencies(list);
        for (oracle.dbtools.crest.model.design.multidimensional.Measure measure : list) {
            this.addToSorted(measure);
            if (!this.cyclicRef) continue;
            return;
        }
    }

    private void addToSorted(oracle.dbtools.crest.model.design.multidimensional.Measure measure) {
        if (this.sortedMeasures.contains(measure)) {
            return;
        }
        MeasureDependence measureDependence = this.getMeasureDependence(measure, this.measureDependencies);
        if (measureDependence == null) {
            this.sortedMeasures.add(measure);
            this.tracedMeasures.add(measure);
            return;
        }
        if (measureDependence.dependOn.size() == 0) {
            this.sortedMeasures.add(measure);
            this.tracedMeasures.add(measure);
            return;
        }
        this.tracedMeasures.add(measure);
        for (oracle.dbtools.crest.model.design.multidimensional.Measure measure2 : measureDependence.dependOn) {
            if (this.tracedMeasures.contains(measure2) && !this.sortedMeasures.contains(measure2)) {
                this.cyclicRef = true;
                String string = "\"" + measure2.getCube().getName() + "\"" + "." + "\"" + measure2.getName() + "\"";
                JOptionPane.showOptionDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("OracleAWExporter.ThereIsCyclicFeferenceForMeasure"), string), Messages.getString("OracleAWExporter.CyclicRference"), 0, 0, null, new String[]{Messages.getString("OracleAWExporter.Ok")}, Messages.getString("OracleAWExporter.Ok"));
                this.error = true;
                this.valid = false;
                this.eb.append("\nCyclic reference for measure ").append(string);
                return;
            }
            if (this.sortedMeasures.contains(measure2)) continue;
            this.addToSorted(measure2);
            if (!this.cyclicRef) continue;
            return;
        }
        this.sortedMeasures.add(measure);
    }

    private MeasureDependence getMeasureDependence(oracle.dbtools.crest.model.design.multidimensional.Measure measure, List list) {
        for (MeasureDependence measureDependence : list) {
            if (measureDependence.measure != measure) continue;
            return measureDependence;
        }
        return null;
    }

    public String getMeasureExpression(oracle.dbtools.crest.model.design.multidimensional.Measure measure) {
        Cube cube = measure.getCube();
        String string = measure.getFormula();
        for (oracle.dbtools.crest.model.design.multidimensional.Measure measure2 : cube.getMeasures()) {
            Measure measure3;
            String string2;
            if (measure2 == measure || string.indexOf(string2 = "\"" + measure2.getName().trim() + "\"") <= -1 || (measure3 = (Measure)this.measMap.get(measure2.getObjectID())) == null) continue;
            String string3 = measure3.getId();
            string = this.replace(string, string2, string3);
        }
        return string;
    }

    public String getMeasureExpression(Slice slice, Slice.MeasureWrapper measureWrapper) {
        oracle.dbtools.crest.model.design.multidimensional.Measure measure = measureWrapper.getMeasure();
        Cube cube = measure.getCube();
        String string = measure.getFormula();
        for (oracle.dbtools.crest.model.design.multidimensional.Measure measure2 : cube.getMeasures()) {
            String string2;
            Measure measure3;
            String string3;
            if (measure2 == measure || string.indexOf(string3 = "\"" + measure2.getName().trim() + "\"") <= -1 || (measure3 = (Measure)this.measMap.get(string2 = slice.getObjectID() + measure2.getObjectID() + measure2.getDefaultAggregationFunction().getObjectID())) == null) continue;
            String string4 = measure3.getId();
            string = this.replace(string, string3, string4);
        }
        return string;
    }

    private String replace(String string, String string2, String string3) {
        String string4 = string2.trim();
        String string5 = string;
        int n = string5.indexOf(string4);
        int n2 = string4.length();
        while (n > -1) {
            String string6 = n == 0 ? "" : string5.substring(0, n);
            int n3 = string6.length() + string3.length();
            string5 = string6 + string3 + string5.substring(n + n2);
            n = string5.indexOf(string4, n3);
        }
        return string5;
    }

    private void validateCube(Cube cube) {
        this.sortedMeasures.clear();
        this.tracedMeasures.clear();
        this.eb.setLength(0);
        this.sortMeasures(cube.getMeasures());
        if (this.cyclicRef) {
            this.valid = false;
            this.validationSB.append("\n\nCube " + cube.getName() + " has measures with cyclic references").append(this.eb.toString());
        }
        if (cube.getFactEntities().size() == 0) {
            this.valid = false;
            this.validationSB.append("\nThere is no Fact Entity defined for Cube " + cube.getName());
        }
        if (cube.hasRolePlayingDimensions()) {
            this.warning = true;
            this.warningsSB.append("\nCube " + cube.getName() + " has Role Playing Dimensions and will not be generated. Use Slice to create cube.");
        }
        if (cube.getDimensions().size() == 0) {
            this.valid = false;
            this.validationSB.append("\nThere is no dimension usage for cube " + cube.getName());
        }
        for (AbstractMDObject abstractMDObject : cube.getDimensions()) {
            oracle.dbtools.crest.model.design.multidimensional.Level level = ((oracle.dbtools.crest.model.design.multidimensional.Dimension)abstractMDObject).getBaseLevel();
            RollupLink rollupLink = cube.getRollUpLink((oracle.dbtools.crest.model.design.multidimensional.Dimension)abstractMDObject);
            if (rollupLink.getChildToParentAttributes().size() == 0) {
                this.valid = false;
                this.validationSB.append("\nThere are no reference attributes defined for dimenson " + abstractMDObject.getName() + " in Cube " + cube.getName());
                continue;
            }
            if (level == null || rollupLink.getChildToParentAttributes().size() == level.getLevelKey().size()) continue;
            this.valid = false;
            this.validationSB.append("\nThe number of reference attributes for dimenson " + abstractMDObject.getName() + " in cube " + cube.getName());
            this.validationSB.append(" differ from number of key attributes for level " + level.getName());
        }
        for (AbstractMDObject abstractMDObject : cube.getMeasures()) {
            this.validateMeasure((oracle.dbtools.crest.model.design.multidimensional.Measure)abstractMDObject);
        }
        for (AbstractMDObject abstractMDObject : cube.getPrecalculatedSlices()) {
            this.validateSlice((Slice)abstractMDObject);
        }
    }

    private void validateMeasure(oracle.dbtools.crest.model.design.multidimensional.Measure measure) {
        if (!measure.isFormula()) {
            ContainedObject containedObject = measure.getMeasureFact();
            if (containedObject == null) {
                this.valid = false;
                this.validationSB.append("\nThere is no fact attribute defined for measure " + measure.getName() + "in Cube " + measure.getCube().getName());
            } else if (this.storDesign != null) {
                if (containedObject instanceof Attribute) {
                    ColumnProxy columnProxy = this.getColumnProxy((Attribute)containedObject);
                    if (columnProxy == null) {
                        this.valid = false;
                        this.validationSB.append("\n There is no corresponding column for attribute ").append(containedObject.getLongName());
                    }
                } else if (((AttributeView)containedObject).getEngColumnView(this.physDesign) == null) {
                    this.valid = false;
                    this.validationSB.append("\n There is no corresponding columnView for attributeView ").append(containedObject.getLongName());
                }
            } else if (containedObject instanceof Attribute) {
                if (((Attribute)containedObject).getEngColumn(this.physDesign) == null) {
                    this.valid = false;
                    this.validationSB.append("\n There is no corresponding column for attribute ").append(containedObject.getLongName());
                }
            } else if (((AttributeView)containedObject).getEngColumnView(this.physDesign) == null) {
                this.valid = false;
                this.validationSB.append("\n There is no corresponding columnView for attributeView ").append(containedObject.getLongName());
            }
        } else {
            this.validateAndSetOLAPMeasure((MultidimensionalDesign)measure.getDesignPart(), measure);
        }
    }

    private void validateAndSetOLAPMeasure(MultidimensionalDesign multidimensionalDesign, oracle.dbtools.crest.model.design.multidimensional.Measure measure) {
        if (measure.isFormula() && measure.getOracleAWFormulaType().equalsIgnoreCase(oracle.dbtools.crest.model.design.multidimensional.Measure.AW_OLAP_FORMULA)) {
            AbstractMDObject abstractMDObject;
            String string;
            oracle.dbtools.crest.model.design.multidimensional.Dimension dimension;
            oracle.dbtools.crest.model.design.multidimensional.Measure measure2 = measure.getUsedOLAPMeasure();
            if (measure2 != null) {
                measure2 = (oracle.dbtools.crest.model.design.multidimensional.Measure)multidimensionalDesign.getMeasureSet().getObjectByID(measure2.getObjectID());
            }
            if (measure2 == null) {
                this.valid = false;
                measure.setUsedOLAPMeasure(null);
                this.validationSB.append("\nBase measure is not set for OLAP calcilated measure " + measure.getName());
            }
            if ((dimension = measure.getOLAPDimension()) != null) {
                dimension = (oracle.dbtools.crest.model.design.multidimensional.Dimension)multidimensionalDesign.getDimensionSet().getObjectByID(dimension.getObjectID());
            }
            if (dimension == null) {
                this.valid = false;
                measure.setOLAPDimension(null);
                measure.setOLAPHierarchy(null);
                measure.setOLAPLevel(null);
                this.validationSB.append("\nDimension is not set for OLAP calcilated measure " + measure.getName());
            }
            if ((string = this.getOperatorID(measure.getOLAPOperator())).indexOf("PRIOR_PERIOD") > -1 || string.indexOf("FUTURE_PERIOD") > -1 || string.indexOf("PERIOD_TO_DATE") > -1 || string.indexOf("SAME_PERIOD_ANCESTORS") > -1 || string.indexOf("SHARE_TO") > -1 || string.indexOf("RANK_") > -1 || string.indexOf("CUMULATIVE_TOTAL") > -1) {
                abstractMDObject = measure.getOLAPHierarchy();
                if (abstractMDObject != null) {
                    abstractMDObject = (oracle.dbtools.crest.model.design.multidimensional.Hierarchy)multidimensionalDesign.getHierarchySet().getObjectByID(abstractMDObject.getObjectID());
                }
                if (abstractMDObject == null) {
                    this.valid = false;
                    measure.setOLAPHierarchy(null);
                    measure.setOLAPLevel(null);
                    this.validationSB.append("\nHierarchy is not set for OLAP calcilated measure " + measure.getName());
                }
            }
            if (string.indexOf("PERIOD_TO_DATE") > -1 || string.indexOf("SHARE_TO_LEVEL") > -1) {
                abstractMDObject = measure.getOLAPLevel();
                if (abstractMDObject != null) {
                    abstractMDObject = (oracle.dbtools.crest.model.design.multidimensional.Level)multidimensionalDesign.getLevelSet().getObjectByID(abstractMDObject.getObjectID());
                }
                if (abstractMDObject == null) {
                    this.valid = false;
                    measure.setOLAPLevel(null);
                    this.validationSB.append("\nLevel is not set for OLAP calcilated measure " + measure.getName());
                }
            }
        }
    }

    private void validateDimension(oracle.dbtools.crest.model.design.multidimensional.Dimension dimension) {
        oracle.dbtools.crest.model.design.multidimensional.Level level = dimension.getBaseLevel();
        if (level == null) {
            this.valid = false;
            this.validationSB.append("\nThere is no base level for dimension " + dimension.getName());
        }
        Iterator iterator = dimension.getHierarchies().iterator();
        while (iterator.hasNext()) {
            AbstractMDObject abstractMDObject = (oracle.dbtools.crest.model.design.multidimensional.Hierarchy)iterator.next();
            this.validateHierachy((oracle.dbtools.crest.model.design.multidimensional.Hierarchy)abstractMDObject);
        }
        for (AbstractMDObject abstractMDObject : dimension.getAllLevels()) {
            this.validateAWAttributes((oracle.dbtools.crest.model.design.multidimensional.Level)abstractMDObject, dimension.isTimeDimension());
        }
    }

    private void validateHierachy(oracle.dbtools.crest.model.design.multidimensional.Hierarchy hierarchy) {
        block4: {
            Object[] objectArray;
            block2: {
                oracle.dbtools.crest.model.design.multidimensional.Level level;
                block7: {
                    block6: {
                        block5: {
                            block3: {
                                objectArray = hierarchy.getLevels().toArray();
                                if (!hierarchy.isValueBasedHierarchy()) break block2;
                                level = (oracle.dbtools.crest.model.design.multidimensional.Level)objectArray[0];
                                if (objectArray.length <= 1) break block3;
                                this.valid = false;
                                this.validationSB.append("\nValue based hierachy " + hierarchy.getName() + " has levels connected to its defintition level " + level.getName());
                                break block4;
                            }
                            if (level.getLevelEntity() != null) break block5;
                            this.valid = false;
                            this.validationSB.append("\nLevel Entity is not defined for " + level.getName());
                            break block4;
                        }
                        if (level.getLevelKey().size() != 0) break block6;
                        this.valid = false;
                        this.validationSB.append("\nLevel key attributes are not defined for " + level.getName());
                        break block4;
                    }
                    if (level.getParentKey().size() != 0) break block7;
                    this.valid = false;
                    this.validationSB.append("\nParent key attributes are nod defined for Value Based Hierarchy in level " + level.getName());
                    break block4;
                }
                if (level.getParentKey().size() == level.getLevelKey().size()) break block4;
                this.valid = false;
                this.validationSB.append("\nThe number of parent key attributes for Value Based Hierarchy in level " + level.getName());
                this.validationSB.append(" differ from number of key attributes ");
                break block4;
            }
            for (int i = 0; i < objectArray.length - 1; ++i) {
                oracle.dbtools.crest.model.design.multidimensional.Level level = (oracle.dbtools.crest.model.design.multidimensional.Level)objectArray[i];
                oracle.dbtools.crest.model.design.multidimensional.Level level2 = (oracle.dbtools.crest.model.design.multidimensional.Level)objectArray[i + 1];
                Link link = level.getFirstLinkToTarget(level2);
                if (level.getLevelKey().size() == 0) {
                    this.valid = false;
                    this.validationSB.append("\nLevel key attributes are not defined for " + level.getName());
                    continue;
                }
                if (link == null) continue;
                RollupLink rollupLink = link.getRollupLink();
                if (level.getLevelEntity() == level2.getLevelEntity() || rollupLink.getChildToParentAttributes().size() == level2.getLevelKey().size()) continue;
                this.valid = false;
                this.validationSB.append("\nThe number of reference attributes from level " + level.getName() + " ito level " + level2.getName());
                this.validationSB.append(" differ from number of key attributes for level " + level2.getName());
            }
        }
    }

    private void validateAWAttributes(oracle.dbtools.crest.model.design.multidimensional.Level level, boolean bl) {
        Level.OraAWAttributes oraAWAttributes = level.getOraAWAttributes();
        if (oraAWAttributes.shortDesc == null) {
            this.warning = true;
            this.warningsSB.append("\nSHORT_DESCRIPTION attribute is not defined for " + level.getName());
        }
        if (oraAWAttributes.longDesc == null) {
            this.warning = true;
            this.warningsSB.append("\nLONG_DESCRIPTION attribute is not defined for " + level.getName());
        }
        if (bl) {
            if (oraAWAttributes.timeSpan == null) {
                this.warning = true;
                this.warningsSB.append("\nTIME_SPAN attribute is not defined for " + level.getName());
            }
            if (oraAWAttributes.timeEnd == null) {
                this.warning = true;
                this.warningsSB.append("\nTIME_END attribute is not defined for " + level.getName());
            }
        }
    }

    private void validateSlice(Slice slice) {
        slice.verifyMeasureWrappers();
        if (slice.getSelectedLevels().size() == 0) {
            this.valid = false;
            this.validationSB.append("\nThere is no dimension usage for slice " + slice.getName());
        }
        for (Slice.MeasureWrapper measureWrapper : slice.getSelectedMeasureWrappers()) {
            List list = this.getMeasureDependenciesFor(measureWrapper.getMeasure(), slice.getCube().getMeasures());
            String string = "";
            boolean bl = true;
            for (int i = 0; i < list.size(); ++i) {
                oracle.dbtools.crest.model.design.multidimensional.Measure measure = (oracle.dbtools.crest.model.design.multidimensional.Measure)list.get(i);
                Slice.MeasureWrapper measureWrapper2 = this.findMWrapperFor(measure, measure.getDefaultAggregationFunction(), slice.getSelectedMeasureWrappers());
                if (measureWrapper2 != null) continue;
                if (bl) {
                    bl = false;
                    string = measure.getName() + " - " + measure.getDefaultAggregationFunction().name;
                    continue;
                }
                string = string + " ," + measure.getName() + " - " + measure.getDefaultAggregationFunction().name;
            }
            if ("".equals(string)) continue;
            this.valid = false;
            this.validationSB.append("\nDependence error in Slice - " + slice.getName() + "measure " + measureWrapper.getMeasure().getName() + "depends on measures: " + string);
        }
    }

    private List getMeasureDependenciesFor(oracle.dbtools.crest.model.design.multidimensional.Measure measure, List list) {
        ArrayList<oracle.dbtools.crest.model.design.multidimensional.Measure> arrayList = new ArrayList<oracle.dbtools.crest.model.design.multidimensional.Measure>();
        if (!measure.isFormula()) {
            return arrayList;
        }
        oracle.dbtools.crest.model.design.multidimensional.Measure measure2 = measure.getUsedOLAPMeasure();
        String string = measure.getFormula().toUpperCase();
        for (oracle.dbtools.crest.model.design.multidimensional.Measure measure3 : list) {
            String string2;
            if (measure3 == measure || !measure.isFormula()) continue;
            if (measure.getOracleAWFormulaType().equalsIgnoreCase(oracle.dbtools.crest.model.design.multidimensional.Measure.AW_OLAP_FORMULA)) {
                if (measure2 == null || measure2 != measure3) continue;
                arrayList.add(measure2);
                continue;
            }
            if (measure3.isCustomFormula() || string.indexOf(string2 = "\"" + measure3.getName().toUpperCase().trim() + "\"") <= -1) continue;
            arrayList.add(measure3);
        }
        return arrayList;
    }

    private Slice.MeasureWrapper findMWrapperFor(oracle.dbtools.crest.model.design.multidimensional.Measure measure, Measure.AggregateFunction aggregateFunction, List list) {
        for (Slice.MeasureWrapper measureWrapper : list) {
            if (measureWrapper.getMeasure() != measure || aggregateFunction != measureWrapper.getAggrFunction()) continue;
            return measureWrapper;
        }
        return null;
    }

    private void exportCalcMeasures() {
        this.overwrite = this.exportType.equals(EXPORT_ALL_CALC_MEASURES);
        this.captureDimensions();
        this.captureFolders();
        for (AWExportOptions.SelObject selObject : this.selectedObjects) {
            AbstractMDObject abstractMDObject;
            if (selObject.object instanceof Cube && selObject.selected) {
                abstractMDObject = (Cube)selObject.object;
                if (abstractMDObject.hasRolePlayingDimensions()) continue;
                this.exportCubeCalcMeasures((Cube)abstractMDObject);
                continue;
            }
            if (!(selObject.object instanceof Slice) || !selObject.selected) continue;
            abstractMDObject = (Slice)selObject.object;
            this.exportSliceCalcMeasures((Slice)abstractMDObject);
        }
        this.exportMeasureFolders();
        this.globalAW.Commit(this.awConnection);
    }

    private void captureAWCubeMeasures(Cube cube, oracle.AWXML.Cube cube2) {
        Vector vector = cube2.getMeasures();
        Vector vector2 = cube2.getDerivedMeasures();
        ArrayList arrayList = new ArrayList(vector);
        ArrayList arrayList2 = new ArrayList(vector2);
        for (oracle.dbtools.crest.model.design.multidimensional.Measure measure : cube.getMeasures()) {
            Measure measure2 = cube2.findMeasure(measure.getNameInOracleAW());
            if (measure2 != null) {
                this.measMap.put(measure.getObjectID(), measure2);
                this.awmeasToMeasure.put(measure2.getId(), measure);
                this.awmeasMap.put(measure2.getId(), measure2);
                arrayList.remove(measure2);
                continue;
            }
            measure2 = cube2.findDerivedMeasure(measure.getNameInOracleAW());
            if (measure2 == null) continue;
            this.measMap.put(measure.getObjectID(), measure2);
            this.awmeasToMeasure.put(measure2.getId(), measure);
            this.awmeasMap.put(measure2.getId(), measure2);
            arrayList2.remove(measure2);
        }
        arrayList.addAll(arrayList2);
        for (oracle.dbtools.crest.model.design.multidimensional.Measure measure : arrayList) {
            this.additionalAWMeasures.put(measure.getId(), measure);
            this.awmeasMap.put(measure.getId(), measure);
        }
    }

    private void deleteAWMeasures(List list, oracle.AWXML.Cube cube) {
        for (int i = list.size() - 1; i > -1; --i) {
            oracle.dbtools.crest.model.design.multidimensional.Measure measure = (oracle.dbtools.crest.model.design.multidimensional.Measure)list.get(i);
            Measure measure2 = (Measure)this.measMap.get(measure.getObjectID());
            if (measure2 == null || !(measure2 instanceof DerivedMeasure)) continue;
            measure2.Delete(this.awConnection);
            cube.removeDerivedMeasure((DerivedMeasure)measure2);
        }
    }

    private void exportCubeCalcMeasures(Cube cube) {
        oracle.AWXML.Cube cube2 = this.globalAW.findCube(cube.getNameInOracleAW());
        if (cube2 != null) {
            this.captureAWCubeMeasures(cube, cube2);
            this.sortedMeasures.clear();
            this.tracedMeasures.clear();
            this.sortMeasures(cube.getMeasures());
            this.deleteAWMeasures(this.sortedMeasures, cube2);
            for (oracle.dbtools.crest.model.design.multidimensional.Measure measure : this.sortedMeasures) {
                Measure measure2;
                if (!measure.isFormula() && !measure.isFactDimension() || measure.isFactDimension() || !this.isValidMeasure(measure, this.sortedMeasures)) continue;
                Measure measure3 = (Measure)this.measMap.get(measure.getObjectID());
                if (measure3 != null && this.overwrite && !(measure3 instanceof DerivedMeasure)) {
                    if (measure3 instanceof OlapMeasure) {
                        cube2.removeOlapMeasure((OlapMeasure)measure3);
                    } else {
                        measure3.Delete(this.awConnection);
                        cube2.removeMeasure(measure3);
                    }
                }
                if (measure3 != null && !this.overwrite) continue;
                if (measure.isDefinedAsOracleAWCalculated() && measure.getOracleAWFormulaType().equalsIgnoreCase(oracle.dbtools.crest.model.design.multidimensional.Measure.AW_OLAP_FORMULA)) {
                    measure2 = this.createOLAPMeasure(cube2, measure, null, null);
                    measure2.Alter(this.awConnection);
                } else {
                    measure2 = this.createDerivedMeasure(cube2, measure, null, null);
                }
                if (measure2 == null) continue;
                if (measure3 != null) {
                    this.oldNewMap.put(measure3.getId(), measure2);
                    this.awmeasMap.put(measure3.getId(), measure2);
                    this.awmeasToMeasure.put(measure3.getId(), measure);
                }
                if (!(measure2 instanceof OlapMeasure)) {
                    measure2.Create(this.awConnection);
                }
                this.exportedMeasures.add(measure2);
            }
        }
    }

    private void exportSliceCalcMeasures(Slice slice) {
    }

    private boolean isValidMeasure(oracle.dbtools.crest.model.design.multidimensional.Measure measure, List list) {
        List list2 = this.getMeasureDependencies(measure, list);
        if (list2.size() == 0) {
            return true;
        }
        boolean bl = true;
        for (oracle.dbtools.crest.model.design.multidimensional.Measure measure2 : list2) {
            Measure measure3;
            if (measure2.isFormula() || (measure3 = (Measure)this.measMap.get(measure2.getObjectID())) != null) continue;
            bl = false;
        }
        return bl;
    }

    private List getMeasureDependencies(oracle.dbtools.crest.model.design.multidimensional.Measure measure, List list) {
        ArrayList<oracle.dbtools.crest.model.design.multidimensional.Measure> arrayList = new ArrayList<oracle.dbtools.crest.model.design.multidimensional.Measure>();
        if (!measure.isFormula()) {
            return arrayList;
        }
        if (measure.getOracleAWFormulaType().equalsIgnoreCase(oracle.dbtools.crest.model.design.multidimensional.Measure.AW_OLAP_FORMULA)) {
            oracle.dbtools.crest.model.design.multidimensional.Measure measure2 = measure.getUsedOLAPMeasure();
            if (measure2 != null) {
                arrayList.add(measure2);
            }
        } else if (!measure.isCustomFormula()) {
            String string = measure.getFormula().toUpperCase();
            for (oracle.dbtools.crest.model.design.multidimensional.Measure measure3 : list) {
                String string2;
                if (measure3 == measure || string.indexOf(string2 = "\"" + measure3.getName().toUpperCase().trim() + "\"") <= -1) continue;
                arrayList.add(measure3);
            }
        }
        return arrayList;
    }

    private void captureFolders() {
        Vector vector = this.globalAW.getMeasureFolders();
        for (oracle.AWXML.MeasureFolder measureFolder : vector) {
            MeasFolder measFolder = this.captureFolder(measureFolder);
            this.awMeasureFolders.add(measFolder);
        }
    }

    private MeasFolder captureFolder(oracle.AWXML.MeasureFolder measureFolder) {
        MeasFolder measFolder = new MeasFolder(measureFolder.getName());
        measFolder.awfolder = measureFolder;
        for (oracle.AWXML.MeasureFolder measureFolder2 : measureFolder.getMeasureFolders()) {
            MeasFolder measFolder2 = this.captureFolder(measureFolder2);
            measFolder.folders.add(measFolder2);
        }
        for (oracle.AWXML.MeasureFolder measureFolder2 : measureFolder.getMeasures()) {
            measFolder.measures.add(measureFolder2.getId());
            this.awmeasMap.put(measureFolder2.getId(), measureFolder2);
        }
        return measFolder;
    }

    private void captureDimensions() {
        ArrayList arrayList = new ArrayList(this.globalAW.getDimensions());
        Iterator iterator = this.mdmDesign.getDimensionSet().iterator();
        while (iterator.hasNext()) {
            oracle.dbtools.crest.model.design.multidimensional.Dimension dimension = (oracle.dbtools.crest.model.design.multidimensional.Dimension)iterator.next();
            oracle.AWXML.Dimension dimension2 = this.findDimension(arrayList, dimension.getNameInOracleAW());
            if (dimension2 == null) continue;
            this.dimMap.put(dimension.getObjectID(), dimension2);
            this.captureDimension(dimension2, dimension);
        }
    }

    private void captureDimension(oracle.AWXML.Dimension dimension, oracle.dbtools.crest.model.design.multidimensional.Dimension dimension2) {
        Object object;
        Object object22;
        ArrayList arrayList = new ArrayList(dimension.getLevels());
        for (Object object22 : dimension2.getAllLevels()) {
            object = this.findLevel(arrayList, ((AbstractMDObject)object22).getNameInOracleAW());
            if (object == null) continue;
            this.levMap.put(((ModelIDObject)object22).getObjectID() + dimension2.getObjectID(), object);
        }
        object22 = new ArrayList(dimension.getHierarchies());
        Iterator iterator = dimension2.getHierarchies().iterator();
        while (iterator.hasNext()) {
            object = (oracle.dbtools.crest.model.design.multidimensional.Hierarchy)iterator.next();
            Hierarchy hierarchy = this.findHierarchy((List)object22, ((AbstractMDObject)object).getNameInOracleAW());
            if (hierarchy == null) continue;
            this.hierMap.put(((ModelIDObject)object).getObjectID(), hierarchy);
        }
    }

    private Level findLevel(List list, String string) {
        for (Level level : list) {
            if (!string.equalsIgnoreCase(level.getName())) continue;
            return level;
        }
        return null;
    }

    private Hierarchy findHierarchy(List list, String string) {
        for (Hierarchy hierarchy : list) {
            if (!string.equalsIgnoreCase(hierarchy.getName())) continue;
            return hierarchy;
        }
        return null;
    }

    private oracle.AWXML.Dimension findDimension(List list, String string) {
        for (oracle.AWXML.Dimension dimension : list) {
            if (!string.equalsIgnoreCase(dimension.getName())) continue;
            return dimension;
        }
        return null;
    }

    private void exportMeasureFolders() {
        for (Object object : this.awMeasureFolders) {
            ((MeasFolder)object).awfolder.Delete(this.awConnection);
            this.globalAW.removeMeasureFolder(((MeasFolder)object).awfolder);
        }
        Iterator iterator = this.mdmDesign.getMeasureFolderSet().iterator();
        while (iterator.hasNext()) {
            Object object;
            object = (MeasureFolder)iterator.next();
            if (((MeasureFolder)object).getParentFolder() != null) continue;
            this.addMeasureFolder((MeasureFolder)object, null, true);
            MeasFolder measFolder = this.findMeasFolder(((AbstractMDObject)object).getNameInOracleAW(), this.awMeasureFolders);
            if (measFolder == null) continue;
            this.awMeasureFolders.remove(measFolder);
        }
        for (Object object : this.awMeasureFolders) {
            this.restoreMeasureFolder((MeasFolder)object, null);
        }
    }

    private MeasFolder findMeasFolder(String string, List list) {
        for (MeasFolder measFolder : list) {
            if (!measFolder.name.equalsIgnoreCase(string)) continue;
            return measFolder;
        }
        return null;
    }

    private void restoreMeasureFolder(MeasFolder measFolder, oracle.AWXML.MeasureFolder measureFolder) {
        oracle.AWXML.MeasureFolder measureFolder2 = null;
        measureFolder2 = measureFolder != null ? measureFolder.createMeasureFolder() : this.globalAW.createMeasureFolder();
        measureFolder2.Create(this.awConnection);
        measureFolder2.setName(measFolder.awfolder.getName());
        measureFolder2.setShortName(measFolder.awfolder.getShortName());
        measureFolder2.setLongName(measFolder.awfolder.getLongName());
        measureFolder2.setPluralName(measFolder.awfolder.getPluralName());
        for (Object object : measFolder.measures) {
            Measure measure = (Measure)this.awmeasMap.get(object);
            if (measure == null) continue;
            measureFolder2.addMeasure(measure);
        }
        for (Object object : measFolder.folders) {
            this.restoreMeasureFolder((MeasFolder)object, measureFolder2);
        }
    }

    private String getExportedXML() {
        String string = "";
        for (Measure measure : this.exportedMeasures) {
            string = string + measure.WriteToXML();
        }
        for (Measure measure : this.exportedFolders) {
            string = string + measure.WriteToXML();
        }
        return string;
    }

    private void closeConnection() {
        if (this.awConnection != null) {
            try {
                this.awConnection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.awConnection = null;
        }
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.connection = null;
        }
    }

    class MeasFolder {
        String name = "";
        oracle.AWXML.MeasureFolder awfolder;
        List measures = new ArrayList();
        List folders = new ArrayList();

        MeasFolder(String string) {
            this.name = string;
        }
    }

    class MeasureDependence {
        oracle.dbtools.crest.model.design.multidimensional.Measure measure;
        List dependOn = new ArrayList();

        MeasureDependence(oracle.dbtools.crest.model.design.multidimensional.Measure measure) {
            this.measure = measure;
        }
    }

    private class CalcMeasuresRunner
    implements Runnable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            try {
                try {
                    OracleAWExporter.this.monitor = new ProgressDialog(OracleAWExporter.this.appView, "", 0, 100);
                    try {
                        block23: {
                            int n;
                            File file;
                            if (!OracleAWExporter.this.exportType.equals(EXPORT_ALL_CALC_MEASURES) && !OracleAWExporter.this.exportType.equals(EXPORT_NEW_CALC_MEASURES)) break block23;
                            OracleAWExporter.this.atached = false;
                            OracleAWExporter.this.monitor.setProgress(5);
                            OracleAWExporter.this.monitor.setNote(Messages.getString("OracleAWExporter.ReadDefinitions"));
                            boolean bl = OracleAWExporter.this.readAWDefinitions(OracleAWExporter.this.awConnection, OracleAWExporter.this.user, OracleAWExporter.this.awName);
                            if (!bl) break block23;
                            OracleAWExporter.this.dimMap = new TreeMap();
                            OracleAWExporter.this.hierMap = new TreeMap();
                            OracleAWExporter.this.monitor.setProgress(40);
                            OracleAWExporter.this.atached = true;
                            OracleAWExporter.this.monitor.setNote(Messages.getString("OracleAWExporter.ExportCalculatedMeasures"));
                            OracleAWExporter.this.exportCalcMeasures();
                            OracleAWExporter.this.commited = false;
                            OracleAWExporter.this.globalAW.Commit(OracleAWExporter.this.awConnection);
                            OracleAWExporter.this.commited = true;
                            bl = true;
                            if ("".equals(OracleAWExporter.this.fileName.trim())) {
                                bl = false;
                            }
                            if (OracleAWExporter.this.fileName.indexOf(46) == -1) {
                                OracleAWExporter.this.fileName = OracleAWExporter.this.fileName + ".xml";
                            }
                            if ((file = new File(OracleAWExporter.this.fileName)).exists() && (n = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), Messages.getString("OracleAWExporter.FileExists") + '\"' + file.getAbsolutePath() + '\"' + " already exists.\nDo you want to overwrite it?", Messages.getString("OracleAWExporter.Warning"), 0, 3, OracleAWExporter.this.getConfiguration().getIcon("SAVE_ICON", 32))) == 1) {
                                bl = false;
                            }
                            if (!bl) break block23;
                            String string = OracleAWExporter.this.getExportedXML();
                            try {
                                if (bl) {
                                    OracleAWExporter.this.monitor.setProgress(95);
                                    OracleAWExporter.this.monitor.setNote(Messages.getString("OracleAWExporter.WriteExportedMetadataToFile"));
                                    FileWriter fileWriter = new FileWriter(file);
                                    fileWriter.write(string);
                                    fileWriter.write("\n");
                                    fileWriter.close();
                                    OracleAWExporter.this.monitor.setProgress(100);
                                    JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), Messages.getString("OracleAWExporter.ExportedOk"));
                                }
                            }
                            catch (Exception exception) {
                                String string2 = exception.toString();
                                LOGGER.error("Failure to write XML string to file: " + OracleAWExporter.this.fileName + "\n", exception);
                                System.out.println("Failure to write XML string to file: " + OracleAWExporter.this.fileName + "\n" + string2);
                            }
                        }
                        OracleAWExporter.this.monitor.close();
                        if (OracleAWExporter.this.commited) return;
                    }
                    catch (Throwable throwable) {
                        OracleAWExporter.this.monitor.close();
                        if (OracleAWExporter.this.commited) throw throwable;
                        JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("OracleAWExporter.ErrorDuringExportToAnlyticalWorkspace"), OracleAWExporter.this.awName), Messages.getString("OracleAWExporter.Error"), 0);
                        throw throwable;
                    }
                    JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("OracleAWExporter.ErrorDuringExportToAnlyticalWorkspace"), OracleAWExporter.this.awName), Messages.getString("OracleAWExporter.Error"), 0);
                    return;
                }
                finally {
                    if (OracleAWExporter.this.atached && OracleAWExporter.this.globalAW != null) {
                        OracleAWExporter.this.globalAW.Detach(OracleAWExporter.this.awConnection);
                        OracleAWExporter.this.atached = false;
                    }
                }
            }
            catch (Exception exception) {
                OracleAWExporter.this.err = exception.toString();
                LOGGER.error("Error Generate Analytical Workspace: ", exception);
                if (OracleAWExporter.this.atached && OracleAWExporter.this.globalAW != null) {
                    OracleAWExporter.this.globalAW.Detach(OracleAWExporter.this.awConnection);
                    OracleAWExporter.this.atached = false;
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        LogReport logReport = new LogReport(OracleAWExporter.this.mdmDesign.getAppView());
                        logReport.setName("Error Log");
                        logReport.setLog(OracleAWExporter.this.err);
                        logReport.showDialog(new Dimension(750, 550));
                    }
                });
                return;
            }
            finally {
                OracleAWExporter.this.closeConnection();
                AW.setCurAW(null);
                System.gc();
            }
        }
    }

    private class Runner
    implements Runnable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            block42: {
                block44: {
                    int n;
                    File file;
                    OracleAWExporter.this.monitor = new ProgressDialog(OracleAWExporter.this.appView, "", 0, 100);
                    OracleAWExporter.this.monitor.setProgress(1);
                    OracleAWExporter.this.monitor.setNote(" ");
                    if (!OracleAWExporter.this.exportType.equals(EXPORT_METADATA_TO_FILE)) break block42;
                    boolean bl = true;
                    if ("".equals(OracleAWExporter.this.fileName.trim())) {
                        OracleAWExporter.this.fileName = OracleAWExporter.this.awName.trim() + ".xml";
                    }
                    if (OracleAWExporter.this.fileName.indexOf(46) == -1) {
                        OracleAWExporter.this.fileName = OracleAWExporter.this.fileName + ".xml";
                    }
                    if ((file = new File(OracleAWExporter.this.fileName)).exists() && (n = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("OracleAWExporter.FileExists"), file.getAbsolutePath()), Messages.getString("OracleAWExporter.Warning"), 0, 3, OracleAWExporter.this.getConfiguration().getIcon("SAVE_ICON", 32))) == 1) {
                        bl = false;
                    }
                    if (!bl) break block42;
                    OracleAWExporter.this.dimMap = new TreeMap();
                    OracleAWExporter.this.hierMap = new TreeMap();
                    OracleAWExporter.this.globalAW = new AW();
                    OracleAWExporter.this.globalAW.setName(OracleAWExporter.this.awName);
                    OracleAWExporter.this.monitor.setProgress(5);
                    OracleAWExporter.this.monitor.setNote(Messages.getString("OracleAWExporter.BuildAnalyticWorkspace"));
                    OracleAWExporter.this.createAW();
                    String string = OracleAWExporter.this.globalAW.WriteToXML();
                    try {
                        if (bl) {
                            OracleAWExporter.this.monitor.setProgress(55);
                            OracleAWExporter.this.monitor.setNote(Messages.getString("OracleAWExporter.WriteAWMetadataToFile"));
                            FileWriter fileWriter = new FileWriter(file);
                            fileWriter.write(string);
                            fileWriter.write("\n");
                            fileWriter.close();
                        }
                    }
                    catch (Exception exception) {
                        String string2 = exception.toString();
                        LOGGER.error("Failure to write XML string to file: " + OracleAWExporter.this.fileName + "\n", exception);
                        System.out.println("Failure to write XML string to file: " + OracleAWExporter.this.fileName + "\n" + string2);
                    }
                    OracleAWExporter.this.monitor.close();
                    if (OracleAWExporter.this.commited || OracleAWExporter.this.exportType.equals(EXPORT_METADATA_TO_FILE)) break block44;
                    JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("OracleAWExporter.ErrorCreatingAnlyticalWorkspace"), OracleAWExporter.this.awName), Messages.getString("OracleAWExporter.Error"), 0);
                }
                OracleAWExporter.this.closeConnection();
                AW.setCurAW(null);
                System.gc();
                return;
            }
            try {
                try {
                    block45: {
                        OracleAWExporter.this.monitor.setProgress(5);
                        OracleAWExporter.this.atached = false;
                        OracleAWExporter.this.monitor.setNote(Messages.getString("OracleAWExporter.DeleteExistingAnalyticWorkspace"));
                        OracleAWExporter.this.deleteExistingAW(OracleAWExporter.this.awConnection, OracleAWExporter.this.user, OracleAWExporter.this.awName);
                        OracleAWExporter.this.monitor.setProgress(20);
                        if (OracleAWExporter.this.atached) {
                            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("OracleAWExporter.AnalyticWorkspaceAttached"), OracleAWExporter.this.user, OracleAWExporter.this.awName), Messages.getString("OracleAWExporter.Error"), 0);
                            break block45;
                        }
                        OracleAWExporter.this.dimMap = new TreeMap();
                        OracleAWExporter.this.hierMap = new TreeMap();
                        OracleAWExporter.this.globalAW = new AW();
                        OracleAWExporter.this.globalAW.setName(OracleAWExporter.this.awName);
                        try {
                            OracleAWExporter.this.monitor.setNote(Messages.getString("OracleAWExporter.BuildAnalyticWorkspace"));
                            OracleAWExporter.this.createAW();
                            String string = OracleAWExporter.this.globalAW.WriteToXML();
                            try {
                                boolean bl = true;
                                if ("".equals(OracleAWExporter.this.fileName.trim())) {
                                    bl = false;
                                }
                                File file = null;
                                if (bl) {
                                    int n;
                                    if (OracleAWExporter.this.fileName.indexOf(46) == -1) {
                                        OracleAWExporter.this.fileName = OracleAWExporter.this.fileName + ".xml";
                                    }
                                    if ((file = new File(OracleAWExporter.this.fileName)).exists() && (n = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), Messages.getString("OracleAWExporter.FileExists") + '\"' + file.getAbsolutePath() + '\"' + " already exists.\nDo you want to overwrite it?", Messages.getString("OracleAWExporter.Warning"), 0, 3, OracleAWExporter.this.getConfiguration().getIcon("SAVE_ICON", 32))) == 1) {
                                        bl = false;
                                    }
                                }
                                if (bl) {
                                    FileWriter fileWriter = new FileWriter(file);
                                    fileWriter.write(string);
                                    fileWriter.write("\n");
                                    fileWriter.close();
                                }
                            }
                            catch (Exception exception) {
                                String string3 = exception.toString();
                                LOGGER.error("Failure to write XML string to file: " + OracleAWExporter.this.fileName + "\n", exception);
                                System.out.println("Failure to write XML string to file: " + OracleAWExporter.this.fileName + "\n" + string3);
                            }
                            if (OracleAWExporter.this.buildAW) {
                                OracleAWExporter.this.monitor.setProgress(25);
                            } else {
                                OracleAWExporter.this.monitor.setProgress(40);
                            }
                            OracleAWExporter.this.monitor.setNote(Messages.getString("OracleAWExporter.CreateAnalyticWorkspace"));
                            OracleAWExporter.this.atached = true;
                            OracleAWExporter.this.globalAW.Create(OracleAWExporter.this.awConnection);
                            if (OracleAWExporter.this.buildAW) {
                                OracleAWExporter.this.monitor.setProgress(50);
                            } else {
                                OracleAWExporter.this.monitor.setProgress(75);
                            }
                            OracleAWExporter.this.created = true;
                            OracleAWExporter.this.monitor.setNote(Messages.getString("OracleAWExporter.CommitAnalyticWorkspace"));
                            OracleAWExporter.this.globalAW.Commit(OracleAWExporter.this.awConnection);
                            OracleAWExporter.this.commited = true;
                            if (OracleAWExporter.this.buildAW) {
                                try {
                                    OracleAWExporter.this.monitor.setProgress(70);
                                    OracleAWExporter.this.monitor.setNote(Messages.getString("OracleAWExporter.PopulatingAalyticWorkspace"));
                                    OracleAWExporter.this.xml_build_global_aw(OracleAWExporter.this.awName);
                                }
                                catch (Exception exception) {
                                    System.out.println("The following error occurred while building  " + OracleAWExporter.this.awName + ":\n\t" + exception.toString());
                                }
                            }
                        }
                        finally {
                            if (OracleAWExporter.this.created) {
                                OracleAWExporter.this.monitor.setProgress(95);
                                OracleAWExporter.this.monitor.setNote(Messages.getString("OracleAWExporter.DetachAnalyticWorkspace"));
                                OracleAWExporter.this.globalAW.Detach(OracleAWExporter.this.awConnection);
                                OracleAWExporter.this.atached = false;
                            }
                        }
                        OracleAWExporter.this.monitor.setProgress(100);
                        JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), Messages.getString("OracleAWExporter.ExportedOk"));
                        {
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                    }
                    OracleAWExporter.this.monitor.close();
                    if (OracleAWExporter.this.commited || OracleAWExporter.this.exportType.equals(EXPORT_METADATA_TO_FILE)) return;
                }
                catch (Throwable throwable) {
                    OracleAWExporter.this.monitor.close();
                    if (OracleAWExporter.this.commited || OracleAWExporter.this.exportType.equals(EXPORT_METADATA_TO_FILE)) throw throwable;
                    JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("OracleAWExporter.ErrorCreatingAnlyticalWorkspace"), OracleAWExporter.this.awName), Messages.getString("OracleAWExporter.Error"), 0);
                    throw throwable;
                }
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("OracleAWExporter.ErrorCreatingAnlyticalWorkspace"), OracleAWExporter.this.awName), Messages.getString("OracleAWExporter.Error"), 0);
                return;
            }
            catch (Exception exception) {
                OracleAWExporter.this.err = exception.toString();
                LOGGER.error("Error Generate Analytical Workspace: ", exception);
                if (OracleAWExporter.this.atached) {
                    OracleAWExporter.this.globalAW.Detach(OracleAWExporter.this.awConnection);
                    OracleAWExporter.this.atached = false;
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        LogReport logReport = new LogReport(OracleAWExporter.this.mdmDesign.getAppView());
                        logReport.setName("Error Log");
                        logReport.setLog(OracleAWExporter.this.err);
                        logReport.showDialog(new Dimension(750, 550));
                    }
                });
                return;
            }
            finally {
                OracleAWExporter.this.closeConnection();
                AW.setCurAW(null);
                System.gc();
            }
        }
    }

    class MeasureDesc {
        Measure awmeasure;
        oracle.dbtools.crest.model.design.multidimensional.Measure measure;
        String awmeasureName;
        Slice.MeasureWrapper mwrapper;

        MeasureDesc() {
        }
    }

    class LevelDesc {
        oracle.dbtools.crest.model.design.multidimensional.Level level;
        oracle.dbtools.crest.model.design.multidimensional.Dimension dim;
        Level olevel;
        oracle.AWXML.Dimension odimension;
        Attribute attribute;

        LevelDesc() {
        }
    }
}

