/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.oracleaw;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import oracle.dbtools.crest.exports.Messages;
import oracle.dbtools.crest.exports.oracleaw.OracleAWExporter;
import oracle.dbtools.crest.imports.metadata.DBMExtractionController;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.multidimensional.Cube;
import oracle.dbtools.crest.model.design.multidimensional.Level;
import oracle.dbtools.crest.model.design.multidimensional.MultidimensionalDesign;
import oracle.dbtools.crest.model.design.multidimensional.Slice;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.multidimensional.CubePropertiesDialogEx;
import oracle.dbtools.crest.swingui.editor.multidimensional.SlicePropertiesDialogEx;
import oracle.dbtools.crest.swingui.wizards.metadata.connection.ConnectionInfo;
import oracle.dbtools.crest.swingui.wizards.metadata.connection.FCPConnectionDialog;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.ide.Ide;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFilter;
import oracle.jdeveloper.db.DatabaseConnections;

public class AWExportOptions
extends CustomDialog {
    private File logicalFile = null;
    private JDialog dialog;
    private boolean result;
    private DefaultListModel listModel;
    private static final int FIELD_WIDTH = 150;
    private static final int FIELD_HEIGHT = 20;
    private Dimension prefDimension = new Dimension(230, 20);
    private Dimension filePrefDimension = new Dimension(150, 20);
    private JTextField tfSchema;
    private JTextField tfAWName;
    private JTextField tfXMLFile;
    private JComboBox cbMDM;
    private JComboBox cbRelDes;
    private JComboBox cbStorage;
    private JComboBox cbConn;
    private JComboBox cbExpMode;
    private Design design;
    private RelationalDesign physicalDesign;
    private StorageDesign storageDesign;
    private MultidimensionalDesign multidimensionalDesign;
    private String schema = "";
    private Connection connection;
    private String aWName;
    private JCheckBox chPopulate;
    private String exportMode = OracleAWExporter.EXPORT_RECREATE_AW;
    private JTabbedPane tabbed;
    private DBMExtractionController controller;
    private static File lastFolder = null;
    private static final Logger LOGGER = new Logger(AWExportOptions.class);
    MultidimensionalDesign currentMDM;
    JTable selectedTable;
    private List selectedObjects = new ArrayList();

    public AWExportOptions(ApplicationView applicationView) {
        super(applicationView);
        Object object;
        Object object2;
        Serializable serializable;
        Object object3;
        Object object4;
        this.setLayout(new BorderLayout());
        this.result = false;
        this.design = applicationView.getCurrentDesign();
        JPanel jPanel = new JPanel(new BorderLayout());
        this.tabbed = new JTabbedPane();
        JPanel jPanel2 = new JPanel(new GridLayout(0, 1));
        jPanel2.setBorder(BorderFactory.createTitledBorder(""));
        JLabel jLabel = new JLabel(Messages.getString("AWExportOptions.DefaultSchema"));
        jLabel.setPreferredSize(this.prefDimension);
        jLabel.setToolTipText(Messages.getString("AWExportOptions.UsedForDimensionalIObjectsAndTables"));
        this.tfSchema = new JTextField("");
        this.tfSchema.setPreferredSize(this.prefDimension);
        this.tfSchema.setToolTipText(Messages.getString("AWExportOptions.UsedForDimensionalObjectsAndTables"));
        JPanel jPanel3 = this.newRow(jLabel, this.tfSchema);
        jPanel2.add(jPanel3);
        MultidimensionalDesign multidimensionalDesign = this.design.getMultidimensionalDesign();
        JLabel jLabel2 = new JLabel(Messages.getString("AWExportOptions.DimensionalModel"));
        jLabel2.setPreferredSize(this.prefDimension);
        this.cbMDM = new JComboBox<Object>(this.design.getMultidimensionalDesigns().toArray());
        this.cbMDM.setFont(this.cbMDM.getFont().deriveFont(0));
        this.cbMDM.setPreferredSize(this.prefDimension);
        this.cbMDM.setSelectedItem(multidimensionalDesign);
        jPanel3 = this.newRow(jLabel2, this.cbMDM);
        jPanel2.add(jPanel3);
        this.currentMDM = multidimensionalDesign;
        this.buildSelected();
        this.cbMDM.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object = AWExportOptions.this.cbMDM.getSelectedItem();
                if (object != AWExportOptions.this.currentMDM) {
                    AWExportOptions.this.currentMDM = (MultidimensionalDesign)object;
                    AWExportOptions.this.buildSelected();
                }
            }
        });
        JLabel jLabel3 = new JLabel(Messages.getString("AWExportOptions.RelationalModel"));
        ArrayList arrayList = new ArrayList();
        arrayList.add(null);
        this.design.getRelationalDesigns().addAllElementsTo(arrayList);
        jLabel3.setPreferredSize(this.prefDimension);
        this.cbRelDes = new JComboBox<Object>(arrayList.toArray());
        if (arrayList.size() == 2) {
            this.cbRelDes.setSelectedItem(arrayList.get(1));
        }
        this.cbRelDes.setFont(this.cbRelDes.getFont().deriveFont(0));
        this.cbRelDes.setPreferredSize(this.prefDimension);
        jPanel3 = this.newRow(jLabel3, this.cbRelDes);
        jPanel2.add(jPanel3);
        JLabel jLabel4 = new JLabel(Messages.getString("AWExportOptions.OracleModel"));
        jLabel4.setPreferredSize(this.prefDimension);
        this.cbStorage = new JComboBox();
        this.cbStorage.setFont(this.cbRelDes.getFont().deriveFont(0));
        this.cbStorage.setPreferredSize(this.prefDimension);
        this.cbStorage.setSelectedItem(null);
        jPanel3 = this.newRow(jLabel4, this.cbStorage);
        jPanel2.add(jPanel3);
        if (arrayList.size() == 2) {
            object4 = this.cbRelDes.getSelectedItem();
            if (object4 != null && object4 instanceof RelationalDesign) {
                object3 = (RelationalDesign)object4;
                serializable = new ArrayList<StorageDesign>();
                serializable.add(null);
                object2 = ((RelationalDesign)object3).getStorageDesignFactory().getOpenStorageDesigns();
                for (int i = 0; i < ((StorageDesign[])object2).length; ++i) {
                    object = object2[i];
                    if (!(object instanceof StorageDesignOraclev10g)) continue;
                    serializable.add(object);
                }
                this.cbStorage.setModel(new DefaultComboBoxModel<Object>(serializable.toArray()));
                if (serializable.size() == 2) {
                    this.cbStorage.setSelectedItem(serializable.get(1));
                }
            } else if (object4 == null) {
                this.cbStorage.setModel(new DefaultComboBoxModel<Object>(new Object[0]));
            }
        }
        object4 = new JLabel(Messages.getString("AWExportOptions.OracleAWName"));
        ((JComponent)object4).setPreferredSize(this.prefDimension);
        ((JComponent)object4).setToolTipText(Messages.getString("AWExportOptions.TheNameOfOracleAW"));
        this.tfAWName = new JTextField("");
        this.tfAWName.setPreferredSize(this.prefDimension);
        this.tfAWName.setToolTipText(Messages.getString("AWExportOptions.TheNameOfOracleAW"));
        jPanel3 = this.newRow((JLabel)object4, this.tfAWName);
        jPanel2.add(jPanel3);
        object3 = new JLabel(Messages.getString("AWExportOptions.ExportMode"));
        ((JComponent)object3).setPreferredSize(this.prefDimension);
        this.cbExpMode = new JComboBox<String>(OracleAWExporter.EXPORT_TYPES);
        this.cbExpMode.setFont(this.cbMDM.getFont().deriveFont(0));
        this.cbExpMode.setPreferredSize(this.prefDimension);
        this.cbExpMode.setSelectedItem(OracleAWExporter.EXPORT_NEW_CALC_MEASURES);
        jPanel3 = this.newRow((JLabel)object3, this.cbExpMode);
        jPanel2.add(jPanel3);
        serializable = new JLabel(Messages.getString("AWExportOptions.PopulateCreatedCubes"));
        ((JComponent)serializable).setPreferredSize(this.prefDimension);
        this.chPopulate = new JCheckBox();
        this.chPopulate.setPreferredSize(this.prefDimension);
        this.chPopulate.setSelected(true);
        jPanel3 = this.newRow((JLabel)serializable, this.chPopulate);
        jPanel2.add(jPanel3);
        object2 = new JLabel(Messages.getString("AWExportOptions.OutputXMLFile"));
        ((JComponent)object2).setPreferredSize(this.prefDimension);
        ((JComponent)object2).setToolTipText(Messages.getString("AWExportOptions.OutputXMLFileForMetadataDefinitions"));
        this.tfXMLFile = new JTextField("");
        this.tfXMLFile.setPreferredSize(this.filePrefDimension);
        this.tfXMLFile.setToolTipText(Messages.getString("AWExportOptions.OutputXMLFileForMetadataDefinitions"));
        JButton jButton = new JButton("...");
        jButton.setPreferredSize(new Dimension(30, 20));
        jButton.setToolTipText(Messages.getString("AWExportOptions.SelectOutputXMLFile"));
        jButton.setMargin(new Insets(0, 0, 5, 0));
        object = new JToolBar();
        ((JComponent)object).setBorder(BorderFactory.createEmptyBorder());
        ((JComponent)object).setPreferredSize(this.prefDimension);
        ((Container)object).add(this.tfXMLFile);
        ((Container)object).add(jButton);
        ((JToolBar)object).setFloatable(false);
        jPanel3 = this.newRow((JLabel)object2, (Component)object);
        jPanel2.add(jPanel3);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AWExportOptions.this.tfXMLFile.setText(AWExportOptions.this.getOutputFileName());
            }
        });
        JLabel jLabel5 = new JLabel(Messages.getString("AWExportOptions.JDBCConnection"));
        jLabel5.setPreferredSize(this.prefDimension);
        this.cbConn = new JComboBox();
        this.cbConn.setRenderer(new ComboBoxRenderer());
        this.updateConnections();
        this.cbConn.setFont(this.cbRelDes.getFont().deriveFont(0));
        this.cbConn.setPreferredSize(this.prefDimension);
        jPanel3 = this.newRow(jLabel5, this.cbConn);
        jPanel2.add(jPanel3);
        JLabel jLabel6 = new JLabel(Messages.getString("AWExportOptions.NewJDBCConnection"));
        jLabel6.setPreferredSize(this.prefDimension);
        JButton jButton2 = new JButton(Messages.getString("AWExportOptions.Create"));
        jButton2.setPreferredSize(this.prefDimension);
        jButton2.setFont(this.cbRelDes.getFont().deriveFont(0));
        jPanel3 = this.newRow(jLabel6, jButton2);
        jPanel2.add(jPanel3);
        jButton2.addActionListener(new AddAction());
        JLabel jLabel7 = new JLabel(Messages.getString("AWExportOptions.TestSelectedConnection"));
        jLabel7.setPreferredSize(this.prefDimension);
        JButton jButton3 = new JButton(Messages.getString("AWExportOptions.Test"));
        jButton3.setPreferredSize(this.prefDimension);
        jButton3.setFont(this.cbRelDes.getFont().deriveFont(0));
        jPanel3 = this.newRow(jLabel7, jButton3);
        jPanel2.add(jPanel3);
        jButton3.addActionListener(new TestAction());
        this.cbRelDes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object = AWExportOptions.this.cbRelDes.getSelectedItem();
                if (object != null && object instanceof RelationalDesign) {
                    RelationalDesign relationalDesign = (RelationalDesign)object;
                    ArrayList<StorageDesign> arrayList = new ArrayList<StorageDesign>();
                    arrayList.add(null);
                    StorageDesign[] storageDesignArray = relationalDesign.getStorageDesignFactory().getOpenStorageDesigns();
                    for (int i = 0; i < storageDesignArray.length; ++i) {
                        StorageDesign storageDesign = storageDesignArray[i];
                        if (!(storageDesign instanceof StorageDesignOraclev10g)) continue;
                        arrayList.add(storageDesign);
                    }
                    AWExportOptions.this.cbStorage.setModel(new DefaultComboBoxModel<Object>(arrayList.toArray()));
                } else if (object == null) {
                    AWExportOptions.this.cbStorage.setModel(new DefaultComboBoxModel<Object>(new Object[0]));
                }
            }
        });
        JPanel jPanel4 = new JPanel(new FlowLayout(2));
        JButton jButton4 = new JButton(Messages.getString("AWExportOptions.OK"));
        jButton4.setMnemonic(79);
        jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AWExportOptions.this.result = AWExportOptions.this.checkSettings();
                if (AWExportOptions.this.result) {
                    AWExportOptions.this.close();
                }
            }
        });
        jPanel4.add(jButton4);
        JButton jButton5 = new JButton(Messages.getString("AWExportOptions.Cancel"));
        jButton5.setMnemonic(67);
        jButton5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AWExportOptions.this.result = false;
                AWExportOptions.this.close();
            }
        });
        jPanel4.add(jButton5);
        JButton jButton6 = new JButton(this.getHelpAction());
        jButton6.setMnemonic(72);
        jPanel4.add(jButton6);
        jButton4.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jButton5.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jButton6.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.tabbed.add(Messages.getString("AWExportOptions.General"), jPanel2);
        this.initSelectedObjectsTab();
        jPanel.add((Component)this.tabbed, "Center");
        jPanel.add((Component)jPanel4, "South");
        this.add(jPanel);
    }

    @Override
    protected void close() {
        this.getDialog().dispose();
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog((Frame)this.getApplicationView().getFrame(), Messages.getString("AWExportOptions.ExportToOracleAWOptions"));
            this.dialog.setModal(true);
            this.dialog.getContentPane().add(this);
            this.setDefaultActions(this.dialog);
            this.dialog.pack();
            this.dialog.setResizable(false);
            CommonUtil.centerOnScreen(this.dialog);
        }
        return this.dialog;
    }

    @Override
    protected String getHelpIndex() {
        return "EXPORT_TO_ORACLE_AW_DIALOG";
    }

    public boolean showDialog() {
        this.getDialog().setVisible(true);
        return this.result;
    }

    private void buildSelected() {
        this.selectedObjects.clear();
        MultidimensionalDesign multidimensionalDesign = (MultidimensionalDesign)this.cbMDM.getSelectedItem();
        if (multidimensionalDesign != null) {
            Iterator iterator = multidimensionalDesign.getCubeSet().iterator();
            while (iterator.hasNext()) {
                Cube cube = (Cube)iterator.next();
                SelObject selObject = new SelObject();
                selObject.selected = true;
                selObject.object = cube;
                this.selectedObjects.add(selObject);
                for (Slice slice : cube.getPrecalculatedSlices()) {
                    selObject = new SelObject();
                    selObject.selected = false;
                    selObject.object = slice;
                    this.selectedObjects.add(selObject);
                }
            }
        }
        if (this.selectedTable != null) {
            this.selectedTable.updateUI();
        }
    }

    private void initSelectedObjectsTab() {
        this.selectedTable = new JTable(new SelAttributesModel());
        this.selectedTable.setSelectionMode(0);
        this.selectedTable.setDefaultRenderer(Object.class, new SelAttributesRenderer());
        this.selectedTable.getTableHeader().setReorderingAllowed(false);
        this.selectedTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                int n;
                if (mouseEvent.getClickCount() == 2 && (n = AWExportOptions.this.selectedTable.getSelectedRow()) != -1 && AWExportOptions.this.selectedObjects.size() > 0 && n < AWExportOptions.this.selectedObjects.size()) {
                    SelObject selObject = (SelObject)AWExportOptions.this.selectedObjects.get(n);
                    if (selObject.object instanceof Cube) {
                        CubePropertiesDialogEx cubePropertiesDialogEx = new CubePropertiesDialogEx(AWExportOptions.this.getApplicationView(), selObject.object);
                        cubePropertiesDialogEx.initProperties(selObject.object);
                        cubePropertiesDialogEx.setModal(true);
                        cubePropertiesDialogEx.setVisible(true);
                    } else if (selObject.object instanceof Slice) {
                        SlicePropertiesDialogEx slicePropertiesDialogEx = new SlicePropertiesDialogEx(AWExportOptions.this.getApplicationView(), selObject.object);
                        slicePropertiesDialogEx.initProperties(selObject.object);
                        slicePropertiesDialogEx.setModal(true);
                        slicePropertiesDialogEx.setVisible(true);
                    }
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.selectedTable);
        jScrollPane.setPreferredSize(new Dimension(325, 410));
        JPanel jPanel = new JPanel();
        jPanel.add(jScrollPane);
        this.selectedTable.setAutoResizeMode(0);
        TableColumn tableColumn = null;
        tableColumn = this.selectedTable.getColumnModel().getColumn(0);
        tableColumn.setPreferredWidth(60);
        tableColumn = this.selectedTable.getColumnModel().getColumn(1);
        tableColumn.setPreferredWidth(262);
        this.tabbed.addTab(Messages.getString("AWExportOptions.CubesAndSlices"), jPanel);
    }

    public File getLogicalFile() {
        return this.logicalFile;
    }

    public Object[] getRelationalFiles() {
        return this.listModel.toArray();
    }

    public void closeConnection() {
        if (this.connection != null) {
            try {
                if (!this.connection.isClosed()) {
                    this.connection.close();
                }
                this.connection = null;
            }
            catch (Exception exception) {
                LOGGER.error("Unable to close the connection", exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean initConnection() {
        block5: {
            this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                this.closeConnection();
                Properties properties = this.getSelectedConnectionProperties();
                if (properties == null) break block5;
                try {
                    this.connection = DatabaseConnections.getInstance().getConnection(properties);
                }
                catch (Exception exception) {
                    MessageDialogs.showErrorMessage(exception.getLocalizedMessage());
                    boolean bl = false;
                    this.setCursor(Cursor.getPredefinedCursor(0));
                    return bl;
                }
            }
            finally {
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
        return this.connection != null;
    }

    private boolean checkSettings() {
        this.schema = this.tfSchema.getText();
        this.exportMode = (String)this.cbExpMode.getSelectedItem();
        if ("".equalsIgnoreCase(this.schema)) {
            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), Messages.getString("AWExportOptions.SetDefaultSchema"), Messages.getString("AWExportOptions.Warning"), 2);
            return false;
        }
        this.aWName = this.tfAWName.getText();
        if ("".equalsIgnoreCase(this.aWName)) {
            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), Messages.getString("AWExportOptions.SetTheNameOfAnalyticalWorkspace"), Messages.getString("AWExportOptions.Warning"), 2);
            return false;
        }
        if (this.cbConn.getSelectedItem() == null && !OracleAWExporter.EXPORT_METADATA_TO_FILE.equals(this.exportMode)) {
            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), Messages.getString("AWExportOptions.SelectJDBCConnection"), Messages.getString("AWExportOptions.Warning"), 2);
            return false;
        }
        if (!this.initConnection()) {
            return false;
        }
        this.physicalDesign = (RelationalDesign)this.cbRelDes.getSelectedItem();
        if (this.physicalDesign == null) {
            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), Messages.getString("AWExportOptions.SelectRelationalModel"), Messages.getString("AWExportOptions.Warning"), 2);
            return false;
        }
        this.storageDesign = (StorageDesign)this.cbStorage.getSelectedItem();
        this.multidimensionalDesign = (MultidimensionalDesign)this.cbMDM.getSelectedItem();
        return true;
    }

    private JPanel newRow(JLabel jLabel, Component component) {
        JPanel jPanel = new JPanel();
        jPanel.add(jLabel);
        jPanel.add(component);
        return jPanel;
    }

    public RelationalDesign getPhysicalDesign() {
        return this.physicalDesign;
    }

    public String getSchema() {
        return this.schema;
    }

    public StorageDesign getStorageDesign() {
        return this.storageDesign;
    }

    public MultidimensionalDesign getMultidimensionalDesign() {
        return this.multidimensionalDesign;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public String getAWName() {
        return this.aWName;
    }

    public DBMExtractionController getController() {
        if (this.controller == null) {
            this.controller = new DBMExtractionController(this.getApplicationView());
        }
        return this.controller;
    }

    private Properties getSelectedConnectionProperties() {
        Properties properties = null;
        try {
            properties = (Properties)this.cbConn.getSelectedItem();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return properties;
    }

    private void updateConnections() {
        ArrayList<Properties> arrayList = new ArrayList<Properties>();
        List<Properties> list = ConnectionInfo.getAllConnections(DatabaseConnections.getInstance(), true);
        for (Properties properties : list) {
            if (ConnectionInfo.getConnectionType(properties) != 1) continue;
            arrayList.add(properties);
        }
        this.cbConn.setModel(new DefaultComboBoxModel<Object>(arrayList.toArray()));
        this.cbConn.setSelectedItem(null);
    }

    private String getOutputFileName() {
        File file;
        String string;
        URLFilter uRLFilter = new URLFilter(){

            public boolean accept(URL uRL) {
                File file = new File(uRL.getPath());
                return file.getName().toLowerCase().endsWith(".xml") || file.isDirectory();
            }

            public String toString() {
                return Messages.getString("AWExportOptions.XMLFiles");
            }
        };
        URLChooser uRLChooser = DialogUtil.newURLChooser();
        uRLChooser.clearChooseableURLFilters();
        uRLChooser.setSelectionScope(0);
        uRLChooser.setSelectionMode(0);
        uRLChooser.setShowJarsAsDirs(false);
        uRLChooser.setURLFilter(uRLFilter);
        if (lastFolder != null) {
            uRLChooser.setSelectedURL(URLFactory.newDirURL((File)lastFolder));
        } else {
            string = this.getApplicationView().getSettings().getDefaultSavePath();
            if (string != null && string.length() > 0) {
                uRLChooser.setSelectedURL(URLFactory.newDirURL((String)string));
            } else {
                URL uRL = this.getApplicationView().getUserHomeDirectory();
                if (uRL != null) {
                    uRLChooser.setSelectedURL(uRL);
                }
            }
        }
        string = this.tfXMLFile.getText();
        if (!"".equals(string.trim()) && !string.toLowerCase().endsWith(".xml") && string.indexOf(46) < 0) {
            string = string + ".xml";
        }
        uRLChooser.setFileNameURL(string);
        int n = uRLChooser.showSaveDialog((Component)Ide.getMainWindow(), Messages.getString("AWExportOptions.SaveToXMLFile"));
        if (n == 0 && (file = new File(uRLChooser.getSelectedURL().getPath())) != null) {
            lastFolder = file.getParentFile();
            return file.toString();
        }
        return this.tfXMLFile.getText();
    }

    public List getSelectedObjects() {
        return this.selectedObjects;
    }

    public boolean isPopulateCubes() {
        return this.chPopulate.isSelected();
    }

    public String getFileName() {
        return this.tfXMLFile.getText();
    }

    public String getExportMode() {
        return this.exportMode;
    }

    public class SelAttributesCBRenderer
    extends JCheckBox
    implements TableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            SelObject selObject = (SelObject)AWExportOptions.this.selectedObjects.get(n);
            this.setSelected(selObject.selected);
            return this;
        }
    }

    public class SelAttributesRenderer
    extends DefaultTableCellRenderer {
        SelAttributesCBRenderer cbRenderer;

        public SelAttributesRenderer() {
            this.cbRenderer = new SelAttributesCBRenderer();
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Color color;
            Color color2;
            SelObject selObject = (SelObject)AWExportOptions.this.selectedObjects.get(n);
            Component component = !(selObject.object instanceof Level) && n2 == 0 ? this.cbRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2) : super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (selObject.object instanceof Slice) {
                color2 = Color.LIGHT_GRAY;
                color = Color.WHITE;
            } else {
                color2 = Color.WHITE;
                color = Color.BLACK;
            }
            component.setBackground(color2);
            component.setForeground(color);
            return component;
        }
    }

    class SelObject {
        boolean selected = false;
        DesignObject object;

        SelObject() {
        }

        String getType() {
            if (this.object instanceof Cube) {
                return "Cube";
            }
            if (this.object instanceof Slice) {
                return "Slice";
            }
            return " ";
        }
    }

    private class SelAttributesModel
    extends AbstractTableModel {
        final String[] COL_NAMES = new String[]{Messages.getString("AWExportOptions.Selected"), Messages.getString("AWExportOptions.CubeSlice")};

        private SelAttributesModel() {
        }

        @Override
        public int getColumnCount() {
            return this.COL_NAMES.length;
        }

        @Override
        public int getRowCount() {
            return AWExportOptions.this.selectedObjects.size();
        }

        @Override
        public String getColumnName(int n) {
            return this.COL_NAMES[n];
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 <= 0;
        }

        public Class getColumnClass(int n) {
            if (n == 0) {
                return Boolean.class;
            }
            return String.class;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 0) {
                SelObject selObject = (SelObject)AWExportOptions.this.selectedObjects.get(n);
                if (object instanceof Boolean) {
                    selObject.selected = (Boolean)object;
                }
            }
        }

        @Override
        public Object getValueAt(int n, int n2) {
            SelObject selObject = (SelObject)AWExportOptions.this.selectedObjects.get(n);
            if (n2 == 1) {
                if (selObject.object instanceof Slice) {
                    return "     " + selObject.object.getName();
                }
                return selObject.object.getName();
            }
            if (n2 == 0 && selObject.object instanceof Level) {
                return "level";
            }
            if (n2 == 0) {
                return selObject.selected;
            }
            return new Integer(n * n2);
        }
    }

    private class TestAction
    implements ActionListener {
        private TestAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FCPConnectionDialog.testConnection(AWExportOptions.this.getSelectedConnectionProperties());
        }
    }

    private class AddAction
    implements ActionListener {
        private AddAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                FCPConnectionDialog.showConnectionDialog(true);
                AWExportOptions.this.updateConnections();
            }
            catch (Exception exception) {
                LOGGER.error(exception);
            }
        }
    }

    class ComboBoxRenderer
    extends JLabel
    implements ListCellRenderer {
        public ComboBoxRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            Properties properties = (Properties)object;
            if (properties != null) {
                this.setText(ConnectionInfo.getConnectionName(properties));
            }
            return this;
        }
    }
}

