/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.udb.v81;

import java.util.List;
import oracle.dbtools.crest.exports.ddl.udb.AbstractSSBUDB;
import oracle.dbtools.crest.model.design.storage.udb.ContainerUDB;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableSpaceUDB;
import oracle.dbtools.crest.model.design.storage.udb.v81.ContainerUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.TableSpaceUDBv81;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBTableSpaceUDBv81
extends AbstractSSBUDB {
    private StorageDesignUDB storageDesign;
    public static final String PAGESIZE = "PAGESIZE";
    public static final String MANAGED_BY = "MANAGED BY";
    public static final String EXTENTSIZE = "EXTENTSIZE";
    public static final String PREFETCHSIZE = "PREFETCHSIZE";
    public static final String OVERHEAD = "OVERHEAD";
    public static final String TRANSFERRATE = "TRANSFERRATE";
    public static final String DROPPED_TABLE_RECOVERY = "DROPPED TABLE RECOVERY";
    public static final String ON_DBPARTITIONNUM = "ON DBPARTITIONNUM";

    @Override
    public boolean canHandle(Object object) {
        return object instanceof TableSpaceUDBv81 && ((TableSpaceUDBv81)object).isMarkedGenerate();
    }

    @Override
    protected void doAppend(StringBuffer stringBuffer, Object object, boolean bl) {
        TableSpaceUDBv81 tableSpaceUDBv81 = (TableSpaceUDBv81)object;
        this.storageDesign = (StorageDesignUDB)this.getStorageDesign(object);
        if (!tableSpaceUDBv81.getDBDefOnly()) {
            this.appendComment(stringBuffer, tableSpaceUDBv81);
            this.appendCreate(stringBuffer, tableSpaceUDBv81);
            this.appendNodeGroup(stringBuffer, tableSpaceUDBv81, bl);
            this.appendPageSize(stringBuffer, tableSpaceUDBv81, bl);
            this.appendManagedBy(stringBuffer, tableSpaceUDBv81);
            this.appendUsingContainer(stringBuffer, tableSpaceUDBv81, bl);
            this.appendExtentSize(stringBuffer, tableSpaceUDBv81, bl);
            this.appendPrefetchSize(stringBuffer, tableSpaceUDBv81, bl);
            this.appendBufferPool(stringBuffer, tableSpaceUDBv81, bl);
            this.appendOverhead(stringBuffer, tableSpaceUDBv81, bl);
            this.appendTransferRate(stringBuffer, tableSpaceUDBv81, bl);
            this.appendDroppedTableRecovery(stringBuffer, tableSpaceUDBv81, bl);
            SSBTableSpaceUDBv81.appendNewLine(stringBuffer, bl, 0);
            this.appendLineFinisher(stringBuffer, bl);
            DDLFileMaker.incrementCreateTablespace();
            if (tableSpaceUDBv81.getDesign().getAppView().getSettings().isGenerateCommentsInRDBMS()) {
                this.appendCommentOn(stringBuffer, tableSpaceUDBv81, bl);
            }
        }
        this.appendUsePrivileges(stringBuffer, tableSpaceUDBv81, bl);
    }

    private void appendCommentOn(StringBuffer stringBuffer, TableSpaceUDBv81 tableSpaceUDBv81, boolean bl) {
        SSBTableSpaceUDBv81.appendNewLine(stringBuffer, bl, 0);
        SSBTableSpaceUDBv81.appendStringWithSpace(stringBuffer, "COMMENT ON");
        SSBTableSpaceUDBv81.appendStringWithSpace(stringBuffer, "TABLESPACE");
        SSBTableSpaceUDBv81.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(tableSpaceUDBv81.getLongName()));
        SSBTableSpaceUDBv81.appendStringWithSpace(stringBuffer, "IS");
        SSBTableSpaceUDBv81.appendString(stringBuffer, '\'');
        SSBTableSpaceUDBv81.appendString(stringBuffer, tableSpaceUDBv81.getCommentInRDBMS());
        SSBTableSpaceUDBv81.appendStringWithSpace(stringBuffer, '\'');
        SSBTableSpaceUDBv81.appendNewLine(stringBuffer, bl, 0);
        this.appendLineFinisher(stringBuffer, bl);
    }

    protected void appendCreate(StringBuffer stringBuffer, TableSpaceUDBv81 tableSpaceUDBv81) {
        this.appendCreate(stringBuffer);
        SSBTableSpaceUDBv81.appendStringWithSpace(stringBuffer, tableSpaceUDBv81.getDataType());
        SSBTableSpaceUDBv81.appendStringWithSpace(stringBuffer, "TABLESPACE");
        SSBTableSpaceUDBv81.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(tableSpaceUDBv81.getName()));
    }

    protected void appendNodeGroup(StringBuffer stringBuffer, TableSpaceUDBv81 tableSpaceUDBv81, boolean bl) {
        if (tableSpaceUDBv81.getNodeGroup() != null) {
            SSBTableSpaceUDBv81.appendNewLine(stringBuffer, bl, 1);
            SSBTableSpaceUDBv81.appendStringWithSpace(stringBuffer, "IN");
            SSBTableSpaceUDBv81.appendStringWithSpace(stringBuffer, "DATABASE");
            SSBTableSpaceUDBv81.appendStringWithSpace(stringBuffer, "PARTITION");
            SSBTableSpaceUDBv81.appendStringWithSpace(stringBuffer, "GROUP");
            SSBTableSpaceUDBv81.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(tableSpaceUDBv81.getNodeGroup().getName()));
        }
    }

    protected void appendPageSize(StringBuffer stringBuffer, TableSpaceUDBv81 tableSpaceUDBv81, boolean bl) {
        if (tableSpaceUDBv81.getPageSize() > 0) {
            SSBTableSpaceUDBv81.appendNewLine(stringBuffer, bl, 1);
            SSBTableSpaceUDBv81.appendStringWithSpace(stringBuffer, PAGESIZE);
            this.appendStringWithSpace(stringBuffer, tableSpaceUDBv81.getPageSize());
            SSBTableSpaceUDBv81.appendStringWithSpace(stringBuffer, 'K');
        }
    }

    protected void appendManagedBy(StringBuffer stringBuffer, TableSpaceUDBv81 tableSpaceUDBv81) {
        SSBTableSpaceUDBv81.appendStringWithSpace(stringBuffer, MANAGED_BY);
        SSBTableSpaceUDBv81.appendStringWithSpace(stringBuffer, tableSpaceUDBv81.getManagedBy());
    }

    protected void appendExtentSize(StringBuffer stringBuffer, TableSpaceUDBv81 tableSpaceUDBv81, boolean bl) {
        if (!"".equalsIgnoreCase(tableSpaceUDBv81.getExtentSize())) {
            SSBTableSpaceUDBv81.appendNewLine(stringBuffer, bl, 1);
            SSBTableSpaceUDBv81.appendStringWithSpace(stringBuffer, EXTENTSIZE);
            SSBTableSpaceUDBv81.appendStringWithSpace(stringBuffer, tableSpaceUDBv81.getExtentSize());
        }
    }

    protected void appendPrefetchSize(StringBuffer stringBuffer, TableSpaceUDBv81 tableSpaceUDBv81, boolean bl) {
        if (!"".equalsIgnoreCase(tableSpaceUDBv81.getPrefetchSize())) {
            SSBTableSpaceUDBv81.appendNewLine(stringBuffer, bl, 1);
            SSBTableSpaceUDBv81.appendStringWithSpace(stringBuffer, PREFETCHSIZE);
            SSBTableSpaceUDBv81.appendStringWithSpace(stringBuffer, tableSpaceUDBv81.getPrefetchSize());
        }
    }

    protected void appendBufferPool(StringBuffer stringBuffer, TableSpaceUDBv81 tableSpaceUDBv81, boolean bl) {
        if (tableSpaceUDBv81.getBufferPool() != null) {
            SSBTableSpaceUDBv81.appendNewLine(stringBuffer, bl, 1);
            SSBTableSpaceUDBv81.appendStringWithSpace(stringBuffer, "BUFFERPOOL");
            this.appendStringWithSpace(stringBuffer, tableSpaceUDBv81.getBufferPool());
        }
    }

    protected void appendOverhead(StringBuffer stringBuffer, TableSpaceUDBv81 tableSpaceUDBv81, boolean bl) {
        if (tableSpaceUDBv81.getOverhead() > 0.0f) {
            SSBTableSpaceUDBv81.appendNewLine(stringBuffer, bl, 1);
            SSBTableSpaceUDBv81.appendStringWithSpace(stringBuffer, OVERHEAD);
            this.appendStringWithSpace(stringBuffer, tableSpaceUDBv81.getOverhead());
        }
    }

    protected void appendTransferRate(StringBuffer stringBuffer, TableSpaceUDBv81 tableSpaceUDBv81, boolean bl) {
        if (tableSpaceUDBv81.getTransferRate() > 0.0f) {
            SSBTableSpaceUDBv81.appendNewLine(stringBuffer, bl, 1);
            SSBTableSpaceUDBv81.appendStringWithSpace(stringBuffer, TRANSFERRATE);
            this.appendStringWithSpace(stringBuffer, tableSpaceUDBv81.getTransferRate());
        }
    }

    protected void appendDroppedTableRecovery(StringBuffer stringBuffer, TableSpaceUDBv81 tableSpaceUDBv81, boolean bl) {
        if (tableSpaceUDBv81.getDataType().equalsIgnoreCase("REGULAR")) {
            SSBTableSpaceUDBv81.appendNewLine(stringBuffer, bl, 1);
            SSBTableSpaceUDBv81.appendStringWithSpace(stringBuffer, DROPPED_TABLE_RECOVERY);
            this.appendOnOffWithSpace(stringBuffer, tableSpaceUDBv81.getDroppedTableRecovery());
        }
    }

    protected void appendUsingContainer(StringBuffer stringBuffer, TableSpaceUDBv81 tableSpaceUDBv81, boolean bl) {
        block6: {
            ContainerUDB[] containerUDBArray = tableSpaceUDBv81.getContainers();
            if (containerUDBArray.length <= 0) break block6;
            List list = tableSpaceUDBv81.getAllNodes();
            if (tableSpaceUDBv81.getManagedBy().equalsIgnoreCase("SYSTEM")) {
                for (int i = 0; i < list.size(); ++i) {
                    SSBTableSpaceUDBv81.appendNewLine(stringBuffer, bl, 1);
                    String string = list.get(i).toString();
                    ContainerUDB[] containerUDBArray2 = tableSpaceUDBv81.getContainersForNode(string);
                    SSBTableSpaceUDBv81.appendStringWithSpace(stringBuffer, "USING");
                    SSBTableSpaceUDBv81.appendString(stringBuffer, '(');
                    for (int j = 0; j < containerUDBArray2.length; ++j) {
                        ContainerUDBv81 containerUDBv81 = (ContainerUDBv81)containerUDBArray2[j];
                        SSBTableSpaceUDBv81.appendString(stringBuffer, containerUDBv81.getContainers().trim());
                        if (j >= containerUDBArray2.length - 1) continue;
                        stringBuffer.append(", ");
                    }
                    SSBTableSpaceUDBv81.appendStringWithSpace(stringBuffer, ')');
                    if (string.equalsIgnoreCase("")) continue;
                    SSBTableSpaceUDBv81.appendStringWithSpace(stringBuffer, ON_DBPARTITIONNUM);
                    SSBTableSpaceUDBv81.appendStringWithSpace(stringBuffer, '(');
                    SSBTableSpaceUDBv81.appendStringWithSpace(stringBuffer, string.trim());
                    SSBTableSpaceUDBv81.appendString(stringBuffer, ')');
                }
            } else {
                for (int i = 0; i < list.size(); ++i) {
                    SSBTableSpaceUDBv81.appendNewLine(stringBuffer, bl, 1);
                    String string = list.get(i).toString();
                    ContainerUDB[] containerUDBArray3 = tableSpaceUDBv81.getContainersForNode(string);
                    SSBTableSpaceUDBv81.appendStringWithSpace(stringBuffer, "USING");
                    SSBTableSpaceUDBv81.appendString(stringBuffer, '(');
                    for (int j = 0; j < containerUDBArray3.length; ++j) {
                        ContainerUDBv81 containerUDBv81 = (ContainerUDBv81)containerUDBArray3[j];
                        SSBTableSpaceUDBv81.appendStringWithSpace(stringBuffer, containerUDBv81.getContainers());
                        if (j >= containerUDBArray3.length - 1) continue;
                        stringBuffer.append(", ");
                    }
                    SSBTableSpaceUDBv81.appendStringWithSpace(stringBuffer, ')');
                    if (string.equalsIgnoreCase("")) continue;
                    SSBTableSpaceUDBv81.appendStringWithSpace(stringBuffer, ON_DBPARTITIONNUM);
                    SSBTableSpaceUDBv81.appendStringWithSpace(stringBuffer, '(');
                    SSBTableSpaceUDBv81.appendStringWithSpace(stringBuffer, string);
                    SSBTableSpaceUDBv81.appendString(stringBuffer, ')');
                }
            }
        }
    }

    private void appendUsePrivileges(StringBuffer stringBuffer, TableSpaceUDB tableSpaceUDB, boolean bl) {
        if (!tableSpaceUDB.getUsers().equalsIgnoreCase("") || !tableSpaceUDB.getGroups().equalsIgnoreCase("")) {
            SSBTableSpaceUDBv81.appendNewLine(stringBuffer, bl, 0);
            SSBTableSpaceUDBv81.appendStringWithSpace(stringBuffer, "GRANT");
            SSBTableSpaceUDBv81.appendStringWithSpace(stringBuffer, "USE");
            SSBTableSpaceUDBv81.appendStringWithSpace(stringBuffer, "OF");
            SSBTableSpaceUDBv81.appendStringWithSpace(stringBuffer, "TABLESPACE");
            SSBTableSpaceUDBv81.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(tableSpaceUDB.getName()));
            SSBTableSpaceUDBv81.appendNewLine(stringBuffer, bl, 1);
            SSBTableSpaceUDBv81.appendStringWithSpace(stringBuffer, "TO");
            if (!tableSpaceUDB.getUsers().equalsIgnoreCase("")) {
                int n;
                for (n = 0; n < tableSpaceUDB.getUserSet().size(); ++n) {
                    if (n > 0) {
                        this.appendComma(stringBuffer);
                    }
                    if (!((String)tableSpaceUDB.getUserSet().elementAt(n)).trim().equalsIgnoreCase("PUBLIC")) {
                        SSBTableSpaceUDBv81.appendStringWithSpace(stringBuffer, "USER");
                    }
                    this.appendStringWithSpace(stringBuffer, tableSpaceUDB.getUserSet().elementAt(n));
                }
                if (!tableSpaceUDB.getGroups().equalsIgnoreCase("")) {
                    for (n = 0; n < tableSpaceUDB.getUserGroupSet().size(); ++n) {
                        this.appendComma(stringBuffer);
                        SSBTableSpaceUDBv81.appendStringWithSpace(stringBuffer, "GROUP");
                        this.appendStringWithSpace(stringBuffer, tableSpaceUDB.getUserGroupSet().elementAt(n));
                    }
                }
            } else {
                for (int i = 0; i < tableSpaceUDB.getUserGroupSet().size(); ++i) {
                    if (i > 0) {
                        this.appendComma(stringBuffer);
                    }
                    SSBTableSpaceUDBv81.appendStringWithSpace(stringBuffer, "GROUP");
                    this.appendStringWithSpace(stringBuffer, tableSpaceUDB.getUserGroupSet().elementAt(i));
                }
            }
            if ("YES".equalsIgnoreCase(tableSpaceUDB.getGrantOption())) {
                SSBTableSpaceUDBv81.appendNewLine(stringBuffer, bl, 1);
                SSBTableSpaceUDBv81.appendStringWithSpace(stringBuffer, "WITH GRANT OPTION");
            }
            SSBTableSpaceUDBv81.appendNewLine(stringBuffer, bl, 0);
            this.appendLineFinisher(stringBuffer, bl);
            SSBTableSpaceUDBv81.appendNewLine(stringBuffer, bl, 0);
        }
    }
}

