/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.udb.v81;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.exports.ddl.oracle.SSBArcFK_CheckConstr;
import oracle.dbtools.crest.exports.ddl.udb.AbstractSSBUDB;
import oracle.dbtools.crest.exports.ddl.udb.v81.SSBIndexProxyUDBv81;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectPlaceHolder;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.constraint.CheckConstraint;
import oracle.dbtools.crest.model.design.constraint.ConstraintEnumeration;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StructuredTypeProxy;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.udb.ColumnProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.StructuredTypeProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableCheckConstraintProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.v81.ColumnProxyUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.StorageDesignUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.TableProxyUDBv81;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBTableProxyUDBv81
extends AbstractSSBUDB {
    private static final String COMPACT = "COMPACT";
    private static final String LINK_TYPE_URL = "LINKTYPE URL";
    private static final String FILE_LINK_CONTROL = "FILE LINK CONTROL";
    private static final String INTEGRITY_ALL = "INTEGRITY ALL";
    private static final String READ_PERMISSION = "READ PERMISSION";
    private static final String WRITE_PERMISSION = "WRITE PERMISSION";
    private static final String ON_UNLINK = "ON UNLINK";
    private static final String INDEX_IN = "INDEX IN";
    private static final String LONG_IN = "LONG IN";
    private static final String PARTITIONING_KEY = "PARTITIONING KEY";
    private static final String USING_HASHING = "USING HASHING";
    private static final String NOT_LOGGED_INITIALLY = "NOT LOGGED INITIALLY";
    private static final String VALUE_COMPRESSION = "VALUE COMPRESSION";
    private static final String RESTRICT_ON_DROP = "RESTRICT ON DROP";
    private static final String OPTIONS = "OPTIONS";
    private static final String REMOTE_SERVER = "REMOTE_SERVER";
    private static final String REMOTE_SCHEMA = "REMOTE_SCHEMA";
    private static final String REMOTE_TABNAME = "REMOTE_TABNAME";
    private static final String ORGANIZE_BY_DIMENSIONS = "ORGANIZE_BY_DIMENSIONS";
    private SSBArcFK_CheckConstr arcConstrHandler;
    private StorageDesignUDBv81 storageDesign = null;
    private SSBIndexProxyUDBv81 ssbIndex = new SSBIndexProxyUDBv81();

    @Override
    public boolean canHandle(Object object) {
        if (object instanceof Table && ((Table)object).isMarkedGenerate()) {
            return true;
        }
        return object instanceof TableProxyUDB;
    }

    @Override
    protected void doAppend(StringBuffer stringBuffer, Object object, boolean bl) {
        Table table = null;
        TableProxyUDBv81 tableProxyUDBv81 = null;
        if (object == null) {
            return;
        }
        if (object instanceof Table) {
            table = (Table)object;
            this.storageDesign = (StorageDesignUDBv81)this.getStorageDesign(object);
            tableProxyUDBv81 = (TableProxyUDBv81)this.storageDesign.getTableProxySet().getProxy(table.getObjectID());
        } else if (object instanceof TableProxyUDB) {
            tableProxyUDBv81 = (TableProxyUDBv81)object;
            table = (Table)tableProxyUDBv81.getObject();
            this.storageDesign = (StorageDesignUDBv81)this.getStorageDesign(object);
        }
        if (tableProxyUDBv81 != null && !tableProxyUDBv81.isMarkedGenerate()) {
            this.appendIndexes(stringBuffer, tableProxyUDBv81, bl);
            if (!table.isBST() || table.isRoot()) {
                this.appendPK(stringBuffer, tableProxyUDBv81, bl);
            }
            this.appendUK(stringBuffer, tableProxyUDBv81, bl);
            return;
        }
        if (table != null) {
            if (table.isBST()) {
                if (!table.isRoot() && table.getBasedOnStructuredType().getElements().length == 0 || table.isRoot() && table.getBasedOnStructuredType().getAllElements().size() == 0) {
                    SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, "--  ERROR: Table " + table.getName() + " is based on structured type without attributes");
                    SSBTableProxyUDBv81.appendNewLine(stringBuffer, true, 0);
                    DDLFileMaker.incrementErrors();
                    return;
                }
            } else if (table.getElementsCollection().size() == 0) {
                SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, "--  ERROR: Table " + table.getName() + " doesn't have columns");
                SSBTableProxyUDBv81.appendNewLine(stringBuffer, true, 0);
                DDLFileMaker.incrementErrors();
                return;
            }
            if (tableProxyUDBv81 != null && tableProxyUDBv81.isCommentChanged()) {
                this.appendComment(stringBuffer, tableProxyUDBv81);
            } else {
                this.appendComment(stringBuffer, table);
            }
            if (tableProxyUDBv81 != null && this.storageDesign.getFormatedName(tableProxyUDBv81.getName()).length() > tableProxyUDBv81.getMaxNameLength()) {
                SSBTableProxyUDBv81.appendNewLine(stringBuffer, true, 0);
                SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, "--  ERROR: Table name length exceeds maximum allowed length(" + tableProxyUDBv81.getMaxNameLength() + ")");
                SSBTableProxyUDBv81.appendNewLine(stringBuffer, true, 0);
                DDLFileMaker.incrementErrors();
            }
            SSBTableProxyUDBv81.appendNewLine(stringBuffer, bl, 0);
            this.appendBeforeCreateScript(stringBuffer, bl, table);
            SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, "CREATE");
            if (tableProxyUDBv81 == null) {
                SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, "TABLE");
                SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(table.getLongName()));
                this.appendElementList(stringBuffer, table, null, bl);
            } else {
                if ("YES".equalsIgnoreCase(tableProxyUDBv81.getSummaryQuery())) {
                    SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, "SUMMARY");
                }
                SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, "TABLE");
                SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(tableProxyUDBv81.getLongName()));
                if (table.isBST()) {
                    SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, "OF");
                    StructuredTypeProxyUDB structuredTypeProxyUDB = (StructuredTypeProxyUDB)this.storageDesign.getStructuredTypeProxySet().getProxy(table.getBasedOnStructuredType().getObjectID());
                    if (structuredTypeProxyUDB != null) {
                        SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(structuredTypeProxyUDB.getName()));
                    } else {
                        SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(table.getBasedOnStructuredType().getName()));
                    }
                    if (!table.isRoot() && table.isPartOfTypeSubstHierarchy()) {
                        SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, "UNDER");
                        TableProxyUDB tableProxyUDB = (TableProxyUDB)this.storageDesign.getTableProxySet().getProxy(table.getTypeSubstitution().getParentContainerObject().getObjectID());
                        if (tableProxyUDB != null) {
                            SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(tableProxyUDB.getLongName()));
                        } else {
                            SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(table.getTypeSubstitution().getParentContainerObject().getName()));
                        }
                        SSBTableProxyUDBv81.appendNewLine(stringBuffer, bl, 1);
                        SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, "INHERIT");
                        SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, "SELECT");
                        SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, "PRIVILEGES");
                    } else if (table.isRoot() && !"".equalsIgnoreCase(tableProxyUDBv81.getHierarchyName())) {
                        SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, "HIERARCHY");
                        SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, tableProxyUDBv81.getHierarchyName());
                    }
                    this.appendObjectTypeColProperties(stringBuffer, table, tableProxyUDBv81, bl);
                } else {
                    this.appendElementList(stringBuffer, table, tableProxyUDBv81, bl);
                    this.appendDimensions(stringBuffer, tableProxyUDBv81, bl);
                    this.appendDataCapture(stringBuffer, tableProxyUDBv81, bl);
                    this.appendFederated(stringBuffer, tableProxyUDBv81, bl);
                    this.appendTableSpace(stringBuffer, tableProxyUDBv81, bl);
                    this.appendPartitioningKey(stringBuffer, tableProxyUDBv81, bl);
                    this.appendValueCompression(stringBuffer, tableProxyUDBv81, bl);
                    this.appendRestrictOnDrop(stringBuffer, tableProxyUDBv81, bl);
                    this.appendInitialLogging(stringBuffer, tableProxyUDBv81, bl);
                    this.appendRemoteOptions(stringBuffer, tableProxyUDBv81, bl);
                }
            }
            SSBTableProxyUDBv81.appendNewLine(stringBuffer, bl, 0);
            this.appendLineFinisher(stringBuffer, bl);
            DDLFileMaker.incrementCreateTable();
            if (tableProxyUDBv81 != null) {
                this.appendColumnCheckConstraints(stringBuffer, tableProxyUDBv81, bl);
                if (this.getArcConstrHandler() != null) {
                    this.getArcConstrHandler().appendArcConstraints(stringBuffer, tableProxyUDBv81, bl);
                }
                if (table.getDesign().getAppView().getSettings().isGenerateCommentsInRDBMS()) {
                    this.appendTableCommentOn(stringBuffer, table, tableProxyUDBv81, bl);
                }
                this.appendIndexes(stringBuffer, tableProxyUDBv81, bl);
                if (!table.isBST() || table.isBST() && table.isRoot()) {
                    this.appendPK(stringBuffer, tableProxyUDBv81, bl);
                }
                this.appendUK(stringBuffer, tableProxyUDBv81, bl);
                if (table.getDesign().getAppView().getSettings().isGenerateTypeSubstTriggers()) {
                    this.appendInsertColumnSubstitutionTrigger(stringBuffer, table, tableProxyUDBv81, bl);
                    this.appendUpdateColumnSubstitutionTrigger(stringBuffer, table, tableProxyUDBv81, bl);
                }
            }
            SSBTableProxyUDBv81.appendNewLine(stringBuffer, bl, 0);
            this.appendAfterCreateScript(stringBuffer, bl, table);
        }
    }

    protected void appendOidColumnDefinition(StringBuffer stringBuffer, Table table, TableProxyUDBv81 tableProxyUDBv81, boolean bl) {
        ContainedObject containedObject;
        if ((table.isRoot() || !table.isPartOfTypeSubstHierarchy()) && (containedObject = table.getOidElement()) != null) {
            SSBTableProxyUDBv81.appendNewLine(stringBuffer, bl, 1);
            SSBTableProxyUDBv81.appendString(stringBuffer, '(');
            SSBTableProxyUDBv81.appendNewLine(stringBuffer, bl, 1);
            SSBTableProxyUDBv81.appendString(stringBuffer, ' ');
            SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, "REF");
            SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, "IS");
            ColumnProxy columnProxy = (ColumnProxy)this.storageDesign.getColumnProxySet().getProxy(containedObject.getObjectID());
            if (columnProxy != null) {
                SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(columnProxy.getName()));
            } else {
                SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(containedObject.getName()));
            }
            SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, "USER");
            SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, "GENERATED");
            if (columnProxy != null) {
                this.appendColumnConstraint(stringBuffer, (Column)containedObject, (ColumnProxyUDBv81)columnProxy);
            }
            SSBTableProxyUDBv81.appendNewLine(stringBuffer, bl, 1);
            SSBTableProxyUDBv81.appendString(stringBuffer, ')');
        }
    }

    private void appendIndexes(StringBuffer stringBuffer, TableProxyUDB tableProxyUDB, boolean bl) {
        Iterator iterator = tableProxyUDB.getIndexes().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!this.ssbIndex.canHandle(e)) continue;
            this.ssbIndex.doAppend(stringBuffer, e, bl);
        }
        this.appendIndexesForConstraints(stringBuffer, (Table)tableProxyUDB.getObject(), tableProxyUDB);
    }

    private void appendPK(StringBuffer stringBuffer, TableProxy tableProxy, boolean bl) {
        Index index = (Index)((Table)tableProxy.getObject()).getPK();
        if (index != null && index.isMarkedGenerate()) {
            this.storageDesign = (StorageDesignUDBv81)this.getStorageDesign(tableProxy);
            SSBTableProxyUDBv81.appendNewLine(stringBuffer, bl, 0);
            this.appendBeforeAlterScript(stringBuffer, bl, index.getTable());
            SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, "ALTER");
            SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, "TABLE");
            SSBTableProxyUDBv81.appendString(stringBuffer, this.storageDesign.getFormatedName(tableProxy.getLongName()));
            SSBTableProxyUDBv81.appendNewLine(stringBuffer, bl, 1);
            SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, "ADD");
            SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, "CONSTRAINT");
            SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(index.getName()));
            SSBTableProxyUDBv81.appendString(stringBuffer, "PRIMARY KEY");
            SSBTableProxyUDBv81.appendNewLine(stringBuffer, bl, 1);
            Column[] columnArray = (Column[])index.getElements();
            if (columnArray.length > 0) {
                SSBTableProxyUDBv81.appendString(stringBuffer, '(');
                SSBTableProxyUDBv81.appendNewLine(stringBuffer, bl, 1);
                for (int i = 0; i < columnArray.length; ++i) {
                    if (i != 0) {
                        this.appendComma(stringBuffer);
                        SSBTableProxyUDBv81.appendNewLine(stringBuffer, bl, 1);
                    }
                    SSBTableProxyUDBv81.appendString(stringBuffer, this.storageDesign.getFormatedName(columnArray[i].getName()));
                }
                SSBTableProxyUDBv81.appendNewLine(stringBuffer, bl, 1);
                SSBTableProxyUDBv81.appendString(stringBuffer, ')');
            }
            SSBTableProxyUDBv81.appendNewLine(stringBuffer, bl, 0);
            this.appendLineFinisher(stringBuffer, bl);
            DDLFileMaker.incrementAlterTable();
            this.appendAfterAlterScript(stringBuffer, bl, index.getTable());
        }
    }

    private void appendUK(StringBuffer stringBuffer, TableProxy tableProxy, boolean bl) {
        Index[] indexArray = (Index[])((Table)tableProxy.getObject()).getKeys();
        if (indexArray.length > 0) {
            for (int i = 0; i < indexArray.length; ++i) {
                Index index = indexArray[i];
                if (!index.getIndexState().equalsIgnoreCase("Unique Constraint") || !index.isMarkedGenerate()) continue;
                this.storageDesign = (StorageDesignUDBv81)this.getStorageDesign(tableProxy);
                SSBTableProxyUDBv81.appendNewLine(stringBuffer, bl, 0);
                this.appendBeforeAlterScript(stringBuffer, bl, index.getTable());
                SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, "ALTER");
                SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, "TABLE");
                SSBTableProxyUDBv81.appendString(stringBuffer, this.storageDesign.getFormatedName(tableProxy.getLongName()));
                SSBTableProxyUDBv81.appendNewLine(stringBuffer, bl, 1);
                SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, "ADD");
                SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, "CONSTRAINT");
                SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(index.getName()));
                SSBTableProxyUDBv81.appendString(stringBuffer, "UNIQUE");
                SSBTableProxyUDBv81.appendNewLine(stringBuffer, bl, 1);
                Column[] columnArray = (Column[])index.getElements();
                if (columnArray.length > 0) {
                    SSBTableProxyUDBv81.appendString(stringBuffer, '(');
                    SSBTableProxyUDBv81.appendNewLine(stringBuffer, bl, 1);
                    for (int j = 0; j < columnArray.length; ++j) {
                        if (j != 0) {
                            this.appendComma(stringBuffer);
                            SSBTableProxyUDBv81.appendNewLine(stringBuffer, bl, 1);
                        }
                        SSBTableProxyUDBv81.appendString(stringBuffer, this.storageDesign.getFormatedName(columnArray[j].getName()));
                    }
                    SSBTableProxyUDBv81.appendNewLine(stringBuffer, bl, 1);
                    SSBTableProxyUDBv81.appendString(stringBuffer, ')');
                }
                SSBTableProxyUDBv81.appendNewLine(stringBuffer, bl, 0);
                this.appendLineFinisher(stringBuffer, bl);
                DDLFileMaker.incrementAlterTable();
                this.appendAfterAlterScript(stringBuffer, bl, index.getTable());
            }
        }
    }

    protected void appendElementList(StringBuffer stringBuffer, Table table, TableProxyUDBv81 tableProxyUDBv81, boolean bl) {
        Column[] columnArray = (Column[])table.getElements();
        Column column = null;
        ColumnProxyUDBv81 columnProxyUDBv81 = null;
        boolean bl2 = true;
        if (tableProxyUDBv81.getSummaryQuery().equalsIgnoreCase("NO")) {
            SSBTableProxyUDBv81.appendNewLine(stringBuffer, bl, 1);
            if (columnArray.length < 1) {
                SSBTableProxyUDBv81.appendNewLine(stringBuffer, bl, 1);
                stringBuffer.append("-- No columns");
                SSBTableProxyUDBv81.appendNewLine(stringBuffer, bl, 1);
            } else {
                for (int i = 0; i < columnArray.length; ++i) {
                    bl2 = false;
                    if (i == 0) {
                        SSBTableProxyUDBv81.appendString(stringBuffer, '(');
                    } else {
                        stringBuffer.append(", ");
                    }
                    SSBTableProxyUDBv81.appendNewLine(stringBuffer, bl, 1);
                    if (tableProxyUDBv81 == null) continue;
                    column = columnArray[i];
                    columnProxyUDBv81 = (ColumnProxyUDBv81)tableProxyUDBv81.getColumnProxy(column.getObjectID());
                    if (this.storageDesign.getFormatedName(columnProxyUDBv81.getName()).length() > columnProxyUDBv81.getMaxNameLength()) {
                        SSBTableProxyUDBv81.appendNewLine(stringBuffer, true, 0);
                        SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, "--  ERROR: Column name length exceeds maximum allowed length(" + columnProxyUDBv81.getMaxNameLength() + ")");
                        SSBTableProxyUDBv81.appendNewLine(stringBuffer, true, 0);
                        DDLFileMaker.incrementErrors();
                    }
                    if (columnProxyUDBv81.isCommentChanged() && !"".equalsIgnoreCase(columnProxyUDBv81.getComment())) {
                        this.appendComment(stringBuffer, columnProxyUDBv81);
                    } else if (!"".equalsIgnoreCase(columnProxyUDBv81.getObject().getComment())) {
                        this.appendComment(stringBuffer, columnProxyUDBv81.getObject());
                    }
                    this.appendColumnNameAndDataType(stringBuffer, columnProxyUDBv81, bl);
                    this.appendBitDataDefinition(stringBuffer, columnProxyUDBv81);
                    this.appendColumnScope(stringBuffer, column, columnProxyUDBv81, bl);
                    this.appendColumnNullsAllowed(stringBuffer, columnProxyUDBv81);
                    this.appendWithDefaultDefinition(stringBuffer, columnProxyUDBv81);
                    this.appendColumnLobOptions(stringBuffer, columnProxyUDBv81, bl);
                    this.appendColumnDatalinkOptions(stringBuffer, columnProxyUDBv81, bl);
                    this.appendColumnConstraint(stringBuffer, column, columnProxyUDBv81);
                    this.appendGeneratedColumnSpec(stringBuffer, columnProxyUDBv81, bl);
                    this.appendCompressSystemDefault(stringBuffer, columnProxyUDBv81, bl);
                }
                this.appendTableConstraintsDefinition(stringBuffer, tableProxyUDBv81, bl, bl2);
                SSBTableProxyUDBv81.appendNewLine(stringBuffer, bl, 1);
                SSBTableProxyUDBv81.appendString(stringBuffer, ')');
            }
        } else {
            this.appendSummaryQuery(stringBuffer, table, tableProxyUDBv81, bl);
        }
    }

    private void appendSummaryQuery(StringBuffer stringBuffer, Table table, TableProxyUDBv81 tableProxyUDBv81, boolean bl) {
        if (tableProxyUDBv81 != null) {
            Column[] columnArray = (Column[])table.getElements();
            Column column = null;
            ColumnProxyUDBv81 columnProxyUDBv81 = null;
            if (columnArray.length > 0) {
                SSBTableProxyUDBv81.appendNewLine(stringBuffer, bl, 1);
                for (int i = 0; i < columnArray.length; ++i) {
                    if (i == 0) {
                        SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, '(');
                    } else {
                        this.appendComma(stringBuffer);
                    }
                    SSBTableProxyUDBv81.appendNewLine(stringBuffer, bl, 1);
                    column = columnArray[i];
                    columnProxyUDBv81 = (ColumnProxyUDBv81)tableProxyUDBv81.getColumnProxy(column.getObjectID());
                    SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(columnProxyUDBv81.getName()));
                }
                SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, ')');
            }
            SSBTableProxyUDBv81.appendNewLine(stringBuffer, bl, 1);
            SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, "AS");
            SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, '(');
            SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, tableProxyUDBv81.getSummaryQueryDefinition());
            SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, ')');
            if (tableProxyUDBv81.getSummaryStatus().equalsIgnoreCase(TableProxyUDB.SUMMARY_STATUS_STATES[1])) {
                SSBTableProxyUDBv81.appendNewLine(stringBuffer, bl, 1);
                SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, "DEFINITION");
                SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, "ONLY");
                this.appendCopyOptions(stringBuffer, tableProxyUDBv81, bl);
            } else {
                this.appendRefreshableTableOptions(stringBuffer, tableProxyUDBv81, bl);
            }
        }
    }

    private void appendRefreshableTableOptions(StringBuffer stringBuffer, TableProxyUDBv81 tableProxyUDBv81, boolean bl) {
        SSBTableProxyUDBv81.appendNewLine(stringBuffer, bl, 1);
        SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, "DATA");
        SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, "INITIALLY");
        SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, "DEFERRED");
        SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, "REFRESH");
        SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, tableProxyUDBv81.getSummaryRefreshOptions());
        SSBTableProxyUDBv81.appendNewLine(stringBuffer, bl, 1);
        SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, tableProxyUDBv81.getSummaryQueryOptimization());
        SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, "QUERY");
        SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, "OPTIMIZATION");
        SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, "MAINTAINED");
        SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, tableProxyUDBv81.getSummaryMaintenance());
    }

    private void appendCopyOptions(StringBuffer stringBuffer, TableProxyUDBv81 tableProxyUDBv81, boolean bl) {
        SSBTableProxyUDBv81.appendNewLine(stringBuffer, bl, 1);
        if ("NONE".equalsIgnoreCase(tableProxyUDBv81.getSummaryCopyColumnDefaults())) {
            SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, tableProxyUDBv81.getSummaryIdentityColumn());
            SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, "DEFAULTS");
        }
        SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, tableProxyUDBv81.getSummaryIdentityColumn());
        SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, "IDENTITY");
    }

    private void appendColumnNameAndDataType(StringBuffer stringBuffer, ColumnProxyUDBv81 columnProxyUDBv81, boolean bl) {
        SSBTableProxyUDBv81.appendString(stringBuffer, ' ');
        SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(columnProxyUDBv81.getName()));
        String string = columnProxyUDBv81.getDataTypeName();
        SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, string);
        if (string.equalsIgnoreCase("unknown")) {
            SSBTableProxyUDBv81.appendNewLine(stringBuffer, bl, 0);
            SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, "--  ERROR: Datatype UNKNOWN is not allowed");
            SSBTableProxyUDBv81.appendNewLine(stringBuffer, bl, 5);
            DDLFileMaker.incrementErrors();
        }
    }

    private void appendWithDefaultDefinition(StringBuffer stringBuffer, ColumnProxyUDBv81 columnProxyUDBv81) {
        String string = columnProxyUDBv81.getDefaultValue();
        String string2 = columnProxyUDBv81.getDefaultValueConstant();
        boolean bl = columnProxyUDBv81.getDefault();
        if (bl) {
            SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, "WITH");
            SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, "DEFAULT");
            if (!"".equalsIgnoreCase(string)) {
                if (string.equalsIgnoreCase(ColumnProxyUDB.getDefaultValueChoices()[1])) {
                    if (!"".equalsIgnoreCase(string2)) {
                        String string3 = columnProxyUDBv81.getColumn().getDatatypeString("DB2/UDB 8.1");
                        String string4 = this.addQuotesToDefault(string3, string2);
                        SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, string4);
                    }
                } else if (string.equalsIgnoreCase(ColumnProxyUDB.getDefaultValueChoices()[4])) {
                    SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, string2);
                } else {
                    String string5 = columnProxyUDBv81.getColumn().getDatatypeString("DB2/UDB 8.1");
                    String string6 = this.addQuotesToDefault(string5, string);
                    SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, string6);
                }
            }
        }
    }

    private void appendColumnNullsAllowed(StringBuffer stringBuffer, ColumnProxyUDBv81 columnProxyUDBv81) {
        if (!columnProxyUDBv81.getNullsAllowed()) {
            SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, "NOT NULL");
        }
    }

    private void appendColumnLobOptions(StringBuffer stringBuffer, ColumnProxyUDBv81 columnProxyUDBv81, boolean bl) {
        if (columnProxyUDBv81.checkLobColumnTypes(columnProxyUDBv81.getDataType())) {
            if (columnProxyUDBv81.getLogging().equalsIgnoreCase("NOT LOGGED")) {
                SSBTableProxyUDBv81.appendNewLine(stringBuffer, bl, 2);
                SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, "NOT LOGGED");
            }
            if (columnProxyUDBv81.getCompact().equalsIgnoreCase("YES")) {
                SSBTableProxyUDBv81.appendNewLine(stringBuffer, bl, 2);
                SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, COMPACT);
            }
        }
    }

    private void appendColumnDatalinkOptions(StringBuffer stringBuffer, ColumnProxyUDBv81 columnProxyUDBv81, boolean bl) {
        if (columnProxyUDBv81.checkDLColumnTypes(columnProxyUDBv81.getDataType())) {
            SSBTableProxyUDBv81.appendNewLine(stringBuffer, bl, 2);
            SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, LINK_TYPE_URL);
            if (columnProxyUDBv81.getLinkControl().equalsIgnoreCase("FILE")) {
                SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, FILE_LINK_CONTROL);
                SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, INTEGRITY_ALL);
                SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, READ_PERMISSION);
                SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, columnProxyUDBv81.getReadPermission());
                SSBTableProxyUDBv81.appendNewLine(stringBuffer, bl, 2);
                SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, WRITE_PERMISSION);
                SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, columnProxyUDBv81.getWritePermission());
                SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, "RECOVERY");
                SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, columnProxyUDBv81.getRecovery().toUpperCase());
                SSBTableProxyUDBv81.appendNewLine(stringBuffer, bl, 2);
                if (!columnProxyUDBv81.getWritePermission().equalsIgnoreCase("FS")) {
                    SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, ON_UNLINK);
                    SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, columnProxyUDBv81.getOnUnlink());
                }
            }
        }
    }

    private void appendTableConstraintsDefinition(StringBuffer stringBuffer, TableProxyUDB tableProxyUDB, boolean bl, boolean bl2) {
        Iterator iterator = ((TableProxyUDBv81)tableProxyUDB).getTableCheckConstraints().iterator();
        boolean bl3 = true;
        while (iterator.hasNext()) {
            TableCheckConstraintProxyUDB tableCheckConstraintProxyUDB = (TableCheckConstraintProxyUDB)iterator.next();
            if (!bl2 || !bl3) {
                this.appendComma(stringBuffer);
            }
            SSBTableProxyUDBv81.appendNewLine(stringBuffer, bl, 1);
            SSBTableProxyUDBv81.appendString(stringBuffer, ' ');
            SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, "CONSTRAINT");
            SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(tableCheckConstraintProxyUDB.getName()));
            SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, "CHECK");
            SSBTableProxyUDBv81.appendString(stringBuffer, '(');
            SSBTableProxyUDBv81.appendString(stringBuffer, tableCheckConstraintProxyUDB.getTableConstraint().getRule());
            SSBTableProxyUDBv81.appendString(stringBuffer, ')');
            bl3 = false;
            this.appendTableConstraintState(stringBuffer, tableCheckConstraintProxyUDB, bl);
        }
    }

    private void appendTableConstraintState(StringBuffer stringBuffer, TableCheckConstraintProxyUDB tableCheckConstraintProxyUDB, boolean bl) {
        SSBTableProxyUDBv81.appendNewLine(stringBuffer, bl, 2);
        SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, tableCheckConstraintProxyUDB.getValidation());
        SSBTableProxyUDBv81.appendNewLine(stringBuffer, bl, 2);
        SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, tableCheckConstraintProxyUDB.getQueryOptimization());
    }

    private void appendColumnConstraint(StringBuffer stringBuffer, Column column, ColumnProxyUDBv81 columnProxyUDBv81) {
        String string;
        if (column.hasConstraintsDefined() && !"".equals(string = column.getConstraintsText(this.storageDesign.getFormatedName(columnProxyUDBv81.getName())))) {
            String string2 = column.getConstraintName();
            if (!string2.equals("") && string2.length() <= 18 || column.getDesign().getAppView().getSettings().isGenerateInlineColumnCC()) {
                SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, "CONSTRAINT");
                SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(string2));
                SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, "CHECK");
                SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, '(');
                SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, string);
                SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, ')');
            }
            if ("".equals(string2) || !"".equals(string2) && string2.length() > 18 || column.getDesign().getAppView().getSettings().isGenerateInlineColumnCC()) {
                SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, "CHECK");
                SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, '(');
                SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, string);
                SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, ')');
            }
        }
    }

    protected void appendDimensions(StringBuffer stringBuffer, TableProxyUDBv81 tableProxyUDBv81, boolean bl) {
        if (tableProxyUDBv81.getOrganizeByDimensions()) {
            SSBTableProxyUDBv81.appendNewLine(stringBuffer, bl, 1);
            SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, ORGANIZE_BY_DIMENSIONS);
            SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, '(');
            SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, tableProxyUDBv81.getDimensions());
            SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, ')');
        }
    }

    protected void appendDataCapture(StringBuffer stringBuffer, TableProxyUDB tableProxyUDB, boolean bl) {
        if (!"NONE".equalsIgnoreCase(tableProxyUDB.getDataCapture())) {
            SSBTableProxyUDBv81.appendNewLine(stringBuffer, bl, 1);
            SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, "DATA CAPTURE");
            SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, tableProxyUDB.getDataCapture());
        }
    }

    protected void appendFederated(StringBuffer stringBuffer, TableProxyUDB tableProxyUDB, boolean bl) {
        if (!"NONE".equalsIgnoreCase(tableProxyUDB.getFederated())) {
            SSBTableProxyUDBv81.appendNewLine(stringBuffer, bl, 1);
            SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, tableProxyUDB.getFederated());
        }
    }

    protected void appendTableSpace(StringBuffer stringBuffer, TableProxyUDBv81 tableProxyUDBv81, boolean bl) {
        if (tableProxyUDBv81.getTableSpace() != null && !tableProxyUDBv81.getTableSpace().getDBDefOnly()) {
            SSBTableProxyUDBv81.appendNewLine(stringBuffer, bl, 1);
            SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, "IN");
            SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(tableProxyUDBv81.getTableSpace().getLongName()));
            this.appendTableSpaceOptions(stringBuffer, tableProxyUDBv81);
        }
    }

    protected void appendTableSpaceOptions(StringBuffer stringBuffer, TableProxyUDBv81 tableProxyUDBv81) {
        if (tableProxyUDBv81.getIndexInTableSpace() != null) {
            SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, INDEX_IN);
            SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(tableProxyUDBv81.getIndexInTableSpace().getLongName()));
        }
        if (tableProxyUDBv81.getLongInTableSpace() != null) {
            SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, LONG_IN);
            SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(tableProxyUDBv81.getLongInTableSpace().getLongName()));
        }
    }

    protected void appendPartitioningKey(StringBuffer stringBuffer, TableProxyUDBv81 tableProxyUDBv81, boolean bl) {
        if (!"".equalsIgnoreCase(tableProxyUDBv81.getPartitioningKey())) {
            SSBTableProxyUDBv81.appendNewLine(stringBuffer, bl, 1);
            SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, PARTITIONING_KEY);
            SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, '(');
            SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, tableProxyUDBv81.getPartitioningKey());
            SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, ')');
            if (tableProxyUDBv81.getPartKeyHashing()) {
                SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, USING_HASHING);
            }
        }
    }

    protected void appendValueCompression(StringBuffer stringBuffer, TableProxyUDBv81 tableProxyUDBv81, boolean bl) {
        if ("YES".equalsIgnoreCase(tableProxyUDBv81.getValueCompression())) {
            SSBTableProxyUDBv81.appendNewLine(stringBuffer, bl, 1);
            SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, VALUE_COMPRESSION);
        }
    }

    protected void appendRestrictOnDrop(StringBuffer stringBuffer, TableProxyUDBv81 tableProxyUDBv81, boolean bl) {
        if ("YES".equalsIgnoreCase(tableProxyUDBv81.getRestrictOnDrop())) {
            SSBTableProxyUDBv81.appendNewLine(stringBuffer, bl, 1);
            SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, "WITH");
            SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, RESTRICT_ON_DROP);
        }
    }

    protected void appendInitialLogging(StringBuffer stringBuffer, TableProxyUDBv81 tableProxyUDBv81, boolean bl) {
        if (!tableProxyUDBv81.getInitialLogging()) {
            SSBTableProxyUDBv81.appendNewLine(stringBuffer, bl, 1);
            SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, NOT_LOGGED_INITIALLY);
        }
    }

    protected void appendRemoteOptions(StringBuffer stringBuffer, TableProxyUDBv81 tableProxyUDBv81, boolean bl) {
        if (tableProxyUDBv81.getUseRemoteOptions()) {
            SSBTableProxyUDBv81.appendNewLine(stringBuffer, bl, 1);
            SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, OPTIONS);
            SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, '(');
            SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, REMOTE_SERVER);
            SSBTableProxyUDBv81.appendString(stringBuffer, '\'');
            SSBTableProxyUDBv81.appendString(stringBuffer, tableProxyUDBv81.getRoRemoteServer());
            SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, '\'');
            if (!"".equalsIgnoreCase(tableProxyUDBv81.getRoRemoteSchema().trim())) {
                SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, REMOTE_SCHEMA);
                SSBTableProxyUDBv81.appendString(stringBuffer, '\'');
                SSBTableProxyUDBv81.appendString(stringBuffer, tableProxyUDBv81.getRoRemoteSchema());
                SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, '\'');
            }
            if (!"".equalsIgnoreCase(tableProxyUDBv81.getRoRemoteTabName().trim())) {
                SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, REMOTE_TABNAME);
                SSBTableProxyUDBv81.appendString(stringBuffer, '\'');
                SSBTableProxyUDBv81.appendString(stringBuffer, tableProxyUDBv81.getRoRemoteTabName());
                SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, '\'');
            }
            SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, ')');
        }
    }

    private void appendColumnCheckConstraints(StringBuffer stringBuffer, TableProxy tableProxy, boolean bl) {
        ColumnProxy[] columnProxyArray = tableProxy.getColumnProxies();
        for (int i = 0; i < columnProxyArray.length; ++i) {
            ColumnProxy columnProxy = columnProxyArray[i];
            Column column = columnProxy.getColumn();
            if (!column.hasConstraintsDefined()) continue;
            String string = column.getConstraintsText(this.storageDesign.getFormatedName(columnProxy.getName()));
            String string2 = column.getConstraintName();
            if ("".equals(string) || "".equals(string2) || string2.length() >= 19) continue;
            SSBTableProxyUDBv81.appendNewLine(stringBuffer, bl, 0);
            SSBTableProxyUDBv81.appendNewLine(stringBuffer, bl, 0);
            SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, "ALTER");
            SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, "TABLE");
            SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(tableProxy.getLongName()));
            SSBTableProxyUDBv81.appendNewLine(stringBuffer, bl, 1);
            SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, "ADD");
            SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, "CONSTRAINT");
            SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(string2));
            SSBTableProxyUDBv81.appendNewLine(stringBuffer, bl, 1);
            SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, "CHECK");
            SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, '(');
            SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, string);
            SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, ')');
            SSBTableProxyUDBv81.appendNewLine(stringBuffer, bl, 0);
            this.appendLineFinisher(stringBuffer, bl);
            SSBTableProxyUDBv81.appendNewLine(stringBuffer, bl, 0);
        }
    }

    protected void appendTableCommentOn(StringBuffer stringBuffer, Table table, TableProxyUDB tableProxyUDB, boolean bl) {
        block6: {
            block5: {
                if (tableProxyUDB == null) break block5;
                this.appendCommentOn(stringBuffer, tableProxyUDB, bl);
                ColumnProxy[] columnProxyArray = tableProxyUDB.getColumnProxies();
                ColumnProxy columnProxy = null;
                for (int i = 0; i < columnProxyArray.length; ++i) {
                    String string;
                    columnProxy = columnProxyArray[i];
                    String string2 = "";
                    if (columnProxy.getCommentInRDBMS() != null && columnProxy.isCommentInRDBMSChanged()) {
                        string2 = columnProxy.getCommentInRDBMS();
                        string = columnProxy.getLongName();
                    } else {
                        string2 = columnProxy.getObject().getCommentInRDBMS();
                        string = ((Column)columnProxy.getObject()).getLongName();
                    }
                    if (string2.equalsIgnoreCase("")) continue;
                    SSBTableProxyUDBv81.appendNewLine(stringBuffer, bl, 0);
                    SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, "COMMENT ON");
                    SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, "COLUMN");
                    SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(string));
                    SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, "IS");
                    SSBTableProxyUDBv81.appendString(stringBuffer, '\'');
                    SSBTableProxyUDBv81.appendString(stringBuffer, string2);
                    SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, '\'');
                    SSBTableProxyUDBv81.appendNewLine(stringBuffer, bl, 0);
                    this.appendLineFinisher(stringBuffer, bl);
                }
                break block6;
            }
            if (table == null) break block6;
            if (table.getCommentInRDBMS() != null && !"".equalsIgnoreCase(table.getCommentInRDBMS())) {
                SSBTableProxyUDBv81.appendNewLine(stringBuffer, bl, 0);
                SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, "COMMENT ON");
                SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, "TABLE");
                SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(table.getLongName()));
                SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, "IS");
                SSBTableProxyUDBv81.appendString(stringBuffer, '\'');
                SSBTableProxyUDBv81.appendString(stringBuffer, table.getCommentInRDBMS());
                SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, '\'');
                SSBTableProxyUDBv81.appendNewLine(stringBuffer, bl, 0);
                this.appendLineFinisher(stringBuffer, bl);
            }
            ContainedObject[] containedObjectArray = table.getElements();
            for (int i = 0; i < containedObjectArray.length; ++i) {
                Column column = (Column)containedObjectArray[i];
                if (column.getCommentInRDBMS() == null || "".equalsIgnoreCase(column.getCommentInRDBMS())) continue;
                SSBTableProxyUDBv81.appendNewLine(stringBuffer, bl, 0);
                SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, "COMMENT ON");
                SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, "COLUMN");
                SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(column.getLongName()));
                SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, "IS");
                SSBTableProxyUDBv81.appendString(stringBuffer, '\'');
                SSBTableProxyUDBv81.appendString(stringBuffer, column.getCommentInRDBMS());
                SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, '\'');
                SSBTableProxyUDBv81.appendNewLine(stringBuffer, bl, 0);
                this.appendLineFinisher(stringBuffer, bl);
            }
        }
    }

    protected void appendGeneratedColumnSpec(StringBuffer stringBuffer, ColumnProxyUDBv81 columnProxyUDBv81, boolean bl) {
        if (columnProxyUDBv81.getUseIdentity()) {
            SSBTableProxyUDBv81.appendNewLine(stringBuffer, bl, 1);
            SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, "GENERATED");
            SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, columnProxyUDBv81.getGenerate());
            SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, "AS");
            if (!"".equalsIgnoreCase(columnProxyUDBv81.getGenerationExpression().trim())) {
                SSBTableProxyUDBv81.appendNewLine(stringBuffer, bl, 1);
                SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, '(');
                SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, columnProxyUDBv81.getGenerationExpression());
                SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, ')');
            } else {
                SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, "IDENTITY");
                SSBTableProxyUDBv81.appendNewLine(stringBuffer, bl, 2);
                SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, '(');
                SSBTableProxyUDBv81.appendNewLine(stringBuffer, bl, 2);
                SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, "START");
                SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, "WITH");
                SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, columnProxyUDBv81.getStartWith());
                SSBTableProxyUDBv81.appendNewLine(stringBuffer, bl, 2);
                SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, "INCREMENT");
                SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, "BY");
                this.appendStringWithSpace(stringBuffer, columnProxyUDBv81.getIncrementBy());
                SSBTableProxyUDBv81.appendNewLine(stringBuffer, bl, 2);
                if ("NO".equalsIgnoreCase(columnProxyUDBv81.getMinValue())) {
                    SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, "NO");
                    SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, "MINVALUE");
                    SSBTableProxyUDBv81.appendNewLine(stringBuffer, bl, 2);
                } else if (!"".equals(columnProxyUDBv81.getMinValue())) {
                    SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, "MINVALUE");
                    SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, columnProxyUDBv81.getMinValue());
                    SSBTableProxyUDBv81.appendNewLine(stringBuffer, bl, 2);
                }
                if ("NO".equalsIgnoreCase(columnProxyUDBv81.getMaxValue())) {
                    SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, "NO");
                    SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, "MAXVALUE");
                    SSBTableProxyUDBv81.appendNewLine(stringBuffer, bl, 2);
                } else if (!"".equals(columnProxyUDBv81.getMaxValue())) {
                    SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, "MAXVALUE");
                    SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, columnProxyUDBv81.getMaxValue());
                    SSBTableProxyUDBv81.appendNewLine(stringBuffer, bl, 2);
                }
                if ("NO".equalsIgnoreCase(columnProxyUDBv81.getCycle())) {
                    SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, "NO");
                    SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, "CYCLE");
                } else {
                    SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, "CYCLE");
                    SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, columnProxyUDBv81.getCycle());
                }
                SSBTableProxyUDBv81.appendNewLine(stringBuffer, bl, 2);
                if ("NO".equalsIgnoreCase(columnProxyUDBv81.getCache())) {
                    SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, "NO");
                    SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, "CACHE");
                } else {
                    SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, "CACHE");
                    SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, columnProxyUDBv81.getCache());
                }
                SSBTableProxyUDBv81.appendNewLine(stringBuffer, bl, 2);
                if ("NO".equalsIgnoreCase(columnProxyUDBv81.getOrder())) {
                    SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, "NO");
                    SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, "ORDER");
                } else {
                    SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, "ORDER");
                }
                SSBTableProxyUDBv81.appendNewLine(stringBuffer, bl, 2);
                SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, ')');
            }
        }
    }

    protected void appendCompressSystemDefault(StringBuffer stringBuffer, ColumnProxyUDBv81 columnProxyUDBv81, boolean bl) {
        if ("YES".equalsIgnoreCase(columnProxyUDBv81.getCompressSystemDefault())) {
            SSBTableProxyUDBv81.appendNewLine(stringBuffer, bl, 1);
            SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, "COMPRESS SYSTEM DEFAULT");
        }
    }

    private void appendObjectTypeColProperties(StringBuffer stringBuffer, Table table, TableProxyUDBv81 tableProxyUDBv81, boolean bl) {
        if (table.isBST() && tableProxyUDBv81 != null) {
            ModelIDObject modelIDObject;
            int n;
            ArrayList arrayList;
            boolean bl2 = false;
            if (table.isRoot()) {
                bl2 = true;
                arrayList = new ArrayList(table.getElementsCollection());
            } else {
                arrayList = table.getElementsByStructuredType(table.getBasedOnStructuredType());
            }
            if (table.isOidIsPK() && table.getOidPKColumns().size() > 0 || tableProxyUDBv81.getTableCheckConstraints().size() > 0) {
                bl2 = true;
            }
            if (!bl2) {
                Column column;
                for (n = 0; n < arrayList.size() && !(bl2 = this.shouldGenerateObjectPropDefinition(column = (Column)arrayList.get(n), (ColumnProxyUDB)(modelIDObject = (ColumnProxyUDB)tableProxyUDBv81.getColumnProxy(column.getObjectID())))); n += 1) {
                }
            }
            if (bl2) {
                ContainedObject containedObject;
                n = 1;
                SSBTableProxyUDBv81.appendNewLine(stringBuffer, bl, 1);
                SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, '(');
                for (int i = 0; i < arrayList.size(); ++i) {
                    ColumnProxyUDB columnProxyUDB;
                    modelIDObject = (Column)arrayList.get(i);
                    if (!this.shouldGenerateObjectPropDefinition((Column)modelIDObject, columnProxyUDB = (ColumnProxyUDB)tableProxyUDBv81.getColumnProxy(modelIDObject.getObjectID()))) continue;
                    if (n == 0) {
                        this.appendComma(stringBuffer);
                    } else {
                        n = 0;
                    }
                    SSBTableProxyUDBv81.appendNewLine(stringBuffer, bl, 1);
                    SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(columnProxyUDB.getName()) + ' ' + "WITH OPTIONS ");
                    this.appendColumnNullsAllowed(stringBuffer, (ColumnProxyUDBv81)columnProxyUDB);
                    this.appendColumnScope(stringBuffer, (Column)modelIDObject, columnProxyUDB, bl);
                    this.appendColumnConstraint(stringBuffer, (Column)modelIDObject, (ColumnProxyUDBv81)columnProxyUDB);
                }
                if (tableProxyUDBv81.getTableCheckConstraints().size() > 0) {
                    if (n == 0) {
                        this.appendComma(stringBuffer);
                    } else {
                        n = 0;
                    }
                    this.appendTableConstraintsDefinition(stringBuffer, tableProxyUDBv81, bl, n != 0);
                }
                if (table.isOidIsPK() && table.isRoot()) {
                    if (n == 0) {
                        this.appendComma(stringBuffer);
                    } else {
                        n = 0;
                    }
                    this.appendPK_ObjectType(stringBuffer, table, tableProxyUDBv81, bl, table.getOidPKColumns().size() == 0);
                }
                if (table.isRoot() && (containedObject = table.getOidElement()) != null) {
                    if (n == 0) {
                        this.appendComma(stringBuffer);
                    } else {
                        n = 0;
                    }
                    SSBTableProxyUDBv81.appendNewLine(stringBuffer, bl, 1);
                    SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, "REF");
                    SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, "IS");
                    modelIDObject = (ColumnProxy)this.storageDesign.getColumnProxySet().getProxy(containedObject.getObjectID());
                    if (modelIDObject != null) {
                        SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(((RelationalObjectProxy)modelIDObject).getName()));
                    } else {
                        SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(containedObject.getName()));
                    }
                    SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, "USER");
                    SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, "GENERATED");
                }
                SSBTableProxyUDBv81.appendNewLine(stringBuffer, bl, 1);
                SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, ')');
            }
        }
    }

    private boolean shouldGenerateObjectPropDefinition(Column column, ColumnProxyUDB columnProxyUDB) {
        if (column.isOid()) {
            return false;
        }
        if (!column.getNullsAllowed()) {
            return true;
        }
        String string = columnProxyUDB.getDefaultValue();
        if (string != null && !"".equalsIgnoreCase(string)) {
            return true;
        }
        if (column.getScope() != null) {
            return true;
        }
        if (!column.getAVTs().isEmpty()) {
            return true;
        }
        ConstraintEnumeration constraintEnumeration = column.getValueList();
        if (constraintEnumeration != null && !constraintEnumeration.isEmpty()) {
            return true;
        }
        CheckConstraint checkConstraint = column.getCheck();
        return checkConstraint != null;
    }

    private void appendPK_ObjectType(StringBuffer stringBuffer, Table table, TableProxy tableProxy, boolean bl, boolean bl2) {
        String string = tableProxy.getPKName();
        if (!"".equals(string)) {
            SSBTableProxyUDBv81.appendNewLine(stringBuffer, bl, 1);
            SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, "CONSTRAINT");
            SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(string));
            SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, "PRIMARY KEY");
            SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, '(');
            if (bl2) {
                ContainedObject containedObject = table.getOidElement();
                ColumnProxy columnProxy = tableProxy.getColumnProxy(containedObject.getObjectID());
                SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(columnProxy.getName()));
            } else {
                boolean bl3 = true;
                for (Column column : table.getOidPKColumns()) {
                    String string2 = column.getName();
                    ColumnProxy columnProxy = tableProxy.getColumnProxy(column.getObjectID());
                    if (columnProxy != null) {
                        string2 = columnProxy.getName();
                    }
                    if (bl3) {
                        SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(string2));
                        bl3 = false;
                        continue;
                    }
                    SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, ',');
                    SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(string2));
                }
            }
            SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, ')');
        }
    }

    private void appendColumnScope(StringBuffer stringBuffer, Column column, ColumnProxy columnProxy, boolean bl) {
        if (column.isReference() && column.getScope() != null) {
            SSBTableProxyUDBv81.appendNewLine(stringBuffer, bl, 2);
            SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, "SCOPE");
            TableProxy tableProxy = (TableProxy)this.storageDesign.getStorageObject(column.getScope().getObjectID());
            SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(tableProxy.getLongName()));
        }
    }

    private void appendInsertColumnSubstitutionTrigger(StringBuffer stringBuffer, Table table, TableProxy tableProxy, boolean bl) {
        List list = this.getColumnsWithRestrictedSubType(table);
        if (list.size() > 0) {
            boolean bl2 = true;
            String string = "";
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 0; i < list.size(); ++i) {
                Column column = (Column)list.get(i);
                ColumnProxy columnProxy = tableProxy.getColumnProxy(column.getObjectID());
                String string2 = this.storageDesign.getFormatedName(columnProxy == null ? column.getName() : columnProxy.getName());
                arrayList.add(string2);
                if (bl2) {
                    string = string2;
                    bl2 = false;
                    continue;
                }
                string = string + ", " + string2;
            }
            if (!"".equals(string)) {
                String string3 = this.storageDesign.getFormatedName(COLUMN_INS_SUBST_TR_PREFIX + this.getStringWithMaxLength(tableProxy.getName(), 18 - COLUMN_INS_SUBST_TR_PREFIX.length()));
                if (tableProxy.getUserSchema() != null) {
                    string3 = this.storageDesign.getFormatedName(tableProxy.getUserSchema().getName()) + "." + string3;
                }
                SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, "CREATE TRIGGER " + this.storageDesign.getFormatedName(string3));
                SSBTableProxyUDBv81.appendNewLine(stringBuffer, bl, 0);
                SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, "NO CASCADE BEFORE INSERT ON " + this.storageDesign.getFormatedName(tableProxy.getLongName()));
                SSBTableProxyUDBv81.appendNewLine(stringBuffer, bl, 0);
                SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, "REFERENCING NEW AS N");
                SSBTableProxyUDBv81.appendNewLine(stringBuffer, bl, 0);
                SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, "FOR EACH ROW MODE DB2SQL");
                SSBTableProxyUDBv81.appendNewLine(stringBuffer, bl, 0);
                SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, "BEGIN ATOMIC");
                this.appendCWDColumnMeta(stringBuffer, list, bl);
                this.appendTriggerConditions(stringBuffer, list, arrayList, bl);
                SSBTableProxyUDBv81.appendNewLine(stringBuffer, bl, 0);
                SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, "END");
                SSBTableProxyUDBv81.appendNewLine(stringBuffer, bl, 0);
                this.appendLineFinisher(stringBuffer, bl);
                SSBTableProxyUDBv81.appendNewLine(stringBuffer, bl, 0);
            }
        }
    }

    private void appendUpdateColumnSubstitutionTrigger(StringBuffer stringBuffer, Table table, TableProxy tableProxy, boolean bl) {
        List list = this.getColumnsWithRestrictedSubType(table);
        if (list.size() > 0) {
            boolean bl2 = true;
            String string = "";
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 0; i < list.size(); ++i) {
                Column column = (Column)list.get(i);
                ColumnProxy columnProxy = tableProxy.getColumnProxy(column.getObjectID());
                String string2 = this.storageDesign.getFormatedName(columnProxy == null ? column.getName() : columnProxy.getName());
                arrayList.add(string2);
                if (bl2) {
                    string = string2;
                    bl2 = false;
                    continue;
                }
                string = string + ", " + string2;
            }
            if (!"".equals(string)) {
                String string3 = this.storageDesign.getFormatedName(COLUMN_UPD_SUBST_TR_PREFIX + this.getStringWithMaxLength(tableProxy.getName(), 18 - COLUMN_UPD_SUBST_TR_PREFIX.length()));
                if (tableProxy.getUserSchema() != null) {
                    string3 = this.storageDesign.getFormatedName(tableProxy.getUserSchema().getName()) + "." + string3;
                }
                SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, "CREATE TRIGGER " + this.storageDesign.getFormatedName(string3));
                SSBTableProxyUDBv81.appendNewLine(stringBuffer, bl, 0);
                SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, "NO CASCADE BEFORE UPDATE OF " + string + " ON " + this.storageDesign.getFormatedName(tableProxy.getLongName()));
                SSBTableProxyUDBv81.appendNewLine(stringBuffer, bl, 0);
                SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, "REFERENCING NEW AS N");
                SSBTableProxyUDBv81.appendNewLine(stringBuffer, bl, 0);
                SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, "FOR EACH ROW MODE DB2SQL");
                SSBTableProxyUDBv81.appendNewLine(stringBuffer, bl, 0);
                SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, "BEGIN ATOMIC");
                this.appendCWDColumnMeta(stringBuffer, list, bl);
                this.appendTriggerConditions(stringBuffer, list, arrayList, bl);
                SSBTableProxyUDBv81.appendNewLine(stringBuffer, bl, 0);
                SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, "END");
                SSBTableProxyUDBv81.appendNewLine(stringBuffer, bl, 0);
                this.appendLineFinisher(stringBuffer, bl);
                SSBTableProxyUDBv81.appendNewLine(stringBuffer, bl, 0);
            }
        }
    }

    private void appendTriggerConditions(StringBuffer stringBuffer, List list, List list2, boolean bl) {
        for (int i = 0; i < list.size(); ++i) {
            Object object;
            Column column = (Column)list.get(i);
            String string = (String)list2.get(i);
            String string2 = "";
            if (column.isAllowSubtypeSubstitution()) {
                object = column.getPermittedSubTypes().iterator();
                boolean bl2 = true;
                while (object.hasNext()) {
                    StructuredType structuredType = (StructuredType)object.next();
                    StructuredTypeProxy structuredTypeProxy = (StructuredTypeProxy)this.storageDesign.getStructuredTypeProxySet().getObjectGeneratedBy(structuredType);
                    if (structuredTypeProxy == null || !structuredType.isInstantiable()) continue;
                    String string3 = this.storageDesign.getFormatedName(structuredTypeProxy.getLongName());
                    if (bl2) {
                        string2 = "ONLY " + string3;
                        bl2 = false;
                        continue;
                    }
                    string2 = string2 + ", " + "ONLY" + " " + string3;
                }
            } else {
                object = (StructuredType)column.getDataType();
                StructuredTypeProxy structuredTypeProxy = (StructuredTypeProxy)this.storageDesign.getStructuredTypeProxySet().getObjectGeneratedBy((DesignObject)object);
                if (structuredTypeProxy != null) {
                    string2 = "ONLY " + this.storageDesign.getFormatedName(structuredTypeProxy.getLongName());
                }
            }
            SSBTableProxyUDBv81.appendNewLine(stringBuffer, bl, 0);
            if (column.isReference()) {
                SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, " IF deref(N." + string + ") IS NOT OF ( " + string2 + " ) THEN");
            } else {
                SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, " IF N." + string + " IS NOT OF ( " + string2 + " ) THEN");
            }
            SSBTableProxyUDBv81.appendNewLine(stringBuffer, bl, 0);
            SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, "  signal SQLSTATE '85000' ('Column " + string + " - Only " + string2.replaceAll("ONLY ", "") + " are permited');");
            SSBTableProxyUDBv81.appendNewLine(stringBuffer, bl, 0);
            SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, " END IF;");
        }
    }

    private void appendCWDColumnMeta(StringBuffer stringBuffer, List list, boolean bl) {
        if (list.size() > 0) {
            SSBTableProxyUDBv81.appendNewLine(stringBuffer, bl, 0);
            SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, "-- DO NOT DELETE OR MODIFY THE FOLLOWING COMMENTS");
        }
        for (int i = 0; i < list.size(); ++i) {
            Column column = (Column)list.get(i);
            for (StructuredType structuredType : column.getPermittedSubTypes()) {
                StructuredTypeProxy structuredTypeProxy = (StructuredTypeProxy)this.storageDesign.getStructuredTypeProxySet().getObjectGeneratedBy(structuredType);
                String string = structuredType.getName();
                if (structuredTypeProxy != null) {
                    string = structuredTypeProxy.getLongName();
                }
                SSBTableProxyUDBv81.appendNewLine(stringBuffer, bl, 0);
                SSBTableProxyUDBv81.appendStringWithSpace(stringBuffer, "-- <cwd_ts_column column=\"" + column.getName() + "\" type=\"" + string + "\" />");
            }
        }
    }

    private void appendIndexesForConstraints(StringBuffer stringBuffer, Table table, TableProxy tableProxy) {
        KeyObject[] keyObjectArray = table.getKeys();
        boolean bl = table.getDesign().getDLSettings().isAutomaticPKGeneration();
        boolean bl2 = table.getDesign().getDLSettings().isAutomaticUKGeneration();
        boolean bl3 = table.getDesign().getDLSettings().isAutomaticFKGeneration();
        for (int i = 0; i < keyObjectArray.length; ++i) {
            Index index;
            ContainedObject[] containedObjectArray;
            Index index2 = (Index)keyObjectArray[i];
            if (!(bl && "Primary Constraint".equals(index2.getIndexState()) || bl2 && "Unique Constraint".equals(index2.getIndexState())) && (!index2.isFK() || !bl3) || (containedObjectArray = index2.getElements()).length <= 0 || (index = this.getIndexForColumns(table, index2, containedObjectArray, false)) != null) continue;
            this.ssbIndex.appendIndexForConstraint(stringBuffer, index2, tableProxy, true);
        }
    }

    private Index getIndexForColumns(Table table, Index index, ContainedObject[] containedObjectArray, boolean bl) {
        Object[] objectArray = table.getIndexes().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            DesignObjectPlaceHolder designObjectPlaceHolder = (DesignObjectPlaceHolder)objectArray[i];
            Index index2 = (Index)designObjectPlaceHolder.getDesignObject();
            ContainedObject[] containedObjectArray2 = index2.getElements();
            if (containedObjectArray.length != containedObjectArray2.length) continue;
            boolean bl2 = false;
            for (int j = 0; j < containedObjectArray.length; ++j) {
                String string;
                if (containedObjectArray[j] != containedObjectArray2[j]) {
                    bl2 = true;
                    break;
                }
                if (!bl || "ASC".equalsIgnoreCase(string = index2.getColumnSortOrder(containedObjectArray2[j]).trim()) || "".equalsIgnoreCase(string)) continue;
                bl2 = true;
                break;
            }
            if (bl2 || index2 == index) continue;
            return index2;
        }
        return null;
    }

    public SSBArcFK_CheckConstr getArcConstrHandler() {
        if (this.arcConstrHandler == null && this.storageDesign != null) {
            this.arcConstrHandler = new SSBArcFK_CheckConstr(this.storageDesign);
        }
        return this.arcConstrHandler;
    }
}

