/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.udb.v81;

import oracle.dbtools.crest.exports.ddl.udb.AbstractSSBUDB;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.udb.v81.InstanceUDBv81;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBInstanceUDBv81
extends AbstractSSBUDB {
    public static final String AUTHENTICATION_TYPE = "-a";
    public static final String PORT_NAME = "-p";
    public static final String TYPE = "-s";
    public static final String WORD_WIDTH = "-w";
    public static final String FENCED_ID = "-u";
    public static final String USER_NAME = "-u";
    public static final String PROFILE_PATH = "-p";
    public static final String CLUSTER_NAME = "-c";
    public static final String HOST_NAME = "-h";
    public static final String PORT_RANGE = "-r";
    public static final String CREATE_INSTANCE = "DB2ICRT";
    private StorageDesign storageDesign;

    @Override
    public boolean canHandle(Object object) {
        return object instanceof InstanceUDBv81 && ((InstanceUDBv81)object).isMarkedGenerate();
    }

    @Override
    protected void doAppend(StringBuffer stringBuffer, Object object, boolean bl) {
        InstanceUDBv81 instanceUDBv81 = (InstanceUDBv81)object;
        this.storageDesign = instanceUDBv81.getStorageDesign();
        if (instanceUDBv81.getOperatingSystem().equalsIgnoreCase("Windows Based")) {
            this.appendForWindowsBasedSystems(stringBuffer, instanceUDBv81, bl);
        }
        if (instanceUDBv81.getOperatingSystem().equalsIgnoreCase("OS/2 Based")) {
            this.appendForWindowsBasedSystems(stringBuffer, instanceUDBv81, bl);
        }
        if (instanceUDBv81.getOperatingSystem().equalsIgnoreCase("Unix Based")) {
            this.appendForUnixBasedSystems(stringBuffer, instanceUDBv81, bl);
        }
    }

    protected void appendForWindowsBasedSystems(StringBuffer stringBuffer, InstanceUDBv81 instanceUDBv81, boolean bl) {
        this.appendCreate(stringBuffer);
        this.appendType(stringBuffer, instanceUDBv81, bl);
        this.appendUserName(stringBuffer, instanceUDBv81, bl);
        this.appendProfilePath(stringBuffer, instanceUDBv81, bl);
        this.appendClusterName(stringBuffer, instanceUDBv81, bl);
        this.appendHostName(stringBuffer, instanceUDBv81, bl);
        this.appendPortRange(stringBuffer, instanceUDBv81, bl);
        SSBInstanceUDBv81.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(instanceUDBv81.getName()));
        SSBInstanceUDBv81.appendNewLine(stringBuffer, bl, 0);
        this.appendLineFinisher(stringBuffer, bl);
        DDLFileMaker.incrementCreateInstance();
    }

    protected void appendForUnixBasedSystems(StringBuffer stringBuffer, InstanceUDBv81 instanceUDBv81, boolean bl) {
        this.appendCreate(stringBuffer);
        this.appendAuthenticationType(stringBuffer, instanceUDBv81, bl);
        this.appendPortName(stringBuffer, instanceUDBv81, bl);
        this.appendType(stringBuffer, instanceUDBv81, bl);
        this.appendWordWidth(stringBuffer, instanceUDBv81, bl);
        this.appendFencedId(stringBuffer, instanceUDBv81, bl);
        SSBInstanceUDBv81.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(instanceUDBv81.getName()));
        SSBInstanceUDBv81.appendNewLine(stringBuffer, bl, 0);
        this.appendLineFinisher(stringBuffer, bl);
    }

    protected void appendAuthenticationType(StringBuffer stringBuffer, InstanceUDBv81 instanceUDBv81, boolean bl) {
        if (!instanceUDBv81.getAuthenticationType().equalsIgnoreCase("")) {
            SSBInstanceUDBv81.appendNewLine(stringBuffer, bl, 1);
            SSBInstanceUDBv81.appendStringWithSpace(stringBuffer, AUTHENTICATION_TYPE);
            SSBInstanceUDBv81.appendStringWithSpace(stringBuffer, instanceUDBv81.getAuthenticationType());
        }
    }

    protected void appendPortName(StringBuffer stringBuffer, InstanceUDBv81 instanceUDBv81, boolean bl) {
        if (!instanceUDBv81.getPortName().equalsIgnoreCase("")) {
            SSBInstanceUDBv81.appendNewLine(stringBuffer, bl, 1);
            SSBInstanceUDBv81.appendStringWithSpace(stringBuffer, "-p");
            SSBInstanceUDBv81.appendStringWithSpace(stringBuffer, instanceUDBv81.getPortName());
        }
    }

    protected void appendType(StringBuffer stringBuffer, InstanceUDBv81 instanceUDBv81, boolean bl) {
        if (!instanceUDBv81.getType().equalsIgnoreCase("")) {
            SSBInstanceUDBv81.appendNewLine(stringBuffer, bl, 1);
            SSBInstanceUDBv81.appendStringWithSpace(stringBuffer, TYPE);
            SSBInstanceUDBv81.appendStringWithSpace(stringBuffer, instanceUDBv81.getType());
        }
    }

    protected void appendWordWidth(StringBuffer stringBuffer, InstanceUDBv81 instanceUDBv81, boolean bl) {
        if (instanceUDBv81.getWordWidth() > 0) {
            SSBInstanceUDBv81.appendNewLine(stringBuffer, bl, 1);
            SSBInstanceUDBv81.appendStringWithSpace(stringBuffer, WORD_WIDTH);
            this.appendStringWithSpace(stringBuffer, instanceUDBv81.getWordWidth());
        }
    }

    protected void appendFencedId(StringBuffer stringBuffer, InstanceUDBv81 instanceUDBv81, boolean bl) {
        if (!instanceUDBv81.getFencedId().equalsIgnoreCase("")) {
            SSBInstanceUDBv81.appendNewLine(stringBuffer, bl, 1);
            SSBInstanceUDBv81.appendStringWithSpace(stringBuffer, "-u");
            SSBInstanceUDBv81.appendStringWithSpace(stringBuffer, instanceUDBv81.getFencedId());
        }
    }

    protected void appendUserName(StringBuffer stringBuffer, InstanceUDBv81 instanceUDBv81, boolean bl) {
        if (!instanceUDBv81.getUserName().equalsIgnoreCase("")) {
            SSBInstanceUDBv81.appendNewLine(stringBuffer, bl, 1);
            SSBInstanceUDBv81.appendStringWithSpace(stringBuffer, "-u");
            SSBInstanceUDBv81.appendString(stringBuffer, instanceUDBv81.getUserName());
            this.appendComma(stringBuffer);
            SSBInstanceUDBv81.appendStringWithSpace(stringBuffer, instanceUDBv81.getPassword());
        }
    }

    protected void appendProfilePath(StringBuffer stringBuffer, InstanceUDBv81 instanceUDBv81, boolean bl) {
        if (!instanceUDBv81.getProfilePath().equalsIgnoreCase("")) {
            SSBInstanceUDBv81.appendNewLine(stringBuffer, bl, 1);
            SSBInstanceUDBv81.appendStringWithSpace(stringBuffer, "-p");
            SSBInstanceUDBv81.appendStringWithSpace(stringBuffer, instanceUDBv81.getProfilePath());
        }
    }

    protected void appendClusterName(StringBuffer stringBuffer, InstanceUDBv81 instanceUDBv81, boolean bl) {
        if (!instanceUDBv81.getClusterName().equalsIgnoreCase("")) {
            SSBInstanceUDBv81.appendNewLine(stringBuffer, bl, 1);
            SSBInstanceUDBv81.appendStringWithSpace(stringBuffer, CLUSTER_NAME);
            SSBInstanceUDBv81.appendStringWithSpace(stringBuffer, instanceUDBv81.getClusterName());
        }
    }

    protected void appendHostName(StringBuffer stringBuffer, InstanceUDBv81 instanceUDBv81, boolean bl) {
        if (!instanceUDBv81.getHostName().equalsIgnoreCase("")) {
            SSBInstanceUDBv81.appendNewLine(stringBuffer, bl, 1);
            SSBInstanceUDBv81.appendStringWithSpace(stringBuffer, HOST_NAME);
            SSBInstanceUDBv81.appendStringWithSpace(stringBuffer, instanceUDBv81.getHostName());
        }
    }

    protected void appendPortRange(StringBuffer stringBuffer, InstanceUDBv81 instanceUDBv81, boolean bl) {
        if (!instanceUDBv81.getPortRange().equalsIgnoreCase("")) {
            SSBInstanceUDBv81.appendNewLine(stringBuffer, bl, 1);
            SSBInstanceUDBv81.appendStringWithSpace(stringBuffer, PORT_RANGE);
            SSBInstanceUDBv81.appendStringWithSpace(stringBuffer, instanceUDBv81.getPortRange());
        }
    }
}

