/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.udb.v81;

import oracle.dbtools.crest.exports.ddl.udb.AbstractSSBUDB;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.v81.FKProxyUDBv81;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBFKUDBv81
extends AbstractSSBUDB {
    private StorageDesignUDB storageDesign;

    @Override
    public boolean canHandle(Object object) {
        if (object instanceof RelationalObjectProxy && !((RelationalObjectProxy)object).getStorageDesign().isOpen()) {
            if (object instanceof FKProxyUDBv81) {
                return ((RelationalObjectProxy)object).getObject().isMarkedGenerate();
            }
        } else if (object instanceof FKIndexAssociation) {
            return ((FKIndexAssociation)object).isMarkedGenerate();
        }
        return object instanceof FKProxyUDBv81 && ((FKProxyUDBv81)object).isMarkedGenerate();
    }

    @Override
    protected void doAppend(StringBuffer stringBuffer, Object object, boolean bl) {
        FKProxyUDBv81 fKProxyUDBv81;
        ModelIDObject modelIDObject;
        if (object instanceof FKIndexAssociation) {
            FKIndexAssociation fKIndexAssociation = (FKIndexAssociation)object;
            modelIDObject = (RelationalDesign)fKIndexAssociation.getDesignPart();
            this.storageDesign = (StorageDesignUDB)((RelationalDesign)modelIDObject).getStorageDesign(((RelationalDesign)modelIDObject).getSelectedRDBMSSite());
            fKProxyUDBv81 = (FKProxyUDBv81)this.storageDesign.getFKProxySet().getProxy(fKIndexAssociation.getObjectID());
            if (fKProxyUDBv81 == null && (fKProxyUDBv81 = (FKProxyUDBv81)this.storageDesign.getFKProxySet().getProxy(fKIndexAssociation.getLocalFKIndex().getObjectID())) == null) {
                return;
            }
        } else {
            fKProxyUDBv81 = (FKProxyUDBv81)object;
            this.storageDesign = (StorageDesignUDB)fKProxyUDBv81.getStorageDesign();
        }
        modelIDObject = (TableProxyUDB)fKProxyUDBv81.getStorageDesign().getTableProxySet().getProxy(fKProxyUDBv81.getTable().getObjectID());
        SSBFKUDBv81.appendNewLine(stringBuffer, bl, 0);
        this.appendBeforeAlterScript(stringBuffer, bl, (ContainerObject)((RelationalObjectProxy)modelIDObject).getObject());
        SSBFKUDBv81.appendStringWithSpace(stringBuffer, "ALTER");
        SSBFKUDBv81.appendStringWithSpace(stringBuffer, "TABLE");
        SSBFKUDBv81.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(((TableProxyUDB)modelIDObject).getLongName()));
        SSBFKUDBv81.appendNewLine(stringBuffer, bl, 1);
        SSBFKUDBv81.appendStringWithSpace(stringBuffer, "ADD");
        SSBFKUDBv81.appendStringWithSpace(stringBuffer, "CONSTRAINT");
        SSBFKUDBv81.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(fKProxyUDBv81.getName()));
        SSBFKUDBv81.appendString(stringBuffer, "FOREIGN KEY");
        SSBFKUDBv81.appendNewLine(stringBuffer, bl, 1);
        SSBFKUDBv81.appendStringWithSpace(stringBuffer, '(');
        SSBFKUDBv81.appendNewLine(stringBuffer, bl, 0);
        SSBFKUDBv81.appendString(stringBuffer, fKProxyUDBv81.getColumns(this.storageDesign));
        SSBFKUDBv81.appendNewLine(stringBuffer, bl, 1);
        SSBFKUDBv81.appendStringWithSpace(stringBuffer, ')');
        this.appendReferences(stringBuffer, fKProxyUDBv81, bl);
        this.appendOnDelete(stringBuffer, fKProxyUDBv81, bl);
        this.appendOnUpdate(stringBuffer, fKProxyUDBv81, bl);
        this.appendConstraintAttribute(stringBuffer, fKProxyUDBv81, bl);
        SSBFKUDBv81.appendNewLine(stringBuffer, bl, 0);
        this.appendLineFinisher(stringBuffer, bl);
        SSBFKUDBv81.appendNewLine(stringBuffer, bl, 0);
        SSBFKUDBv81.appendNewLine(stringBuffer, bl, 0);
        DDLFileMaker.incrementAlterTable();
        this.appendAfterAlterScript(stringBuffer, bl, (ContainerObject)((RelationalObjectProxy)modelIDObject).getObject());
    }

    private void appendReferences(StringBuffer stringBuffer, FKProxyUDBv81 fKProxyUDBv81, boolean bl) {
        SSBFKUDBv81.appendNewLine(stringBuffer, bl, 1);
        SSBFKUDBv81.appendStringWithSpace(stringBuffer, "REFERENCES");
        TableProxyUDB tableProxyUDB = (TableProxyUDB)fKProxyUDBv81.getStorageDesign().getTableProxySet().getProxy(fKProxyUDBv81.getFKTable().getObjectID());
        SSBFKUDBv81.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(tableProxyUDB.getLongName()));
        SSBFKUDBv81.appendNewLine(stringBuffer, bl, 1);
        SSBFKUDBv81.appendStringWithSpace(stringBuffer, '(');
        SSBFKUDBv81.appendNewLine(stringBuffer, bl, 0);
        SSBFKUDBv81.appendString(stringBuffer, fKProxyUDBv81.getReferenceColumns(this.storageDesign));
        SSBFKUDBv81.appendNewLine(stringBuffer, bl, 1);
        SSBFKUDBv81.appendString(stringBuffer, ')');
    }

    private void appendOnDelete(StringBuffer stringBuffer, FKProxyUDBv81 fKProxyUDBv81, boolean bl) {
        FKIndexAssociation fKIndexAssociation = ((Index)fKProxyUDBv81.getObject()).getFKAssociation();
        String string = fKIndexAssociation.getDeleteRule();
        if (string.equalsIgnoreCase("SET DEFAULT")) {
            string = fKIndexAssociation.isMandatory() ? "RESTRICT" : "SET NULL";
        }
        SSBFKUDBv81.appendNewLine(stringBuffer, bl, 1);
        SSBFKUDBv81.appendStringWithSpace(stringBuffer, "ON");
        SSBFKUDBv81.appendStringWithSpace(stringBuffer, "DELETE");
        SSBFKUDBv81.appendString(stringBuffer, string);
    }

    private void appendOnUpdate(StringBuffer stringBuffer, FKProxyUDBv81 fKProxyUDBv81, boolean bl) {
        SSBFKUDBv81.appendNewLine(stringBuffer, bl, 1);
        SSBFKUDBv81.appendStringWithSpace(stringBuffer, "ON");
        SSBFKUDBv81.appendStringWithSpace(stringBuffer, "UPDATE");
        SSBFKUDBv81.appendString(stringBuffer, fKProxyUDBv81.getOnUpdate());
    }

    private void appendConstraintAttribute(StringBuffer stringBuffer, FKProxyUDBv81 fKProxyUDBv81, boolean bl) {
        SSBFKUDBv81.appendNewLine(stringBuffer, bl, 1);
        SSBFKUDBv81.appendStringWithSpace(stringBuffer, fKProxyUDBv81.getValidation());
        SSBFKUDBv81.appendStringWithSpace(stringBuffer, fKProxyUDBv81.getQueryOptimization());
        SSBFKUDBv81.appendStringWithSpace(stringBuffer, "QUERY");
        SSBFKUDBv81.appendStringWithSpace(stringBuffer, "OPTIMIZATION");
    }
}

